/*
 * Decompiled with CFR 0.152.
 */
package com.dataiku.dip.security.ldap;

import com.dataiku.dip.security.auth.ServerAuthenticationFailure;
import com.dataiku.dip.security.auth.UserAttributes;
import com.dataiku.dip.security.auth.UserAuthenticationException;
import com.dataiku.dip.security.auth.UserCredentialsAuthenticator;
import com.dataiku.dip.security.auth.UserCredentialsAuthenticatorSettings;
import com.dataiku.dip.security.auth.UserIdentity;
import com.dataiku.dip.security.auth.UserNotFoundException;
import com.dataiku.dip.security.auth.UserQueryFilter;
import com.dataiku.dip.security.auth.UserSourceType;
import com.dataiku.dip.security.auth.UserSupplier;
import com.dataiku.dip.security.auth.UserSupplierSettings;
import com.dataiku.dip.security.ldap.LDAPConnectionFactory;
import com.dataiku.dip.security.ldap.LdapSettings;
import com.dataiku.dip.security.ldap.LdapUser;
import com.dataiku.dip.server.services.licensing.DkuLicenseEnforcementService;
import com.dataiku.dip.server.services.licensing.LimitsStatusComputer;
import com.dataiku.dip.util.LdapUtils;
import com.dataiku.dip.utils.DKULogger;
import java.io.IOException;
import java.util.Collections;
import java.util.HashSet;
import java.util.Set;
import java.util.stream.Collectors;
import org.apache.commons.lang.StringUtils;

public abstract class LdapCredentialsAuthenticatorAndSupplier
implements UserCredentialsAuthenticator,
UserSupplier {
    private static final DKULogger logger = DKULogger.getLogger((String)"dku.auth.ldap");
    private LDAPConnectionFactory ldapConnectionFactory;
    private DkuLicenseEnforcementService licenseEnforcementService;
    protected LdapSettings ldapSettings;

    public LdapCredentialsAuthenticatorAndSupplier(LDAPConnectionFactory ldapConnectionFactory, DkuLicenseEnforcementService licenseEnforcementService) {
        this.ldapConnectionFactory = ldapConnectionFactory;
        this.licenseEnforcementService = licenseEnforcementService;
    }

    @Override
    public boolean canSyncOnDemand() {
        return true;
    }

    @Override
    public boolean canFetchUsers() {
        return true;
    }

    @Override
    public boolean canFetchGroups() {
        return true;
    }

    @Override
    public String getDefaultProfile() {
        return this.ldapSettings.defaultUserProfile;
    }

    @Override
    public UserCredentialsAuthenticatorSettings getAuthenticatorSettings() {
        return this.ldapSettings;
    }

    @Override
    public UserSupplierSettings getUserSupplierSettings() {
        return this.ldapSettings;
    }

    @Override
    public UserIdentity authenticate(String login, String password) throws ServerAuthenticationFailure, UserAuthenticationException, LimitsStatusComputer.LicenseLimitException, UserNotFoundException {
        LdapUser ldapUser;
        this.licenseEnforcementService.checkLdapAllowed();
        try (LdapUtils.Connection connection = this.ldapConnectionFactory.create(this.ldapSettings);){
            ldapUser = connection.lookupUser(login, password);
        }
        catch (IOException e) {
            throw new ServerAuthenticationFailure("Couldn't verify user ldap credentials", e);
        }
        if (ldapUser == null) {
            throw new UserAuthenticationException("Login '" + login + "' not found in LDAP (or bad password)");
        }
        return this.getUserIdentity(ldapUser);
    }

    @Override
    public UserAttributes getUserAttributes(UserIdentity userIdentity) throws UserNotFoundException, ServerAuthenticationFailure {
        if (userIdentity.sourceType == UserSourceType.LDAP) {
            return new UserAttributes(userIdentity);
        }
        return this.fetchUser(userIdentity.login);
    }

    private UserAttributes fetchUser(String login) throws UserNotFoundException, ServerAuthenticationFailure {
        UserAttributes userAttributes;
        block9: {
            LdapUtils.Connection connection = this.ldapConnectionFactory.create(this.ldapSettings);
            try {
                LdapUser ldapUser = connection.lookupUser(login);
                if (ldapUser == null) {
                    throw new UserNotFoundException("Login '" + login + "' not found in LDAP");
                }
                UserAttributes userAttributes2 = new UserAttributes();
                userAttributes2.displayName = ldapUser.displayName;
                userAttributes2.email = ldapUser.email;
                userAttributes2.sourceGroupNames = ldapUser.groups;
                userAttributes2.login = login;
                userAttributes = userAttributes2;
                if (connection == null) break block9;
            }
            catch (Throwable throwable) {
                try {
                    if (connection != null) {
                        try {
                            connection.close();
                        }
                        catch (Throwable throwable2) {
                            throwable.addSuppressed(throwable2);
                        }
                    }
                    throw throwable;
                }
                catch (IOException e) {
                    throw new ServerAuthenticationFailure("Could not get user attributes from LDAP", e);
                }
            }
            connection.close();
        }
        return userAttributes;
    }

    @Override
    public Set<UserAttributes> fetchUsers(UserQueryFilter filter) throws ServerAuthenticationFailure {
        if (StringUtils.isNotBlank((String)filter.getLogin())) {
            try {
                return Collections.singleton(this.fetchUser(filter.getLogin()));
            }
            catch (UserNotFoundException e) {
                return Collections.emptySet();
            }
        }
        return this.fetchUsers(this.ldapSettings.enableGroups ? filter.getGroupName() : "");
    }

    private Set<UserAttributes> fetchUsers(String groupName) throws ServerAuthenticationFailure {
        HashSet<UserAttributes> hashSet;
        block12: {
            LdapUtils.Connection connection = this.ldapConnectionFactory.create(this.ldapSettings);
            try {
                HashSet<UserAttributes> users = new HashSet<UserAttributes>();
                Set<LdapUser> ldapUsers = connection.getAllUsers();
                Set<Object> ldapGroups = new HashSet();
                if (this.ldapSettings.enableGroups) {
                    ldapGroups = connection.getAllGroups();
                }
                for (LdapUser ldapUser : ldapUsers) {
                    UserAttributes userAttributes = new UserAttributes();
                    userAttributes.login = ldapUser.username;
                    userAttributes.displayName = ldapUser.displayName;
                    userAttributes.email = ldapUser.email;
                    String groupMembershipUserAttributeValue = this.ldapSettings.groupMembershipUserAttribute.getValue(ldapUser);
                    String groupMembershipUserAttributeKeyAndValue = this.ldapSettings.groupMembershipUserAttribute.getKeyAndValue(ldapUser);
                    if (groupMembershipUserAttributeValue == null) {
                        logger.warnV("LDAP user '%s' does not contain group membership attribute %s, cannot map groups to user", new Object[]{ldapUser.username, this.ldapSettings.groupMembershipUserAttribute});
                    } else {
                        userAttributes.sourceGroupNames = ldapGroups.stream().filter(group -> group.members.contains(groupMembershipUserAttributeValue) || group.members.contains(groupMembershipUserAttributeKeyAndValue)).map(group -> group.name).collect(Collectors.toSet());
                    }
                    if (!StringUtils.isBlank((String)groupName) && (!this.ldapSettings.enableGroups || !userAttributes.sourceGroupNames.contains(groupName))) continue;
                    users.add(userAttributes);
                }
                hashSet = users;
                if (connection == null) break block12;
            }
            catch (Throwable throwable) {
                try {
                    if (connection != null) {
                        try {
                            connection.close();
                        }
                        catch (Throwable throwable2) {
                            throwable.addSuppressed(throwable2);
                        }
                    }
                    throw throwable;
                }
                catch (IOException e) {
                    throw new ServerAuthenticationFailure("Could not get user attributes from LDAP", e);
                }
            }
            connection.close();
        }
        return hashSet;
    }

    @Override
    public Set<String> fetchGroups() throws ServerAuthenticationFailure {
        Set<String> set;
        block8: {
            LdapUtils.Connection connection = this.ldapConnectionFactory.create(this.ldapSettings);
            try {
                set = connection.getAllGroups().stream().map(ldapGroup -> ldapGroup.name).collect(Collectors.toSet());
                if (connection == null) break block8;
            }
            catch (Throwable throwable) {
                try {
                    if (connection != null) {
                        try {
                            connection.close();
                        }
                        catch (Throwable throwable2) {
                            throwable.addSuppressed(throwable2);
                        }
                    }
                    throw throwable;
                }
                catch (IOException e) {
                    throw new ServerAuthenticationFailure("Could not fetch LDAP groups", e);
                }
            }
            connection.close();
        }
        return set;
    }

    private UserIdentity getUserIdentity(LdapUser ldapUser) {
        UserIdentity userIdentity = new UserIdentity(UserSourceType.LDAP, ldapUser.username);
        userIdentity.displayName = ldapUser.displayName;
        userIdentity.email = ldapUser.email;
        userIdentity.groupNames = ldapUser.groups;
        return userIdentity;
    }
}

