/*
 * Decompiled with CFR 0.152.
 */
package com.dataiku.dip.transactions.fs.utils;

import java.io.File;
import java.io.IOException;
import java.io.RandomAccessFile;
import java.nio.channels.FileChannel;
import java.nio.channels.FileLock;

public class FSLock {
    private FileChannel lockChannel;
    private FileLock lock;
    private RandomAccessFile lockFile;
    private final File lockFilePath;

    public FSLock(File root, String lockFilename) {
        this.lockFilePath = new File(root, lockFilename);
    }

    public synchronized void acquireLockOfFail() throws IOException {
        if (this.lock != null) {
            return;
        }
        try {
            this.lockFile = new RandomAccessFile(this.lockFilePath, "rw");
            this.lockChannel = this.lockFile.getChannel();
            this.lock = this.lockChannel.tryLock();
            if (this.lock == null) {
                throw new IOException("Unable to acquire filesystem lock: " + String.valueOf(this.lockFilePath));
            }
        }
        catch (IOException e) {
            this.releaseLock();
            throw e;
        }
    }

    public synchronized void acquireLockWait() throws IOException {
        if (this.lock != null) {
            return;
        }
        try {
            this.lockFile = new RandomAccessFile(this.lockFilePath, "rw");
            this.lockChannel = this.lockFile.getChannel();
            this.lock = this.lockChannel.lock();
            if (this.lock == null) {
                throw new IOException("Unable to acquire filesystem lock");
            }
        }
        catch (IOException e) {
            this.releaseLock();
            throw e;
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public synchronized void releaseLock() throws IOException {
        try {
            if (this.lock != null) {
                this.lock.release();
            }
        }
        finally {
            this.lock = null;
            try {
                if (this.lockChannel != null) {
                    this.lockChannel.close();
                }
            }
            finally {
                this.lockChannel = null;
                try {
                    if (this.lockFile != null) {
                        this.lockFile.close();
                    }
                }
                finally {
                    this.lockFile = null;
                }
            }
        }
    }
}

