/*
 * Decompiled with CFR 0.152.
 */
package com.dataiku.hive.udf.maths;

import com.dataiku.hive.udf.maths.PrefixSumMovingAverage;
import java.util.ArrayList;
import java.util.List;
import org.apache.commons.logging.Log;
import org.apache.commons.logging.LogFactory;
import org.apache.hadoop.hive.ql.exec.Description;
import org.apache.hadoop.hive.ql.exec.UDFArgumentTypeException;
import org.apache.hadoop.hive.ql.metadata.HiveException;
import org.apache.hadoop.hive.ql.parse.SemanticException;
import org.apache.hadoop.hive.ql.udf.generic.AbstractGenericUDAFResolver;
import org.apache.hadoop.hive.ql.udf.generic.GenericUDAFEvaluator;
import org.apache.hadoop.hive.serde2.io.DoubleWritable;
import org.apache.hadoop.hive.serde2.objectinspector.ObjectInspector;
import org.apache.hadoop.hive.serde2.objectinspector.ObjectInspectorFactory;
import org.apache.hadoop.hive.serde2.objectinspector.PrimitiveObjectInspector;
import org.apache.hadoop.hive.serde2.objectinspector.StandardListObjectInspector;
import org.apache.hadoop.hive.serde2.objectinspector.primitive.PrimitiveObjectInspectorFactory;
import org.apache.hadoop.hive.serde2.objectinspector.primitive.PrimitiveObjectInspectorUtils;
import org.apache.hadoop.hive.serde2.typeinfo.PrimitiveTypeInfo;
import org.apache.hadoop.hive.serde2.typeinfo.TypeInfo;

@Description(name="moving_avg", value="_FUNC_(p, x, windows, div) - Returns the moving mean of a set of numbers over a window of n observations 1/pow(div,i)")
public class UDFExponentialSmoothingMovingAverage
extends AbstractGenericUDAFResolver {
    static final Log LOG = LogFactory.getLog((String)UDFExponentialSmoothingMovingAverage.class.getName());

    public GenericUDAFEvaluator getEvaluator(TypeInfo[] parameters) throws SemanticException {
        if (parameters.length != 5) {
            throw new UDFArgumentTypeException(parameters.length - 1, "Moving Average requires 5 parameters");
        }
        if (parameters[0].getCategory() != ObjectInspector.Category.PRIMITIVE) {
            throw new UDFArgumentTypeException(0, "Only primitive, numeric types can have a moving average but " + parameters[0].getTypeName() + "was passed.");
        }
        switch (((PrimitiveTypeInfo)parameters[0]).getPrimitiveCategory()) {
            case FLOAT: 
            case DOUBLE: 
            case INT: 
            case LONG: 
            case SHORT: {
                break;
            }
            default: {
                throw new UDFArgumentTypeException(0, "Only numeric type arguments (excluding bytes and timestamps) are acceptedbut " + parameters[0].getTypeName() + " was passed.");
            }
        }
        if (parameters[1].getCategory() != ObjectInspector.Category.PRIMITIVE) {
            throw new UDFArgumentTypeException(0, "Only primitive, numeric types can have a moving average but " + parameters[1].getTypeName() + "was passed.");
        }
        switch (((PrimitiveTypeInfo)parameters[1]).getPrimitiveCategory()) {
            case FLOAT: 
            case DOUBLE: 
            case INT: 
            case LONG: 
            case SHORT: {
                break;
            }
            default: {
                throw new UDFArgumentTypeException(0, "Only numeric type arguments (excluding bytes and timestamps) are acceptedbut " + parameters[1].getTypeName() + " was passed.");
            }
        }
        if (parameters[2].getCategory() != ObjectInspector.Category.PRIMITIVE) {
            throw new UDFArgumentTypeException(1, "ensure that the window size is an integer");
        }
        if (((PrimitiveTypeInfo)parameters[2]).getPrimitiveCategory() != PrimitiveObjectInspector.PrimitiveCategory.INT) {
            throw new UDFArgumentTypeException(1, "ensure that the window size is an integer");
        }
        if (parameters[3].getCategory() != ObjectInspector.Category.PRIMITIVE) {
            throw new UDFArgumentTypeException(1, "ensure that the diviseur is a double");
        }
        if (((PrimitiveTypeInfo)parameters[3]).getPrimitiveCategory() != PrimitiveObjectInspector.PrimitiveCategory.DOUBLE) {
            throw new UDFArgumentTypeException(1, "ensure that the diviseur is a double");
        }
        if (parameters[4].getCategory() != ObjectInspector.Category.PRIMITIVE) {
            throw new UDFArgumentTypeException(1, "ensure that the position is a int.");
        }
        if (((PrimitiveTypeInfo)parameters[4]).getPrimitiveCategory() != PrimitiveObjectInspector.PrimitiveCategory.INT) {
            throw new UDFArgumentTypeException(1, "ensure that the position is a int.");
        }
        return new GenericUDAFMovingAverageEvaluator();
    }

    public static class GenericUDAFMovingAverageEvaluator
    extends GenericUDAFEvaluator {
        private PrimitiveObjectInspector periodOI;
        private PrimitiveObjectInspector inputOI;
        private PrimitiveObjectInspector windowSizeOI;
        private PrimitiveObjectInspector diviseurOI;
        private PrimitiveObjectInspector positionOI;
        private StandardListObjectInspector loi;

        public ObjectInspector init(GenericUDAFEvaluator.Mode m, ObjectInspector[] parameters) throws HiveException {
            super.init(m, parameters);
            if (m == GenericUDAFEvaluator.Mode.PARTIAL1 || m == GenericUDAFEvaluator.Mode.COMPLETE) {
                assert (parameters.length == 5);
                this.periodOI = (PrimitiveObjectInspector)parameters[0];
                this.inputOI = (PrimitiveObjectInspector)parameters[1];
                this.windowSizeOI = (PrimitiveObjectInspector)parameters[2];
                this.diviseurOI = (PrimitiveObjectInspector)parameters[3];
                this.positionOI = (PrimitiveObjectInspector)parameters[4];
            } else {
                this.loi = (StandardListObjectInspector)parameters[0];
            }
            if (m == GenericUDAFEvaluator.Mode.PARTIAL1 || m == GenericUDAFEvaluator.Mode.PARTIAL2) {
                return ObjectInspectorFactory.getStandardListObjectInspector((ObjectInspector)PrimitiveObjectInspectorFactory.writableDoubleObjectInspector);
            }
            return PrimitiveObjectInspectorFactory.writableDoubleObjectInspector;
        }

        public Object terminatePartial(GenericUDAFEvaluator.AggregationBuffer agg) throws HiveException {
            MaAgg myagg = (MaAgg)agg;
            return myagg.prefixSum.serialize();
        }

        public Object terminate(GenericUDAFEvaluator.AggregationBuffer agg) throws HiveException {
            MaAgg myagg = (MaAgg)agg;
            if (myagg.prefixSum.tableSize() < 1) {
                return null;
            }
            ArrayList result = new ArrayList();
            DoubleWritable[] entry = new DoubleWritable[]{new DoubleWritable(myagg.prefixSum.getEntry((int)(myagg.prefixSum.tableSize() - 1)).movingAverage)};
            return entry[0];
        }

        public void merge(GenericUDAFEvaluator.AggregationBuffer agg, Object partial) throws HiveException {
            if (partial != null) {
                MaAgg myagg = (MaAgg)agg;
                List partialMovingAverage = this.loi.getList(partial);
                myagg.prefixSum.merge(partialMovingAverage);
            }
        }

        public void iterate(GenericUDAFEvaluator.AggregationBuffer agg, Object[] parameters) throws HiveException {
            assert (parameters.length == 5);
            if (parameters[0] == null || parameters[1] == null || parameters[2] == null || parameters[3] == null || parameters[4] == null) {
                return;
            }
            MaAgg myagg = (MaAgg)agg;
            if (!myagg.prefixSum.isReady()) {
                int windowSize = PrimitiveObjectInspectorUtils.getInt((Object)parameters[2], (PrimitiveObjectInspector)this.windowSizeOI);
                double diviseur = PrimitiveObjectInspectorUtils.getDouble((Object)parameters[3], (PrimitiveObjectInspector)this.diviseurOI);
                int position = PrimitiveObjectInspectorUtils.getInt((Object)parameters[4], (PrimitiveObjectInspector)this.positionOI);
                if (windowSize < 1) {
                    throw new HiveException(((Object)((Object)this)).getClass().getSimpleName() + " needs a window size >= 1");
                }
                myagg.prefixSum.allocate(windowSize, diviseur, position);
            }
            int p = PrimitiveObjectInspectorUtils.getInt((Object)parameters[0], (PrimitiveObjectInspector)this.periodOI);
            double v = PrimitiveObjectInspectorUtils.getDouble((Object)parameters[1], (PrimitiveObjectInspector)this.inputOI);
            myagg.prefixSum.add(p, v);
        }

        public GenericUDAFEvaluator.AggregationBuffer getNewAggregationBuffer() throws HiveException {
            MaAgg result = new MaAgg();
            this.reset(result);
            return result;
        }

        public void reset(GenericUDAFEvaluator.AggregationBuffer agg) throws HiveException {
            MaAgg myagg = (MaAgg)agg;
            myagg.prefixSum = new PrefixSumMovingAverage();
            myagg.prefixSum.reset();
        }

        static class MaAgg
        implements GenericUDAFEvaluator.AggregationBuffer {
            PrefixSumMovingAverage prefixSum;

            MaAgg() {
            }
        }
    }
}

