/*
 * Decompiled with CFR 0.152.
 */
package com.dataiku.dip.spark.ml.h2o;

import com.dataiku.dip.spark.compat.package$;
import com.dataiku.dip.spark.ml.Util$;
import java.io.Serializable;
import java.lang.reflect.Method;
import org.apache.spark.SparkConf;
import org.apache.spark.SparkContext;
import org.apache.spark.h2o.H2OConf;
import org.apache.spark.h2o.H2OContext;
import org.apache.spark.ml.linalg.Vector;
import org.apache.spark.sql.Dataset;
import org.apache.spark.sql.Row;
import org.apache.spark.sql.SQLContext;
import scala.Array$;
import scala.Function0;
import scala.Function1;
import scala.MatchError;
import scala.None$;
import scala.Option;
import scala.Option$;
import scala.Predef;
import scala.Predef$;
import scala.Tuple2;
import scala.Tuple3;
import scala.collection.GenIterable;
import scala.collection.GenTraversableOnce;
import scala.collection.IndexedSeq;
import scala.collection.IndexedSeq$;
import scala.collection.Seq;
import scala.collection.TraversableLike;
import scala.collection.TraversableOnce;
import scala.collection.immutable.;
import scala.collection.immutable.List;
import scala.collection.immutable.Map;
import scala.collection.immutable.Nil$;
import scala.collection.mutable.ArrayOps;
import scala.reflect.ClassTag;
import scala.reflect.ClassTag$;
import scala.runtime.BoxedUnit;
import scala.runtime.BoxesRunTime;
import water.H2O;
import water.fvec.Frame;
import water.fvec.H2OFrame;
import water.init.AbstractEmbeddedH2OConfig;

public final class H2OSupport$ {
    public static H2OSupport$ MODULE$;
    private volatile H2OContext h2OContext;
    private volatile SparkContext sparkContext;

    static {
        new H2OSupport$();
    }

    private H2OContext h2OContext() {
        return this.h2OContext;
    }

    private void h2OContext_$eq(H2OContext x$1) {
        this.h2OContext = x$1;
    }

    private SparkContext sparkContext() {
        return this.sparkContext;
    }

    private void sparkContext_$eq(SparkContext x$1) {
        this.sparkContext = x$1;
    }

    public synchronized void setSparkContext(SparkContext sc) {
        this.sparkContext_$eq(sc);
    }

    public synchronized H2OContext getH2OContext() {
        block1: {
            if (this.sparkContext() == null) {
                throw new IllegalStateException("No Spark Context found for H2OSupport! You must set it first.");
            }
            if (this.h2OContext() != null) break block1;
            this.h2OContext_$eq((H2OContext)this.getMethod("getOrCreate", (Seq<Class<?>>)Predef$.MODULE$.wrapRefArray((Object[])new Class[]{SparkContext.class}), (ClassTag)ClassTag$.MODULE$.apply(H2OContext.class)).map((Function1 & Serializable & scala.Serializable)x$1 -> x$1.invoke(null, MODULE$.sparkContext())).orElse((Function0 & Serializable & scala.Serializable)() -> MODULE$.getMethod("getOrCreate", (Seq<Class<?>>)Predef$.MODULE$.wrapRefArray((Object[])new Class[]{H2OConf.class}), (ClassTag)ClassTag$.MODULE$.apply(H2OContext.class)).map((Function1 & Serializable & scala.Serializable)x$2 -> x$2.invoke(null, H2OConf.class.getConstructor(SparkConf.class).newInstance(MODULE$.sparkContext().getConf())))).getOrElse((Function0 & Serializable & scala.Serializable)() -> {
                throw new IllegalArgumentException("Using an unsupported version of Sparkling Water");
            }));
        }
        return this.h2OContext();
    }

    public synchronized void stopH2OContext() {
        if (this.h2OContext() != null) {
            H2O.orderlyShutdown((int)1000);
            AbstractEmbeddedH2OConfig config = H2O.embeddedH2OConfig;
            if (config != null) {
                config.exit(0);
            }
            this.h2OContext_$eq(null);
            return;
        }
    }

    public <T> Option<Method> getMethod(String name, Seq<Class<?>> args, ClassTag<T> evidence$1) {
        return new ArrayOps.ofRef(Predef$.MODULE$.refArrayOps((Object[])((ClassTag)Predef$.MODULE$.implicitly(evidence$1)).runtimeClass().getMethods())).find((Function1 & Serializable & scala.Serializable)m -> BoxesRunTime.boxToBoolean((boolean)H2OSupport$.$anonfun$getMethod$1(name, args, m)));
    }

    public Dataset<Row> asDataFrame(H2OFrame frame, SQLContext sql) {
        return (Dataset)this.getMethod("asDataFrame", (Seq<Class<?>>)Predef$.MODULE$.wrapRefArray((Object[])new Class[]{Frame.class, SQLContext.class}), (ClassTag)ClassTag$.MODULE$.apply(H2OContext.class)).map((Function1 & Serializable & scala.Serializable)x$3 -> x$3.invoke((Object)MODULE$.getH2OContext(), frame, sql)).orElse((Function0 & Serializable & scala.Serializable)() -> MODULE$.getMethod("asDataFrame", (Seq<Class<?>>)Predef$.MODULE$.wrapRefArray((Object[])new Class[]{Frame.class, Boolean.TYPE, SQLContext.class}), (ClassTag)ClassTag$.MODULE$.apply(H2OContext.class)).map((Function1 & Serializable & scala.Serializable)x$4 -> x$4.invoke((Object)MODULE$.getH2OContext(), frame, Predef$.MODULE$.boolean2Boolean(true), sql))).orElse((Function0 & Serializable & scala.Serializable)() -> MODULE$.getMethod("asDataFrame", (Seq<Class<?>>)Predef$.MODULE$.wrapRefArray((Object[])new Class[]{Frame.class, Boolean.TYPE}), (ClassTag)ClassTag$.MODULE$.apply(H2OContext.class)).map((Function1 & Serializable & scala.Serializable)x$5 -> x$5.invoke((Object)MODULE$.getH2OContext(), frame, Predef$.MODULE$.boolean2Boolean(true)))).orElse((Function0 & Serializable & scala.Serializable)() -> MODULE$.getMethod("asSparkFrame", (Seq<Class<?>>)Predef$.MODULE$.wrapRefArray((Object[])new Class[]{Frame.class, Boolean.TYPE}), (ClassTag)ClassTag$.MODULE$.apply(H2OContext.class)).map((Function1 & Serializable & scala.Serializable)x$6 -> x$6.invoke((Object)MODULE$.getH2OContext(), frame, Predef$.MODULE$.boolean2Boolean(true)))).getOrElse((Function0 & Serializable & scala.Serializable)() -> {
            throw new IllegalArgumentException("Using an unsupported version of Sparkling Water");
        });
    }

    public Map<String, String> h2oSparkOptions() {
        return (Map)Predef$.MODULE$.Map().apply((Seq)Predef$.MODULE$.wrapRefArray((Object[])new Tuple2[]{Predef.ArrowAssoc$.MODULE$.$minus$greater$extension(Predef$.MODULE$.ArrowAssoc((Object)"spark.ext.h2o.disable.ga"), (Object)"true"), Predef.ArrowAssoc$.MODULE$.$minus$greater$extension(Predef$.MODULE$.ArrowAssoc((Object)"spark.ext.h2o.repl.enabled"), (Object)"false"), Predef.ArrowAssoc$.MODULE$.$minus$greater$extension(Predef$.MODULE$.ArrowAssoc((Object)"spark.ext.h2o.spark.version.check.enabled"), (Object)"false")}));
    }

    private Tuple3<H2OFrame, H2OFrame, Dataset<Row>> getScorableData(Dataset<Row> data, String featuresColumn, IndexedSeq<String> categoricalFeatures, Option<String> target, boolean categoricalTarget) {
        Row row = (Row)data.first();
        int nNumericVar = ((Vector)row.getAs(featuresColumn)).size();
        Dataset<Row> zipped = Util$.MODULE$.RichDataFrame(data).zipWithIndex();
        Dataset pruned = zipped.select((Seq)((TraversableLike)((TraversableLike)categoricalFeatures.$plus$plus((GenTraversableOnce)new .colon.colon((Object)featuresColumn, (List)new .colon.colon((Object)"index", (List)Nil$.MODULE$)), IndexedSeq$.MODULE$.canBuildFrom())).$plus$plus((GenTraversableOnce)Option$.MODULE$.option2Iterable(target), IndexedSeq$.MODULE$.canBuildFrom())).map((Function1 & Serializable & scala.Serializable)colName -> zipped.apply(colName), IndexedSeq$.MODULE$.canBuildFrom()));
        H2OFrame h2oFrame = this.getH2OContext().asH2OFrame(pruned);
        scala.collection.immutable.IndexedSeq<String> numericalNames = package$.MODULE$.h2oNumericalFeatureVectorToNames(featuresColumn, Predef$.MODULE$.int2Integer(nNumericVar));
        H2OFrame train = h2oFrame.apply((String[])((TraversableOnce)((TraversableLike)numericalNames.$plus$plus(categoricalFeatures, scala.collection.immutable.IndexedSeq$.MODULE$.canBuildFrom())).$plus$plus((GenTraversableOnce)Option$.MODULE$.option2Iterable(target), scala.collection.immutable.IndexedSeq$.MODULE$.canBuildFrom())).toArray(ClassTag$.MODULE$.apply(String.class)));
        categoricalFeatures.indices().foreach((Function1 & Serializable & scala.Serializable)i -> train.replace(nNumericVar + BoxesRunTime.unboxToInt((Object)i), train.vec((String)categoricalFeatures.apply(BoxesRunTime.unboxToInt((Object)i))).toCategoricalVec()));
        Object object = target.isDefined() && categoricalTarget ? train.replace(train.numCols() - 1, train.lastVec().toCategoricalVec()) : BoxedUnit.UNIT;
        train.update();
        return new Tuple3((Object)train, (Object)h2oFrame, zipped);
    }

    private boolean getScorableData$default$5() {
        return false;
    }

    public H2OFrame getTrainingData(Dataset<Row> data, String features, IndexedSeq<String> categoricalFeatures, Option<String> target, boolean categoricalTarget) {
        Tuple3<H2OFrame, H2OFrame, Dataset<Row>> tuple3 = this.getScorableData(data, features, categoricalFeatures, target, categoricalTarget);
        if (tuple3 == null) {
            throw new MatchError(tuple3);
        }
        H2OFrame train = (H2OFrame)tuple3._1();
        H2OFrame h2oFrame = (H2OFrame)tuple3._2();
        Dataset zipped = (Dataset)tuple3._3();
        Tuple3 tuple32 = new Tuple3((Object)train, (Object)h2oFrame, (Object)zipped);
        H2OFrame train2 = (H2OFrame)tuple32._1();
        H2OFrame h2oFrame2 = (H2OFrame)tuple32._2();
        Dataset zipped2 = (Dataset)tuple32._3();
        return train2;
    }

    public Dataset<Row> score(Dataset<Row> data, String features, IndexedSeq<String> categoricalFeatures, Function1<H2OFrame, H2OFrame> scoringMethod) {
        Tuple3<H2OFrame, H2OFrame, Dataset<Row>> tuple3 = this.getScorableData(data, features, categoricalFeatures, (Option<String>)None$.MODULE$, this.getScorableData$default$5());
        if (tuple3 == null) {
            throw new MatchError(tuple3);
        }
        H2OFrame train = (H2OFrame)tuple3._1();
        H2OFrame h2oFrame = (H2OFrame)tuple3._2();
        Dataset zipped = (Dataset)tuple3._3();
        Tuple3 tuple32 = new Tuple3((Object)train, (Object)h2oFrame, (Object)zipped);
        H2OFrame train2 = (H2OFrame)tuple32._1();
        H2OFrame h2oFrame2 = (H2OFrame)tuple32._2();
        Dataset zipped2 = (Dataset)tuple32._3();
        H2OFrame scoring = (H2OFrame)scoringMethod.apply((Object)train2);
        scoring.add("index", h2oFrame2.vec("index"));
        scoring.update();
        Dataset<Row> scoringDf = this.asDataFrame(scoring, data.sqlContext());
        return zipped2.join(scoringDf, "index").drop("index");
    }

    public static final /* synthetic */ boolean $anonfun$getMethod$2(Tuple2 x0$1) {
        Tuple2 tuple2 = x0$1;
        if (tuple2 != null) {
            Class c1 = (Class)tuple2._1();
            Class c2 = (Class)tuple2._2();
            Class clazz = c1;
            Class clazz2 = c2;
            return !(clazz != null ? !clazz.equals(clazz2) : clazz2 != null);
        }
        throw new MatchError((Object)tuple2);
    }

    /*
     * Enabled force condition propagation
     * Lifted jumps to return sites
     */
    public static final /* synthetic */ boolean $anonfun$getMethod$1(String name$1, Seq args$1, Method m) {
        String string = m.getName();
        String string2 = name$1;
        if (string == null) {
            if (string2 != null) {
                return false;
            }
        } else if (!string.equals(string2)) return false;
        if (m.getParameterTypes().length != args$1.length()) return false;
        if (!new ArrayOps.ofRef(Predef$.MODULE$.refArrayOps((Object[])new ArrayOps.ofRef(Predef$.MODULE$.refArrayOps((Object[])m.getParameterTypes())).zip((GenIterable)args$1, Array$.MODULE$.canBuildFrom(ClassTag$.MODULE$.apply(Tuple2.class))))).forall((Function1 & Serializable & scala.Serializable)x0$1 -> BoxesRunTime.boxToBoolean((boolean)H2OSupport$.$anonfun$getMethod$2(x0$1)))) return false;
        return true;
    }

    private H2OSupport$() {
        MODULE$ = this;
        this.h2OContext = null;
        this.sparkContext = null;
    }
}

