/*
 * Decompiled with CFR 0.152.
 */
package com.dataiku.dss.legacy.aws.com.amazonaws.services.identitymanagement.model.transform;

import com.dataiku.dss.legacy.aws.com.amazonaws.services.identitymanagement.model.ContextEntry;
import com.dataiku.dss.legacy.aws.com.amazonaws.transform.SimpleTypeStaxUnmarshallers;
import com.dataiku.dss.legacy.aws.com.amazonaws.transform.StaxUnmarshallerContext;
import com.dataiku.dss.legacy.aws.com.amazonaws.transform.Unmarshaller;
import java.util.ArrayList;
import javax.xml.stream.events.XMLEvent;

public class ContextEntryStaxUnmarshaller
implements Unmarshaller<ContextEntry, StaxUnmarshallerContext> {
    private static ContextEntryStaxUnmarshaller instance;

    @Override
    public ContextEntry unmarshall(StaxUnmarshallerContext context) throws Exception {
        ContextEntry contextEntry = new ContextEntry();
        int originalDepth = context.getCurrentDepth();
        int targetDepth = originalDepth + 1;
        if (context.isStartOfDocument()) {
            ++targetDepth;
        }
        while (true) {
            XMLEvent xmlEvent;
            if ((xmlEvent = context.nextEvent()).isEndDocument()) {
                return contextEntry;
            }
            if (xmlEvent.isAttribute() || xmlEvent.isStartElement()) {
                if (context.testExpression("ContextKeyName", targetDepth)) {
                    contextEntry.setContextKeyName(SimpleTypeStaxUnmarshallers.StringStaxUnmarshaller.getInstance().unmarshall(context));
                    continue;
                }
                if (context.testExpression("ContextKeyValues", targetDepth)) {
                    contextEntry.withContextKeyValues(new ArrayList<String>());
                    continue;
                }
                if (context.testExpression("ContextKeyValues/member", targetDepth)) {
                    contextEntry.withContextKeyValues(SimpleTypeStaxUnmarshallers.StringStaxUnmarshaller.getInstance().unmarshall(context));
                    continue;
                }
                if (!context.testExpression("ContextKeyType", targetDepth)) continue;
                contextEntry.setContextKeyType(SimpleTypeStaxUnmarshallers.StringStaxUnmarshaller.getInstance().unmarshall(context));
                continue;
            }
            if (xmlEvent.isEndElement() && context.getCurrentDepth() < originalDepth) break;
        }
        return contextEntry;
    }

    public static ContextEntryStaxUnmarshaller getInstance() {
        if (instance == null) {
            instance = new ContextEntryStaxUnmarshaller();
        }
        return instance;
    }
}

