/*
 * Decompiled with CFR 0.152.
 */
package org.geotools.filter.visitor;

import org.geotools.filter.visitor.DuplicatingFilterVisitor;
import org.geotools.geometry.jts.ReferencedEnvelope;
import org.locationtech.jts.geom.Envelope;
import org.locationtech.jts.geom.Geometry;
import org.opengis.filter.FilterFactory2;
import org.opengis.filter.expression.Expression;
import org.opengis.filter.expression.Literal;
import org.opengis.filter.spatial.BBOX;
import org.opengis.referencing.crs.CoordinateReferenceSystem;

public class FixBBOXFilterVisitor
extends DuplicatingFilterVisitor {
    ReferencedEnvelope maxbbox;

    public FixBBOXFilterVisitor(ReferencedEnvelope maxbbox) {
        this.maxbbox = maxbbox;
    }

    @Override
    public Object visit(BBOX filter, Object extraData) {
        Envelope bbox = null;
        Expression leftGeometry = filter.getExpression1();
        Expression rightGeometry = filter.getExpression2();
        boolean clipped = false;
        Literal le = null;
        if (leftGeometry != null && leftGeometry instanceof Literal) {
            le = (Literal)leftGeometry;
        } else if (rightGeometry != null && rightGeometry instanceof Literal) {
            le = (Literal)rightGeometry;
        }
        CoordinateReferenceSystem crs = null;
        if (le != null && le.getValue() != null && le.getValue() instanceof Geometry) {
            Geometry geometry = (Geometry)le.getValue();
            bbox = geometry.getEnvelopeInternal();
            crs = (CoordinateReferenceSystem)geometry.getUserData();
        } else if (le != null && le.getValue() != null && le.getValue() instanceof ReferencedEnvelope) {
            bbox = (Envelope)le.getValue();
            crs = ((ReferencedEnvelope)((Object)le.getValue())).getCoordinateReferenceSystem();
        }
        if (bbox == null) {
            return super.visit(filter, extraData);
        }
        double minx = bbox.getMinX();
        double miny = bbox.getMinY();
        double maxx = bbox.getMaxX();
        double maxy = bbox.getMaxY();
        if (this.maxbbox != null) {
            if (minx < this.maxbbox.getMinX()) {
                minx = this.maxbbox.getMinX();
                clipped = true;
            }
            if (maxx > this.maxbbox.getMaxX()) {
                maxx = this.maxbbox.getMaxX();
                clipped = true;
            }
            if (miny < this.maxbbox.getMinY()) {
                miny = this.maxbbox.getMinY();
                clipped = true;
            }
            if (maxy > this.maxbbox.getMaxY()) {
                maxy = this.maxbbox.getMaxY();
                clipped = true;
            }
        }
        if (clipped) {
            FilterFactory2 ff = this.getFactory(extraData);
            return ff.bbox(filter.getExpression1(), (Expression)ff.literal((Object)new ReferencedEnvelope(minx, maxx, miny, maxy, crs)));
        }
        return super.visit(filter, extraData);
    }
}

