/*
 * Decompiled with CFR 0.152.
 */
package io.delta.kernel.defaults.internal.data.vector;

import io.delta.kernel.data.ArrayValue;
import io.delta.kernel.data.ColumnVector;
import io.delta.kernel.data.MapValue;
import io.delta.kernel.internal.util.Preconditions;
import io.delta.kernel.types.DataType;
import java.math.BigDecimal;
import java.util.Objects;
import java.util.Optional;

public abstract class AbstractColumnVector
implements ColumnVector {
    private final int size;
    private final DataType dataType;
    private final Optional<boolean[]> nullability;

    protected AbstractColumnVector(int n, DataType dataType, Optional<boolean[]> optional) {
        Preconditions.checkArgument((n >= 0 ? 1 : 0) != 0, (String)"invalid size: %s", (Object[])new Object[]{n});
        optional.ifPresent(blArray -> Preconditions.checkArgument((((boolean[])blArray).length >= n ? 1 : 0) != 0, (String)"invalid number of values (%s) for given size (%s)", (Object[])new Object[]{((boolean[])blArray).length, n}));
        this.size = n;
        this.dataType = Objects.requireNonNull(dataType);
        this.nullability = Objects.requireNonNull(optional);
    }

    public DataType getDataType() {
        return this.dataType;
    }

    public int getSize() {
        return this.size;
    }

    public void close() {
    }

    public boolean isNullAt(int n) {
        this.checkValidRowId(n);
        if (!this.nullability.isPresent()) {
            return false;
        }
        return this.nullability.get()[n];
    }

    public boolean getBoolean(int n) {
        throw this.unsupportedDataAccessException("boolean");
    }

    public byte getByte(int n) {
        throw this.unsupportedDataAccessException("byte");
    }

    public short getShort(int n) {
        throw this.unsupportedDataAccessException("short");
    }

    public int getInt(int n) {
        throw this.unsupportedDataAccessException("int");
    }

    public long getLong(int n) {
        throw this.unsupportedDataAccessException("long");
    }

    public float getFloat(int n) {
        throw this.unsupportedDataAccessException("float");
    }

    public double getDouble(int n) {
        throw this.unsupportedDataAccessException("double");
    }

    public byte[] getBinary(int n) {
        throw this.unsupportedDataAccessException("binary");
    }

    public String getString(int n) {
        throw this.unsupportedDataAccessException("string");
    }

    public BigDecimal getDecimal(int n) {
        throw this.unsupportedDataAccessException("decimal");
    }

    public MapValue getMap(int n) {
        throw this.unsupportedDataAccessException("map");
    }

    public ArrayValue getArray(int n) {
        throw this.unsupportedDataAccessException("array");
    }

    protected UnsupportedOperationException unsupportedDataAccessException(String string) {
        String string2 = String.format("Trying to access a `%s` value from vector of type `%s`", string, this.getDataType());
        throw new UnsupportedOperationException(string2);
    }

    protected void checkValidRowId(int n) {
        if (n < 0 || n >= this.size) {
            throw new IllegalArgumentException("invalid row access: " + n);
        }
    }
}

