/*
 * Decompiled with CFR 0.152.
 */
package com.dataiku.dss.shadelibpoi.org.apache.poi.ss.formula;

import com.dataiku.dss.shadelibpoi.org.apache.poi.ss.formula.OperationEvaluationContext;
import com.dataiku.dss.shadelibpoi.org.apache.poi.ss.formula.OperationEvaluatorFactory;
import com.dataiku.dss.shadelibpoi.org.apache.poi.ss.formula.eval.FunctionNameEval;
import com.dataiku.dss.shadelibpoi.org.apache.poi.ss.formula.eval.NotImplementedFunctionException;
import com.dataiku.dss.shadelibpoi.org.apache.poi.ss.formula.eval.ValueEval;
import com.dataiku.dss.shadelibpoi.org.apache.poi.ss.formula.functions.ArrayFunction;
import com.dataiku.dss.shadelibpoi.org.apache.poi.ss.formula.functions.FreeRefFunction;

final class UserDefinedFunction
implements FreeRefFunction {
    public static final FreeRefFunction instance = new UserDefinedFunction();

    private UserDefinedFunction() {
    }

    @Override
    public ValueEval evaluate(ValueEval[] args, OperationEvaluationContext ec) {
        ArrayFunction func;
        ValueEval eval;
        int nIncomingArgs = args.length;
        if (nIncomingArgs < 1) {
            throw new IllegalStateException("function name argument missing");
        }
        ValueEval nameArg = args[0];
        if (!(nameArg instanceof FunctionNameEval)) {
            throw new IllegalStateException("First argument should be a NameEval, but got (" + nameArg.getClass().getName() + ")");
        }
        String functionName = ((FunctionNameEval)nameArg).getFunctionName();
        FreeRefFunction targetFunc = ec.findUserDefinedFunction(functionName);
        if (targetFunc == null) {
            throw new NotImplementedFunctionException(functionName);
        }
        int nOutGoingArgs = nIncomingArgs - 1;
        ValueEval[] outGoingArgs = new ValueEval[nOutGoingArgs];
        System.arraycopy(args, 1, outGoingArgs, 0, nOutGoingArgs);
        if (targetFunc instanceof ArrayFunction && (eval = OperationEvaluatorFactory.evaluateArrayFunction(func = (ArrayFunction)((Object)targetFunc), outGoingArgs, ec)) != null) {
            return eval;
        }
        return targetFunc.evaluate(outGoingArgs, ec);
    }
}

