/*
 * Decompiled with CFR 0.152.
 */
package com.dataiku.dss.shadelibpoi.org.apache.poi.xdgf.usermodel.section.geometry;

import com.dataiku.dss.shadelibpoi.org.apache.poi.ooxml.POIXMLException;
import com.dataiku.dss.shadelibpoi.org.apache.poi.xdgf.usermodel.XDGFCell;
import com.dataiku.dss.shadelibpoi.org.apache.poi.xdgf.usermodel.XDGFShape;
import com.dataiku.dss.shadelibpoi.org.apache.poi.xdgf.usermodel.section.geometry.EllipticalArcTo;
import com.dataiku.dss.shadelibpoi.org.apache.poi.xdgf.usermodel.section.geometry.GeometryRow;
import com.microsoft.schemas.office.visio.x2012.main.CellType;
import com.microsoft.schemas.office.visio.x2012.main.RowType;
import java.awt.geom.Path2D;

public class RelEllipticalArcTo
implements GeometryRow {
    RelEllipticalArcTo _master;
    Double x;
    Double y;
    Double a;
    Double b;
    Double c;
    Double d;
    Boolean deleted;

    public RelEllipticalArcTo(RowType row) {
        if (row.isSetDel()) {
            this.deleted = row.getDel();
        }
        block16: for (CellType cell : row.getCellArray()) {
            String cellName;
            switch (cellName = cell.getN()) {
                case "X": {
                    this.x = XDGFCell.parseDoubleValue(cell);
                    continue block16;
                }
                case "Y": {
                    this.y = XDGFCell.parseDoubleValue(cell);
                    continue block16;
                }
                case "A": {
                    this.a = XDGFCell.parseDoubleValue(cell);
                    continue block16;
                }
                case "B": {
                    this.b = XDGFCell.parseDoubleValue(cell);
                    continue block16;
                }
                case "C": {
                    this.c = XDGFCell.parseDoubleValue(cell);
                    continue block16;
                }
                case "D": {
                    this.d = XDGFCell.parseDoubleValue(cell);
                    continue block16;
                }
                default: {
                    throw new POIXMLException("Invalid cell '" + cellName + "' in RelEllipticalArcTo row");
                }
            }
        }
    }

    public boolean getDel() {
        if (this.deleted != null) {
            return this.deleted;
        }
        return this._master != null && this._master.getDel();
    }

    public Double getX() {
        return this.x == null ? this._master.x : this.x;
    }

    public Double getY() {
        return this.y == null ? this._master.y : this.y;
    }

    public Double getA() {
        return this.a == null ? this._master.a : this.a;
    }

    public Double getB() {
        return this.b == null ? this._master.b : this.b;
    }

    public Double getC() {
        return this.c == null ? this._master.c : this.c;
    }

    public Double getD() {
        return this.d == null ? this._master.d : this.d;
    }

    @Override
    public void setupMaster(GeometryRow row) {
        this._master = (RelEllipticalArcTo)row;
    }

    @Override
    public void addToPath(Path2D.Double path, XDGFShape parent) {
        if (this.getDel()) {
            return;
        }
        double w = parent.getWidth();
        double h = parent.getHeight();
        double x = this.getX() * w;
        double y = this.getY() * h;
        double a = this.getA() * w;
        double b = this.getB() * h;
        double c = this.getC();
        double d = this.getD();
        EllipticalArcTo.createEllipticalArc(x, y, a, b, c, d, path);
    }
}

