/*
 * Decompiled with CFR 0.152.
 */
package com.dataiku.dss.shadelib.com.nimbusds.oauth2.sdk.dpop;

import com.dataiku.dss.shadelib.com.nimbusds.jose.JOSEException;
import com.dataiku.dss.shadelib.com.nimbusds.jose.JWSAlgorithm;
import com.dataiku.dss.shadelib.com.nimbusds.jose.JWSHeader;
import com.dataiku.dss.shadelib.com.nimbusds.jose.JWSSigner;
import com.dataiku.dss.shadelib.com.nimbusds.jose.crypto.factories.DefaultJWSSignerFactory;
import com.dataiku.dss.shadelib.com.nimbusds.jose.jwk.JWK;
import com.dataiku.dss.shadelib.com.nimbusds.jwt.JWTClaimsSet;
import com.dataiku.dss.shadelib.com.nimbusds.jwt.SignedJWT;
import com.dataiku.dss.shadelib.com.nimbusds.oauth2.sdk.dpop.DPoPProofFactory;
import com.dataiku.dss.shadelib.com.nimbusds.oauth2.sdk.dpop.DPoPUtils;
import com.dataiku.dss.shadelib.com.nimbusds.oauth2.sdk.id.JWTID;
import com.dataiku.dss.shadelib.com.nimbusds.oauth2.sdk.token.AccessToken;
import com.dataiku.dss.shadelib.com.nimbusds.openid.connect.sdk.Nonce;
import java.net.URI;
import java.security.Provider;
import java.util.Date;

public class DefaultDPoPProofFactory
implements DPoPProofFactory {
    private final JWK publicJWK;
    private final JWSAlgorithm jwsAlg;
    private final JWSSigner jwsSigner;

    public DefaultDPoPProofFactory(JWK jwk, JWSAlgorithm jwsAlg) throws JOSEException {
        this(jwk, jwsAlg, null);
    }

    public DefaultDPoPProofFactory(JWK jwk, JWSAlgorithm jwsAlg, Provider jcaProvider) throws JOSEException {
        if (!jwk.isPrivate()) {
            throw new IllegalArgumentException("The JWK must include private parameters");
        }
        if (!JWSAlgorithm.Family.SIGNATURE.contains(jwsAlg)) {
            throw new IllegalArgumentException("The JWS algorithm must be for a digital signature");
        }
        this.jwsAlg = jwsAlg;
        DefaultJWSSignerFactory factory = new DefaultJWSSignerFactory();
        if (jcaProvider != null) {
            factory.getJCAContext().setProvider(jcaProvider);
        }
        this.jwsSigner = factory.createJWSSigner(jwk, jwsAlg);
        this.publicJWK = jwk.toPublicJWK();
    }

    public JWK getPublicJWK() {
        return this.publicJWK;
    }

    public JWSAlgorithm getJWSAlgorithm() {
        return this.jwsAlg;
    }

    public JWSSigner getJWSSigner() {
        return this.jwsSigner;
    }

    @Override
    public SignedJWT createDPoPJWT(String htm, URI htu) throws JOSEException {
        return this.createDPoPJWT(htm, htu, null, null);
    }

    @Override
    public SignedJWT createDPoPJWT(String htm, URI htu, Nonce nonce) throws JOSEException {
        return this.createDPoPJWT(htm, htu, null, nonce);
    }

    @Override
    public SignedJWT createDPoPJWT(String htm, URI htu, AccessToken accessToken) throws JOSEException {
        return this.createDPoPJWT(htm, htu, accessToken, null);
    }

    @Override
    public SignedJWT createDPoPJWT(String htm, URI htu, AccessToken accessToken, Nonce nonce) throws JOSEException {
        return this.createDPoPJWT(new JWTID(12), htm, htu, new Date(), accessToken, nonce);
    }

    @Override
    public SignedJWT createDPoPJWT(JWTID jti, String htm, URI htu, Date iat, AccessToken accessToken) throws JOSEException {
        return this.createDPoPJWT(jti, htm, htu, iat, accessToken, null);
    }

    @Override
    public SignedJWT createDPoPJWT(JWTID jti, String htm, URI htu, Date iat, AccessToken accessToken, Nonce nonce) throws JOSEException {
        JWSHeader jwsHeader = new JWSHeader.Builder(this.getJWSAlgorithm()).type(TYPE).jwk(this.getPublicJWK()).build();
        JWTClaimsSet jwtClaimsSet = DPoPUtils.createJWTClaimsSet(jti, htm, htu, iat, accessToken, nonce);
        SignedJWT signedJWT = new SignedJWT(jwsHeader, jwtClaimsSet);
        signedJWT.sign(this.getJWSSigner());
        return signedJWT;
    }
}

