/*
 * Decompiled with CFR 0.152.
 */
package com.dataiku.dss.shadelib.com.nimbusds.openid.connect.sdk.federation.trust.constraints;

import com.dataiku.dss.shadelib.com.nimbusds.oauth2.sdk.ParseException;
import com.dataiku.dss.shadelib.com.nimbusds.oauth2.sdk.id.Identifier;
import com.dataiku.dss.shadelib.com.nimbusds.oauth2.sdk.util.CollectionUtils;
import com.dataiku.dss.shadelib.com.nimbusds.openid.connect.sdk.federation.entities.EntityType;
import com.dataiku.dss.shadelib.net.jcip.annotations.Immutable;
import java.util.HashSet;
import java.util.List;
import java.util.Objects;
import java.util.Set;

@Immutable
public final class LeafEntityTypeConstraint {
    public static final LeafEntityTypeConstraint ANY = new LeafEntityTypeConstraint(null);
    private final Set<EntityType> allowed;

    public LeafEntityTypeConstraint(Set<EntityType> allowed) {
        this.allowed = CollectionUtils.isNotEmpty(allowed) ? allowed : null;
    }

    public boolean allowsAny() {
        return CollectionUtils.isEmpty(this.allowed);
    }

    public Set<EntityType> getAllowed() {
        return this.allowed;
    }

    public List<String> getAllowedAsStringList() {
        if (this.allowsAny()) {
            return null;
        }
        return Identifier.toStringList(this.allowed);
    }

    public boolean isAllowed(EntityType type) {
        return this.allowsAny() || this.allowed.contains(type);
    }

    public String toString() {
        if (this.allowsAny()) {
            return "null";
        }
        return this.allowed.toString();
    }

    public boolean equals(Object o) {
        if (this == o) {
            return true;
        }
        if (!(o instanceof LeafEntityTypeConstraint)) {
            return false;
        }
        LeafEntityTypeConstraint that = (LeafEntityTypeConstraint)o;
        return Objects.equals(this.getAllowed(), that.getAllowed());
    }

    public int hashCode() {
        return Objects.hash(this.getAllowed());
    }

    public static LeafEntityTypeConstraint parse(List<String> values2) throws ParseException {
        if (CollectionUtils.isEmpty(values2)) {
            return ANY;
        }
        HashSet<EntityType> types = new HashSet<EntityType>();
        for (String v : values2) {
            types.add(new EntityType(v));
        }
        return new LeafEntityTypeConstraint(types);
    }
}

