/*
 * Decompiled with CFR 0.152.
 */
package com.dataiku.dss.shadelib.org.apache.lucene.analysis.compound;

import com.dataiku.dss.shadelib.org.apache.lucene.analysis.CharArraySet;
import com.dataiku.dss.shadelib.org.apache.lucene.analysis.TokenFilterFactory;
import com.dataiku.dss.shadelib.org.apache.lucene.analysis.TokenStream;
import com.dataiku.dss.shadelib.org.apache.lucene.analysis.compound.DictionaryCompoundWordTokenFilter;
import com.dataiku.dss.shadelib.org.apache.lucene.util.ResourceLoader;
import com.dataiku.dss.shadelib.org.apache.lucene.util.ResourceLoaderAware;
import java.io.IOException;
import java.util.Map;

public class DictionaryCompoundWordTokenFilterFactory
extends TokenFilterFactory
implements ResourceLoaderAware {
    public static final String NAME = "dictionaryCompoundWord";
    private CharArraySet dictionary;
    private final String dictFile;
    private final int minWordSize;
    private final int minSubwordSize;
    private final int maxSubwordSize;
    private final boolean onlyLongestMatch;

    public DictionaryCompoundWordTokenFilterFactory(Map<String, String> args2) {
        super(args2);
        this.dictFile = this.require(args2, "dictionary");
        this.minWordSize = this.getInt(args2, "minWordSize", 5);
        this.minSubwordSize = this.getInt(args2, "minSubwordSize", 2);
        this.maxSubwordSize = this.getInt(args2, "maxSubwordSize", 15);
        this.onlyLongestMatch = this.getBoolean(args2, "onlyLongestMatch", true);
        if (!args2.isEmpty()) {
            throw new IllegalArgumentException("Unknown parameters: " + args2);
        }
    }

    public DictionaryCompoundWordTokenFilterFactory() {
        throw DictionaryCompoundWordTokenFilterFactory.defaultCtorException();
    }

    @Override
    public void inform(ResourceLoader loader) throws IOException {
        this.dictionary = super.getWordSet(loader, this.dictFile, false);
    }

    @Override
    public TokenStream create(TokenStream input) {
        if (this.dictionary == null) {
            return input;
        }
        return new DictionaryCompoundWordTokenFilter(input, this.dictionary, this.minWordSize, this.minSubwordSize, this.maxSubwordSize, this.onlyLongestMatch);
    }
}

