/*
 * Decompiled with CFR 0.152.
 */
package com.dataiku.dss.shadelib.org.apache.lucene.analysis.de;

import com.dataiku.dss.shadelib.org.apache.lucene.analysis.Analyzer;
import com.dataiku.dss.shadelib.org.apache.lucene.analysis.CharArraySet;
import com.dataiku.dss.shadelib.org.apache.lucene.analysis.LowerCaseFilter;
import com.dataiku.dss.shadelib.org.apache.lucene.analysis.StopFilter;
import com.dataiku.dss.shadelib.org.apache.lucene.analysis.StopwordAnalyzerBase;
import com.dataiku.dss.shadelib.org.apache.lucene.analysis.TokenFilter;
import com.dataiku.dss.shadelib.org.apache.lucene.analysis.TokenStream;
import com.dataiku.dss.shadelib.org.apache.lucene.analysis.WordlistLoader;
import com.dataiku.dss.shadelib.org.apache.lucene.analysis.de.GermanLightStemFilter;
import com.dataiku.dss.shadelib.org.apache.lucene.analysis.de.GermanNormalizationFilter;
import com.dataiku.dss.shadelib.org.apache.lucene.analysis.miscellaneous.SetKeywordMarkerFilter;
import com.dataiku.dss.shadelib.org.apache.lucene.analysis.snowball.SnowballFilter;
import com.dataiku.dss.shadelib.org.apache.lucene.analysis.standard.StandardTokenizer;
import com.dataiku.dss.shadelib.org.apache.lucene.util.IOUtils;
import java.io.IOException;
import java.io.UncheckedIOException;

public final class GermanAnalyzer
extends StopwordAnalyzerBase {
    public static final String DEFAULT_STOPWORD_FILE = "german_stop.txt";
    private final CharArraySet exclusionSet;

    public static final CharArraySet getDefaultStopSet() {
        return DefaultSetHolder.DEFAULT_SET;
    }

    public GermanAnalyzer() {
        this(DefaultSetHolder.DEFAULT_SET);
    }

    public GermanAnalyzer(CharArraySet stopwords) {
        this(stopwords, CharArraySet.EMPTY_SET);
    }

    public GermanAnalyzer(CharArraySet stopwords, CharArraySet stemExclusionSet) {
        super(stopwords);
        this.exclusionSet = CharArraySet.unmodifiableSet(CharArraySet.copy(stemExclusionSet));
    }

    @Override
    protected Analyzer.TokenStreamComponents createComponents(String fieldName) {
        StandardTokenizer source = new StandardTokenizer();
        TokenFilter result = new LowerCaseFilter(source);
        result = new StopFilter(result, this.stopwords);
        result = new SetKeywordMarkerFilter(result, this.exclusionSet);
        result = new GermanNormalizationFilter(result);
        result = new GermanLightStemFilter(result);
        return new Analyzer.TokenStreamComponents(source, (TokenStream)result);
    }

    @Override
    protected TokenStream normalize(String fieldName, TokenStream in) {
        TokenFilter result = new LowerCaseFilter(in);
        result = new GermanNormalizationFilter(result);
        return result;
    }

    private static class DefaultSetHolder {
        private static final CharArraySet DEFAULT_SET;

        private DefaultSetHolder() {
        }

        static {
            try {
                DEFAULT_SET = WordlistLoader.getSnowballWordSet(IOUtils.requireResourceNonNull(SnowballFilter.class.getResourceAsStream(GermanAnalyzer.DEFAULT_STOPWORD_FILE), GermanAnalyzer.DEFAULT_STOPWORD_FILE));
            }
            catch (IOException ex) {
                throw new UncheckedIOException("Unable to load default stopword set", ex);
            }
        }
    }
}

