/*
 * Decompiled with CFR 0.152.
 */
package com.dataiku.dss.shadelib.org.eclipse.jetty.session;

import com.dataiku.dss.shadelib.org.eclipse.jetty.session.AbstractSessionCacheFactory;
import com.dataiku.dss.shadelib.org.eclipse.jetty.session.NullSessionCache;
import com.dataiku.dss.shadelib.org.eclipse.jetty.session.SessionCache;
import com.dataiku.dss.shadelib.org.eclipse.jetty.session.SessionManager;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

public class NullSessionCacheFactory
extends AbstractSessionCacheFactory {
    private static final Logger LOG = LoggerFactory.getLogger(NullSessionCacheFactory.class);

    @Override
    public int getEvictionPolicy() {
        return 0;
    }

    @Override
    public void setEvictionPolicy(int evictionPolicy) {
        if (LOG.isDebugEnabled()) {
            LOG.debug("Ignoring eviction policy setting for NullSessionCaches");
        }
    }

    @Override
    public boolean isSaveOnInactiveEviction() {
        return false;
    }

    @Override
    public void setSaveOnInactiveEviction(boolean saveOnInactiveEvict) {
        if (LOG.isDebugEnabled()) {
            LOG.debug("Ignoring eviction policy setting for NullSessionCaches");
        }
    }

    @Override
    public boolean isInvalidateOnShutdown() {
        return false;
    }

    @Override
    public void setInvalidateOnShutdown(boolean invalidateOnShutdown) {
        if (LOG.isDebugEnabled()) {
            LOG.debug("Ignoring invalidateOnShutdown setting for NullSessionCaches");
        }
    }

    @Override
    public SessionCache newSessionCache(SessionManager manager) {
        return new NullSessionCache(manager);
    }
}

