/*
 * Decompiled with CFR 0.152.
 */
package com.twitter.hbc;

import com.google.common.annotations.VisibleForTesting;
import com.twitter.hbc.ReconnectionManager;

public class BasicReconnectionManager
implements ReconnectionManager {
    public static final int INITIAL_EXPONENTIAL_BACKOFF_MILLIS = 5000;
    public static final int INITIAL_LINEAR_BACKOFF_MILLIS = 250;
    public static final int MAX_LINEAR_BACKOFF_MILLIS = 16000;
    public static final int MAX_EXPONENTIAL_BACKOFF_MILLIS = 320000;
    private final int maxRetries;
    private int currentRetryCount;
    private int exponentialBackoffCount;
    private int linearBackoffCount;
    private int backoffMillis;

    public BasicReconnectionManager(int maxRetries) {
        this.maxRetries = maxRetries;
    }

    @Override
    public void handleExponentialBackoff() {
        this.handleBackoff(this.incrAndGetExponentialBackoff());
    }

    @Override
    public void handleLinearBackoff() {
        this.handleBackoff(this.incrAndGetLinearBackoff());
    }

    @Override
    public boolean shouldReconnectOn400s() {
        ++this.currentRetryCount;
        return this.currentRetryCount <= this.maxRetries;
    }

    @Override
    public int estimateBackfill(double tps) {
        return Math.min(150000, (int)tps * this.backoffMillis);
    }

    @Override
    public void resetCounts() {
        this.linearBackoffCount = 0;
        this.exponentialBackoffCount = 0;
        this.currentRetryCount = 0;
        this.backoffMillis = 0;
    }

    private void handleBackoff(int millis) {
        this.backoffMillis += millis;
        try {
            Thread.sleep(millis);
        }
        catch (InterruptedException interruptedException) {
            // empty catch block
        }
    }

    @VisibleForTesting
    int incrAndGetExponentialBackoff() {
        this.linearBackoffCount = 0;
        ++this.exponentialBackoffCount;
        return this.calculateExponentialBackoffMillis();
    }

    @VisibleForTesting
    int incrAndGetLinearBackoff() {
        this.exponentialBackoffCount = 0;
        ++this.linearBackoffCount;
        return this.calculateLinearBackoffMillis();
    }

    private int calculateExponentialBackoffMillis() {
        assert (this.exponentialBackoffCount > 0);
        return Math.min(320000, 5000 << this.exponentialBackoffCount - 1);
    }

    private int calculateLinearBackoffMillis() {
        return Math.min(16000, 250 * this.linearBackoffCount);
    }
}

