/*
 * Decompiled with CFR 0.152.
 */
package com.dataiku.gh.core.models.blueprints;

import com.dataiku.gh.core.models.blueprints.BlueprintVersion;
import com.dataiku.gh.core.models.enriched.EnrichedBlueprintVersion;
import com.dataiku.gh.core.models.migration_paths.BlueprintVersionMigrationPath;
import com.dataiku.gh.core.models.security.RoleUsersContainer;
import com.dataiku.gh.core.models.signoff.SignoffConfiguration;
import com.dataiku.gh.core.models.signoff.SignoffUser;
import com.dataiku.j2ts.annotations.UIModel;
import com.dataiku.j2ts.annotations.UINullable;
import java.util.List;
import java.util.stream.Collectors;
import org.apache.commons.collections4.CollectionUtils;

@UIModel
public class BlueprintVersionExport {
    public BlueprintVersion blueprintVersion;
    @UINullable
    public String originVersionId;
    @UINullable
    public List<SignoffConfiguration> signoffsConfigurations;
    @UINullable
    public List<BlueprintVersionMigrationPath> migrationPaths;

    public static BlueprintVersionExport buildFromAndFilterUsers(EnrichedBlueprintVersion enrichedBlueprintVersion, List<BlueprintVersionMigrationPath> migrationPaths) {
        BlueprintVersionExport exBpv = new BlueprintVersionExport();
        exBpv.blueprintVersion = enrichedBlueprintVersion.blueprintVersion;
        exBpv.originVersionId = enrichedBlueprintVersion.blueprintVersionTrace.originVersionId;
        exBpv.signoffsConfigurations = enrichedBlueprintVersion.signoffsConfigurations;
        if (CollectionUtils.isNotEmpty(exBpv.signoffsConfigurations)) {
            exBpv.signoffsConfigurations.forEach(signoffConfiguration -> {
                signoffConfiguration.feedbackUsersGroups.forEach(signoffUsersGroup -> {
                    signoffUsersGroup.users = BlueprintVersionExport.filterSignoffUsersForExport(signoffUsersGroup.users);
                });
                signoffConfiguration.approvers = BlueprintVersionExport.filterSignoffUsersForExport(signoffConfiguration.approvers);
            });
        }
        if (CollectionUtils.isNotEmpty(migrationPaths)) {
            exBpv.migrationPaths = migrationPaths;
        }
        return exBpv;
    }

    private static List<SignoffUser> filterSignoffUsersForExport(List<SignoffUser> toFilter) {
        return toFilter.stream().filter(user -> user.usersContainer instanceof RoleUsersContainer).peek(user -> {
            user.addedBy = "";
            user.addedOn = "";
        }).collect(Collectors.toList());
    }

    @UIModel
    public static enum MigrationPathImportBehavior {
        FAIL_IMPORT_ON_EXISTING_MIGRATION_OR_MISSING_VERSION,
        IGNORE_MIGRATION_ON_EXISTING_MIGRATION_OR_MISSING_VERSION,
        IMPORT_WITHOUT_MIGRATIONS;

    }
}

