/*
 * Decompiled with CFR 0.152.
 */
package com.dataiku.gh.core.models.blueprints;

import com.dataiku.gh.core.models.blueprints.StepDefinition;
import com.dataiku.gh.core.visitors.IBlueprintVersionVisitor;
import java.util.ArrayList;
import java.util.List;
import java.util.Objects;
import java.util.Optional;
import org.apache.commons.lang3.StringUtils;

public class WorkflowDefinition {
    public List<StepDefinition> stepDefinitions = new ArrayList<StepDefinition>();

    public void accept(IBlueprintVersionVisitor blueprintVersionVisitor) {
        this.stepDefinitions.forEach(stepDefinition -> stepDefinition.accept(blueprintVersionVisitor));
        blueprintVersionVisitor.visit(this);
    }

    public Optional<StepDefinition> findStepDefinitionById(String stepId) {
        return this.stepDefinitions.stream().filter(stepDefinition -> StringUtils.equals((CharSequence)stepDefinition.id, (CharSequence)stepId)).findFirst();
    }

    public boolean hasConditions() {
        return this.stepDefinitions.stream().anyMatch(stepDefinition -> stepDefinition.visibilityCondition != null);
    }

    public boolean equals(Object o) {
        if (this == o) {
            return true;
        }
        if (o == null || this.getClass() != o.getClass()) {
            return false;
        }
        WorkflowDefinition that = (WorkflowDefinition)o;
        return Objects.equals(this.stepDefinitions, that.stepDefinitions);
    }

    public int hashCode() {
        return Objects.hash(this.stepDefinitions);
    }

    public static WorkflowDefinition build(List<StepDefinition> stepDefinitions) {
        WorkflowDefinition def = new WorkflowDefinition();
        def.stepDefinitions = stepDefinitions;
        return def;
    }
}

