/*
 * Decompiled with CFR 0.152.
 */
package com.dataiku.gh.core.models.roles.assignments;

import com.dataiku.gh.core.models.roles.assignments.RoleAssignmentsRule;
import com.dataiku.gh.core.visitors.IBlueprintRoleAssignmentsVisitor;
import com.dataiku.j2ts.annotations.UIModel;
import java.util.ArrayList;
import java.util.HashMap;
import java.util.List;
import java.util.Map;
import java.util.Objects;

@UIModel
public class BlueprintRoleAssignments {
    public String blueprintId;
    public Map<String, List<RoleAssignmentsRule>> roleAssignmentsRules = new HashMap<String, List<RoleAssignmentsRule>>();
    public List<String> inheritBlueprintIds = new ArrayList<String>();
    public List<String> inheritArtifactFieldIds = new ArrayList<String>();

    public void accept(IBlueprintRoleAssignmentsVisitor blueprintRoleAssignmentsVisitor) {
        for (Map.Entry<String, List<RoleAssignmentsRule>> entry : this.roleAssignmentsRules.entrySet()) {
            blueprintRoleAssignmentsVisitor.visit(entry.getKey(), entry.getValue());
            entry.getValue().forEach(roleAssignmentsRule -> roleAssignmentsRule.accept(blueprintRoleAssignmentsVisitor, (String)entry.getKey()));
        }
        blueprintRoleAssignmentsVisitor.visit(this);
    }

    public boolean equals(Object o) {
        if (this == o) {
            return true;
        }
        if (o == null || this.getClass() != o.getClass()) {
            return false;
        }
        BlueprintRoleAssignments that = (BlueprintRoleAssignments)o;
        return Objects.equals(this.blueprintId, that.blueprintId) && Objects.equals(this.roleAssignmentsRules, that.roleAssignmentsRules) && Objects.equals(this.inheritBlueprintIds, that.inheritBlueprintIds) && Objects.equals(this.inheritArtifactFieldIds, that.inheritArtifactFieldIds);
    }

    public int hashCode() {
        return Objects.hash(this.blueprintId, this.roleAssignmentsRules, this.inheritBlueprintIds, this.inheritArtifactFieldIds);
    }

    public static BlueprintRoleAssignments build(String blueprintId, Map<String, List<RoleAssignmentsRule>> roleAssignmentsRules, List<String> inheritBlueprintIds, List<String> inheritArtifactFieldIds) {
        BlueprintRoleAssignments blueprintRoleAssignments = new BlueprintRoleAssignments();
        blueprintRoleAssignments.blueprintId = blueprintId;
        blueprintRoleAssignments.roleAssignmentsRules = roleAssignmentsRules;
        blueprintRoleAssignments.inheritBlueprintIds = inheritBlueprintIds;
        blueprintRoleAssignments.inheritArtifactFieldIds = inheritArtifactFieldIds;
        return blueprintRoleAssignments;
    }
}

