/*
 * Decompiled with CFR 0.152.
 */
package com.dataiku.gh.core.models.search;

import com.dataiku.dip.utils.polyjson.Mapping;
import com.dataiku.dip.utils.polyjson.PolyJSON;
import com.dataiku.gh.core.visitors.IArtifactSearchSortVisitor;
import com.dataiku.gh.core.visitors.IFieldSortColumnFieldVisitor;
import com.dataiku.gh.core.visitors.ISortColumnVisitor;
import com.dataiku.j2ts.annotations.UIModel;
import com.dataiku.j2ts.annotations.UINullable;
import java.util.ArrayList;
import java.util.Arrays;
import java.util.List;
import java.util.Objects;
import javax.annotation.Nullable;

@UIModel
public class ArtifactSearchSort {
    public SortColumn column;
    public SortDirection direction;

    public void accept(IArtifactSearchSortVisitor visitor) {
        if (this.column != null) {
            this.column.accept(visitor);
        }
        visitor.visit(this);
    }

    public static ArtifactSearchSort build(SortColumn column, SortDirection direction) {
        ArtifactSearchSort artifactSearchSort = new ArtifactSearchSort();
        artifactSearchSort.column = column;
        artifactSearchSort.direction = direction;
        return artifactSearchSort;
    }

    @PolyJSON(value={@Mapping(value=NameSortColumn.class, type="name"), @Mapping(value=WorkflowSortColumn.class, type="workflow"), @Mapping(value=FieldSortColumn.class, type="field")})
    public static abstract class SortColumn {
        public abstract void accept(ISortColumnVisitor var1);
    }

    public static enum SortDirection {
        ASC,
        DESC;

    }

    public static class FieldSortColumnField {
        @Nullable
        public String blueprintId;
        public String fieldId;
        @UINullable
        public boolean canBeReference = true;

        public void accept(IFieldSortColumnFieldVisitor visitor) {
            visitor.visit(this);
        }

        public static FieldSortColumnField build(@Nullable String blueprintId, String fieldId) {
            FieldSortColumnField fieldSortColumnField = new FieldSortColumnField();
            fieldSortColumnField.blueprintId = blueprintId;
            fieldSortColumnField.fieldId = fieldId;
            return fieldSortColumnField;
        }

        public boolean equals(Object o) {
            if (o == null || this.getClass() != o.getClass()) {
                return false;
            }
            FieldSortColumnField that = (FieldSortColumnField)o;
            return this.canBeReference == that.canBeReference && Objects.equals(this.blueprintId, that.blueprintId) && Objects.equals(this.fieldId, that.fieldId);
        }

        public int hashCode() {
            return Objects.hash(this.blueprintId, this.fieldId, this.canBeReference);
        }
    }

    public static class FieldSortColumn
    extends SortColumn {
        public static final String TYPE = "field";
        public List<FieldSortColumnField> fields = new ArrayList<FieldSortColumnField>();

        @Override
        public void accept(ISortColumnVisitor visitor) {
            visitor.visit(this);
            this.fields.forEach(field -> field.accept(visitor));
        }

        public static FieldSortColumn build(FieldSortColumnField ... fields) {
            FieldSortColumn fieldSortColumn = new FieldSortColumn();
            fieldSortColumn.fields.addAll(Arrays.asList(fields));
            return fieldSortColumn;
        }
    }

    public static class WorkflowSortColumn
    extends SortColumn {
        public static final String TYPE = "workflow";

        @Override
        public void accept(ISortColumnVisitor visitor) {
            visitor.visit(this);
        }

        public static WorkflowSortColumn build() {
            return new WorkflowSortColumn();
        }
    }

    public static class NameSortColumn
    extends SortColumn {
        public static final String TYPE = "name";

        @Override
        public void accept(ISortColumnVisitor visitor) {
            visitor.visit(this);
        }

        public static NameSortColumn build() {
            return new NameSortColumn();
        }
    }
}

