/*
 * Decompiled with CFR 0.152.
 */
package com.dataiku.gh.core.publicapi;

import com.dataiku.dip.security.AuthCtx;
import com.dataiku.dip.server.api.PublicAPIControllerBase;
import com.dataiku.dip.server.controllers.AuditedCall;
import com.dataiku.gh.core.context.GovernAction;
import com.dataiku.gh.core.models.api.SignoffUpdateStatus;
import com.dataiku.gh.core.models.history.ActionType;
import com.dataiku.gh.core.models.security.UserUsersContainer;
import com.dataiku.gh.core.models.signoff.Signoff;
import com.dataiku.gh.core.models.signoff.SignoffApproval;
import com.dataiku.gh.core.models.signoff.SignoffDetails;
import com.dataiku.gh.core.models.signoff.SignoffFeedback;
import com.dataiku.gh.core.models.signoff.SignoffId;
import com.dataiku.gh.core.models.signoff.SignoffRecurrenceConfiguration;
import com.dataiku.gh.core.models.ui.UISignoffApprovalData;
import com.dataiku.gh.core.models.ui.UISignoffFeedbackData;
import com.dataiku.gh.core.services.signoff.ISignoffsService;
import com.dataiku.gh.core.utils.ValidatorUtils;
import com.dataiku.gh.security.auth.MetaAuthService;
import jakarta.servlet.http.HttpServletRequest;
import java.util.List;
import javax.annotation.Nullable;
import org.apache.commons.lang3.StringUtils;
import org.springframework.beans.factory.annotation.Autowired;
import org.springframework.stereotype.Controller;
import org.springframework.web.bind.annotation.PathVariable;
import org.springframework.web.bind.annotation.RequestMapping;
import org.springframework.web.bind.annotation.RequestMethod;
import org.springframework.web.bind.annotation.RequestParam;
import org.springframework.web.bind.annotation.ResponseBody;

@Controller
public class PublicAPISignoffsController
extends PublicAPIControllerBase {
    @Autowired
    private MetaAuthService authService;
    @Autowired
    private ISignoffsService signoffsService;

    @AuditedCall(value={"msgType", "signoffs-list", "artifactId", "${artifactId}"})
    @RequestMapping(value={"/publicapi/artifact/{artifactId}/signoffs"}, method={RequestMethod.GET})
    @ResponseBody
    public List<Signoff> list(HttpServletRequest req, @PathVariable String artifactId) throws Exception {
        AuthCtx authCtx = this.authService.getTicketOrKey_NT(req);
        return this.signoffsService.getSignoffs(authCtx, artifactId);
    }

    @AuditedCall(value={"msgType", "signoff-get", "artifactId", "${artifactId}", "stepId", "${stepId}"})
    @RequestMapping(value={"/publicapi/artifact/{artifactId}/workflow/step/{stepId}/signoff"}, method={RequestMethod.GET})
    @ResponseBody
    public Signoff get(HttpServletRequest req, @PathVariable String artifactId, @PathVariable String stepId) throws Exception {
        AuthCtx authCtx = this.authService.getTicketOrKey_NT(req);
        return this.signoffsService.getSignoff(authCtx, SignoffId.build(artifactId, stepId));
    }

    @AuditedCall(value={"msgType", "signoff-get-details", "artifactId", "${artifactId}", "stepId", "${stepId}"})
    @RequestMapping(value={"/publicapi/artifact/{artifactId}/workflow/step/{stepId}/signoff/details"}, method={RequestMethod.GET})
    @ResponseBody
    public SignoffDetails getDetails(HttpServletRequest req, @PathVariable String artifactId, @PathVariable String stepId) throws Exception {
        AuthCtx authCtx = this.authService.getTicketOrKey_NT(req);
        return this.signoffsService.getSignoffDetails(authCtx, SignoffId.build(artifactId, stepId));
    }

    @AuditedCall(value={"msgType", "signoff-create", "artifactId", "${artifactId}", "stepId", "${stepId}"})
    @RequestMapping(value={"/publicapi/artifact/{artifactId}/workflow/step/{stepId}/signoff/create"}, method={RequestMethod.POST})
    @GovernAction(value=ActionType.SIGNOFF_CREATE)
    @ResponseBody
    public Signoff createSignoff(HttpServletRequest req, @PathVariable String artifactId, @PathVariable String stepId) throws Exception {
        AuthCtx authCtx = this.authService.getTicketOrKey_NT(req);
        return this.signoffsService.createSignoff(authCtx, SignoffId.build(artifactId, stepId));
    }

    @AuditedCall(value={"msgType", "signoff-delegate-feedback", "artifactId", "${artifactId}", "stepId", "${stepId}"})
    @RequestMapping(value={"/publicapi/artifact/{artifactId}/workflow/step/{stepId}/signoff/delegate-feedback"}, method={RequestMethod.POST})
    @GovernAction(value=ActionType.SIGNOFF_DELEGATE_FEEDBACK)
    @ResponseBody
    public Signoff delegateFeedback(HttpServletRequest req, @PathVariable String artifactId, @PathVariable String stepId, @RequestParam String groupId) throws Exception {
        AuthCtx authCtx = this.authService.getTicketOrKey_NT(req);
        UserUsersContainer delegateToUser = (UserUsersContainer)this.getRequestBodyAs(req, UserUsersContainer.class);
        ValidatorUtils.validateThat(StringUtils.isNotBlank((CharSequence)delegateToUser.login), "Delegated user login is required", new Object[0]);
        return this.signoffsService.delegateFeedback(authCtx, SignoffId.build(artifactId, stepId), groupId, delegateToUser);
    }

    @AuditedCall(value={"msgType", "signoff-add-feedback", "artifactId", "${artifactId}", "stepId", "${stepId}"})
    @RequestMapping(value={"/publicapi/artifact/{artifactId}/workflow/step/{stepId}/signoff/feedback"}, method={RequestMethod.POST})
    @GovernAction(value=ActionType.SIGNOFF_ADD_FEEDBACK)
    @ResponseBody
    public SignoffFeedback addFeedback(HttpServletRequest req, @PathVariable String artifactId, @PathVariable String stepId, @RequestParam String groupId) throws Exception {
        AuthCtx authCtx = this.authService.getTicketOrKey_NT(req);
        UISignoffFeedbackData signoffFeedbackData = (UISignoffFeedbackData)this.getRequestBodyAs(req, UISignoffFeedbackData.class);
        ValidatorUtils.validateThat(signoffFeedbackData.status != null, "Feedback status is required", new Object[0]);
        return this.signoffsService.addFeedback(authCtx, SignoffId.build(artifactId, stepId), groupId, signoffFeedbackData);
    }

    @AuditedCall(value={"msgType", "signoff-edit-feedback", "artifactId", "${artifactId}", "stepId", "${stepId}", "feedbackId", "${feedbackId}"})
    @RequestMapping(value={"/publicapi/artifact/{artifactId}/workflow/step/{stepId}/signoff/feedback/{feedbackId}"}, method={RequestMethod.PUT})
    @GovernAction(value=ActionType.SIGNOFF_EDIT_FEEDBACK)
    @ResponseBody
    public SignoffFeedback editFeedback(HttpServletRequest req, @PathVariable String artifactId, @PathVariable String stepId, @PathVariable String feedbackId) throws Exception {
        AuthCtx authCtx = this.authService.getTicketOrKey_NT(req);
        UISignoffFeedbackData signoffFeedbackData = (UISignoffFeedbackData)this.getRequestBodyAs(req, UISignoffFeedbackData.class);
        ValidatorUtils.validateThat(StringUtils.isNotBlank((CharSequence)feedbackId), "Feedback id is required", new Object[0]);
        ValidatorUtils.validateThat(signoffFeedbackData.status != null, "Feedback status is required", new Object[0]);
        return this.signoffsService.editFeedback(authCtx, SignoffId.build(artifactId, stepId), feedbackId, signoffFeedbackData);
    }

    @AuditedCall(value={"msgType", "signoff-delete-feedback", "artifactId", "${artifactId}", "stepId", "${stepId}", "feedbackId", "${feedbackId}"})
    @RequestMapping(value={"/publicapi/artifact/{artifactId}/workflow/step/{stepId}/signoff/feedback/{feedbackId}"}, method={RequestMethod.DELETE})
    @GovernAction(value=ActionType.SIGNOFF_DELETE_FEEDBACK)
    @ResponseBody
    public void deleteFeedback(HttpServletRequest req, @PathVariable String artifactId, @PathVariable String stepId, @PathVariable String feedbackId) throws Exception {
        AuthCtx authCtx = this.authService.getTicketOrKey_NT(req);
        this.signoffsService.deleteFeedback(authCtx, SignoffId.build(artifactId, stepId), feedbackId);
    }

    @AuditedCall(value={"msgType", "signoff-delegate-approval", "artifactId", "${artifactId}", "stepId", "${stepId}"})
    @RequestMapping(value={"/publicapi/artifact/{artifactId}/workflow/step/{stepId}/signoff/delegate-approval"}, method={RequestMethod.POST})
    @GovernAction(value=ActionType.SIGNOFF_DELEGATE_APPROVAL)
    @ResponseBody
    public Signoff delegateApproval(HttpServletRequest req, @PathVariable String artifactId, @PathVariable String stepId) throws Exception {
        AuthCtx authCtx = this.authService.getTicketOrKey_NT(req);
        UserUsersContainer delegateToUser = (UserUsersContainer)this.getRequestBodyAs(req, UserUsersContainer.class);
        ValidatorUtils.validateThat(StringUtils.isNotBlank((CharSequence)delegateToUser.login), "Delegated user login is required", new Object[0]);
        return this.signoffsService.delegateApproval(authCtx, SignoffId.build(artifactId, stepId), delegateToUser);
    }

    @AuditedCall(value={"msgType", "signoff-add-approval", "artifactId", "${artifactId}", "stepId", "${stepId}"})
    @RequestMapping(value={"/publicapi/artifact/{artifactId}/workflow/step/{stepId}/signoff/approval"}, method={RequestMethod.POST})
    @GovernAction(value=ActionType.SIGNOFF_ADD_APPROVAL)
    @ResponseBody
    public SignoffApproval addApproval(HttpServletRequest req, @PathVariable String artifactId, @PathVariable String stepId) throws Exception {
        AuthCtx authCtx = this.authService.getTicketOrKey_NT(req);
        UISignoffApprovalData signoffApprovalData = (UISignoffApprovalData)this.getRequestBodyAs(req, UISignoffApprovalData.class);
        ValidatorUtils.validateThat(signoffApprovalData.status != null, "Approval status is required", new Object[0]);
        return this.signoffsService.addApproval(authCtx, SignoffId.build(artifactId, stepId), signoffApprovalData);
    }

    @AuditedCall(value={"msgType", "signoff-edit-approval", "artifactId", "${artifactId}", "stepId", "${stepId}"})
    @RequestMapping(value={"/publicapi/artifact/{artifactId}/workflow/step/{stepId}/signoff/approval"}, method={RequestMethod.PUT})
    @GovernAction(value=ActionType.SIGNOFF_EDIT_APPROVAL)
    @ResponseBody
    public SignoffApproval editApproval(HttpServletRequest req, @PathVariable String artifactId, @PathVariable String stepId) throws Exception {
        AuthCtx authCtx = this.authService.getTicketOrKey_NT(req);
        UISignoffApprovalData signoffApprovalData = (UISignoffApprovalData)this.getRequestBodyAs(req, UISignoffApprovalData.class);
        ValidatorUtils.validateThat(signoffApprovalData.status != null, "Approval status is required", new Object[0]);
        return this.signoffsService.editApproval(authCtx, SignoffId.build(artifactId, stepId), signoffApprovalData);
    }

    @AuditedCall(value={"msgType", "signoff-delete-approval", "artifactId", "${artifactId}", "stepId", "${stepId}"})
    @RequestMapping(value={"/publicapi/artifact/{artifactId}/workflow/step/{stepId}/signoff/approval"}, method={RequestMethod.DELETE})
    @GovernAction(value=ActionType.SIGNOFF_DELETE_APPROVAL)
    @ResponseBody
    public void deleteApproval(HttpServletRequest req, @PathVariable String artifactId, @PathVariable String stepId) throws Exception {
        AuthCtx authCtx = this.authService.getTicketOrKey_NT(req);
        this.signoffsService.deleteApproval(authCtx, SignoffId.build(artifactId, stepId));
    }

    @AuditedCall(value={"msgType", "signoff-update-status", "artifactId", "${artifactId}", "stepId", "${stepId}"})
    @RequestMapping(value={"/publicapi/artifact/{artifactId}/workflow/step/{stepId}/signoff/update-status"}, method={RequestMethod.POST})
    @GovernAction(value=ActionType.SIGNOFF_UPDATE_STATUS)
    @ResponseBody
    @Nullable
    public Signoff updateStatus(HttpServletRequest req, @PathVariable String artifactId, @PathVariable String stepId) throws Exception {
        AuthCtx authCtx = this.authService.getTicketOrKey_NT(req);
        SignoffUpdateStatus signoffUpdateStatus = (SignoffUpdateStatus)this.getRequestBodyAs(req, SignoffUpdateStatus.class);
        return this.signoffsService.updateStatus(authCtx, SignoffId.build(artifactId, stepId), signoffUpdateStatus.targetStatus, signoffUpdateStatus.usersToSendEmailTo, signoffUpdateStatus.reloadConfForReset);
    }

    @AuditedCall(value={"msgType", "signoff-schedule-reset", "artifactId", "${artifactId}", "stepId", "${stepId}"})
    @RequestMapping(value={"/publicapi/artifact/{artifactId}/workflow/step/{stepId}/signoff/schedule-reset"}, method={RequestMethod.POST})
    @GovernAction(value=ActionType.SIGNOFF_SCHEDULE_RESET)
    @ResponseBody
    public Signoff scheduleReset(HttpServletRequest req, @PathVariable String artifactId, @PathVariable String stepId) throws Exception {
        AuthCtx authCtx = this.authService.getTicketOrKey_NT(req);
        SignoffRecurrenceConfiguration signoffRecurrenceConfiguration = (SignoffRecurrenceConfiguration)this.getRequestBodyAs(req, SignoffRecurrenceConfiguration.class);
        return this.signoffsService.scheduleReset(authCtx, SignoffId.build(artifactId, stepId), signoffRecurrenceConfiguration);
    }
}

