/*
 * Decompiled with CFR 0.152.
 */
package com.dataiku.gh.core.services.governance;

import com.dataiku.dip.exceptions.DKUSecurityException;
import com.dataiku.dip.security.AuthCtx;
import com.dataiku.dip.server.services.licensing.LimitsStatusComputer;
import com.dataiku.dip.utils.AutoCloseableLock;
import com.dataiku.dip.utils.DKULogger;
import com.dataiku.dip.utils.NamedLock;
import com.dataiku.dss_gh.api.models.identifiers.DSSProjectIdentifier;
import com.dataiku.gh.core.models.enriched.EnrichedArtifact;
import com.dataiku.gh.core.models.governance.GovernanceResult;
import com.dataiku.gh.core.models.governance.GovernanceResultContainer;
import com.dataiku.gh.core.models.governance.IGovernanceSettingsValidationService;
import com.dataiku.gh.core.models.governance.InputGovernanceSettings;
import com.dataiku.gh.core.services.artifacts.IArtifactsDataService;
import com.dataiku.gh.core.services.dss.sync.DSSObjectsToArtifactMapperService;
import com.dataiku.gh.core.services.governance.IGovernanceCoordinatorService;
import com.dataiku.gh.core.services.governance.IGovernanceExecutorService;
import com.dataiku.gh.core.services.governance.IGovernancePermissionService;
import com.dataiku.gh.core.services.governance.config.IAutoGovernanceConfigurationService;
import com.dataiku.gh.core.services.governance.hide.IGovernanceHideService;
import com.dataiku.gh.core.services.governance.utils.GovernanceUtils;
import com.dataiku.gh.core.services.subscriptions.ISubscriptionsService;
import com.dataiku.gh.core.services.utils.ITransactionHandler;
import com.dataiku.gh.core.services.utils.ITransactionScope;
import com.dataiku.gh.core.storage.sql.search.governance.IGovernanceArtifactSearchDAO;
import com.dataiku.gh.server.services.licensing.LicenseEnforcementService;
import java.io.IOException;
import java.util.HashSet;
import java.util.Set;
import org.apache.commons.collections4.CollectionUtils;
import org.springframework.beans.factory.annotation.Autowired;
import org.springframework.stereotype.Service;

@Service
public class GovernanceCoordinatorService
implements IGovernanceCoordinatorService {
    protected static final DKULogger logger = DKULogger.getLogger((String)"gh.services.governance-service");
    @Autowired
    private LicenseEnforcementService licenseEnforcementService;
    @Autowired
    private IArtifactsDataService artifactsDataService;
    @Autowired
    private ITransactionHandler transactionHandler;
    @Autowired
    private IAutoGovernanceConfigurationService autoGovernanceConfigurationService;
    @Autowired
    private IGovernanceSettingsValidationService governanceSettingsValidationService;
    @Autowired
    private IGovernanceExecutorService governanceExecutorService;
    @Autowired
    private ISubscriptionsService subscriptionsService;
    @Autowired
    private IGovernanceArtifactSearchDAO governanceArtifactSearchDAO;
    @Autowired
    private IGovernanceHideService governanceHideService;
    @Autowired
    private IGovernancePermissionService governancePermissionService;

    @Override
    public GovernanceResultContainer manualGovern(AuthCtx authCtx, String dataikuArtifactId, InputGovernanceSettings inputGovernanceSettings) throws LimitsStatusComputer.LicenseLimitException, IOException, DKUSecurityException {
        GovernanceResult governanceResult;
        EnrichedArtifact dataikuItemToGovernEnrichedArtifact;
        boolean isAdvancedLicense = this.licenseEnforcementService.isGovernBlueprintDesignerAllowed();
        try (ITransactionScope ts = this.transactionHandler.openNewReadTransaction();){
            dataikuItemToGovernEnrichedArtifact = this.artifactsDataService.getArtifact(dataikuArtifactId);
            this.governanceSettingsValidationService.validateFromManualGovern(dataikuItemToGovernEnrichedArtifact, inputGovernanceSettings);
            this.governancePermissionService.validateArtifactAutoConfigPermission(authCtx, inputGovernanceSettings, dataikuItemToGovernEnrichedArtifact);
            ts.commit();
        }
        try (AutoCloseableLock ignored = NamedLock.acquire((String)GovernanceCoordinatorService.getLockKey(dataikuItemToGovernEnrichedArtifact));){
            governanceResult = this.applyGovernanceSettingsToArtifact(dataikuItemToGovernEnrichedArtifact.artifact.id, inputGovernanceSettings, isAdvancedLicense);
        }
        GovernanceResultContainer resultContainer = new GovernanceResultContainer();
        resultContainer.add(dataikuItemToGovernEnrichedArtifact.blueprintVersion.id, governanceResult);
        if (governanceResult.status == GovernanceResult.GovernanceResultStatus.GOVERNED) {
            Set<String> nextBatch;
            try (ITransactionScope ts = this.transactionHandler.openNewWriteTransaction();){
                if (authCtx != null && governanceResult.governArtifactId != null) {
                    this.subscriptionsService.automaticSubscribe(authCtx, governanceResult.governArtifactId);
                }
                nextBatch = this.getDataikuItemChildrenIdsForAutoGovernance(dataikuItemToGovernEnrichedArtifact.artifact.id);
                ts.commit();
            }
            if (CollectionUtils.isNotEmpty(nextBatch)) {
                this.runAutoGovernance(nextBatch, resultContainer, isAdvancedLicense);
            }
        }
        logger.debugV("Manual governance result: %s", new Object[]{resultContainer});
        return resultContainer;
    }

    @Override
    public GovernanceResultContainer runAutoGovernance(String dataikuArtifactId) {
        GovernanceResultContainer resultContainer = new GovernanceResultContainer();
        this.runAutoGovernance(Set.of(dataikuArtifactId), resultContainer, this.licenseEnforcementService.isGovernBlueprintDesignerAllowed());
        return resultContainer;
    }

    private void runAutoGovernance(Set<String> dataikuArtifactIds, GovernanceResultContainer resultContainer, boolean isAdvancedLicense) {
        HashSet<String> nextBatch = new HashSet<String>();
        logger.debug((Object)("Running governance on artifacts with IDs: " + String.join((CharSequence)" ; ", dataikuArtifactIds)));
        for (String dataikuArtifactId : dataikuArtifactIds) {
            GovernanceResult governanceResult;
            EnrichedArtifact dataikuItemToGovernEnrichedArtifact;
            block25: {
                dataikuItemToGovernEnrichedArtifact = null;
                try {
                    try (ITransactionScope ts = this.transactionHandler.openNewReadTransaction();){
                        dataikuItemToGovernEnrichedArtifact = this.artifactsDataService.getArtifact(dataikuArtifactId);
                        ts.commit();
                    }
                    if (GovernanceUtils.isHidden(dataikuItemToGovernEnrichedArtifact.artifact)) {
                        logger.infoV("Artifact of ID: %s is already hidden", new Object[]{dataikuItemToGovernEnrichedArtifact.artifact.id});
                        governanceResult = GovernanceResult.buildNothing(dataikuItemToGovernEnrichedArtifact.artifact.id, GovernanceResult.GovernanceResultStatusReason.ALREADY_HIDDEN);
                        break block25;
                    }
                    if (GovernanceUtils.isGoverned(dataikuItemToGovernEnrichedArtifact.artifact)) {
                        logger.infoV("Artifact of ID: %s is already governed", new Object[]{dataikuItemToGovernEnrichedArtifact.artifact.id});
                        governanceResult = GovernanceResult.buildNothing(dataikuItemToGovernEnrichedArtifact.artifact.id, GovernanceResult.GovernanceResultStatusReason.ALREADY_GOVERNED);
                        break block25;
                    }
                    try (AutoCloseableLock ignored = NamedLock.acquire((String)GovernanceCoordinatorService.getLockKey(dataikuItemToGovernEnrichedArtifact));){
                        InputGovernanceSettings inputGovernanceSettings = this.autoGovernanceConfigurationService.getInputGovernanceConfiguration(dataikuArtifactId);
                        governanceResult = this.applyGovernanceSettingsToArtifact(dataikuArtifactId, inputGovernanceSettings, isAdvancedLicense);
                    }
                    if (governanceResult.status != GovernanceResult.GovernanceResultStatus.GOVERNED) break block25;
                    ts = this.transactionHandler.openNewReadTransaction();
                    try {
                        nextBatch.addAll(this.getDataikuItemChildrenIdsForAutoGovernance(dataikuItemToGovernEnrichedArtifact.artifact.id));
                        ts.commit();
                    }
                    finally {
                        if (ts != null) {
                            ts.close();
                        }
                    }
                }
                catch (Exception e) {
                    governanceResult = GovernanceResult.buildNothing(dataikuArtifactId, GovernanceResult.GovernanceResultStatusReason.ERROR);
                    logger.error((Object)("Error while running governance on artifact of ID: " + dataikuArtifactId + " - ignoring this one"), (Throwable)e);
                }
            }
            resultContainer.add(dataikuItemToGovernEnrichedArtifact != null ? dataikuItemToGovernEnrichedArtifact.blueprintVersion.id : null, governanceResult);
        }
        if (!nextBatch.isEmpty()) {
            this.runAutoGovernance(nextBatch, resultContainer, isAdvancedLicense);
        }
    }

    private GovernanceResult applyGovernanceSettingsToArtifact(String dataikuArtifactId, InputGovernanceSettings inputGovernanceSettings, boolean isAdvancedLicense) throws IOException {
        GovernanceResult governanceResult;
        try (ITransactionScope ts = this.transactionHandler.openNewWriteTransaction();){
            governanceResult = this.governanceExecutorService.applyGovernanceSettingsToArtifact(dataikuArtifactId, inputGovernanceSettings, isAdvancedLicense);
            logger.debugV("Result of governance on artifacts `%s` is `%s`", new Object[]{dataikuArtifactId, governanceResult});
            ts.commit();
        }
        return governanceResult;
    }

    private Set<String> getDataikuItemChildrenIdsForAutoGovernance(String dataikuArtifactId) throws IOException {
        return this.governanceArtifactSearchDAO.findChildrenArtifactIdsToRunAutoGovernanceOn(dataikuArtifactId);
    }

    private static String getLockKey(EnrichedArtifact ea) {
        DSSProjectIdentifier projectIdentifier = DSSObjectsToArtifactMapperService.getProjectIdentifierFromDataikuProjectItemArtifact(ea.artifact);
        return "autogovern:" + projectIdentifier.nodeId + "#" + projectIdentifier.projectKey;
    }
}

