/*
 * Decompiled with CFR 0.152.
 */
package com.dataiku.gh.core.services.governance;

import com.dataiku.dip.security.AuthCtx;
import com.dataiku.dip.utils.DKULogger;
import com.dataiku.gh.core.context.GovernActionContext;
import com.dataiku.gh.core.models.history.ActionType;
import com.dataiku.gh.core.services.governance.IGovernanceCoordinatorService;
import com.dataiku.gh.core.services.governance.IGovernanceQueueExecutorService;
import java.util.List;
import java.util.concurrent.BlockingQueue;
import java.util.concurrent.LinkedBlockingQueue;
import javax.annotation.Nullable;
import org.apache.commons.collections4.CollectionUtils;
import org.springframework.beans.factory.annotation.Autowired;
import org.springframework.stereotype.Service;

@Service
public class GovernanceQueueExecutorService
implements IGovernanceQueueExecutorService {
    @Autowired
    private IGovernanceCoordinatorService governanceCoordinatorService;
    protected static final DKULogger logger = DKULogger.getLogger((String)"gh.services.auto-governance-queue");
    private final AutomaticGovernanceQueueHandler queueHandler = new AutomaticGovernanceQueueHandler();
    private Thread governThread;

    public GovernanceQueueExecutorService() {
        this.initGovernThread();
    }

    private synchronized void initGovernThread() {
        if (this.governThread != null) {
            this.governThread.interrupt();
            this.governThread = null;
        }
        this.governThread = new Thread(this.queueHandler);
        this.governThread.setUncaughtExceptionHandler((thread, throwable) -> {
            logger.error((Object)"Automatic governance service handler thread caught unhandled throwable", throwable);
            this.initGovernThread();
        });
        this.governThread.start();
    }

    @Override
    public void addToGovernanceQueue(List<String> artifactIds) {
        if (CollectionUtils.isNotEmpty(artifactIds)) {
            artifactIds.forEach(artifactId -> this.queueHandler.queue.add(new GovernanceQueueItem(GovernActionContext.getContext().actionType, GovernActionContext.getContext().authCtx, (String)artifactId)));
        }
    }

    public class AutomaticGovernanceQueueHandler
    implements Runnable {
        private final BlockingQueue<GovernanceQueueItem> queue = new LinkedBlockingQueue<GovernanceQueueItem>();

        private void handleQueueEvent(GovernanceQueueItem governanceQueueItem) {
            try (GovernActionContext.ContextContainer ignored = GovernActionContext.attachNewContext(governanceQueueItem.actionType, governanceQueueItem.authCtx);){
                GovernanceQueueExecutorService.this.governanceCoordinatorService.runAutoGovernance(governanceQueueItem.dataikuItemArtifactId);
            }
        }

        @Override
        public void run() {
            Thread.currentThread().setName("automatic-governance-queue-handler");
            try {
                while (!Thread.currentThread().isInterrupted()) {
                    GovernanceQueueItem governanceQueueItem = this.queue.take();
                    DKULogger.startCurrentCall();
                    logger.debugV("Automatic governance starts on artifact `%s`. items left in queue: %s", new Object[]{governanceQueueItem.dataikuItemArtifactId, this.queue.size()});
                    try {
                        this.handleQueueEvent(governanceQueueItem);
                        logger.debugV("Automatic governance done on artifact '%s'", new Object[]{governanceQueueItem.dataikuItemArtifactId});
                    }
                    catch (Exception e) {
                        logger.error((Object)("Automatic governance failed on artifact '" + governanceQueueItem.dataikuItemArtifactId + "'"), (Throwable)e);
                    }
                    DKULogger.endCurrentCall();
                }
            }
            catch (InterruptedException e) {
                Thread.currentThread().interrupt();
                logger.error((Object)"Automatic governance thread interrupted", (Throwable)e);
            }
        }
    }

    protected static class GovernanceQueueItem {
        public ActionType actionType;
        @Nullable
        public AuthCtx authCtx;
        public String dataikuItemArtifactId;

        public GovernanceQueueItem(ActionType actionType, @Nullable AuthCtx authCtx, String dataikuItemArtifactId) {
            this.actionType = actionType;
            this.authCtx = authCtx;
            this.dataikuItemArtifactId = dataikuItemArtifactId;
        }
    }
}

