/*
 * Decompiled with CFR 0.152.
 */
package com.dataiku.gh.server.services;

import com.dataiku.dip.coremodel.InfoMessage;
import com.dataiku.dip.dao.DkuGroup;
import com.dataiku.dip.dao.DkuUser;
import com.dataiku.dip.dao.SessionsDAO;
import com.dataiku.dip.dao.UserLastActivity;
import com.dataiku.dip.dao.UsersActivityDAO;
import com.dataiku.dip.exceptions.CodedException;
import com.dataiku.dip.exceptions.DKUSecurityException;
import com.dataiku.dip.exceptions.DSSInternalErrorException;
import com.dataiku.dip.exceptions.UnauthorizedException;
import com.dataiku.dip.security.AuthCtx;
import com.dataiku.dip.security.PasswordEncryptionService;
import com.dataiku.dip.security.SecurityCodes;
import com.dataiku.dip.security.auth.GroupDiff;
import com.dataiku.dip.security.auth.UserDiff;
import com.dataiku.dip.security.auth.UserSourceType;
import com.dataiku.dip.server.controllers.NotFoundException;
import com.dataiku.dip.server.services.DkuUsersService;
import com.dataiku.dip.server.services.TransactionService;
import com.dataiku.dip.server.services.UserCodes;
import com.dataiku.dip.server.services.licensing.AbstractLicenseFeaturesStatusBuilder;
import com.dataiku.dip.server.services.licensing.LimitsStatusComputer;
import com.dataiku.dip.transactions.TransactionContext;
import com.dataiku.dip.transactions.ifaces.RWTransaction;
import com.dataiku.dip.transactions.ifaces.Transaction;
import com.dataiku.dip.util.SecretKeyGenerator;
import com.dataiku.dip.utils.DKULogger;
import com.dataiku.dip.utils.JSON;
import com.dataiku.dip.utils.Pair;
import com.dataiku.dss.shadelib.com.google.common.collect.HashMultimap;
import com.dataiku.dss.shadelib.com.google.common.collect.Multimap;
import com.dataiku.gh.ApplicationConfigurator;
import com.dataiku.gh.dao.GeneralSettingsDAO;
import com.dataiku.gh.dao.ImagesDAO;
import com.dataiku.gh.dao.UsersDAO;
import com.dataiku.gh.security.IPermissionsService;
import com.dataiku.gh.security.model.AbstractGlobalScopePublicAPIKey;
import com.dataiku.gh.security.model.GlobalScopePublicAPIKeyWithGroups;
import com.dataiku.gh.security.model.PublicUser;
import com.dataiku.gh.server.api.auth.PublicAPIKeysService;
import com.dataiku.gh.server.services.PubSubService;
import com.dataiku.gh.server.services.licensing.LicenseEnforcementService;
import com.dataiku.j2ts.annotations.UIModel;
import com.dataiku.j2ts.annotations.UINullable;
import com.google.gson.JsonObject;
import java.io.Closeable;
import java.io.IOException;
import java.util.ArrayList;
import java.util.Collection;
import java.util.Collections;
import java.util.HashSet;
import java.util.List;
import java.util.Locale;
import java.util.Map;
import java.util.Objects;
import java.util.Set;
import java.util.concurrent.atomic.AtomicReference;
import java.util.regex.Matcher;
import java.util.regex.Pattern;
import java.util.stream.Collectors;
import org.apache.commons.lang.StringUtils;
import org.springframework.beans.factory.annotation.Autowired;
import org.springframework.stereotype.Service;
import org.springframework.transaction.PlatformTransactionManager;
import org.springframework.transaction.TransactionDefinition;
import org.springframework.transaction.TransactionStatus;
import org.springframework.transaction.support.DefaultTransactionDefinition;

@Service
public class UsersService
implements DkuUsersService {
    private static final String baseLoginPatten = "[a-zA-Z0-9@.+_-]+";
    private static final Pattern loginPattern = Pattern.compile("^[a-zA-Z0-9@.+_-]+$");
    private static final Pattern mentionPattern = Pattern.compile("@[a-zA-Z0-9@.+_-]+");
    private static final Pattern validGroupPattern = Pattern.compile("^[a-zA-Z0-9@.+_-]{1,80}$");
    @Autowired
    private GeneralSettingsDAO gsDAO;
    @Autowired
    private ImagesDAO imagesDAO;
    @Autowired
    private UsersDAO dao;
    @Autowired
    private LicenseEnforcementService limitsService;
    @Autowired
    private PubSubService pubSub;
    @Autowired
    private TransactionService transactionService;
    @Autowired
    private PasswordEncryptionService symetricCryptoService;
    @Autowired
    private UsersActivityDAO usersActivityDAO;
    @Autowired
    private IPermissionsService permissionsService;
    @Autowired
    private SessionsDAO sessionDao;
    @Autowired
    private PublicAPIKeysService publicAPIKeysService;
    private static final DKULogger logger = DKULogger.getLogger((String)"dku.users");
    @Autowired
    private PlatformTransactionManager platformTransactionManager;

    public static Pair<Void, String> computeTrialStatusAndResultingUserProfile(GeneralSettingsDAO.GeneralSettings gs, UsersDAO.User u) {
        String resultingUserProfile = UsersService.computeResultingUserProfile(gs, u, u.userProfile);
        return new Pair(null, (Object)resultingUserProfile);
    }

    private static String computeResultingUserProfile(GeneralSettingsDAO.GeneralSettings gs, UsersDAO.User user, String existingUserProfile) {
        String resultingUserProfile = existingUserProfile;
        return resultingUserProfile;
    }

    public DkuUser getUserWithCaseSensitiveRule(String login) throws IOException {
        return this.areLoginsCaseSensitive() ? this.dao.getOrNull(login) : this.dao.getUserIgnoreCaseOrNull(login);
    }

    public DkuUser createForeignUser(UserSourceType sourceType, String login, String displayName, String email, Set<String> groups, String userProfile) throws CodedException, IOException, LimitsStatusComputer.LicenseLimitException {
        UsersDAO.User u = new UsersDAO.User(login, sourceType);
        u.displayName = displayName;
        u.email = email;
        u.userProfile = userProfile;
        u.groups = new ArrayList<String>(groups);
        this.dao.addForeignUser(u);
        this.limitsService.checkPermissionChangeIsValid();
        return u;
    }

    public List<? extends DkuGroup> listGroups() throws IOException {
        return this.dao.listGroups();
    }

    public List<? extends DkuUser> listUsers() throws IOException {
        return this.dao.listUsers();
    }

    public List<? extends DkuUser> listUsersUnsafe() throws IOException {
        return this.dao.listUsersUnsafe();
    }

    public UserDiff updateUser(DkuUser user) throws IOException, CodedException, LimitsStatusComputer.LicenseLimitException {
        UsersDAO.User userToUpdate = this.getInternalUserOrNullUnsafe(user.getLogin());
        userToUpdate.displayName = user.getDisplayName();
        userToUpdate.sourceType = user.getUserSourceType();
        userToUpdate.groups = user.getGroups();
        userToUpdate.enabled = user.isEnabled();
        userToUpdate.email = user.getEmail();
        userToUpdate.userProfile = user.getUserProfile();
        UserSaveContext usc = UserSaveContext.buildExternalSourceUpdate();
        UserDiff userDiff = this.saveUser(userToUpdate, false, usc, null);
        this.limitsService.checkPermissionChangeIsValid();
        return userDiff;
    }

    public void disableDkuUser(String userLogin) throws IOException, CodedException, LimitsStatusComputer.LicenseLimitException {
        DkuUser syncedUser = this.getUserWithCaseSensitiveRule(userLogin);
        syncedUser.setEnabled(false);
        this.updateUser(syncedUser);
        this.sessionDao.removeExistingSessionsForUser(userLogin);
    }

    public boolean userHasACommonGroupWithAuthCtx(AuthCtx authCtx, String userLogin) throws IOException {
        UsersDAO.User user = this.dao.getMandatoryUnsafe(userLogin);
        return this.userHasACommonGroupWithAuthCtx(authCtx, user);
    }

    public boolean userHasACommonGroupWithAuthCtx(AuthCtx authCtx, UsersDAO.User user) {
        for (String candidateGroup : user.groups) {
            if (!authCtx.getGroupsIfRelevant().contains(candidateGroup)) continue;
            return true;
        }
        return false;
    }

    public List<UIUser> listUsersEnabledOnly_RestrictionCheck_NoLeak(AuthCtx authCtx) throws IOException {
        return this.listUsersEnabledOnly_RestrictionCheck_NoLeak(authCtx, null);
    }

    public List<UIUser> listUsersWithDisabled_RestrictionCheck_NoLeak(AuthCtx authCtx) throws IOException {
        return this.listUsers_RestrictionCheck_NoLeak(authCtx, null, true, false);
    }

    public List<UIUser> listUsersEnabledOnly_RestrictionCheck_NoLeak(AuthCtx authCtx, String groupFilter) throws IOException {
        return this.listUsers_RestrictionCheck_NoLeak(authCtx, groupFilter, false, false);
    }

    public List<UIUser> listExpiredTrialUsers(AuthCtx authCtx) throws IOException, UnauthorizedException {
        ArrayList<UIUser> ret = new ArrayList<UIUser>();
        if (!authCtx.isAdmin()) {
            throw new UnauthorizedException("Only instance administrators are allowed to list expired trial users", "denied");
        }
        GeneralSettingsDAO.GeneralSettings gs = this.gsDAO.getUnsafeAutoTXN();
        for (UsersDAO.User u : this.dao.listUsers()) {
            UIUser uiu = new UIUser(u);
            uiu.computeTrialStatus(gs, u);
        }
        return ret;
    }

    private boolean includedInUserList(AuthCtx authCtx, GeneralSettingsDAO.GeneralSettings settings, UsersDAO.User user, String groupFilter, boolean includeDisabled) throws IOException {
        boolean addIt;
        boolean bl = addIt = includeDisabled || user.enabled;
        if (settings.security.restrictUsersAndGroupsVisibility) {
            if (authCtx == null) {
                throw new IOException("Cannot verify users and groups visibility. Using this in a free edition ?");
            }
            if (!authCtx.isAdmin()) {
                if (user.groups == null) {
                    addIt = false;
                } else {
                    boolean matchesAGroup = false;
                    for (String candidateGroup : user.groups) {
                        if (!authCtx.getGroupsIfRelevant().contains(candidateGroup)) continue;
                        matchesAGroup = true;
                        break;
                    }
                    if (!matchesAGroup) {
                        addIt = false;
                    }
                }
            }
        }
        if (!(groupFilter == null || user.groups != null && user.groups.contains(groupFilter))) {
            addIt = false;
        }
        return addIt;
    }

    public List<UIUser> listUsers_RestrictionCheck_NoLeak(AuthCtx authCtx, String groupFilter, boolean includeDisabled, boolean includeProfileAndTrialComputation) throws IOException {
        GeneralSettingsDAO.GeneralSettings settings = this.gsDAO.getUnsafeAutoTXN();
        ArrayList<UIUser> users = new ArrayList<UIUser>();
        for (UsersDAO.User user : this.dao.listUsers()) {
            if (!this.includedInUserList(authCtx, settings, user, groupFilter, includeDisabled)) continue;
            UIUser uiUser = new UIUser(user);
            if (includeProfileAndTrialComputation) {
                uiUser.computeTrialStatus(settings, user);
            }
            users.add(uiUser);
        }
        return users;
    }

    public List<APIUser> listAPIUsers_RestrictionCheck_WithSensitive(AuthCtx authCtx, String groupFilter, boolean includeDisabled, boolean includeProfileAndTrialComputation, boolean includeSettings) throws IOException {
        GeneralSettingsDAO.GeneralSettings settings = this.gsDAO.getUnsafeAutoTXN();
        ArrayList<APIUser> users = new ArrayList<APIUser>();
        for (UsersDAO.User user : this.dao.listUsers()) {
            if (!this.includedInUserList(authCtx, settings, user, groupFilter, includeDisabled)) continue;
            APIUser apiUser = includeSettings ? new APIUser(user, true) : new APIUser(user);
            if (includeProfileAndTrialComputation) {
                apiUser.computeTrialStatus(settings, user);
            }
            users.add(apiUser);
        }
        return users;
    }

    public List<APIUser> listAPIUsers_RestrictionCheck_WithSensitive(AuthCtx authCtx, String groupFilter, boolean includeDisabled, boolean includeProfileAndTrialComputation) throws IOException {
        return this.listAPIUsers_RestrictionCheck_WithSensitive(authCtx, groupFilter, includeDisabled, includeProfileAndTrialComputation, false);
    }

    public boolean hasAdminUsers(AuthCtx authCtx) throws IOException {
        for (UIUser user : this.listUsersEnabledOnly_RestrictionCheck_NoLeak(authCtx)) {
            if (!this.isAdmin(user.login)) continue;
            return true;
        }
        return false;
    }

    public GroupsSecurity listGroupNamesWithSecurity(AuthCtx authCtx, boolean localOnly) throws IOException {
        GeneralSettingsDAO.GeneralSettings gs = this.gsDAO.getUnsafeAutoTXN();
        return new GroupsSecurity(this.listGroupNames(authCtx, localOnly), !gs.security.restrictUsersAndGroupsVisibility);
    }

    public List<String> listGroupNames(AuthCtx authCtx, boolean localOnly) throws IOException {
        GeneralSettingsDAO.GeneralSettings gs = this.gsDAO.getUnsafeAutoTXN();
        ArrayList<String> ret = new ArrayList<String>();
        for (UsersDAO.Group g : this.dao.listGroupsUnsafe()) {
            boolean addIt = true;
            if (gs.security.restrictUsersAndGroupsVisibility && !authCtx.isAdmin() && !authCtx.getGroupsIfRelevant().contains(g.name)) {
                addIt = false;
            }
            if (localOnly && g.sourceType != UserSourceType.LOCAL) {
                addIt = false;
            }
            if (!addIt) continue;
            ret.add(g.name);
        }
        return ret;
    }

    public List<UsersDAO.Group> listGroupsFull() throws IOException {
        return this.dao.listGroups();
    }

    private void checkCanEditEmailAndDisplayName(AuthCtx authCtx, UserDTOBase existingUser, UserDTOBase newUser) throws IOException, DKUSecurityException {
        GeneralSettingsDAO.GeneralSettings gs = this.gsDAO.getUnsafeAutoTXN();
        if (!(authCtx.isAdmin() || Objects.equals(existingUser.email, newUser.email) && Objects.equals(existingUser.displayName, newUser.displayName) || gs.security.enableEmailAndDisplayNameModification)) {
            throw new DKUSecurityException("You are not allowed to edit your email or display name.");
        }
    }

    public UserDiff editUserFromUI_PasswordCheck_AllowedFieldsOnly(UIUser inputUser, AuthCtx authCtx) throws IOException, LimitsStatusComputer.LicenseLimitException, CodedException, DKUSecurityException {
        if (!(StringUtils.isBlank((String)inputUser.oldPassword) && StringUtils.isBlank((String)inputUser.password) || !StringUtils.isBlank((String)inputUser.oldPassword) && this.checkPassword(inputUser.login, inputUser.oldPassword))) {
            throw new CodedException((InfoMessage.MessageCode)SecurityCodes.ERR_SECURITY_WRONG_PASSWORD, "Your old password is wrong");
        }
        UIUser realUser = this.getUser_NoLeak(inputUser.login);
        realUser = (UIUser)JSON.deepCopy((Object)realUser);
        this.checkCanEditEmailAndDisplayName(authCtx, realUser, inputUser);
        realUser.email = inputUser.email;
        realUser.displayName = inputUser.displayName;
        realUser.oldPassword = inputUser.oldPassword;
        realUser.password = inputUser.password;
        if (inputUser.userProperties != null) {
            realUser.userProperties = inputUser.userProperties;
        }
        return this.editUserFromUI_NoCheck(realUser, authCtx);
    }

    public UserDiff editUserFromAPI_AllowedFieldsOnly(APIUser inputUser, AuthCtx authCtx) throws IOException, LimitsStatusComputer.LicenseLimitException, CodedException, DKUSecurityException {
        APIUser cleanUser = this.getUserForAPI_NoCheck_WithSensitive(authCtx, inputUser.login);
        cleanUser = (APIUser)JSON.deepCopy((Object)cleanUser);
        this.checkCanEditEmailAndDisplayName(authCtx, cleanUser, inputUser);
        cleanUser.email = inputUser.email;
        if (inputUser.userProperties != null) {
            cleanUser.userProperties = inputUser.userProperties;
        }
        return this.editUserFromAPI_NoCheck(cleanUser, authCtx);
    }

    public boolean checkPassword(String login, String password) throws IOException, CodedException {
        return this.areLoginsCaseSensitive() ? this.dao.checkLogin(login, password) : this.dao.checkLoginIgnoreCase(login, password);
    }

    public boolean areLoginsCaseSensitive() {
        return ApplicationConfigurator.getGeneralSettingsUnsafeAutoTXN().security.caseSensitiveLogins;
    }

    public UIUser getUserOrNull_NoLeak(String login) throws IOException {
        UsersDAO.User user = this.dao.getOrNull(login);
        return user != null ? this.makeUIUser_NoSensitive(user) : null;
    }

    public UIUser getUser_NoLeak(String login) throws IOException {
        return this.makeUIUser_NoSensitive(this.dao.getMandatory(login));
    }

    public UIUser getUserForUI_WithSensitive(String login) throws IOException {
        UsersDAO.User user = this.dao.getMandatory(login);
        UIUser uiUser = this.makeUIUser_NoSensitive(user);
        uiUser.adminProperties = user.adminProperties;
        uiUser.userProperties = user.userProperties;
        return uiUser;
    }

    public UIUser getUserForUI_RestrictionCheck_UserSensitive(AuthCtx authCtx, String login, boolean includeProfileAndTrialComputation) throws IOException, DKUSecurityException {
        UsersDAO.User user = this.dao.getOrNull(login);
        GeneralSettingsDAO.GeneralSettings gs = this.gsDAO.getUnsafeAutoTXN();
        if (user == null && gs.security.restrictUsersAndGroupsVisibility && !authCtx.isAdmin()) {
            throw new UnauthorizedException("You may not view this profile", "profile-forbidden");
        }
        if (user == null) {
            throw new NotFoundException("User does not exist");
        }
        boolean allowed = this.includedInUserList(authCtx, gs, user, null, true);
        if (!allowed) {
            throw new UnauthorizedException("You may not view this profile", "profile-forbidden");
        }
        UIUser uiUser = this.makeUIUser_NoSensitive(user);
        if (authCtx.getAssociatedDSSUserMand().equals(user.login)) {
            uiUser.userProperties = user.userProperties;
        }
        if (includeProfileAndTrialComputation) {
            uiUser.computeTrialStatus(gs, user);
        }
        return uiUser;
    }

    public APIUser getUserForAPI_RestrictionCheck_NoSensitive(AuthCtx authCtx, String login) throws IOException, UnauthorizedException {
        UsersDAO.User user = this.dao.getOrNull(login);
        GeneralSettingsDAO.GeneralSettings gs = this.gsDAO.getUnsafeAutoTXN();
        if (user == null && gs.security.restrictUsersAndGroupsVisibility && !authCtx.isAdmin()) {
            throw new UnauthorizedException("You may not view this profile", "profile-forbidden");
        }
        if (user == null) {
            throw new NotFoundException("User does not exist");
        }
        boolean allowed = this.includedInUserList(authCtx, gs, user, null, true);
        if (!allowed) {
            throw new UnauthorizedException("You may not view this profile", "profile-forbidden");
        }
        return this.makeAPIUser_NoSensitive(user);
    }

    public APIUser getUserForAPI_NoCheck_WithSensitive(AuthCtx authCtx, String login) throws IOException {
        return this.getUserForAPI_NoCheck_WithSensitive(authCtx, login, false);
    }

    public APIUser getUserForAPI_NoCheck_WithSensitive(AuthCtx authCtx, String login, boolean includeProfileAndTrialComputation) throws IOException {
        UsersDAO.User user = this.dao.getMandatory(login);
        APIUser uiUser = this.makeAPIUser_NoSensitive(user);
        if (includeProfileAndTrialComputation) {
            GeneralSettingsDAO.GeneralSettings gs = this.gsDAO.getUnsafeAutoTXN();
            uiUser.computeTrialStatus(gs, user);
        }
        uiUser.adminProperties = user.adminProperties;
        uiUser.userProperties = user.userProperties;
        return uiUser;
    }

    public APIUser getUserForAPI_NoCheck_WithUserSensitive(String login) throws IOException {
        UsersDAO.User user = this.dao.getMandatory(login);
        APIUser uiUser = this.makeAPIUser_NoSensitive(user);
        uiUser.userProfile = this.getResultingUserProfileForTrials(user);
        uiUser.userProperties = user.userProperties;
        return uiUser;
    }

    private UIUser makeUIUser_NoSensitive(UsersDAO.User u) throws IOException {
        assert (u != null);
        UIUser ud = new UIUser(u);
        ud.objectImgHash = this.imagesDAO.getOriginalImageHash(null, "USER", u.login);
        ud.userProfile = this.limitsService.getUserProfileByNameOrFallback((String)u.userProfile).profile;
        return ud;
    }

    private APIUser makeAPIUser_NoSensitive(UsersDAO.User u) throws IOException {
        assert (u != null);
        APIUser ud = new APIUser(u);
        ud.objectImgHash = this.imagesDAO.getOriginalImageHash(null, "USER", u.login);
        return ud;
    }

    private String getResultingUserProfileForTrials(UsersDAO.User user) {
        try {
            GeneralSettingsDAO.GeneralSettings gs = this.gsDAO.getUnsafeAutoTXN();
            Pair<Void, String> trialStatusAndResultingProfile = UsersService.computeTrialStatusAndResultingUserProfile(gs, user);
            return (String)trialStatusAndResultingProfile.second;
        }
        catch (IOException e) {
            logger.warn((Object)"Failed to retrieve trial status", (Throwable)e);
            return user.userProfile;
        }
    }

    public boolean isAdmin(String login) throws IOException {
        UsersDAO.User u = this.dao.getMandatoryUnsafe(login);
        for (String groupName : u.groups) {
            UsersDAO.Group g = this.dao.getGroupUnsafe(groupName);
            if (g == null || !g.isAdmin()) continue;
            return true;
        }
        return false;
    }

    public boolean isDisabled(String login) throws IOException {
        UsersDAO.User u = this.dao.getMandatoryUnsafe(login);
        return !u.enabled;
    }

    private void enableDisableUserAdmin(String login, boolean enable) throws IOException {
        UsersDAO.User u = this.dao.getMandatory(login);
        u.enabled = enable;
        this.dao.saveUser(u);
    }

    public void enableDisableUsersAdmin(List<String> logins, AuthCtx u, boolean enable) throws IOException {
        if (!enable) {
            this.makeCurrentLoginLast(logins, u.getAssociatedDSSUser());
        }
        for (String login : logins) {
            this.enableDisableUserAdmin(login, enable);
        }
    }

    public void deleteUserAdmin(String login) throws Exception {
        this.dao.deleteUser(login);
    }

    public boolean isValidLogin(String login) {
        return !StringUtils.isBlank((String)login) && loginPattern.matcher(login).find();
    }

    public void sendWelcomeEmail(DkuUser user) {
    }

    public void sendWelcomeEmailWhenProfileChange(DkuUser oldUser) {
        UsersDAO.User newUser;
        if (oldUser == null) {
            return;
        }
        try (Transaction rt = this.transactionService.retrieveOrBeginRead();){
            newUser = this.dao.getOrNull(oldUser.getLogin());
        }
        catch (IOException e) {
            logger.error((Object)e.getMessage(), (Throwable)e);
            return;
        }
        if (newUser == null) {
            return;
        }
        if (!Objects.equals(newUser.getUserProfile(), oldUser.getUserProfile()) && "NONE".equals(oldUser.getUserProfile())) {
            this.sendWelcomeEmail(newUser);
        }
    }

    private void check(boolean condition, String msg) throws CodedException {
        if (!condition) {
            throw new CodedException((InfoMessage.MessageCode)SecurityCodes.ERR_SECURITY_CRUD_INVALID_SETTINGS, msg);
        }
    }

    public InfoMessage.InfoMessages addUserAdmin_NT(UIUser inputUser, AuthCtx authCtx) throws Exception {
        InfoMessage.InfoMessages ret = new InfoMessage.InfoMessages();
        TransactionContext.assertNoAttachedTransaction();
        this.check(StringUtils.isNotBlank((String)inputUser.displayName), "Display name cannot be empty");
        this.check(StringUtils.isNotBlank((String)inputUser.login), "Login cannot be empty");
        this.check(inputUser.login.length() >= 1, "Login name is too short (min. 1 character)");
        this.check(this.isValidLogin(inputUser.login), "Login is invalid or contains special characters");
        try (RWTransaction t = this.transactionService.beginWriteAsLoggedInUser(authCtx);){
            boolean userWillUseALicense;
            UsersDAO.User usr;
            this.permissionsService.checkAdmin(authCtx);
            switch (inputUser.sourceType) {
                case LOCAL: {
                    usr = this.dao.addUser(inputUser.login, inputUser.password);
                    usr.displayName = inputUser.displayName;
                    usr.groups = inputUser.groups;
                    usr.email = inputUser.email;
                    usr.userProfile = inputUser.userProfile;
                    this.updateUserTrialTokenIfDataikerCloudAdmin(usr, authCtx);
                    break;
                }
                case PAM: 
                case LDAP: 
                case AZURE_AD: 
                case CUSTOM: {
                    usr = new UsersDAO.User(inputUser.login, inputUser.sourceType);
                    usr.displayName = inputUser.displayName;
                    usr.email = inputUser.email;
                    usr.groups = inputUser.groups;
                    usr.userProfile = inputUser.userProfile;
                    this.updateUserTrialTokenIfDataikerCloudAdmin(usr, authCtx);
                    this.dao.addForeignUser(usr);
                    break;
                }
                case LOCAL_NO_AUTH: {
                    usr = this.dao.addUser(inputUser.login, null);
                    usr.displayName = inputUser.displayName;
                    usr.groups = inputUser.groups;
                    usr.email = inputUser.email;
                    usr.userProfile = inputUser.userProfile;
                    usr.sourceType = UserSourceType.LOCAL_NO_AUTH;
                    this.updateUserTrialTokenIfDataikerCloudAdmin(usr, authCtx);
                    break;
                }
                default: {
                    throw new DSSInternalErrorException("Invalid  auth source type: " + String.valueOf(inputUser.sourceType));
                }
            }
            if (inputUser.adminProperties != null) {
                usr.adminProperties = inputUser.adminProperties;
            }
            if (inputUser.userProperties != null) {
                usr.userProperties = inputUser.userProperties;
            }
            UserSaveContext usc = inputUser.sourceType == UserSourceType.LOCAL && StringUtils.isNotBlank((String)inputUser.password) ? UserSaveContext.buildDefaultWithPassword(inputUser.password) : UserSaveContext.buildDefaultWithoutPassword();
            this.saveUser(usr, true, usc, authCtx);
            boolean bl = userWillUseALicense = !"NONE".equals(usr.userProfile);
            if (userWillUseALicense) {
                this.limitsService.checkUsersOverQuota("create a user");
            }
            t.commit("Created user " + usr.login);
            this.sendWelcomeEmail(usr);
            InfoMessage.InfoMessages infoMessages = ret;
            return infoMessages;
        }
    }

    private void makeCurrentLoginLast(List<String> logins, String currentLogin) {
        if (logins.contains(currentLogin)) {
            logins.removeAll(Collections.singletonList(currentLogin));
            logins.add(currentLogin);
        }
    }

    private void removeUsersFromGroups(List<String> logins, List<String> groupNames, AuthCtx authCtx) throws IOException, CodedException {
        for (String groupName : groupNames) {
            for (String login : logins) {
                this.removeUserFromGroup(login, groupName, authCtx);
            }
        }
    }

    private UserDiff removeUserFromGroup(String login, String group, AuthCtx authCtx) throws IOException, CodedException {
        UsersDAO.User usr = this.dao.getMandatory(login);
        if (!usr.groups.contains(group)) {
            return new UserDiff();
        }
        usr.groups.remove(group);
        return this.saveUser(usr, false, UserSaveContext.buildDefaultWithoutPassword(), authCtx);
    }

    private void addUsersToGroups(List<String> users, List<String> groupNames, AuthCtx authCtx) throws IOException, CodedException {
        for (String groupName : groupNames) {
            UsersDAO.Group group = this.getGroupMandatory(groupName);
            for (String user : users) {
                this.addUserToGroup(user, group.name, authCtx);
            }
        }
    }

    private void addUserToGroup(String login, String group, AuthCtx authCtx) throws IOException, CodedException {
        UsersDAO.User usr = this.dao.getMandatory(login);
        if (usr.groups.contains(group)) {
            return;
        }
        usr.groups.add(group);
        this.saveUser(usr, false, UserSaveContext.buildDefaultWithoutPassword(), authCtx);
    }

    public UserDiff editUserFromUI_NoCheck(UIUser inputUser, AuthCtx authCtx) throws IOException, CodedException {
        boolean setSecurePassword;
        this.check(StringUtils.isNotBlank((String)inputUser.displayName), "Display name cannot be empty");
        UsersDAO.User usr = this.dao.getMandatory(inputUser.login);
        this.updateUserFromDTOBase(usr, inputUser);
        if (inputUser.adminProperties != null) {
            usr.adminProperties = inputUser.adminProperties;
        }
        if (inputUser.userProperties != null) {
            usr.userProperties = inputUser.userProperties;
        }
        this.updateSecretsIfNeeded(usr);
        boolean bl = setSecurePassword = !StringUtils.isBlank((String)inputUser.password) && inputUser.sourceType == UserSourceType.LOCAL;
        if (setSecurePassword) {
            usr.setSecurePassword(inputUser.password);
        }
        UserSaveContext usc = setSecurePassword ? UserSaveContext.buildDefaultWithPassword(inputUser.password) : UserSaveContext.buildDefaultWithoutPassword();
        return this.saveUser(usr, false, usc, authCtx);
    }

    public UserDiff editUserFromAPI_NoCheck(APIUser inputUser, AuthCtx authCtx) throws IOException, CodedException {
        boolean setSecurePassword;
        this.check(StringUtils.isNotBlank((String)inputUser.displayName), "Display name cannot be empty");
        UsersDAO.User usr = this.dao.getMandatory(inputUser.login);
        this.updateUserFromDTOBase(usr, inputUser);
        if (inputUser.adminProperties != null) {
            usr.adminProperties = inputUser.adminProperties;
        }
        if (inputUser.userProperties != null) {
            usr.userProperties = inputUser.userProperties;
        }
        this.updateSecretsIfNeeded(usr);
        boolean bl = setSecurePassword = !StringUtils.isBlank((String)inputUser.password) && inputUser.sourceType == UserSourceType.LOCAL;
        if (setSecurePassword) {
            usr.setSecurePassword(inputUser.password);
        }
        UserSaveContext usc = setSecurePassword ? UserSaveContext.buildDefaultWithPassword(inputUser.password) : UserSaveContext.buildDefaultWithoutPassword();
        this.updateUserTrialTokenIfDataikerCloudAdmin(usr, authCtx);
        return this.saveUser(usr, false, usc, authCtx);
    }

    public UserDiff editUserFromAPIDiff_NoCheck(APIUser userModifications, AuthCtx authCtx) throws IOException, CodedException, IllegalArgumentException {
        boolean setSecurePassword;
        UsersDAO.User user = this.dao.getOrNull(userModifications.login);
        if (user == null) {
            throw new IllegalArgumentException("User '" + userModifications.login + "' does not exist");
        }
        if (userModifications.displayName != null) {
            this.check(StringUtils.isNotBlank((String)userModifications.displayName), "Display name cannot be empty");
            user.displayName = userModifications.displayName;
        }
        this.updateUserFromDTOBaseDiff(user, userModifications);
        if (userModifications.adminProperties != null) {
            user.adminProperties = userModifications.adminProperties;
        }
        if (userModifications.userProperties != null) {
            user.userProperties = userModifications.userProperties;
        }
        this.updateSecretsIfNeeded(user);
        boolean bl = setSecurePassword = userModifications.sourceType == UserSourceType.LOCAL && !StringUtils.isBlank((String)userModifications.password);
        if (setSecurePassword) {
            user.setSecurePassword(userModifications.password);
        }
        UserSaveContext userSaveContext = setSecurePassword ? UserSaveContext.buildDefaultWithPassword(userModifications.password) : UserSaveContext.buildDefaultWithoutPassword();
        this.updateUserTrialTokenIfDataikerCloudAdmin(user, authCtx);
        return this.saveUser(user, false, userSaveContext, authCtx);
    }

    private void updateUserFromDTOBaseDiff(UsersDAO.User user, UserDTOBase dto) throws IOException {
        if (dto.sourceType != null) {
            user.sourceType = dto.sourceType;
        }
        if (dto.email != null) {
            user.email = dto.email;
        }
        if (dto.displayName != null) {
            user.displayName = dto.displayName;
        }
        if (dto.enabled != null) {
            user.enabled = dto.enabled;
        }
        if (dto.groups != null) {
            ArrayList<String> newGrps = new ArrayList<String>();
            if (user.groups != null) {
                for (String groupName : user.groups) {
                    UsersDAO.Group group;
                    if (newGrps.contains(groupName) || (group = this.dao.getGroupUnsafe(groupName)) == null || group.sourceType == UserSourceType.LOCAL) continue;
                    newGrps.add(groupName);
                }
            }
            for (String groupName : dto.groups) {
                if (newGrps.contains(groupName)) continue;
                newGrps.add(groupName);
            }
            user.groups = newGrps;
        }
        if (dto.userProfile != null) {
            user.userProfile = dto.userProfile;
        }
    }

    private void updateUserFromDTOBase(UsersDAO.User user, UserDTOBase dto) throws IOException {
        user.sourceType = dto.sourceType;
        user.email = dto.email;
        user.displayName = dto.displayName;
        user.enabled = dto.enabled;
        ArrayList<String> newGrps = new ArrayList<String>();
        if (user.groups != null) {
            for (String groupName : user.groups) {
                UsersDAO.Group group;
                if (newGrps.contains(groupName) || (group = this.dao.getGroupUnsafe(groupName)) == null || group.sourceType == UserSourceType.LOCAL) continue;
                newGrps.add(groupName);
            }
        }
        if (dto.groups != null) {
            for (String groupName : dto.groups) {
                if (newGrps.contains(groupName)) continue;
                newGrps.add(groupName);
            }
        }
        user.groups = newGrps;
        user.userProfile = dto.userProfile;
    }

    private void updateSecretsIfNeeded(UsersDAO.User user) {
    }

    private void updateUserTrialTokenIfDataikerCloudAdmin(UsersDAO.User user, AuthCtx authCtx) {
    }

    public UsersDAO.Group getGroup(String groupName) throws IOException {
        return this.dao.getGroup(groupName);
    }

    public UsersDAO.Group getGroupMandatory(String groupName) throws IOException {
        return this.dao.getGroupMandatory(groupName);
    }

    public void addGroup(UsersDAO.Group group) throws IOException, CodedException {
        this.check(StringUtils.isNotBlank((String)group.name), "Empty group name");
        this.check(!group.name.contains(" "), "Group name must not contain spaces");
        this.check(group.name.length() <= 80, "Group name is too long (80 characters maximum)");
        this.check(validGroupPattern.matcher(group.name).find(), "Group name is invalid or contains special characters");
        this.check(group.sourceType != UserSourceType.SAAS && group.sourceType != UserSourceType.PAM, "Invalid group source type");
        this.dao.addGroup(group);
    }

    public InfoMessage.InfoMessages deleteGroup(AuthCtx user, String groupName) throws Exception {
        InfoMessage.InfoMessages ret = new InfoMessage.InfoMessages();
        this.dao.getGroupMandatoryUnsafe(groupName);
        for (UsersDAO.User u : this.dao.listUsers()) {
            if (!u.groups.remove(groupName)) continue;
            UserSaveContext usc = UserSaveContext.buildDefaultWithoutPassword();
            this.saveUser(u, false, usc, user);
        }
        for (AbstractGlobalScopePublicAPIKey publicAPIKey : this.publicAPIKeysService.listGlobalAPIKeys()) {
            GlobalScopePublicAPIKeyWithGroups apiKeyWithGroups;
            List<String> keyGroups;
            if (!(publicAPIKey instanceof GlobalScopePublicAPIKeyWithGroups) || !(keyGroups = (apiKeyWithGroups = (GlobalScopePublicAPIKeyWithGroups)publicAPIKey).getGroups()).contains(groupName)) continue;
            List<String> newGroups = keyGroups.stream().filter(g -> !groupName.equals(g)).toList();
            GlobalScopePublicAPIKeyWithGroups keyWithoutGroup = new GlobalScopePublicAPIKeyWithGroups(apiKeyWithGroups, newGroups);
            this.publicAPIKeysService.updateGlobalAPIKeyById(keyWithoutGroup);
        }
        this.dao.deleteGroup(groupName);
        return ret;
    }

    public GroupDiff updateGroup(UsersDAO.Group group) throws IOException {
        this.dao.getGroupMandatory(group.name);
        GroupDiff groupDiff = this.dao.saveGroup(group);
        return groupDiff;
    }

    public UserDiff saveUser(UsersDAO.User u, boolean isCreationActionType, UserSaveContext usc, AuthCtx authCtx) throws IOException, CodedException {
        AbstractLicenseFeaturesStatusBuilder.LicenseFeaturesStatus lls = this.limitsService.getFeaturesStatus();
        if (!lls.userSecurityAllowed) {
            logger.infoV("Security not enabled, making the user an administrator: %s", new Object[]{u.login});
            boolean alreadyAnAdmin = false;
            for (String existingGroup : u.groups) {
                UsersDAO.Group g = this.dao.getGroupUnsafe(existingGroup);
                if (g == null || !g.isAdmin()) continue;
                alreadyAnAdmin = true;
                break;
            }
            if (!alreadyAnAdmin) {
                logger.info((Object)"Not currently in an admin group, creating a new one");
                String newGroupName = String.format("%s-admin-%s", u.login, SecretKeyGenerator.generate((int)6));
                UsersDAO.Group g = new UsersDAO.Group();
                g.sourceType = UserSourceType.LOCAL;
                g.name = newGroupName;
                g.withAdmin(true);
                this.dao.saveGroup(g);
                u.groups.add(newGroupName);
            }
        }
        UserDiff userDiff = this.dao.saveUser(u);
        return userDiff;
    }

    public UsersDAO.GroupPermissions getUserEffectiveGroupPermissions(UsersDAO.User user) throws IOException {
        UsersDAO.GroupPermissions computed = UsersDAO.GroupPermissions.baseGroupPermissionsForUnion();
        for (UsersDAO.Group group : this.dao.listGroupsUnsafe()) {
            if (!user.groups.contains(group.name)) continue;
            computed = computed.union(group);
        }
        return computed;
    }

    public InfoMessage.InfoMessages prepareDeleteUsers_NT(List<String> logins, AuthCtx user) throws Exception {
        try (RWTransaction rwt = this.transactionService.beginNonCommittableWriteAsDSS();){
            InfoMessage.InfoMessages infoMessages;
            block13: {
                Closeable tr = this.beginAlwaysRollbackingDBTransaction();
                try {
                    this.makeCurrentLoginLast(logins, user.getAssociatedDSSUser());
                    for (String login : logins) {
                        this.deleteUserAdmin(login);
                    }
                    infoMessages = this.checkCurrentState(user);
                    if (tr == null) break block13;
                }
                catch (Throwable throwable) {
                    if (tr != null) {
                        try {
                            tr.close();
                        }
                        catch (Throwable throwable2) {
                            throwable.addSuppressed(throwable2);
                        }
                    }
                    throw throwable;
                }
                tr.close();
            }
            return infoMessages;
        }
    }

    public InfoMessage.InfoMessages prepareDisableUsers_NT(List<String> logins, AuthCtx user) throws IOException, DKUSecurityException {
        try (RWTransaction ignored = this.transactionService.beginNonCommittableWriteAsDSS();){
            InfoMessage.InfoMessages infoMessages;
            block12: {
                Closeable tr = this.beginAlwaysRollbackingDBTransaction();
                try {
                    this.enableDisableUsersAdmin(logins, user, false);
                    infoMessages = this.checkCurrentState(user);
                    if (tr == null) break block12;
                }
                catch (Throwable throwable) {
                    if (tr != null) {
                        try {
                            tr.close();
                        }
                        catch (Throwable throwable2) {
                            throwable.addSuppressed(throwable2);
                        }
                    }
                    throw throwable;
                }
                tr.close();
            }
            return infoMessages;
        }
    }

    public InfoMessage.InfoMessages prepareDeleteGroup_NT(String groupName, AuthCtx user) throws Exception {
        try (RWTransaction rwt = this.transactionService.beginNonCommittableWriteAsDSS();){
            InfoMessage.InfoMessages infoMessages;
            block12: {
                Closeable tr = this.beginAlwaysRollbackingDBTransaction();
                try {
                    this.deleteGroup(user, groupName);
                    infoMessages = this.checkCurrentState(user);
                    if (tr == null) break block12;
                }
                catch (Throwable throwable) {
                    if (tr != null) {
                        try {
                            tr.close();
                        }
                        catch (Throwable throwable2) {
                            throwable.addSuppressed(throwable2);
                        }
                    }
                    throw throwable;
                }
                tr.close();
            }
            return infoMessages;
        }
    }

    public InfoMessage.InfoMessages prepareEditUser_NT(UIUser uiUser, AuthCtx user) throws LimitsStatusComputer.LicenseLimitException, IOException, DKUSecurityException, CodedException {
        try (RWTransaction rwt = this.transactionService.beginNonCommittableWriteAsDSS();){
            InfoMessage.InfoMessages infoMessages;
            block12: {
                Closeable tr = this.beginAlwaysRollbackingDBTransaction();
                try {
                    this.editUserFromUI_NoCheck(uiUser, user);
                    infoMessages = this.checkCurrentState(user);
                    if (tr == null) break block12;
                }
                catch (Throwable throwable) {
                    if (tr != null) {
                        try {
                            tr.close();
                        }
                        catch (Throwable throwable2) {
                            throwable.addSuppressed(throwable2);
                        }
                    }
                    throw throwable;
                }
                tr.close();
            }
            return infoMessages;
        }
    }

    public InfoMessage.InfoMessages prepareAssignUsersToGroups_NT(List<String> logins, List<String> groupsToAdd, List<String> groupsToRemove, AuthCtx user) throws IOException, DKUSecurityException, CodedException {
        try (RWTransaction rwt = this.transactionService.beginNonCommittableWriteAsDSS();){
            InfoMessage.InfoMessages infoMessages;
            block12: {
                Closeable tr = this.beginAlwaysRollbackingDBTransaction();
                try {
                    this.removeUsersFromGroups(logins, groupsToRemove, user);
                    this.addUsersToGroups(logins, groupsToAdd, user);
                    infoMessages = this.checkCurrentState(user);
                    if (tr == null) break block12;
                }
                catch (Throwable throwable) {
                    if (tr != null) {
                        try {
                            tr.close();
                        }
                        catch (Throwable throwable2) {
                            throwable.addSuppressed(throwable2);
                        }
                    }
                    throw throwable;
                }
                tr.close();
            }
            return infoMessages;
        }
    }

    public void deleteUsersAdmin(List<String> logins, AuthCtx user) throws Exception {
        this.makeCurrentLoginLast(logins, user.getAssociatedDSSUser());
        for (String login : logins) {
            this.deleteUserAdmin(login);
        }
    }

    public void assignUsersToGroups(List<String> logins, List<String> groupsToAdd, List<String> groupsToRemove, AuthCtx user) throws IOException, CodedException {
        this.makeCurrentLoginLast(logins, user.getAssociatedDSSUser());
        this.removeUsersFromGroups(logins, groupsToRemove, user);
        this.addUsersToGroups(logins, groupsToAdd, user);
    }

    public void assignUsersToProfile(List<String> logins, String newProfile, AuthCtx authCtx) throws IOException, CodedException {
        this.makeCurrentLoginLast(logins, authCtx.getAssociatedDSSUser());
        for (String login : logins) {
            UsersDAO.User user = this.dao.getMandatory(login);
            user.userProfile = newProfile;
            this.saveUser(user, false, UserSaveContext.buildDefaultWithoutPassword(), authCtx);
        }
    }

    public InfoMessage.InfoMessages prepareUpdateGroup_NT(UsersDAO.Group group, AuthCtx user) throws Exception {
        try (RWTransaction rwt = this.transactionService.beginNonCommittableWriteAsDSS();){
            InfoMessage.InfoMessages infoMessages;
            block12: {
                Closeable tr = this.beginAlwaysRollbackingDBTransaction();
                try {
                    this.updateGroup(group);
                    infoMessages = this.checkCurrentState(user);
                    if (tr == null) break block12;
                }
                catch (Throwable throwable) {
                    if (tr != null) {
                        try {
                            tr.close();
                        }
                        catch (Throwable throwable2) {
                            throwable.addSuppressed(throwable2);
                        }
                    }
                    throw throwable;
                }
                tr.close();
            }
            return infoMessages;
        }
    }

    private InfoMessage.InfoMessages checkCurrentState(AuthCtx user) throws IOException, DKUSecurityException {
        String dssUser;
        InfoMessage.InfoMessages messages = new InfoMessage.InfoMessages();
        if (!this.hasAdminUsers(user)) {
            messages.withWarning((InfoMessage.MessageCode)UserCodes.WARN_USER_REMOVING_LAST_ADMIN, null).summarize();
        }
        if (this.getUserOrNull_NoLeak(dssUser = user.getAssociatedDSSUserMand()) == null) {
            messages.withWarning((InfoMessage.MessageCode)UserCodes.WARN_USER_DELETING_OWN_ACCOUNT, null).summarize();
        } else if (!this.isAdmin(dssUser)) {
            messages.withWarning((InfoMessage.MessageCode)UserCodes.WARN_USER_REVOKING_OWN_ADMIN, null).summarize();
        } else if (this.isDisabled(dssUser)) {
            messages.withWarning((InfoMessage.MessageCode)UserCodes.WARN_USER_DISABLING_OWN_ADMIN, null).summarize();
        }
        return messages;
    }

    public Set<String> getMentions(String s) throws IOException {
        HashSet<String> ret = new HashSet<String>();
        if (StringUtils.isBlank((String)s)) {
            return ret;
        }
        Matcher matcher = mentionPattern.matcher(s);
        while (matcher.find()) {
            String matched = matcher.group();
            String login = matched.substring(1);
            if (ret.contains(login) || this.dao.getOrNull(login) == null) continue;
            ret.add(login);
        }
        return ret;
    }

    public Set<String> getMentionsNoExistenceCheck(String s) {
        HashSet<String> ret = new HashSet<String>();
        Matcher matcher = mentionPattern.matcher(s);
        while (matcher.find()) {
            String matched = matcher.group();
            String login = matched.substring(1);
            ret.add(login);
        }
        return ret;
    }

    public List<PublicUser> getPublicUsers(Collection<String> logins) throws IOException {
        return this.dao.getPublicUsers(logins);
    }

    public UsersDAO.User getInternalUserOrNullUnsafe(String login) throws IOException {
        return this.dao.getOrNullUnsafe(login);
    }

    public UsersDAO.User getInternalMandatoryUnsafe(String login) throws IOException {
        return this.dao.getMandatoryUnsafe(login);
    }

    public List<UsersDAO.User> listUsersInternalUnsafeEnabledOnly() throws IOException {
        ArrayList<UsersDAO.User> res = new ArrayList<UsersDAO.User>();
        for (UsersDAO.User user : this.dao.listUsersUnsafe()) {
            if (!user.enabled) continue;
            res.add(user);
        }
        return res;
    }

    public List<UsersDAO.User> listUsersInternalUnsafeEnabledOnlyForGroup(String groupName) throws IOException {
        ArrayList<UsersDAO.User> res = new ArrayList<UsersDAO.User>();
        for (UsersDAO.User user : this.dao.listUsersUnsafe()) {
            if (!user.enabled || !user.groups.contains(groupName)) continue;
            res.add(user);
        }
        return res;
    }

    public List<UsersDAO.User> getUsersInternalUnsafeEnabledOnlyByLogins(Collection<String> logins) throws IOException {
        HashSet<String> loginsSet = new HashSet<String>(logins);
        ArrayList<UsersDAO.User> res = new ArrayList<UsersDAO.User>();
        for (UsersDAO.User user : this.dao.listUsersUnsafe()) {
            if (!user.enabled || !loginsSet.contains(user.login)) continue;
            res.add(user);
        }
        return res;
    }

    public List<UsersDAO.User> listUsersInternalEnabledOnly() throws IOException {
        return this.dao.listUsers().stream().filter(user -> user.enabled).collect(Collectors.toList());
    }

    public PublicUser getPublicUser(String login) throws IOException {
        return this.dao.getPublicUser(login);
    }

    public UserLastActivity getUserLastActivity(String login) throws IOException {
        return this.usersActivityDAO.getUserLastActivity(login);
    }

    public Map<String, UserLastActivity> getAllUsersActivity(boolean recreateOnError) throws IOException {
        return this.usersActivityDAO.getAllUsersActivity(recreateOnError);
    }

    public static Multimap<String, String> buildLoginsByEmailMap(List<? extends DkuUser> users) {
        HashMultimap loginsByEmails = HashMultimap.create();
        users.forEach(arg_0 -> UsersService.lambda$buildLoginsByEmailMap$2((Multimap)loginsByEmails, arg_0));
        return loginsByEmails;
    }

    private Closeable beginAlwaysRollbackingDBTransaction() {
        AtomicReference<TransactionStatus> dataSourceTransaction = new AtomicReference<TransactionStatus>();
        DefaultTransactionDefinition transactionDefinition = new DefaultTransactionDefinition();
        transactionDefinition.setPropagationBehavior(3);
        dataSourceTransaction.set(this.platformTransactionManager.getTransaction((TransactionDefinition)transactionDefinition));
        return () -> {
            if (dataSourceTransaction.get() != null) {
                this.platformTransactionManager.rollback((TransactionStatus)dataSourceTransaction.get());
                dataSourceTransaction.set(null);
            }
        };
    }

    private static /* synthetic */ void lambda$buildLoginsByEmailMap$2(Multimap loginsByEmails, DkuUser user) {
        String login = user.getLogin();
        String email = user.getEmail();
        if (StringUtils.isNotBlank((String)email)) {
            loginsByEmails.put((Object)email.toLowerCase(Locale.ROOT), (Object)login);
        }
        if (StringUtils.indexOf((String)login, (char)'@') > 0) {
            loginsByEmails.put((Object)login.toLowerCase(Locale.ROOT), (Object)login);
        }
    }

    public static class UserSaveContext {
        public final UserSaveContextType type;
        public final String password;

        private UserSaveContext(UserSaveContextType type, String password) {
            this.type = type;
            this.password = password;
        }

        public static UserSaveContext buildInstanceInit() {
            return new UserSaveContext(UserSaveContextType.INSTANCE_INIT, null);
        }

        public static UserSaveContext buildExternalSourceUpdate() {
            return new UserSaveContext(UserSaveContextType.EXTERNAL_SOURCE_UPDATE, null);
        }

        public static UserSaveContext buildDefaultWithoutPassword() {
            return new UserSaveContext(UserSaveContextType.DEFAULT_WITHOUT_PASSWORD, null);
        }

        public static UserSaveContext buildDefaultWithPassword(String pwd) {
            return new UserSaveContext(UserSaveContextType.DEFAULT_WITH_PASSWORD, pwd);
        }
    }

    @UIModel
    public static class UIUser
    extends UserDTOBase {
        public String oldPassword;
        public String password;
        public JsonObject adminProperties;
        public JsonObject userProperties;
        @UINullable
        public UserLastActivity activity;

        public UIUser() {
        }

        public UIUser(UsersDAO.User u) {
            this.login = u.login;
            this.sourceType = u.sourceType;
            this.displayName = u.displayName;
            this.groups = u.groups;
            this.email = u.email;
            this.enabled = u.enabled;
            this.creationDate = u.creationDate;
            this.userProfile = u.userProfile;
        }

        public String toString() {
            return "UIUser{login='" + this.login + "', sourceType=" + String.valueOf(this.sourceType) + ", displayName='" + this.displayName + "', groups=" + String.valueOf(this.groups) + ", email='" + this.email + "'}";
        }

        public String getLogin() {
            return this.login;
        }

        public String getDisplayName() {
            return this.displayName;
        }

        public void setDisplayName(String displayName) {
            this.displayName = displayName;
        }

        public String getEmail() {
            return this.email;
        }

        public void setEmail(String email) {
            this.email = email;
        }

        public String getUserProfile() {
            return this.userProfile;
        }

        public void setUserProfile(String userProfile) {
            this.userProfile = userProfile;
        }

        public UserSourceType getUserSourceType() {
            return this.sourceType;
        }

        public List<String> getGroups() {
            return this.groups;
        }

        public void addGroupMembership(String group) {
            this.groups.add(group);
        }

        public void removeGroupMembership(String group) {
            this.groups.remove(group);
        }

        public boolean isEnabled() {
            return this.enabled;
        }

        public void setEnabled(boolean enabled) {
            this.enabled = enabled;
        }
    }

    public static class APIUser
    extends UserDTOBase {
        public JsonObject adminProperties;
        public JsonObject userProperties;
        public String password;
        public int activeWebSocketSesssions;

        private APIUser() {
        }

        public APIUser(UsersDAO.User u, boolean withSensitive) {
            this.login = u.login;
            this.sourceType = u.sourceType;
            this.displayName = u.displayName;
            this.groups = u.groups;
            this.email = u.email;
            this.userProfile = u.userProfile;
            this.enabled = u.enabled;
            this.creationDate = u.creationDate;
            if (withSensitive) {
                this.adminProperties = u.adminProperties;
                this.userProperties = u.userProperties;
            }
        }

        public APIUser(UsersDAO.User user) {
            this(user, false);
        }

        public APIUser(UIUser ui) {
            this.login = ui.login;
            this.sourceType = ui.sourceType;
            this.displayName = ui.displayName;
            this.groups = ui.groups;
            this.email = ui.email;
            this.userProfile = ui.resultingUserProfile != null ? ui.resultingUserProfile : ui.userProfile;
            this.enabled = ui.enabled;
            this.creationDate = ui.creationDate;
        }
    }

    @UIModel
    public static class GroupsSecurity {
        public List<String> groups;
        public boolean mayShowAllUsersGroup;

        public GroupsSecurity(List<String> groups, boolean mayShowAllUsersGroup) {
            this.groups = groups;
            this.mayShowAllUsersGroup = mayShowAllUsersGroup;
        }
    }

    @UIModel
    public static class UserDTOBase {
        public String login;
        public UserSourceType sourceType;
        public String displayName;
        public List<String> groups;
        public String email;
        public String userProfile;
        @UINullable
        public Long creationDate;
        public Boolean enabled;
        public long objectImgHash;
        public String resultingUserProfile;

        public void computeTrialStatus(GeneralSettingsDAO.GeneralSettings gs, UsersDAO.User u) {
            this.resultingUserProfile = UsersService.computeResultingUserProfile(gs, u, this.userProfile);
        }
    }

    public static enum UserSaveContextType {
        INSTANCE_INIT,
        EXTERNAL_SOURCE_UPDATE,
        DEFAULT_WITHOUT_PASSWORD,
        DEFAULT_WITH_PASSWORD;

    }
}

