% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/dkuWriteDataset.R
\name{dkuWriteDataset}
\alias{dkuWriteDataset}
\title{Writes a data.frame to Dataiku's Data Science Studio}
\usage{
dkuWriteDataset(df, name, partition = "", schema = TRUE, convertLists = TRUE)
}
\arguments{
\item{df}{The data.frame to write to Data Science Studio}

\item{name}{The name of the dataset in data science studio to write to}

\item{partition}{The name of the partition to write to. Optional}

\item{schema}{Whether to overwrite the schema of the target dataset}

\item{convertLists}{Whether to convert list-columns to JSON}
}
\value{
None
}
\description{
Writes a data.frame to Dataiku's Data Science Studio
}
\details{
This function writes a dataset to Dataiku's Data Science Studio.

Please see Dataiku's online documentation for
a description of how to use partitions in combination with R.
}
\examples{
\dontrun{
# write the iris dataset to Data Science Studio
dkuWriteDataset(iris, "irisDataiku")

# do not copy schema to Data Science Studio
dkuWriteDataset(iris, "irisDataiku", schema=F)

# write dataset to a partition of the 'counts' dataset
df = data.frame(x=c(1,2,3,4))
dkuWriteDataset(df, "counts", partition="2015-01-01")
}
}
