(function() {
    "use strict";

    function aiDatasetDescriptionsModalController(
        $scope,
        $rootScope,
        AIExplanationService,
        translate
    ) {
        $scope.init = function (object, canWriteProjectFn) {
            $scope.object = object
            $scope.canWriteProject = canWriteProjectFn
            this.appConfig = $rootScope.appConfig;
        };

        $scope.modalTitle = function() {
            if (!$scope.object || $scope.object.name === undefined){
                return "";
            }
            let translationTag = "MODALS.GENERATE_METADATA.TITLE_EDIT"
            let modalTitleStart = 'Edit metadata for "'

            if (this.appConfig.prepareAICompletionEnabled ) {
                translationTag = "MODALS.GENERATE_METADATA.TITLE_GENERATE"
                modalTitleStart = 'Generate metadata for "'
            }

            return translate(
                translationTag,
                modalTitleStart + $scope.object.name + '"',
                { name: $scope.object.name }
            );
        };
        
        $scope.canCloseModal = function() {
            if (!$scope.explanationRequested) {
                return true;
            }
            if (!$scope.abortRequested) {
                AIExplanationService.abortExplain($scope.lastJobId).catch(function(r) {
                    setErrorInScope.bind($rootScope)(r.data, r.status, r.headers);
                });
                $scope.abortRequested = true;
                $scope.explanationRequested = false;
            }
            return true;
        };
    }

    angular.module("dataiku.aiDatasetDescriptions")
        .controller("AIDatasetDescriptionsModalController", aiDatasetDescriptionsModalController);
})();
