(function() {
'use strict';

const app = angular.module('dataiku.deployer');

app.controller('GovernanceAbstractDeployerModalController', function($scope, DataikuAPI) {
    $scope.governanceMessages = {};
    $scope.governanceStatusLoaded = false;
    $scope.publishedItemId = null;
    $scope.infraId = null;
    $scope.packageId = null;
    $scope.deploymentId = null;
    $scope.deployment = null;
    $scope.ignoreWarnings = false;
    $scope.hasErrors = true;

    $scope.confirm = function() {
        $scope.resolveModal();
    };

    $scope.setIgnoreWarnings = function(value) {
        // I don't know why I need to do that ng-change trick,
        // but the model was not updating itself so this is the only way
        // I found.
        $scope.ignoreWarnings = value;
    };
    
    $scope.cancel = function() {
        $scope.dismiss();
    };

    function callGovernanceStatusApi($scope, deployerType) {
        if (deployerType == 'apiDeployer') {
            if ($scope.publishedItemId && $scope.infraId) {
                return DataikuAPI.apideployer.deployments.getGovernanceStatusNewDeployment($scope.publishedItemId, $scope.infraId, $scope.packageId);
            } else if ($scope.deployment) {
                return DataikuAPI.apideployer.deployments.getGovernanceStatusDeployment($scope.deployment);
            } else {
                return DataikuAPI.apideployer.deployments.getGovernanceStatusDeploymentId($scope.deploymentId, $scope.infraId, $scope.packageId);
            }
        }
        else if (deployerType == 'projectDeployer') {
            if ($scope.publishedItemId && $scope.infraId) {
                return DataikuAPI.projectdeployer.deployments.getGovernanceStatusNewDeployment($scope.publishedItemId, $scope.infraId, $scope.packageId);
            } else if ($scope.deployment) {
                return DataikuAPI.projectdeployer.deployments.getGovernanceStatusDeployment($scope.deployment);
            } else {
                return DataikuAPI.projectdeployer.deployments.getGovernanceStatusDeploymentId($scope.deploymentId, $scope.infraId, $scope.packageId);
            }
        }
    }

    $scope.refreshGovernanceStatuses = function(deployerType) {
        $scope.governanceMessages = {};
        $scope.governanceStatusLoaded = false;
        callGovernanceStatusApi($scope, deployerType)
            .success(governanceMessages => {
                $scope.governanceStatusLoaded = true;
                $scope.governanceMessages = governanceMessages;
                $scope.hasErrors = governanceMessages.error;
                if (!governanceMessages.error && !governanceMessages.warning) {
                    $scope.confirm();
                    return;
                }
            })
            .error(setErrorInScope.bind($scope));
    };
});
})();