(function(){
    'use strict';

    const app = angular.module('dataiku.charts');

    /**
     * (!) This directive previously was in static/dataiku/js/simple_report/chart_dragdrop.js
     */
    app.directive('chartDragCopySource', () => {
        return {
            controller: 'ChartDragDropController',
            link : function($scope, element, attrs) {

                const el = element[0];

                $scope.$watch(attrs.chartDragDisable, function(nv) {
                    element[0].draggable = nv !== true;
                });

                el.addEventListener('dragstart', function(e) {
                    $scope.$apply(function() {
                        $scope.activeDragDrop.active = true;
                        $scope.setDragActive();
                        $scope.activeDragDrop.data = $scope.$eval(attrs.chartDragCopySource);
                    });
                    e.dataTransfer.effectAllowed = 'copy';
                    e.dataTransfer.setData(window.dkuDragType, JSON.stringify($scope.activeDragDrop.data));
                    // FIXME highlight droppable
                    this.classList.add('dragging');
                    return false;
                }, false);

                el.addEventListener('dragend', function(e) {
                    this.classList.remove('dragging');
                    return false;
                }, false);
            }
        };
    });
})();
