from dataiku.base.folder_context import build_folder_context

"""
Utility functions for interactive computations.
"""


def patch_image_folder_for_evaluation(core_params, split_folder):
    """
    Patches core_params to use the evaluation's image folder, not the model's.

    :param core_params: Core parameters
    :type core_params: dict
    :param split_folder: Path to the split folder
    :type split_folder: str
    :raises ValueError: raise if it has model with image but not image attribute in the evaluation
    """
    split_folder_context = build_folder_context(split_folder)
    is_evaluation = split_folder_context.isfile("evaluation.json")
    has_model_with_images = core_params.get("managedFolderSmartId")
    if not is_evaluation or not has_model_with_images:
        return

    folder_id = split_folder_context.read_json("evaluation.json").get("managedFolderSmartId")
    if folder_id:
        core_params["managedFolderSmartId"] = folder_id
    else:
        raise ValueError(
            "Configuration Error: Older evaluations do not support image features for interactive computation. "
            "Please create a new evaluation."
        )


def is_evaluation_with_images(split_folder, core_params):
    """
    :param split_folder: Path to the split folder.
    :type split_folder: str
    :param core_params: Core parameters.
    :type core_params: dict
    :rtype: bool
    """
    split_folder_context = build_folder_context(split_folder)
    is_evaluation = split_folder_context.isfile("evaluation.json")
    has_model_with_images = core_params.get("managedFolderSmartId")
    return is_evaluation and has_model_with_images
