/*
 * Decompiled with CFR 0.152.
 */
package com.dataiku.dip.geoadmin;

import com.dataiku.dip.ProcessorWithResourceFiles;
import com.dataiku.dip.data.geo.AdminGeoDataUtils;
import com.dataiku.dip.datalayer.Column;
import com.dataiku.dip.datalayer.Processor;
import com.dataiku.dip.datalayer.Row;
import com.dataiku.dip.datalayer.SingleRowProcessor;
import com.dataiku.dip.pivot.backend.dss.maps.LinoPointAdminAxisHandler;
import com.dataiku.dip.plugins.IPluginsRegistryService;
import com.dataiku.dip.server.SpringUtils;
import com.dataiku.dip.shaker.model.StepParams;
import com.dataiku.dip.shaker.processors.Category;
import com.dataiku.dip.shaker.processors.ProcessorMeta;
import com.dataiku.dip.shaker.processors.ProcessorTag;
import com.dataiku.dip.shaker.server.ProcessorDesc;
import com.dataiku.dip.shaker.types.GeoPoint;
import com.dataiku.dip.shaker.types.GeometryMeaning;
import com.google.common.collect.Sets;
import java.io.File;
import java.util.ArrayList;
import java.util.HashMap;
import java.util.List;
import java.util.Map;
import java.util.Optional;
import java.util.Set;
import org.apache.avro.generic.GenericRecord;
import org.apache.commons.lang.StringUtils;
import org.apache.log4j.Logger;
import org.geotools.data.DataStore;
import org.locationtech.jts.geom.Envelope;
import org.locationtech.jts.geom.Geometry;
import org.locationtech.jts.geom.MultiPolygon;
import org.locationtech.jts.index.SpatialIndex;
import org.locationtech.jts.index.strtree.STRtree;
import org.opengis.feature.simple.SimpleFeature;

public class CityLevelReverseGeocoder
extends SingleRowProcessor
implements Processor,
ProcessorWithResourceFiles {
    static final int COUNTRY_LEVEL = 2;
    static final int CITY_LEVEL = 8;
    static final String ENGLISH_NAME_SUFFIX = "_enName";
    static final String ISO_CODE_SUFFIX = "_iso";
    static final String GEOM_COLUMN_SUFFIX = "_geom";
    private Optional<Integer> administrativeBoundariesToDisplay;
    public static final ProcessorMeta<CityLevelReverseGeocoder, Parameter> META = new ProcessorMeta<CityLevelReverseGeocoder, Parameter>(){

        public String getName() {
            return "CityLevelReverseGeocoder";
        }

        public Category getCategory() {
            return Category.GEOGRAPHIC;
        }

        public Set<ProcessorTag> getTags() {
            return Sets.newHashSet((Object[])new ProcessorTag[]{ProcessorTag.GEOGRAPHIC, ProcessorTag.ENRICH});
        }

        public String getHelp() {
            return "This processor performs a reverse-geocoding (latitude / longitude -> address) and retrieves administrative boundaries.\n\nOutput is provided at a city-level resolution, ie: it resolves the country, region, and city, but not street addresses.\n\nWith the option 'Output the smallest selected administrative area', retrieve the polygon of the most local selected level.\n\n# Administrative levels\n\nThe processor is based on administrative levels defined by the <a href='https://wiki.openstreetmap.org/wiki/Tag:boundary%3Dadministrative#admin_level'>OpenStreetMap project:</a> 7 levels (from 2 to 8) are provided. The exact definition of each level depends on the country, but generally speaking the following are true:\n\n* Level 2: country\n* Level 4: state / large region\n* Level 6: county / departement / small region\n* Level 8: city\n\n# Coverage\n\nThe processor provides worldwide coverage of countries. The coverage at more detailed levels depends on the country.\n\nDepending on the country, both local name and english names can be available. More details <a href='https://wiki.openstreetmap.org/wiki/Tag:boundary%3Dadministrative#admin_level'>here</a>.";
        }

        public Class<Parameter> stepParamClass() {
            return Parameter.class;
        }

        public ProcessorDesc describe() {
            return ProcessorDesc.withGenericForm((String)this.getName(), (String)"Reverse geocoding").withMNEColParam("inputCol", "Input Column").withParam("l8OutCol", "string", false, true, "Output column for 'level 8' (city)").withParam("l7OutCol", "string", false, true, "Output column for 'level 7' (city)").withParam("l6OutCol", "string", false, true, "Output column for 'level 6' (department)").withParam("l5OutCol", "string", false, true, "Output column for 'level 5' ()").withParam("l4OutCol", "string", false, true, "Output column for 'level 4' (region)").withParam("l3OutCol", "string", false, true, "Output column for 'level 3' (large region)").withParam("l2OutCol", "string", false, true, "Output column for 'level 2' (country)").withParam("doOutputBoundaries", "boolean", false, true, "Output polygon coordinates for the smallest selected administrative area");
        }

        public CityLevelReverseGeocoder build(Parameter parameter) throws Exception {
            return new CityLevelReverseGeocoder(parameter);
        }
    };
    final Parameter parameter;
    private Column inputGeopointColumn;
    private List<Column> outputColumnPerLevel = new ArrayList<Column>();
    private static Map<Integer, GeoLookup> lookupPerLevel = new HashMap<Integer, GeoLookup>();
    GeometryMeaning geomMeaning = new GeometryMeaning();
    private static Logger logger = Logger.getLogger((String)"dku.shaker.geo");
    File resourceFolder;

    public CityLevelReverseGeocoder(Parameter parameter) {
        this.parameter = parameter;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    private static GeoLookup buildAdministrativeLevelLookup(File resourceFolder, int level) throws Exception {
        Class<LinoPointAdminAxisHandler> clazz = LinoPointAdminAxisHandler.class;
        synchronized (LinoPointAdminAxisHandler.class) {
            if (lookupPerLevel.get(level) != null) {
                // ** MonitorExit[var2_2] (shouldn't be in output)
                return lookupPerLevel.get(level);
            }
            GeoLookup ret = CityLevelReverseGeocoder.readLookup(resourceFolder, level);
            lookupPerLevel.put(level, ret);
            // ** MonitorExit[var2_2] (shouldn't be in output)
            return ret;
        }
    }

    public void init() throws Exception {
        int administrativeLevel;
        this.inputGeopointColumn = this.cf.column(this.parameter.inputCol, Processor.ProcessorRole.INPUT_COLUMN);
        this.outputColumnPerLevel.add(null);
        this.outputColumnPerLevel.add(null);
        String[] outputColumnName = new String[]{"", "", this.parameter.l2OutCol, this.parameter.l3OutCol, this.parameter.l4OutCol, this.parameter.l5OutCol, this.parameter.l6OutCol, this.parameter.l7OutCol, this.parameter.l8OutCol};
        for (administrativeLevel = 2; administrativeLevel <= 8; ++administrativeLevel) {
            if (!StringUtils.isBlank((String)outputColumnName[administrativeLevel])) {
                this.cf.columnAfter(this.parameter.inputCol, outputColumnName[administrativeLevel] + ENGLISH_NAME_SUFFIX, Processor.ProcessorRole.OUTPUT_COLUMN);
                this.outputColumnPerLevel.add(this.cf.columnAfter(this.parameter.inputCol, outputColumnName[administrativeLevel], Processor.ProcessorRole.OUTPUT_COLUMN));
                if (administrativeLevel != 2) continue;
                this.cf.columnAfter(this.parameter.inputCol, outputColumnName[administrativeLevel] + ISO_CODE_SUFFIX, Processor.ProcessorRole.OUTPUT_COLUMN);
                continue;
            }
            this.outputColumnPerLevel.add(null);
        }
        if (this.parameter.doOutputBoundaries) {
            this.administrativeBoundariesToDisplay = this.getSmallestSelectedArea();
            if (this.administrativeBoundariesToDisplay.isPresent()) {
                this.cf.columnAfter(outputColumnName[this.administrativeBoundariesToDisplay.get()] + ENGLISH_NAME_SUFFIX, outputColumnName[this.administrativeBoundariesToDisplay.get()] + GEOM_COLUMN_SUFFIX, Processor.ProcessorRole.OUTPUT_COLUMN);
            }
        } else {
            this.administrativeBoundariesToDisplay = Optional.empty();
        }
        for (administrativeLevel = 2; administrativeLevel <= 8; ++administrativeLevel) {
            if (this.outputColumnPerLevel.get(administrativeLevel) == null) continue;
            CityLevelReverseGeocoder.buildAdministrativeLevelLookup(this.resourceFolder, administrativeLevel);
        }
    }

    private Optional<Integer> getSmallestSelectedArea() {
        for (int administrativeLevel = 8; administrativeLevel >= 2; --administrativeLevel) {
            if (this.outputColumnPerLevel.get(administrativeLevel) == null) continue;
            return Optional.of(administrativeLevel);
        }
        return Optional.empty();
    }

    public void processRow(Row rowToProcess) throws Exception {
        String inputValue = rowToProcess.get(this.inputGeopointColumn);
        if (StringUtils.isBlank((String)inputValue)) {
            logger.info((Object)"nodata");
            return;
        }
        try {
            Geometry inputGeopoint = this.geomMeaning.toGeometry(inputValue);
            if (inputGeopoint == null && (inputGeopoint = new GeoPoint().toGeometry(inputValue)) == null) {
                return;
            }
            for (int administrativeLevel = 2; administrativeLevel <= 8; ++administrativeLevel) {
                boolean hasFoundGeom = false;
                if (this.outputColumnPerLevel.get(administrativeLevel) == null) continue;
                Envelope geomEnv = inputGeopoint.getEnvelopeInternal();
                List matchingEnvelopes = CityLevelReverseGeocoder.lookupPerLevel.get((Object)Integer.valueOf((int)administrativeLevel)).tree.query(geomEnv);
                for (Object matchingEnvelope : matchingEnvelopes) {
                    RowData matchingObject = (RowData)((Object)matchingEnvelope);
                    boolean isWithin = false;
                    try {
                        isWithin = AdminGeoDataUtils.contains((AdminGeoDataUtils.TreeLeafBase)matchingObject, (Geometry)inputGeopoint);
                    }
                    catch (Exception e) {
                        logger.warn((Object)("Error intersecting with " + matchingObject.dataIndex + "  level " + administrativeLevel), (Throwable)e);
                    }
                    if (!isWithin) continue;
                    hasFoundGeom = true;
                    GenericRecord record = CityLevelReverseGeocoder.lookupPerLevel.get((Object)Integer.valueOf((int)administrativeLevel)).data.get(matchingObject.dataIndex);
                    rowToProcess.put(this.outputColumnPerLevel.get(administrativeLevel), record.get("localName").toString());
                    rowToProcess.put(this.cf.column(this.outputColumnPerLevel.get(administrativeLevel).getName() + ENGLISH_NAME_SUFFIX, Processor.ProcessorRole.OUTPUT_COLUMN), record.get("enName").toString());
                    if (administrativeLevel == 2) {
                        rowToProcess.put(this.cf.column(this.outputColumnPerLevel.get(administrativeLevel).getName() + ISO_CODE_SUFFIX, Processor.ProcessorRole.OUTPUT_COLUMN), record.get("isoCode").toString());
                    }
                    if (!this.administrativeBoundariesToDisplay.isPresent() || administrativeLevel != this.administrativeBoundariesToDisplay.get()) continue;
                    rowToProcess.put(this.cf.column(this.outputColumnPerLevel.get(administrativeLevel).getName() + GEOM_COLUMN_SUFFIX, Processor.ProcessorRole.OUTPUT_COLUMN), matchingObject.geom.toText());
                }
                if (hasFoundGeom || !this.administrativeBoundariesToDisplay.isPresent() || administrativeLevel != this.administrativeBoundariesToDisplay.get()) continue;
                rowToProcess.put(this.cf.column(this.outputColumnPerLevel.get(administrativeLevel).getName() + GEOM_COLUMN_SUFFIX, Processor.ProcessorRole.OUTPUT_COLUMN), "");
            }
        }
        catch (Exception e) {
            logger.warn((Object)"Failed to process", (Throwable)e);
        }
    }

    public void postProcess() {
    }

    public Map<String, File> gatherRequirements() {
        HashMap<String, File> ret = new HashMap<String, File>();
        IPluginsRegistryService ps = (IPluginsRegistryService)SpringUtils.getBean(IPluginsRegistryService.class);
        ret.put("dku.citygeocoder.resource", ps.getPluginResourceFolder("geoadmin"));
        return ret;
    }

    public void setRequiredFiles(Map<String, File> requiredFiles) {
        this.resourceFolder = requiredFiles.get("dku.citygeocoder.resource");
        logger.info((Object)("Geocoder: Set required folder " + this.resourceFolder));
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     * Unable to fully structure code
     */
    private static GeoLookup readLookup(File resourceFolder, int administrativeLevel) throws Exception {
        lookup = new GeoLookup();
        tree = new STRtree();
        CityLevelReverseGeocoder.logger.info((Object)"  Read data");
        lookup.data = AdminGeoDataUtils.getData((File)resourceFolder, (int)administrativeLevel).data;
        CityLevelReverseGeocoder.logger.info((Object)"  Read geo");
        dataStore = AdminGeoDataUtils.getDataStore((File)resourceFolder, (int)administrativeLevel);
        try {
            rowNumber = 0;
            treeNodesNumber = 0;
            source = AdminGeoDataUtils.getSource((DataStore)dataStore);
            featuresIterator = source.getFeatures().features();
            var9_9 = null;
lbl13:
            // 2 sources

            try {
                while (featuresIterator.hasNext()) {
                    block20: {
                        block21: {
                            feature = (SimpleFeature)featuresIterator.next();
                            ++rowNumber;
                            rowData = new RowData();
                            AdminGeoDataUtils.fillLeaf((SimpleFeature)feature, (AdminGeoDataUtils.TreeLeafBase)rowData);
                            if (rowData.geom == null) break block20;
                            if (administrativeLevel != 2 || !(rowData.geom instanceof MultiPolygon)) break block21;
                            countryPolygons = (MultiPolygon)rowData.geom;
                            CityLevelReverseGeocoder.logger.info((Object)("MULTI COUNTRY " + rowData.dataIndex + " with " + countryPolygons.getNumGeometries() + " geoms"));
                            for (countryPolygonNumber = 0; countryPolygonNumber < countryPolygons.getNumGeometries(); ++countryPolygonNumber) {
                                tree.insert(countryPolygons.getGeometryN(countryPolygonNumber).getEnvelopeInternal(), (Object)rowData);
                                ++treeNodesNumber;
                            }
                            ** GOTO lbl13
                        }
                        tree.insert(rowData.geom.getEnvelopeInternal(), (Object)rowData);
                        ++treeNodesNumber;
                        continue;
                    }
                    CityLevelReverseGeocoder.logger.warn((Object)"null geom !");
                }
            }
            catch (Throwable var10_12) {
                var9_9 = var10_12;
                throw var10_12;
            }
            finally {
                if (featuresIterator != null) {
                    if (var9_9 != null) {
                        try {
                            featuresIterator.close();
                        }
                        catch (Throwable var10_11) {
                            var9_9.addSuppressed(var10_11);
                        }
                    } else {
                        featuresIterator.close();
                    }
                }
            }
            CityLevelReverseGeocoder.logger.info((Object)(" Created " + rowNumber + " RowData and " + treeNodesNumber + " tree nodes"));
        }
        finally {
            if (dataStore != null) {
                dataStore.dispose();
            }
        }
        tree.build();
        lookup.tree = tree;
        return lookup;
    }

    static class GeoLookup {
        SpatialIndex tree;
        Map<Integer, GenericRecord> data = new HashMap<Integer, GenericRecord>();

        GeoLookup() {
        }
    }

    static class RowData
    extends AdminGeoDataUtils.TreeLeafBase {
        RowData() {
        }
    }

    public static class Parameter
    implements StepParams {
        private static final long serialVersionUID = -1L;
        String inputCol;
        String l8OutCol;
        String l7OutCol;
        String l6OutCol;
        String l5OutCol;
        String l4OutCol;
        String l3OutCol;
        String l2OutCol;
        boolean doOutputBoundaries = false;

        public void validate() {
        }
    }
}

