/*
 * Decompiled with CFR 0.152.
 */
package com.dataiku.dss.legacy.aws.com.amazonaws.services.ec2.model.transform;

import com.dataiku.dss.legacy.aws.com.amazonaws.DefaultRequest;
import com.dataiku.dss.legacy.aws.com.amazonaws.Request;
import com.dataiku.dss.legacy.aws.com.amazonaws.SdkClientException;
import com.dataiku.dss.legacy.aws.com.amazonaws.http.HttpMethodName;
import com.dataiku.dss.legacy.aws.com.amazonaws.services.ec2.model.ModifyVerifiedAccessInstanceLoggingConfigurationRequest;
import com.dataiku.dss.legacy.aws.com.amazonaws.services.ec2.model.VerifiedAccessLogCloudWatchLogsDestinationOptions;
import com.dataiku.dss.legacy.aws.com.amazonaws.services.ec2.model.VerifiedAccessLogKinesisDataFirehoseDestinationOptions;
import com.dataiku.dss.legacy.aws.com.amazonaws.services.ec2.model.VerifiedAccessLogOptions;
import com.dataiku.dss.legacy.aws.com.amazonaws.services.ec2.model.VerifiedAccessLogS3DestinationOptions;
import com.dataiku.dss.legacy.aws.com.amazonaws.transform.Marshaller;
import com.dataiku.dss.legacy.aws.com.amazonaws.util.IdempotentUtils;
import com.dataiku.dss.legacy.aws.com.amazonaws.util.StringUtils;

public class ModifyVerifiedAccessInstanceLoggingConfigurationRequestMarshaller
implements Marshaller<Request<ModifyVerifiedAccessInstanceLoggingConfigurationRequest>, ModifyVerifiedAccessInstanceLoggingConfigurationRequest> {
    @Override
    public Request<ModifyVerifiedAccessInstanceLoggingConfigurationRequest> marshall(ModifyVerifiedAccessInstanceLoggingConfigurationRequest modifyVerifiedAccessInstanceLoggingConfigurationRequest) {
        VerifiedAccessLogOptions accessLogs;
        if (modifyVerifiedAccessInstanceLoggingConfigurationRequest == null) {
            throw new SdkClientException("Invalid argument passed to marshall(...)");
        }
        DefaultRequest<ModifyVerifiedAccessInstanceLoggingConfigurationRequest> request = new DefaultRequest<ModifyVerifiedAccessInstanceLoggingConfigurationRequest>(modifyVerifiedAccessInstanceLoggingConfigurationRequest, "AmazonEC2");
        request.addParameter("Action", "ModifyVerifiedAccessInstanceLoggingConfiguration");
        request.addParameter("Version", "2016-11-15");
        request.setHttpMethod(HttpMethodName.POST);
        if (modifyVerifiedAccessInstanceLoggingConfigurationRequest.getVerifiedAccessInstanceId() != null) {
            request.addParameter("VerifiedAccessInstanceId", StringUtils.fromString(modifyVerifiedAccessInstanceLoggingConfigurationRequest.getVerifiedAccessInstanceId()));
        }
        if ((accessLogs = modifyVerifiedAccessInstanceLoggingConfigurationRequest.getAccessLogs()) != null) {
            VerifiedAccessLogKinesisDataFirehoseDestinationOptions kinesisDataFirehose;
            VerifiedAccessLogCloudWatchLogsDestinationOptions cloudWatchLogs;
            VerifiedAccessLogS3DestinationOptions s3 = accessLogs.getS3();
            if (s3 != null) {
                if (s3.getEnabled() != null) {
                    request.addParameter("AccessLogs.S3.Enabled", StringUtils.fromBoolean(s3.getEnabled()));
                }
                if (s3.getBucketName() != null) {
                    request.addParameter("AccessLogs.S3.BucketName", StringUtils.fromString(s3.getBucketName()));
                }
                if (s3.getPrefix() != null) {
                    request.addParameter("AccessLogs.S3.Prefix", StringUtils.fromString(s3.getPrefix()));
                }
                if (s3.getBucketOwner() != null) {
                    request.addParameter("AccessLogs.S3.BucketOwner", StringUtils.fromString(s3.getBucketOwner()));
                }
            }
            if ((cloudWatchLogs = accessLogs.getCloudWatchLogs()) != null) {
                if (cloudWatchLogs.getEnabled() != null) {
                    request.addParameter("AccessLogs.CloudWatchLogs.Enabled", StringUtils.fromBoolean(cloudWatchLogs.getEnabled()));
                }
                if (cloudWatchLogs.getLogGroup() != null) {
                    request.addParameter("AccessLogs.CloudWatchLogs.LogGroup", StringUtils.fromString(cloudWatchLogs.getLogGroup()));
                }
            }
            if ((kinesisDataFirehose = accessLogs.getKinesisDataFirehose()) != null) {
                if (kinesisDataFirehose.getEnabled() != null) {
                    request.addParameter("AccessLogs.KinesisDataFirehose.Enabled", StringUtils.fromBoolean(kinesisDataFirehose.getEnabled()));
                }
                if (kinesisDataFirehose.getDeliveryStream() != null) {
                    request.addParameter("AccessLogs.KinesisDataFirehose.DeliveryStream", StringUtils.fromString(kinesisDataFirehose.getDeliveryStream()));
                }
            }
            if (accessLogs.getLogVersion() != null) {
                request.addParameter("AccessLogs.LogVersion", StringUtils.fromString(accessLogs.getLogVersion()));
            }
            if (accessLogs.getIncludeTrustContext() != null) {
                request.addParameter("AccessLogs.IncludeTrustContext", StringUtils.fromBoolean(accessLogs.getIncludeTrustContext()));
            }
        }
        request.addParameter("ClientToken", IdempotentUtils.resolveString(modifyVerifiedAccessInstanceLoggingConfigurationRequest.getClientToken()));
        return request;
    }
}

