/*
 * Decompiled with CFR 0.152.
 */
package com.dataiku.dip.activity.filterutils;

import com.dataiku.dip.dataflow.exec.filter.FilterDesc;
import java.util.HashSet;
import java.util.Set;

public class FilterAnalyzer {
    private FilterAnalyzer() {
    }

    public static FilterSummary analyzeFilter(FilterDesc filter) {
        if (filter == null) {
            return null;
        }
        if (filter.uiData == null || filter.uiData.mode == null) {
            return null;
        }
        FilterSummary filterSummary = new FilterSummary();
        filterSummary.mode = filter.uiData.mode;
        if ("&&".equals(filterSummary.mode) || "||".equals(filterSummary.mode)) {
            FilterAnalyzer.visitFilterNode(filter, filterSummary, 1, new HashSet<FilterDesc>());
        }
        return filterSummary;
    }

    private static void visitFilterNode(FilterDesc filter, FilterSummary filterSummary, int currentDepth, Set<FilterDesc> visitedFilters) {
        if (visitedFilters.contains(filter)) {
            return;
        }
        visitedFilters.add(filter);
        if (currentDepth > filterSummary.depth) {
            filterSummary.depth = currentDepth;
        }
        for (FilterDesc.FilterUiCondition condition : filter.uiData.conditions) {
            if (condition == null) continue;
            if (condition.subCondition != null && condition.subCondition.uiData != null) {
                ++filterSummary.nbGroups;
                FilterAnalyzer.visitFilterNode(condition.subCondition, filterSummary, currentDepth + 1, visitedFilters);
                continue;
            }
            ++filterSummary.numberOfConditions;
        }
    }

    public static class FilterSummary {
        public int depth = 1;
        public int numberOfConditions = 0;
        public int nbGroups = 0;
        public String mode;

        public FilterSummary() {
        }

        public FilterSummary(int depth, int numberOfConditions, String mode) {
            this.mode = mode;
            this.depth = depth;
            this.numberOfConditions = numberOfConditions;
            this.nbGroups = depth - 1;
        }
    }
}

