/*
 * Decompiled with CFR 0.152.
 */
package com.dataiku.dip.analysis.coreservices;

import com.dataiku.common.server.SerializedError;
import com.dataiku.dip.analysis.coreservices.IAnalysisMLKernel;
import com.dataiku.dip.analysis.ml.distributed.workers.WorkerPool;
import com.dataiku.dip.analysis.model.core.WorkSet;
import com.dataiku.dip.dao.GeneralSettingsDAO;
import com.dataiku.dip.exceptions.DKUSecurityException;
import com.dataiku.dip.io.AbstractImpersonatedSecretProtectedPythonKernel;
import com.dataiku.dip.io.SingleCommandKernelLink;
import com.dataiku.dip.security.AuthCtx;
import com.dataiku.dip.security.process.IsolableProcess;
import com.dataiku.dip.security.tickets.APITicketService;
import com.dataiku.dip.server.SpringUtils;
import com.dataiku.dip.util.SecretKeyGenerator;
import com.dataiku.dip.utils.DKULogger;
import com.dataiku.dip.utils.DKUtils;
import com.dataiku.dip.utils.JSON;
import com.google.gson.JsonObject;
import java.io.File;
import java.io.FileNotFoundException;
import java.io.FileOutputStream;
import java.io.IOException;
import java.io.PrintWriter;
import java.io.Writer;
import java.util.Collections;
import java.util.Map;
import org.apache.log4j.Level;

public class AnalysisMLKernel
extends AbstractImpersonatedSecretProtectedPythonKernel<SingleCommandKernelLink>
implements IAnalysisMLKernel {
    private final DKUtils.LineSubscription outputLogPlug;
    private final DKUtils.LineSubscription errorLogPlug;
    protected Map<String, String> forcedEnvVars = Collections.emptyMap();
    private String pythonModule = "dataiku.doctor.server";
    protected APITicketService.Ticket ticket;
    protected boolean abort = false;
    protected DKULogger logger = DKULogger.getLogger((String)"dku.ml.kernel");

    public AnalysisMLKernel(SingleCommandKernelLink link, WorkSet.PreprocessingSet pps, String projectKey, String envName, AuthCtx authCtx, File workDir) throws FileNotFoundException {
        this(link, pps, projectKey, envName, authCtx, workDir, null);
    }

    public AnalysisMLKernel(SingleCommandKernelLink link, WorkSet.PreprocessingSet pps, String projectKey, String envName, AuthCtx authCtx, File workDir, WorkerPool workerPool) throws FileNotFoundException {
        super(link, GeneralSettingsDAO.CGrouppableProcessType.ML_KERNEL, authCtx, workDir, null, true, null, projectKey, envName, workerPool);
        this.createTempDirForImpersonation = true;
        if (pps != null) {
            File ppLogFile = new File(pps.run_folder, "train.log");
            this.logger.info((Object)("Writing output of " + this.getId() + " to " + ppLogFile.getAbsolutePath()));
            PrintWriter printWriter = new PrintWriter(new FileOutputStream(ppLogFile, true), true);
            this.outputLogPlug = new DKUtils.OutputWriterSubscription((Writer)printWriter, true);
            this.errorLogPlug = new DKUtils.OutputWriterSubscription((Writer)printWriter, true);
        } else {
            this.outputLogPlug = new DKUtils.LoggingLineSubscription(Level.INFO);
            this.errorLogPlug = new DKUtils.LoggingLineSubscription(Level.INFO);
        }
        SpringUtils.getInstance().autowire((Object)this);
        this.kernelEnvVariables.put("DKU_ENABLE_GLOBAL_EMBEDDING_CACHE", Boolean.toString(true));
    }

    @Override
    protected String getPythonModule() {
        return this.pythonModule;
    }

    @Override
    public void setPythonModule(String pythonModule) {
        this.pythonModule = pythonModule;
    }

    protected void createTicket(String identifier) {
        final APITicketService ticketService = (APITicketService)SpringUtils.getBean(APITicketService.class);
        this.ticket = ticketService.createTicket(this.authCtx, "analysis-ml-" + this.projectKey + "-" + identifier, null);
        this.addOnShutdown(new Runnable(){

            @Override
            public void run() {
                ticketService.expireTicket(AnalysisMLKernel.this.ticket);
            }
        });
    }

    @Override
    protected IsolableProcess createAndStartProcess(ProcessBuilder pb, GeneralSettingsDAO.CGrouppableProcessType cgrouppableProcessType) throws DKUSecurityException, IOException, InterruptedException {
        this.createTicket(SecretKeyGenerator.generateSmall());
        pb.environment().put("DKU_API_TICKET", this.ticket.getSecret());
        pb.environment().putAll(this.forcedEnvVars);
        return super.createAndStartProcess(pb, cgrouppableProcessType);
    }

    @Override
    public void forceEnvVars(Map<String, String> envVars) {
        this.forcedEnvVars = envVars;
    }

    protected void startStandardTailers() throws IOException {
        this.outputConsumer.withOutputConsumer((DKUtils.ExecSubscription)new DKUtils.TailerLineSubscription(this.smartLogTailBuilder));
        this.outputConsumer.withErrorConsumer((DKUtils.ExecSubscription)new DKUtils.TailerLineSubscription(this.smartLogTailBuilder));
        this.outputConsumer.withOutputConsumer((DKUtils.ExecSubscription)this.outputLogPlug);
        this.outputConsumer.withErrorConsumer((DKUtils.ExecSubscription)this.errorLogPlug);
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Override
    public void abort() throws IOException, InterruptedException {
        this.logger.info((Object)"Aborting kernel");
        AnalysisMLKernel analysisMLKernel = this;
        synchronized (analysisMLKernel) {
            this.abort = true;
        }
        this.killWithoutMercy();
    }

    @Override
    public synchronized boolean isAborted() {
        return this.abort;
    }

    @Override
    public void waitForResults() throws Exception {
    }

    @Override
    public SerializedError waitForError() throws Exception {
        return null;
    }

    @Override
    public void cleanup() throws Exception {
    }

    @Override
    public void registerOnShutDownRunnable(Runnable runnable) {
        this.addOnShutdown(runnable);
    }

    public static class ComputeRequest {
        public final String command;
        public final String arg;

        public ComputeRequest(String command, String arg) {
            this.command = command;
            this.arg = arg;
        }

        public ComputeRequest(String command, JsonObject arg) {
            this(command, JSON.pretty((Object)arg));
        }
    }
}

