/*
 * Decompiled with CFR 0.152.
 */
package com.dataiku.dip.analysis.docgen.helpers;

import com.dataiku.dip.analysis.model.preprocessing.CatFeaturePreprocessingParams;
import com.dataiku.dip.analysis.model.preprocessing.FeaturePreprocessingParams;
import com.dataiku.dip.analysis.model.preprocessing.ImageFeaturePreprocessingParams;
import com.dataiku.dip.analysis.model.preprocessing.NumFeaturePreprocessingParams;
import com.dataiku.dip.analysis.model.preprocessing.TextFeaturePreprocessingParams;
import com.dataiku.dip.analysis.model.preprocessing.VectorFeaturePreprocessingParams;
import com.dataiku.scoring.pipelines.DatetimeCyclicalEncoder;
import java.util.Arrays;
import java.util.stream.Collectors;
import org.apache.commons.lang3.StringUtils;
import org.apache.log4j.Logger;

public class FeaturePreprocessingParamsDescriptor {
    private static Logger logger = Logger.getLogger((String)"dku.analysis.docgen");

    private FeaturePreprocessingParamsDescriptor() {
    }

    private static <E extends Enum<E>> String defaultLabel(E enume) {
        return StringUtils.capitalize((String)enume.name().toLowerCase().replace('_', ' '));
    }

    public static String label(FeaturePreprocessingParams.Role role) {
        if (role == FeaturePreprocessingParams.Role.REJECT) {
            return "Rejected";
        }
        return FeaturePreprocessingParamsDescriptor.defaultLabel(role);
    }

    public static String label(FeaturePreprocessingParams.FeatureType type) {
        return FeaturePreprocessingParamsDescriptor.defaultLabel(type);
    }

    public static String label(ImageFeaturePreprocessingParams.ImageHandlingMethod imageHandling) {
        if (ImageFeaturePreprocessingParams.ImageHandlingMethod.CUSTOM.equals((Object)imageHandling) || ImageFeaturePreprocessingParams.ImageHandlingMethod.EMBEDDING_EXTRACTION.equals((Object)imageHandling)) {
            return imageHandling.getDisplayLabel();
        }
        logger.warn((Object)("Unsupported image_handling type : " + String.valueOf((Object)imageHandling)));
        return "";
    }

    public static String label(VectorFeaturePreprocessingParams.VectorHandlingMethod vectorHandling) {
        if (VectorFeaturePreprocessingParams.VectorHandlingMethod.UNFOLD.equals((Object)vectorHandling)) {
            return "Unfolding";
        }
        logger.warn((Object)("Unsupported vector_handling type : " + String.valueOf((Object)vectorHandling)));
        return "";
    }

    public static String label(TextFeaturePreprocessingParams.TextHandlingMethod textHandling) {
        switch (textHandling) {
            case TOKENIZE_HASHING: {
                return "Term hashing";
            }
            case TOKENIZE_HASHING_SVD: {
                return "Term hashing + SVD";
            }
            case TOKENIZE_COUNTS: {
                return "Count vectorization";
            }
            case TOKENIZE_TFIDF: {
                return "TF/IDF vectorization";
            }
            case SENTENCE_EMBEDDING: {
                return "Text embedding";
            }
            case CUSTOM: {
                return "Custom";
            }
        }
        logger.warn((Object)("Unsupported text_handling type : " + String.valueOf((Object)textHandling)));
        return "";
    }

    public static String label(NumFeaturePreprocessingParams.RescalingMethod rescaling) {
        switch (rescaling) {
            case AVGSTD: {
                return "Avg-std rescaling";
            }
            case MINMAX: {
                return "Min-max rescaling";
            }
            case NONE: {
                return "No rescaling";
            }
        }
        logger.warn((Object)("Unsupported rescaling type : " + String.valueOf((Object)rescaling)));
        return "";
    }

    public static String label(NumFeaturePreprocessingParams num) {
        Object ret = "";
        switch (num.numerical_handling) {
            case REGULAR: {
                ret = FeaturePreprocessingParamsDescriptor.label(num.rescaling);
                break;
            }
            case FLAG_PRESENCE: {
                ret = "Presence flag";
                break;
            }
            case BINARIZE: {
                ret = "Binarization";
                if (!num.keep_regular) break;
                ret = (String)ret + " and use regular (" + FeaturePreprocessingParamsDescriptor.label(num.rescaling).toLowerCase() + ")";
                break;
            }
            case CUSTOM: {
                ret = "Custom";
                break;
            }
            case QUANTILE_BIN: {
                ret = "Quantization in " + num.quantile_bin_nb_bins + " quantiles";
                if (!num.keep_regular) break;
                ret = (String)ret + " and use regular (" + FeaturePreprocessingParamsDescriptor.label(num.rescaling).toLowerCase() + ")";
                break;
            }
            case DATETIME_CYCLICAL: {
                ret = "Cyclical datetime encoding: ";
                ret = (String)ret + Arrays.stream(DatetimeCyclicalEncoder.Period.values()).filter(p -> num.datetime_cyclical_periods.contains(p)).map(p -> p.name().toLowerCase()).collect(Collectors.joining(", "));
                if (!num.keep_regular) break;
                ret = (String)ret + " and use regular (" + FeaturePreprocessingParamsDescriptor.label(num.rescaling).toLowerCase() + ")";
                break;
            }
            default: {
                logger.warn((Object)("Unsupported numerical_handling type : " + String.valueOf((Object)num.numerical_handling)));
            }
        }
        return ret;
    }

    public static String label(CatFeaturePreprocessingParams cat) {
        if (cat.category_handling == null) {
            return "No handling";
        }
        switch (cat.category_handling) {
            case NONE: {
                return "No handling";
            }
            case DUMMIFY: {
                return "Dummy encoding";
            }
            case IMPACT: {
                Object ret = "Target encoding:";
                if (cat.impact_method == CatFeaturePreprocessingParams.ImpactMethod.M_ESTIMATOR) {
                    ret = (String)ret + " impact";
                }
                if (cat.impact_method == CatFeaturePreprocessingParams.ImpactMethod.GLMM) {
                    ret = (String)ret + " GLMM";
                }
                if (cat.impact_kfold) {
                    ret = (String)ret + " with " + cat.impact_kfold_k + "-fold";
                }
                if (cat.categorical_rescaling != null && cat.categorical_rescaling != NumFeaturePreprocessingParams.RescalingMethod.NONE) {
                    ret = (String)ret + " (" + FeaturePreprocessingParamsDescriptor.label(cat.categorical_rescaling) + ")";
                }
                return ret;
            }
            case ORDINAL: {
                Object ret = "Ordinal encoding:";
                if (cat.ordinal_order == CatFeaturePreprocessingParams.OrdinalOrder.COUNT) {
                    ret = (String)ret + " row count";
                }
                if (cat.ordinal_order == CatFeaturePreprocessingParams.OrdinalOrder.LEXICOGRAPHIC) {
                    ret = (String)ret + " lexicographic";
                }
                ret = (String)ret + (cat.ordinal_ascending ? " ascending" : " descending");
                return ret;
            }
            case FREQUENCY: {
                Object ret = "Frequency encoding: ";
                ret = (String)ret + (cat.frequency_normalized ? "normalized counts" : "raw counts");
                if (cat.categorical_rescaling != null && cat.categorical_rescaling != NumFeaturePreprocessingParams.RescalingMethod.NONE) {
                    ret = (String)ret + " (" + FeaturePreprocessingParamsDescriptor.label(cat.categorical_rescaling) + ")";
                }
                return ret;
            }
            case FLAG_PRESENCE: {
                return "Presence flag";
            }
            case HASHING: {
                return "Feature hashing";
            }
            case CUSTOM: {
                return "Custom";
            }
        }
        logger.warn((Object)("Unsupported category_handling type : " + String.valueOf((Object)cat.category_handling)));
        return "";
    }

    public static String label(CatFeaturePreprocessingParams.MissingHandlingMethod missingHandling) {
        if (missingHandling == null) {
            logger.warn((Object)("Unsupported missing_handling type : " + String.valueOf((Object)missingHandling)));
            return "";
        }
        switch (missingHandling) {
            case IMPUTE: {
                return "impute missing";
            }
            case DROP_ROW: {
                return "drop missing";
            }
        }
        logger.warn((Object)("Unsupported missing_handling type : " + String.valueOf((Object)missingHandling)));
        return "";
    }
}

