/*
 * Decompiled with CFR 0.152.
 */
package com.dataiku.dip.analysis.ml.clustering.guess;

import com.dataiku.dip.analysis.ml.prediction.guess.IncrementalFeatureGuessHandler;
import com.dataiku.dip.analysis.ml.shared.FeatureGuessUtils;
import com.dataiku.dip.analysis.ml.shared.Guesser;
import com.dataiku.dip.analysis.model.ClusteringModelingParams;
import com.dataiku.dip.analysis.model.GuessStatus;
import com.dataiku.dip.analysis.model.clustering.ClusteringMLTask;
import com.dataiku.dip.analysis.model.preprocessing.ClusteringPreprocessingParams;
import com.dataiku.dip.analysis.model.preprocessing.FeaturePreprocessingParams;
import com.dataiku.dip.datalayer.memimpl.MemColumn;
import com.dataiku.dip.datalayer.memimpl.MemTable;
import com.dataiku.dip.datasets.StreamableDatasetSelection;
import com.dataiku.dip.utils.DKULogger;
import java.util.HashMap;
import javax.annotation.Nullable;

public abstract class ClusteringGuesser
extends Guesser<ClusteringMLTask> {
    private static final DKULogger logger = DKULogger.getLogger((String)"dku.analysis");

    public ClusteringGuesser(ClusteringMLTask task, MemTable table) {
        super(task, table);
    }

    @Override
    public void guessAllSettings(boolean throwException) {
        ((ClusteringMLTask)this.task).sampling = new ClusteringMLTask.ClusterSampling();
        switch (((ClusteringMLTask)this.task).backendType) {
            case PY_MEMORY: {
                ((ClusteringMLTask)this.task).sampling.selection = StreamableDatasetSelection.head100K();
                break;
            }
            case H2O: 
            case MLLIB: {
                ((ClusteringMLTask)this.task).sampling.selection = StreamableDatasetSelection.full();
            }
        }
        logger.info((Object)"Guessing algorithms");
        ((ClusteringMLTask)this.task).modeling = this.guessAlgorithms(false);
        ((ClusteringMLTask)this.task).preprocessing = new ClusteringPreprocessingParams();
        ((ClusteringMLTask)this.task).preprocessing.per_feature = new HashMap();
        for (MemColumn column : this.table.columns.values()) {
            logger.info((Object)("Guessing feature " + column.getName()));
            FeaturePreprocessingParams fp = this.guessSingleFeature(column);
            fp.state = new FeaturePreprocessingParams.FeatureState();
            fp.state.recordedMeaning = column.selectedType.type.getClass().getSimpleName();
            ((ClusteringMLTask)this.task).preprocessing.per_feature.put(column.getName(), fp);
        }
        this.guessOutliersAndReduction();
    }

    public void reguessAlgorithms() {
        ((ClusteringMLTask)this.task).modeling.disableAll();
        ((ClusteringMLTask)this.task).modeling = this.guessAlgorithms(true);
        this.guessOutliersAndReduction();
    }

    public void guessOutliersAndReduction() {
        if (((ClusteringMLTask)this.task).backendType.isSparkBased()) {
            ((ClusteringMLTask)this.task).preprocessing.outliers.method = ClusteringPreprocessingParams.OutliersHandlingMethod.NONE;
        }
        ((ClusteringMLTask)this.task).preprocessing.reduce.disable = true;
        ((ClusteringMLTask)this.task).preprocessing.reduce.enable = false;
        ((ClusteringMLTask)this.task).preprocessing.outliers.min_n = (int)((double)this.table.nrows() * 0.01);
    }

    @Override
    public void updateGuess(@Nullable GuessStatus previousGuessStatus) {
        IncrementalFeatureGuessHandler incremental = new IncrementalFeatureGuessHandler();
        if (((ClusteringMLTask)this.task).preprocessing != null) {
            incremental.update(this.table, ((ClusteringMLTask)this.task).preprocessing.per_feature, this);
        }
    }

    @Override
    public FeaturePreprocessingParams guessSingleFeature(MemColumn column) {
        return FeatureGuessUtils.guessSingleFeature(this.table, column, this.task);
    }

    public abstract ClusteringModelingParams guessAlgorithms(boolean var1);
}

