/*
 * Decompiled with CFR 0.152.
 */
package com.dataiku.dip.analysis.model.clustering;

import java.util.List;

public class HeatMap {
    public List<String> cluster_labels;
    public List<Long> cluster_sizes;
    public long total_size;
    public List<String> num_names;
    public List<Double> num_averages;
    public List<Double> num_std_devs;
    public List<List<Double>> cluster_num_averages;
    public List<List<Double>> cluster_num_std_devs;
    public List<String> cat_names;
    public List<List<String>> levels;
    public List<List<Double>> proportions;
    public List<List<List<Double>>> cluster_proportions;

    private static boolean isInvalid(Double d) {
        return d == null || d.isNaN() || d.isInfinite();
    }

    public HeatMap normalized() {
        int i;
        for (i = 0; i < this.num_averages.size(); ++i) {
            if (HeatMap.isInvalid(this.num_averages.get(i))) {
                this.num_averages.set(i, 0.0);
            }
            if (HeatMap.isInvalid(this.num_std_devs.get(i))) {
                this.num_std_devs.set(i, 1.0);
            }
            for (int c2 = 0; c2 < this.cluster_labels.size(); ++c2) {
                if (HeatMap.isInvalid(this.cluster_num_averages.get(c2).get(i))) {
                    this.cluster_num_averages.get(c2).set(i, this.num_averages.get(i));
                }
                if (!HeatMap.isInvalid(this.cluster_num_std_devs.get(c2).get(i))) continue;
                this.cluster_num_std_devs.get(c2).set(i, this.num_std_devs.get(i));
            }
        }
        for (i = 0; i < this.cat_names.size(); ++i) {
            for (int lev = 0; lev < this.proportions.get(i).size(); ++lev) {
                if (HeatMap.isInvalid(this.proportions.get(i).get(lev))) {
                    this.proportions.get(i).set(lev, 0.0);
                }
                for (int c3 = 0; c3 < this.cluster_labels.size(); ++c3) {
                    if (!HeatMap.isInvalid(this.cluster_proportions.get(c3).get(i).get(lev))) continue;
                    this.cluster_proportions.get(c3).get(i).set(lev, this.proportions.get(i).get(lev));
                }
            }
        }
        return this;
    }
}

