/*
 * Decompiled with CFR 0.152.
 */
package com.dataiku.dip.apideployer.datamodel.actual.sagemaker;

import com.dataiku.dip.apideployer.datamodel.actual.sagemaker.SageMakerResource;
import com.dataiku.dip.apideployer.datamodel.config.SageMakerAPIDeployment;
import com.dataiku.dip.apideployer.datamodel.config.SageMakerAPIDeploymentInfra;
import com.dataiku.dip.apideployer.deployments.SageMakerDeploymentConfigManager;
import com.dataiku.dip.exceptions.DKUSecurityException;
import com.dataiku.dip.externalinfras.sagemaker.SageMakerUtils;
import com.dataiku.dip.security.AuthCtx;
import com.dataiku.dip.utils.DKULogger;
import com.dataiku.dip.variables.VariablesContext;
import com.dataiku.dss.shadelib.org.apache.commons.lang3.StringUtils;
import com.dataiku.dss.shadelibawssk2.software.amazon.awssdk.core.exception.SdkException;
import com.dataiku.dss.shadelibawssk2.software.amazon.awssdk.services.sagemaker.SageMakerClient;
import com.dataiku.dss.shadelibawssk2.software.amazon.awssdk.services.sagemaker.model.CreateEndpointConfigRequest;
import com.dataiku.dss.shadelibawssk2.software.amazon.awssdk.services.sagemaker.model.DescribeEndpointConfigResponse;
import com.dataiku.dss.shadelibawssk2.software.amazon.awssdk.services.sagemaker.model.ProductionVariant;
import com.dataiku.dss.shadelibawssk2.software.amazon.awssdk.services.sagemaker.model.Tag;
import java.io.IOException;
import java.util.Collection;
import java.util.Optional;
import java.util.stream.Collectors;

public class SageMakerEndpointConfig
extends SageMakerResource<DescribeEndpointConfigResponse> {
    private static final DKULogger logger = DKULogger.getLogger((String)"dku.deployer.deployment.actual.sagemaker.resource-summary");

    public CreateEndpointConfigRequest createCreateEndpointConfigRequest() {
        CreateEndpointConfigRequest.Builder createEndpointConfigRequest = CreateEndpointConfigRequest.builder();
        this.resourceDescription.ifPresent(endpointConfigDescription -> createEndpointConfigRequest.endpointConfigName(this.name).productionVariants((Collection)endpointConfigDescription.productionVariants()).dataCaptureConfig(endpointConfigDescription.dataCaptureConfig()).kmsKeyId(endpointConfigDescription.kmsKeyId()).tags(this.getSageMakerTags()));
        return (CreateEndpointConfigRequest)createEndpointConfigRequest.build();
    }

    public static class SageMakerEndpointConfigBuilder {
        private SageMakerEndpointConfigBuilder() {
        }

        public static SageMakerEndpointConfig buildFromRemoteConfig_NT(SageMakerClient sageMakerClient, String endpointConfigName) {
            SageMakerEndpointConfig sageMakerEndpointConfig = new SageMakerEndpointConfig();
            sageMakerEndpointConfig.name = endpointConfigName;
            sageMakerEndpointConfig.resourceShouldExist = StringUtils.isNotBlank((CharSequence)endpointConfigName);
            if (sageMakerEndpointConfig.resourceShouldExist) {
                try {
                    Optional<DescribeEndpointConfigResponse> deployedEndpointConfigDescription = SageMakerUtils.retrieveCheckEndpointConfig_NT(sageMakerClient, endpointConfigName);
                    if (deployedEndpointConfigDescription.isPresent()) {
                        sageMakerEndpointConfig.resourceDescription = deployedEndpointConfigDescription;
                        sageMakerEndpointConfig.tags = SageMakerUtils.listTags_NT(sageMakerClient, deployedEndpointConfigDescription.get().endpointConfigArn()).stream().collect(Collectors.toMap(Tag::key, Tag::value));
                    } else {
                        logger.warn((Object)String.format("Endpoint Configuration '%s' is not present in SageMaker. Updating the deployment should create it.", endpointConfigName));
                    }
                }
                catch (SdkException e) {
                    logger.errorV("Error while retrieving SageMaker Endpoint Configuration %s.", new Object[]{endpointConfigName});
                    throw e;
                }
            }
            return sageMakerEndpointConfig;
        }

        public static SageMakerEndpointConfig buildFromLocalConfig(AuthCtx authCtx, SageMakerAPIDeployment deployment, SageMakerAPIDeploymentInfra infra, VariablesContext vc, String resourceName, String modelName) throws IOException, DKUSecurityException {
            SageMakerDeploymentConfigManager deploymentConfigManager = new SageMakerDeploymentConfigManager(deployment, infra, vc);
            SageMakerEndpointConfig sageMakerEndpointConfig = new SageMakerEndpointConfig();
            sageMakerEndpointConfig.name = resourceName;
            sageMakerEndpointConfig.isRemote = false;
            sageMakerEndpointConfig.tags = deploymentConfigManager.prepareTags();
            DescribeEndpointConfigResponse.Builder describeEndpointConfigResponse = DescribeEndpointConfigResponse.builder().endpointConfigName(sageMakerEndpointConfig.name).productionVariants(new ProductionVariant[]{deploymentConfigManager.getProductionVariant(modelName)}).dataCaptureConfig(deploymentConfigManager.getDataCaptureConfig(authCtx));
            String kmsKeyId = deploymentConfigManager.getKmsKeyId();
            if (StringUtils.isNotBlank((CharSequence)kmsKeyId)) {
                describeEndpointConfigResponse.kmsKeyId(kmsKeyId);
            }
            sageMakerEndpointConfig.resourceDescription = Optional.of((DescribeEndpointConfigResponse)describeEndpointConfigResponse.build());
            return sageMakerEndpointConfig;
        }
    }
}

