/*
 * Decompiled with CFR 0.152.
 */
package com.dataiku.dip.connections;

import com.dataiku.common.krb.Krb5KeytabLoginContextCache;
import com.dataiku.dip.ApplicationConfigurator;
import com.dataiku.dip.ProxySettings;
import com.dataiku.dip.connections.AbstractSQLConnection;
import com.dataiku.dip.connections.BigQueryConnection;
import com.dataiku.dip.connections.ConnectionUtils;
import com.dataiku.dip.connections.ConnectionsDAO;
import com.dataiku.dip.connections.DatabricksConnection;
import com.dataiku.dip.connections.HiveConnection;
import com.dataiku.dip.connections.ImpalaConnection;
import com.dataiku.dip.connections.SQLConnectionService;
import com.dataiku.dip.connections.SQLConnectionServiceDispatcher;
import com.dataiku.dip.connections.SQLDriverLoader;
import com.dataiku.dip.connections.SnowflakeConnection;
import com.dataiku.dip.connections.TeradataConnection;
import com.dataiku.dip.connections.bigquery.builtin.BigQueryJdbcConnection;
import com.dataiku.dip.connections.bigquery.simba.BigQuerySimbaConnectionWrapper;
import com.dataiku.dip.coremodel.Dataset;
import com.dataiku.dip.coremodel.SerializedDataset;
import com.dataiku.dip.coremodel.SimpleKeyValue;
import com.dataiku.dip.dataflow.jobrunner.JobContext;
import com.dataiku.dip.datasets.DatasetInspector;
import com.dataiku.dip.datasets.sql.AbstractSQLDatasetHandler;
import com.dataiku.dip.datasets.sql.SQLCodes;
import com.dataiku.dip.datasets.sql.SQLExceptionsParser;
import com.dataiku.dip.exceptions.CodedException;
import com.dataiku.dip.exceptions.CodedSQLException;
import com.dataiku.dip.exceptions.DKUSecurityException;
import com.dataiku.dip.exceptions.ICodedException;
import com.dataiku.dip.queries.QueryParams;
import com.dataiku.dip.recipes.code.hive.HiveConfHelper;
import com.dataiku.dip.resourceusage.ComputeResourceUsage;
import com.dataiku.dip.resourceusage.SQLComputeResourceUsage;
import com.dataiku.dip.security.AuthCtx;
import com.dataiku.dip.security.model.ICredentialsService;
import com.dataiku.dip.server.SpringUtils;
import com.dataiku.dip.sql.DriverVersionExtractor;
import com.dataiku.dip.sql.SQLDialect;
import com.dataiku.dip.sql.SQLUtils;
import com.dataiku.dip.sql.bigquery.BigQueryClient;
import com.dataiku.dip.sql.bigquery.BigQueryNativeClient;
import com.dataiku.dip.sql.queries.Splitter;
import com.dataiku.dip.util.SecretKeyGenerator;
import com.dataiku.dip.utils.DKULogger;
import com.dataiku.dip.utils.ErrorContext;
import com.dataiku.dip.utils.JSON;
import com.dataiku.dip.utils.NotImplementedException;
import com.dataiku.dip.variables.VariablesContext;
import com.dataiku.dip.variables.VariablesService;
import com.google.common.collect.Maps;
import java.io.IOException;
import java.net.URISyntaxException;
import java.security.PrivilegedActionException;
import java.security.PrivilegedExceptionAction;
import java.sql.Connection;
import java.sql.DatabaseMetaData;
import java.sql.Driver;
import java.sql.PreparedStatement;
import java.sql.SQLException;
import java.sql.Statement;
import java.util.ArrayList;
import java.util.Arrays;
import java.util.HashMap;
import java.util.List;
import java.util.Map;
import java.util.Properties;
import java.util.stream.Collectors;
import javax.annotation.Nullable;
import javax.security.auth.Subject;
import org.apache.commons.lang.StringUtils;
import org.apache.commons.lang.text.StrSubstitutor;

public class SQLConnectionProvider {
    private static final DKULogger logger = DKULogger.getLogger((String)"dku.connections.sql.provider");

    public static SQLConnectionData getConnectionData_NT(AuthCtx authCtx, SerializedDataset sd) throws IOException, SQLException, DKUSecurityException {
        String connection = ((AbstractSQLDatasetHandler.AbstractSQLConfig)sd.getParams()).connection;
        return SQLConnectionProvider.getConnectionData_NT(authCtx, sd.getProjectKey(), connection);
    }

    public static SQLConnectionData getConnectionData_NT(AuthCtx authCtx, String projectKey, String connectionName) throws IOException, SQLException, DKUSecurityException {
        AbstractSQLConnection conn = SQLConnectionProvider.getDSSConnection(authCtx, connectionName);
        return conn.getConnectionData_NT(authCtx, projectKey);
    }

    public static AbstractSQLConnection getDSSConnection(AuthCtx authCtx, String connectionName) throws IOException, SQLException {
        try {
            return ConnectionsDAO.get().getMandatoryConnectionAs(authCtx, connectionName, AbstractSQLConnection.class);
        }
        catch (DKUSecurityException e) {
            throw new CodedSQLException(SQLCodes.ERR_SQL_INVALID_CONF, "Insufficient rights to use connection", (Throwable)e);
        }
    }

    public static AbstractSQLConnection getDSSConnectionUnexpandedUnsafe(AuthCtx authCtx, String connectionName) throws IOException, CodedSQLException {
        try {
            return ConnectionsDAO.get().getMandatoryConnectionUnsafeUnexpandedAs(authCtx, connectionName, AbstractSQLConnection.class);
        }
        catch (DKUSecurityException e) {
            throw new CodedSQLException(SQLCodes.ERR_SQL_INVALID_CONF, "Insufficient rights to use connection", (Throwable)e);
        }
    }

    public static SQLDialect getConnectionDialect(AuthCtx authCtx, String connectionName) throws IOException, SQLException, DKUSecurityException {
        AbstractSQLConnection conn = SQLConnectionProvider.getDSSConnection(authCtx, connectionName);
        return conn.getDialect();
    }

    public static SQLDialect getConnectionDialect(AuthCtx authCtx, SerializedDataset sd) throws IOException, SQLException, DKUSecurityException {
        String connection = ((AbstractSQLDatasetHandler.AbstractSQLConfig)sd.getParams()).connection;
        return SQLConnectionProvider.getConnectionDialect(authCtx, connection);
    }

    public static SQLDialect getConnectionDialectIfSQLOrNull(AuthCtx authCtx, Dataset sd) throws IOException, SQLException, DKUSecurityException {
        return DatasetInspector.isSQL(sd) ? SQLConnectionProvider.getConnectionDialect(authCtx, sd.serialize()) : null;
    }

    public static SQLConnectionData getConnectionData_NT(AuthCtx authCtx, String projectKey, QueryParams queryDesc) throws IOException, DKUSecurityException, SQLException {
        AbstractSQLConnection conn = ConnectionsDAO.get().getMandatoryConnectionAs(authCtx, queryDesc.connection, AbstractSQLConnection.class);
        if (conn instanceof HiveConnection && queryDesc.querySettings != null && queryDesc.querySettings.extraConf != null) {
            List<SimpleKeyValue> resolvedHiveConf = new HiveConfHelper().getResolvedConf(authCtx, projectKey, queryDesc.querySettings.inheritConf, queryDesc.querySettings.extraConf);
            ((HiveConnection)conn).params.hiveconf = resolvedHiveConf;
        }
        return conn.getConnectionData_NT(authCtx, projectKey);
    }

    public static SQLConnectionWrapper newConnection(SQLConnectionData connData, AuthCtx authCtx, String projectKey) throws SQLException, DKUSecurityException, InterruptedException {
        String debugId = (connData.getConnection() == null ? "unk" : connData.getConnection().name) + "-" + SecretKeyGenerator.generateSmall();
        return SQLConnectionProvider.newConnection(connData, authCtx, projectKey, debugId, true);
    }

    public static SQLConnectionWrapper newConnection(SQLConnectionData connData, AuthCtx authCtx, String projectKey, String debugId, boolean verboseRollback) throws SQLException, DKUSecurityException, InterruptedException {
        return SQLConnectionProvider.newConnection(connData, authCtx, projectKey, debugId, verboseRollback, false);
    }

    public static SQLConnectionWrapper newConnection(SQLConnectionData connData, AuthCtx authCtx, String projectKey, String debugId, boolean verboseRollback, boolean noReportCRU) throws SQLException, DKUSecurityException, InterruptedException {
        SQLConnectionWrapper conn;
        block42: {
            String driverClass = connData.getDriver(authCtx, projectKey);
            if (driverClass != null) {
                SQLDriverLoader.loadDriver(driverClass, connData.getJarsDirectory(), connData.getJarsFallThroughPackages(), connData.getJarsNonFallThroughPackages());
            }
            try {
                conn = connData.buildConnection(authCtx, projectKey, debugId, verboseRollback);
            }
            catch (SQLException e) {
                throw SQLExceptionsParser.tryCodeSQLException("Failed to connect", connData, e, false);
            }
            catch (InterruptedException e) {
                throw e;
            }
            try {
                DriverVersionExtractor driverVersionExtractor = new DriverVersionExtractor(conn.getMetaData());
                logger.info((Object)driverVersionExtractor.getFormatterDriverInfos());
                logger.info((Object)driverVersionExtractor.getFormattedDatabaseInfos());
            }
            catch (NotImplementedException ex) {
                logger.warn((Object)"Connection doesn't implement database metadata", (Throwable)ex);
            }
            catch (SQLException ex) {
                logger.warn((Object)("Error while fetching info from connection : " + ex.getMessage()), (Throwable)ex);
            }
            conn.setAutoCommitToConnectionSpecifiedMode();
            try {
                AbstractSQLConnection abstractSQLConnection = connData.getConnection();
                if (abstractSQLConnection instanceof DatabricksConnection) {
                    Statement stmt;
                    VariablesContext vc;
                    DatabricksConnection databricksConnection = (DatabricksConnection)abstractSQLConnection;
                    VariablesService vs = (VariablesService)SpringUtils.getBean(VariablesService.class);
                    VariablesContext variablesContext = vc = projectKey != null ? vs.getForProject(projectKey) : vs.getForGlobal();
                    if (StringUtils.isNotBlank((String)databricksConnection.params.defaultCatalog) && StringUtils.isNotBlank((String)databricksConnection.params.defaultSchema)) {
                        logger.info((Object)"Executing USE for Databricks defaultCatalog and schema");
                        stmt = conn.createStatement();
                        try {
                            stmt.execute("USE " + connData.getDialect().quoteIdentifier(vc.expand(databricksConnection.params.defaultCatalog)) + "." + connData.getDialect().quoteIdentifier(vc.expand(databricksConnection.params.defaultSchema)));
                        }
                        finally {
                            if (stmt != null) {
                                stmt.close();
                            }
                        }
                    }
                    if (StringUtils.isNotBlank((String)databricksConnection.params.defaultSchema)) {
                        logger.info((Object)"Executing USE for Databricks defaultSchema without catalog");
                        stmt = conn.createStatement();
                        try {
                            stmt.execute("USE " + connData.getDialect().quoteIdentifier(vc.expand(databricksConnection.params.defaultSchema)));
                        }
                        finally {
                            if (stmt != null) {
                                stmt.close();
                            }
                        }
                    }
                    if (StringUtils.isNotBlank((String)databricksConnection.params.defaultCatalog)) {
                        logger.info((Object)"Executing USE CATALOG for Databricks defaultCatalog without schema");
                        stmt = conn.createStatement();
                        try {
                            stmt.execute("USE CATALOG " + connData.getDialect().quoteIdentifier(vc.expand(databricksConnection.params.defaultCatalog)));
                        }
                        finally {
                            if (stmt != null) {
                                stmt.close();
                            }
                        }
                    }
                }
                connData.getDialect().executePostConnectTasks(connData, conn);
                if (!(connData instanceof ImpalaConnection.ImpalaSQLConnectionData)) break block42;
                ImpalaConnection.ImpalaSQLConnectionData impalaConnData = (ImpalaConnection.ImpalaSQLConnectionData)connData;
                try (Statement stmt = conn.createStatement();){
                    stmt.execute("USE " + connData.getDialect().quoteIdentifier(impalaConnData.getDatabase()));
                }
            }
            catch (SQLException e) {
                try {
                    conn.close();
                }
                catch (SQLException sQLException) {
                    // empty catch block
                }
                throw e;
            }
        }
        if (!noReportCRU) {
            SQLComputeResourceUsage.setupSQLConnection(conn.cru, conn, connData.getConnection().name);
            conn.cru.reportStartNoFail();
        } else {
            conn.setNoReportCRU();
        }
        return conn;
    }

    public static SQLConnectionWrapper newConnection(String connectionName, AuthCtx authCtx, String projectKey) throws SQLException, IOException, DKUSecurityException, InterruptedException {
        SQLConnectionData connData = SQLConnectionProvider.getConnectionData_NT(authCtx, projectKey, connectionName);
        return SQLConnectionProvider.newConnection(connData, authCtx, projectKey);
    }

    public static interface SQLConnectionData {
        public ConnectionUtils.SQLConnectionType getType();

        public AbstractSQLConnection getConnection();

        public SQLDialect getDialect();

        public String getDriver(AuthCtx var1, String var2);

        public String getJarsDirectory();

        public List<String> getJarsFallThroughPackages();

        public List<String> getJarsNonFallThroughPackages();

        public void setJarsFallThroughPackages(List<String> var1);

        public void setJarsNonFallThroughPackages(List<String> var1);

        public SQLConnectionData withProperty(AbstractSQLConnection.CustomDatabaseProperty var1);

        public SQLConnectionData withProperty(String var1, String var2);

        public SQLConnectionData withPropertyIfNotBlank(AbstractSQLConnection.CustomDatabaseProperty var1);

        public SQLConnectionData withPropertyIfNotBlank(String var1, String var2);

        public SQLConnectionData withHiddenProperty(String var1, String var2);

        public boolean hasProperty(String var1);

        public String getSchemaSearchPath();

        public SQLConnectionData withSchemaSearchPath(String var1);

        public SQLConnectionWrapper buildConnection(AuthCtx var1, String var2, String var3, boolean var4) throws SQLException, DKUSecurityException, InterruptedException;

        public SparkJDBCInfo getSparkConnectionInfo(AuthCtx var1, String var2) throws SQLException;
    }

    public static class SQLConnectionWrapper
    implements AutoCloseable {
        protected final Connection connection;
        protected final ComputeResourceUsage cru;
        protected final SQLConnectionData connData;
        protected final String debugId;
        protected boolean verboseRollback;
        private boolean noReportCRU;
        private final ConnectionCloser connectionCloser;

        public SQLConnectionWrapper(SQLConnectionData connData, Connection connection, String debugId, boolean verboseRollback) {
            this(connData, connection, debugId, verboseRollback, new DefaultConnectionCloser(connection, connData.getDialect()));
        }

        public SQLConnectionWrapper(SQLConnectionData connData, Connection connection, String debugId, boolean verboseRollback, ConnectionCloser connectionCloser) {
            this.connData = connData;
            this.connection = connection;
            this.debugId = debugId;
            this.cru = new ComputeResourceUsage();
            this.verboseRollback = verboseRollback;
            this.connectionCloser = connectionCloser;
        }

        public ComputeResourceUsage getComputeResourceUsage() {
            return this.cru;
        }

        public void setNoReportCRU() {
            this.noReportCRU = true;
        }

        public String getDebugId() {
            return this.debugId;
        }

        public ConnectionCloser getConnectionCloser() {
            return this.connectionCloser;
        }

        public boolean getAutoCommit() throws SQLException {
            return this.connection.getAutoCommit();
        }

        public void setAutoCommit(boolean autoCommit) throws SQLException {
            this.connection.setAutoCommit(autoCommit);
        }

        private void setAutoCommitToConnectionSpecifiedMode() {
            if (this.supportsCommitAndRollback()) {
                boolean autocommitMode = "FabricWarehouse".equals(this.connData.getConnection().type) || "Synapse".equals(this.connData.getConnection().type) || this.connData.getConnection().getParams().autocommitMode;
                logger.traceV("Set autocommit=%s on conn=%s", new Object[]{autocommitMode, this.debugId});
                SQLUtils.unsafeSetAutoCommit(this.connection, autocommitMode);
            } else {
                logger.traceV("Not setting autocommit on conn=%s, unsupported", new Object[]{this.debugId});
            }
        }

        public DatabaseMetaData getMetaData() throws SQLException {
            return this.connection.getMetaData();
        }

        public SQLConnectionData getConnectionData() {
            return this.connData;
        }

        public SQLDialect getDialect() {
            return this.connData.getDialect();
        }

        @Override
        public void close() throws SQLException {
            logger.debugV("Close conn=%s", new Object[]{this.debugId});
            this.connectionCloser.close();
            if (!this.noReportCRU) {
                this.cru.reportCompleteNoFail();
            }
        }

        public Connection getConnectionUnsafe(boolean iKnowWhatIamDoing) {
            assert (iKnowWhatIamDoing);
            return this.connection;
        }

        public Statement createStatement() throws SQLException {
            return this.connection.createStatement();
        }

        public Statement createStatement(int resultSetType, int resultSetConcurrency) throws SQLException {
            return this.connection.createStatement(resultSetType, resultSetConcurrency);
        }

        public void rollback() throws SQLException {
            if (this.verboseRollback) {
                logger.debugV("Rollback conn=%s", new Object[]{this.debugId});
            } else {
                logger.traceV("Rollback conn=%s", new Object[]{this.debugId});
            }
            this.connection.rollback();
        }

        public boolean isClosed() throws SQLException {
            return this.connectionCloser.isClosed();
        }

        public void commit() throws SQLException {
            logger.debugV("Commit conn=%s", new Object[]{this.debugId});
            this.connection.commit();
        }

        public PreparedStatement prepareStatement(String sql) throws SQLException {
            return this.connection.prepareStatement(sql);
        }

        public PreparedStatement prepareStatement(String sql, int resultSetType, int resultSetConcurrency) throws SQLException {
            return this.connection.prepareStatement(sql, resultSetType, resultSetConcurrency);
        }

        public void rollbackAndClose() throws SQLException {
            logger.debugV("Rollback and close conn=%s", new Object[]{this.debugId});
            if (this.supportsCommitAndRollback()) {
                this.rollback();
            }
            logger.debugV("Close conn=%s", new Object[]{this.debugId});
            this.close();
        }

        protected boolean supportsCommitAndRollback() {
            return this.connData.getDialect().supportsCommitAndRollback();
        }

        public static class DefaultConnectionCloser
        implements ConnectionCloser {
            private final Connection connection;
            private final SQLDialect dialect;

            public DefaultConnectionCloser(Connection connection, SQLDialect dialect) {
                this.connection = connection;
                this.dialect = dialect;
            }

            @Override
            public void close() throws SQLException {
                ConnectionUtils.actuallyCloseJdbcConnection(this.connection, this.dialect);
            }

            @Override
            public boolean isClosed() throws SQLException {
                return this.connection.isClosed();
            }
        }
    }

    public static class SnowflakeSQLConnectionData
    extends GenericSQLConnectionData {
        public SnowflakeSQLConnectionData(String type, SQLDialect dialect, SnowflakeConnection connection, String driver, String jdbcUrl, String jarsDirectory) {
            super(type, dialect, (AbstractSQLConnection)connection, driver, jdbcUrl, jarsDirectory);
        }

        @Override
        protected Properties getProperties(boolean hideSecrets) {
            Properties props = super.getProperties(hideSecrets);
            if (hideSecrets && props.getProperty("private_key_file_pwd") != null) {
                props.setProperty("private_key_file_pwd", "***");
            }
            return props;
        }
    }

    public static class BigQuerySQLConnectionData
    extends AbstractSQLConnectionData {
        public final boolean useDriver;
        private final String jdbcUrl;
        private final String driver;
        private final String jarsDirectory;

        public BigQuerySQLConnectionData(String type, SQLDialect dialect, BigQueryConnection connection, String driver, String jdbcUrl, String jarsDirectory) {
            super(ConnectionUtils.SQLConnectionType.valueOf(type.toUpperCase()), dialect, connection);
            if (connection.params.driverMode == BigQueryConnection.BigQueryDriverMode.DRIVERLESS) {
                this.useDriver = false;
                this.driver = null;
                this.jdbcUrl = null;
                this.jarsDirectory = null;
            } else {
                this.useDriver = true;
                this.driver = driver;
                this.jdbcUrl = jdbcUrl;
                this.jarsDirectory = jarsDirectory;
            }
        }

        @Override
        public List<String> getJarsFallThroughPackages() {
            if (this.useDriver) {
                String fallThroughPackages = ApplicationConfigurator.getProperty((String)"dku.bigquery.fallThroughPackages", (String)"org.slf4j");
                return Arrays.stream(fallThroughPackages.split(",")).filter(StringUtils::isNotBlank).map(String::trim).collect(Collectors.toList());
            }
            return null;
        }

        @Override
        public String getDriver(AuthCtx authCtx, String projectKey) {
            return this.driver;
        }

        @Override
        public String getJarsDirectory() {
            return this.useDriver ? this.jarsDirectory : null;
        }

        @Override
        public SparkJDBCInfo getSparkConnectionInfo(AuthCtx authCtx, String projectKey) throws SQLException {
            BigQueryConnection bigQueryConnection = (BigQueryConnection)this.getConnection();
            JdbcConnectionData jdbcData = new SimpleJdbcConnectionData(this.jdbcUrl, bigQueryConnection.getDisplayableJdbcUrl(), this.getProperties(false), this.getProperties(true), this.getHiddenProperties());
            jdbcData = jdbcData.expandVariables(authCtx, bigQueryConnection, projectKey);
            SparkJDBCInfo info = new SparkJDBCInfo();
            info.driver = this.getDriver(authCtx, projectKey);
            info.properties = jdbcData.getProperties();
            info.url = jdbcData.getJdbcUrl();
            int fetchSize = SQLUtils.retrieveFetchSize(this);
            if (fetchSize > 0) {
                info.properties.put("fetchSize", (Object)fetchSize);
            }
            return info;
        }

        @Override
        public SQLConnectionWrapper buildConnection(AuthCtx authCtx, String projectKey, String debugId, boolean verboseRollback) throws SQLException, DKUSecurityException, InterruptedException {
            SQLConnectionWrapper wrapper;
            BigQueryConnection bigQueryConnection = this.getConnectionAndCheckConfiguration();
            if (this.useDriver) {
                SQLConnectionWrapper conn;
                JdbcConnectionData jdbcData = new SimpleJdbcConnectionData(this.jdbcUrl, bigQueryConnection.getDisplayableJdbcUrl(), this.getProperties(false), this.getProperties(true), this.getHiddenProperties());
                jdbcData = jdbcData.expandVariables(authCtx, bigQueryConnection, projectKey);
                String actualJdbcUrl = jdbcData.getJdbcUrl();
                logger.info((Object)("Connecting to " + jdbcData.getDisplayableJdbcUrl() + " with props: " + jdbcData.getDisplayablePropertiesAsString() + " conn=" + debugId));
                Driver actualDriver = SQLDriverLoader.getDriverTheRightWay(actualJdbcUrl, this.driver, this.getJarsDirectory(), this.getJarsFallThroughPackages(), this.getJarsNonFallThroughPackages());
                this.initPostConnectStatements(authCtx, projectKey);
                SQLConnectionService.SQLConnectionKey key = new SQLConnectionService.SQLConnectionKey(authCtx, jdbcData, this, this.getDriver(authCtx, projectKey), actualDriver, debugId, verboseRollback);
                SQLConnectionService sqlConnectionService = SQLConnectionServiceDispatcher.getSQLConnectionService(bigQueryConnection.params.connectionPoolSettings, debugId);
                try {
                    conn = sqlConnectionService.take(authCtx, key);
                }
                catch (Exception e) {
                    throw new SQLException("Unable to connect", e);
                }
                if (conn == null) {
                    throw new SQLException("Unable to retrieve connection " + jdbcData.getDisplayableJdbcUrl());
                }
                BigQuerySimbaConnectionWrapper jdbcConnection = new BigQuerySimbaConnectionWrapper(conn.getConnectionUnsafe(true));
                wrapper = new SQLConnectionWrapper(this, jdbcConnection, debugId, verboseRollback, conn.getConnectionCloser());
            } else {
                BigQueryNativeClient bigQueryClient;
                try {
                    bigQueryClient = bigQueryConnection.getClient(authCtx, projectKey);
                }
                catch (IOException | URISyntaxException e) {
                    throw new SQLException(e);
                }
                BigQueryJdbcConnection jdbcConnection = new BigQueryJdbcConnection(bigQueryClient, this.getProperties(false));
                wrapper = new SQLConnectionWrapper(this, jdbcConnection, debugId, verboseRollback);
            }
            this.runPostConnectStatements(wrapper);
            return wrapper;
        }

        private BigQueryConnection getConnectionAndCheckConfiguration() throws CodedSQLException {
            BigQueryConnection connection = (BigQueryConnection)this.getConnection();
            try (ErrorContext.ACNDC ignored = ErrorContext.pushWithNDC((String)("connection: " + connection.name));){
                connection.checkConfiguration();
            }
            catch (CodedException | DKUSecurityException e) {
                SQLCodes code = ((ICodedException)e).getCode() != null ? ((ICodedException)e).getCode() : SQLCodes.ERR_SQL_INVALID_CONF;
                throw new CodedSQLException(code, "Invalid configuration", e);
            }
            return connection;
        }

        public BigQueryClient getRestClient(AuthCtx authCtx) throws DKUSecurityException, IOException, SQLException {
            return ((BigQueryConnection)this.getConnection()).getRestClient(authCtx);
        }
    }

    public static class TeradataSQLConnectionData
    extends AbstractSQLConnectionData {
        private final String driver;
        private final String jarsDirectory;
        private final ICredentialsService.BasicCredential creds;

        public TeradataSQLConnectionData(ConnectionUtils.SQLConnectionType type, SQLDialect dialect, AbstractSQLConnection connection, String driver, String jarsDirectory, ICredentialsService.BasicCredential creds) {
            super(type, dialect, connection);
            this.driver = driver;
            this.jarsDirectory = jarsDirectory;
            this.creds = creds;
        }

        public TeradataSQLConnectionData(String type, SQLDialect dialect, AbstractSQLConnection connection, String driver, String jarsDirectory, ICredentialsService.BasicCredential creds) {
            this(ConnectionUtils.SQLConnectionType.valueOf(type.toUpperCase()), dialect, connection, driver, jarsDirectory, creds);
        }

        @Override
        public String getJarsDirectory() {
            return this.jarsDirectory;
        }

        @Override
        public String getDriver(AuthCtx authCtx, String projectKey) {
            return this.driver;
        }

        @Override
        public SparkJDBCInfo getSparkConnectionInfo(AuthCtx authCtx, String projectKey) throws SQLException {
            JdbcConnectionData jdbcData = this.getJdbcConnectionData(authCtx, true);
            jdbcData = jdbcData.expandVariables(authCtx, this.getConnection(), projectKey);
            SparkJDBCInfo info = new SparkJDBCInfo();
            info.driver = this.getDriver(authCtx, projectKey);
            info.properties = jdbcData.getProperties();
            info.url = jdbcData.getJdbcUrl();
            int fetchSize = SQLUtils.retrieveFetchSize(this);
            if (fetchSize > 0) {
                info.properties.put("fetchSize", (Object)fetchSize);
            }
            return info;
        }

        private JdbcConnectionData getJdbcConnectionData(AuthCtx authCtx, boolean forSpark) throws SQLException {
            Object baseUrl;
            TeradataConnection tconn = (TeradataConnection)this.getConnection();
            if (tconn.params.useURL) {
                if (StringUtils.isBlank((String)tconn.params.url)) {
                    throw ErrorContext.iae((String)"Teradata connection JDBC URL is not set");
                }
                baseUrl = tconn.params.url;
            } else if (tconn.params.kerberosLoginEnabled) {
                baseUrl = "jdbc:teradata://" + tconn.params.host + "/LOGMECH=KRB5";
                if (StringUtils.isNotBlank((String)tconn.params.defaultDatabase)) {
                    baseUrl = (String)baseUrl + ",DATABASE=" + tconn.params.defaultDatabase;
                }
            } else {
                baseUrl = "jdbc:teradata://" + tconn.params.host;
                if (this.creds != null) {
                    baseUrl = (String)baseUrl + "/USER=" + this.creds.user + ",PASSWORD=" + this.creds.password;
                }
                if (StringUtils.isNotBlank((String)tconn.params.defaultDatabase)) {
                    baseUrl = (String)baseUrl + ",DATABASE=" + tconn.params.defaultDatabase;
                }
            }
            boolean needsInitialComma = ((String)baseUrl).contains("=");
            boolean first = true;
            StringBuilder sb = new StringBuilder();
            for (AbstractSQLConnection.CustomDatabaseProperty e : this.getCustomDatabaseProperties()) {
                if (!first || needsInitialComma) {
                    sb.append(",");
                }
                first = false;
                sb.append(e.name);
                sb.append("='");
                sb.append(e.value.replaceAll("'", "''"));
                sb.append("'");
            }
            return new SimpleJdbcConnectionData((String)baseUrl + sb.toString(), this.getConnection().getDisplayableJdbcUrl(), this.getProperties(false), this.getProperties(true), this.getHiddenProperties());
        }

        @Override
        public SQLConnectionWrapper buildConnection(final AuthCtx authCtx, String projectKey, String debugId, boolean verboseRollback) throws SQLException, DKUSecurityException, InterruptedException {
            SQLConnectionWrapper connWrapper;
            TeradataConnection tconn = (TeradataConnection)this.getConnection();
            JdbcConnectionData jdbcData = this.getJdbcConnectionData(authCtx, false);
            jdbcData = jdbcData.expandVariables(authCtx, this.getConnection(), projectKey);
            String jdbcUrl = jdbcData.getJdbcUrl();
            logger.info((Object)("Connecting to " + jdbcData.getDisplayableJdbcUrl() + " with props: " + jdbcData.getDisplayablePropertiesAsString() + " conn=" + debugId));
            Driver actualDriver = SQLDriverLoader.getDriverTheRightWay(jdbcUrl, this.driver, this.getJarsDirectory(), null, null);
            this.initPostConnectStatements(authCtx, projectKey);
            final SQLConnectionService.SQLConnectionKey key = new SQLConnectionService.SQLConnectionKey(authCtx, jdbcData, this, this.getDriver(authCtx, projectKey), actualDriver, debugId, verboseRollback);
            final SQLConnectionService sqlConnectionService = SQLConnectionServiceDispatcher.getSQLConnectionService(tconn.params.connectionPoolSettings, debugId);
            if (tconn.params.kerberosLoginEnabled) {
                Subject doAs;
                try {
                    doAs = Krb5KeytabLoginContextCache.get(tconn.params.dssPrincipal, tconn.params.dssKeytabPath).getSubject();
                }
                catch (Exception e) {
                    throw new SQLException("Unable to login", e);
                }
                try {
                    connWrapper = Subject.doAs(doAs, new PrivilegedExceptionAction<SQLConnectionWrapper>(){

                        @Override
                        public SQLConnectionWrapper run() throws Exception {
                            return sqlConnectionService.take(authCtx, key);
                        }
                    });
                }
                catch (PrivilegedActionException e) {
                    Exception thrown = e.getException();
                    if (thrown instanceof SQLException) {
                        throw (SQLException)thrown;
                    }
                    throw new SQLException("Unable to connect", thrown);
                }
            }
            try {
                connWrapper = sqlConnectionService.take(authCtx, key);
            }
            catch (Exception e) {
                throw new SQLException("Unable to connect", e);
            }
            if (connWrapper == null) {
                throw new SQLException("Unable to retrieve connection " + jdbcData.getDisplayableJdbcUrl());
            }
            TeradataConnection.TeradataSQLConnectionWrapper wrapper = new TeradataConnection.TeradataSQLConnectionWrapper(this, connWrapper.getConnectionUnsafe(true), debugId, verboseRollback, connWrapper.getConnectionCloser());
            this.runPostConnectStatements(wrapper);
            return wrapper;
        }

        @Override
        protected void runBasePostConnectStatements(SQLConnectionWrapper wrapper) throws SQLException {
            logger.info((Object)("Executing post-connect statements: " + this.postConnectStatements));
            this.runStatements((TeradataConnection.TeradataSQLConnectionWrapper)wrapper, this.postConnectStatements);
        }

        @Override
        protected void runJobOnlyPostConnectStatements(SQLConnectionWrapper wrapper) throws SQLException {
            logger.info((Object)("Executing job-post-connect statements: " + this.jobOnlyPostConnectStatements));
            this.runStatements((TeradataConnection.TeradataSQLConnectionWrapper)wrapper, this.jobOnlyPostConnectStatements);
        }

        private void runStatements(TeradataConnection.TeradataSQLConnectionWrapper wrapper, String statements) throws SQLException {
            Splitter splitter = this.getDialect().getSplitter();
            String[] statementSqls = splitter.split(statements);
            try (Statement statement = wrapper.createTrustedStatement(true);){
                for (String statementSql : statementSqls) {
                    logger.info((Object)("Executing trusted post-connect statement: " + statementSql));
                    statement.execute(statementSql);
                    logger.info((Object)"Trusted post-connect Statement done");
                }
            }
        }
    }

    public static class GenericSQLConnectionData
    extends AbstractSQLConnectionData {
        private final String jdbcUrl;
        private final String driver;
        private final String jarsDirectory;

        public GenericSQLConnectionData(ConnectionUtils.SQLConnectionType type, SQLDialect dialect, AbstractSQLConnection connection, String driver, String jdbcUrl, String jarsDirectory) {
            super(type, dialect, connection);
            this.driver = driver;
            this.jdbcUrl = jdbcUrl;
            this.jarsDirectory = jarsDirectory;
        }

        public GenericSQLConnectionData(String type, SQLDialect dialect, AbstractSQLConnection connection, String driver, String jdbcUrl, String jarsDirectory) {
            this(ConnectionUtils.SQLConnectionType.valueOf(type.toUpperCase()), dialect, connection, driver, jdbcUrl, jarsDirectory);
        }

        @Override
        public String getDriver(AuthCtx authCtx, String projectKey) {
            return this.driver;
        }

        @Override
        public String getJarsDirectory() {
            return this.jarsDirectory;
        }

        @Override
        public SparkJDBCInfo getSparkConnectionInfo(AuthCtx authCtx, String projectKey) throws SQLException {
            JdbcConnectionData jdbcData = new SimpleJdbcConnectionData(this.jdbcUrl, this.getConnection().getDisplayableJdbcUrl(), this.getProperties(false), this.getProperties(true), this.getHiddenProperties());
            jdbcData = jdbcData.expandVariables(authCtx, this.getConnection(), projectKey);
            SparkJDBCInfo info = new SparkJDBCInfo();
            info.driver = this.getDriver(authCtx, projectKey);
            info.properties = jdbcData.getProperties();
            info.url = jdbcData.getJdbcUrl();
            AbstractSQLConnection.AbstractSQLParams params = this.getConnection().getParams();
            int fetchSize = SQLUtils.retrieveFetchSize(this);
            if (fetchSize > 0) {
                info.properties.put("fetchSize", (Object)fetchSize);
            }
            return info;
        }

        protected SQLConnectionWrapper problemsAwareConnect(AuthCtx authCtx, SQLConnectionService.SQLConnectionKey connectionKey) throws SQLException {
            try {
                SQLConnectionService sqlConnectionService = SQLConnectionServiceDispatcher.getSQLConnectionService(connectionKey.sqlConnectionData.getConnection().getParams().connectionPoolSettings, connectionKey.debugId);
                return sqlConnectionService.take(authCtx, connectionKey);
            }
            catch (Exception e) {
                Driver driver = connectionKey.driver;
                if (e.getCause() instanceof NullPointerException && this.getType() == ConnectionUtils.SQLConnectionType.MYSQL && driver.getMajorVersion() < 8) {
                    throw new SQLException("The MySQL JDBC driver failed while connecting to your database. We know this problem is likely to happen with an old MySQL driver. Since your version of the driver (" + driver.getMajorVersion() + "." + driver.getMinorVersion() + ") is outdated, installing the last version might fix this problem.");
                }
                if (e instanceof NullPointerException && this.getType() == ConnectionUtils.SQLConnectionType.SNOWFLAKE) {
                    throw new SQLException("The Snowflake JDBC driver failed while connecting to your database. Please check the connection parameters.", e);
                }
                throw new SQLException("Unable to connect", e);
            }
        }

        @Override
        public SQLConnectionWrapper buildConnection(final AuthCtx authCtx, String projectKey, String debugId, boolean verboseRollback) throws SQLException, DKUSecurityException, InterruptedException {
            SQLConnectionWrapper wrapper;
            Subject doAs;
            try (ErrorContext.ACNDC ac = ErrorContext.pushWithNDC((String)("connection: " + this.getConnection().name));){
                this.getConnection().checkConfiguration();
            }
            catch (CodedException | DKUSecurityException e) {
                SQLCodes code = ((ICodedException)e).getCode() != null ? ((ICodedException)e).getCode() : SQLCodes.ERR_SQL_INVALID_CONF;
                throw new CodedSQLException(code, "Invalid configuration", e);
            }
            JdbcConnectionData jdbcData = new SimpleJdbcConnectionData(this.jdbcUrl, this.getConnection().getDisplayableJdbcUrl(), this.getProperties(false), this.getProperties(true), this.getHiddenProperties());
            try {
                doAs = this.getDoAs();
            }
            catch (Exception e) {
                throw new SQLException("Unable to login", e);
            }
            jdbcData = jdbcData.expandVariables(authCtx, this.getConnection(), projectKey);
            String actualJdbcUrl = jdbcData.getJdbcUrl();
            logger.info((Object)("Connecting to " + jdbcData.getDisplayableJdbcUrl() + " with props: " + jdbcData.getDisplayablePropertiesAsString() + " conn=" + debugId));
            Driver actualDriver = this.getDriverTheRightWay(actualJdbcUrl);
            Properties props = jdbcData.getProperties();
            this.initPostConnectStatements(authCtx, projectKey);
            final SQLConnectionService.SQLConnectionKey key = new SQLConnectionService.SQLConnectionKey(authCtx, jdbcData, this, this.getDriver(authCtx, projectKey), actualDriver, debugId, verboseRollback);
            if (doAs != null) {
                try {
                    this.addProxyUserProperties(authCtx, props, jdbcData.getHiddenProperties(), doAs);
                }
                catch (SQLException e) {
                    throw e;
                }
                catch (Exception e) {
                    throw new SQLException("Failed to create proxy user", e);
                }
                try {
                    wrapper = Subject.doAs(doAs, new PrivilegedExceptionAction<SQLConnectionWrapper>(){

                        @Override
                        public SQLConnectionWrapper run() throws Exception {
                            return this.problemsAwareConnect(authCtx, key);
                        }
                    });
                }
                catch (PrivilegedActionException e) {
                    Exception thrown = e.getException();
                    if (thrown instanceof SQLException) {
                        throw (SQLException)thrown;
                    }
                    throw new SQLException("Unable to connect", thrown);
                }
            }
            wrapper = this.problemsAwareConnect(authCtx, key);
            this.runPostConnectStatements(wrapper);
            return wrapper;
        }

        protected Driver getDriverTheRightWay(String jdbcUrl) throws SQLException {
            return SQLDriverLoader.getDriverTheRightWay(jdbcUrl, this.driver, this.getJarsDirectory(), this.getJarsFallThroughPackages(), this.getJarsNonFallThroughPackages());
        }

        protected void addProxyUserProperties(AuthCtx authCtx, Properties props, Map<String, String> hiddenProps, Subject doAs) throws Exception {
        }

        protected Subject getDoAs() throws Exception {
            return null;
        }
    }

    public static abstract class AbstractSQLConnectionData
    implements SQLConnectionData {
        private final ConnectionUtils.SQLConnectionType type;
        private final AbstractSQLConnection connection;
        private final SQLDialect dialect;
        private final List<AbstractSQLConnection.CustomDatabaseProperty> properties;
        private final Map<String, String> hiddenProperties;
        private String schemaSearchPath;
        protected String postConnectStatements;
        protected String jobOnlyPostConnectStatements;
        private List<String> fallThroughPackages;
        private List<String> nonFallThroughPackages;

        public AbstractSQLConnectionData(ConnectionUtils.SQLConnectionType type, SQLDialect dialect, AbstractSQLConnection connection) {
            this.type = type;
            this.dialect = dialect;
            this.connection = connection;
            this.properties = new ArrayList<AbstractSQLConnection.CustomDatabaseProperty>();
            this.hiddenProperties = new HashMap<String, String>();
        }

        @Override
        public ConnectionUtils.SQLConnectionType getType() {
            return this.type;
        }

        @Override
        public AbstractSQLConnection getConnection() {
            return this.connection;
        }

        @Override
        public SQLDialect getDialect() {
            return this.dialect;
        }

        @Override
        public String getJarsDirectory() {
            return null;
        }

        private List<String> getPackagesFromParam(String param, List<String> defaultPackages) {
            String pkgs;
            if (this.connection != null && StringUtils.isNotBlank((String)(pkgs = this.connection.getDkuPropertiesAsParams().getParam(param, "")))) {
                return Arrays.asList(pkgs.split(","));
            }
            return defaultPackages;
        }

        @Override
        public List<String> getJarsFallThroughPackages() {
            return this.getPackagesFromParam("fallthrough.packages", this.fallThroughPackages);
        }

        @Override
        public List<String> getJarsNonFallThroughPackages() {
            return this.getPackagesFromParam("nonfallthrough.packages", this.nonFallThroughPackages);
        }

        @Override
        public void setJarsFallThroughPackages(List<String> fallThroughPackages) {
            this.fallThroughPackages = fallThroughPackages;
        }

        @Override
        public void setJarsNonFallThroughPackages(List<String> fallThroughPackages) {
            this.nonFallThroughPackages = fallThroughPackages;
        }

        @Override
        public boolean hasProperty(String name) {
            return this.getProperties(false).get(name) != null;
        }

        protected Properties getProperties(boolean hideSecrets) {
            Properties props = new Properties();
            for (AbstractSQLConnection.CustomDatabaseProperty prop : this.properties) {
                String val = hideSecrets && prop.secret ? "***" : prop.value;
                props.setProperty(prop.name, StringUtils.defaultIfEmpty((String)val, (String)""));
            }
            return props;
        }

        protected Map<String, String> getHiddenProperties() {
            return this.hiddenProperties;
        }

        protected List<AbstractSQLConnection.CustomDatabaseProperty> getCustomDatabaseProperties() {
            return this.properties;
        }

        @Override
        public String getSchemaSearchPath() {
            return this.schemaSearchPath;
        }

        @Override
        public SQLConnectionData withSchemaSearchPath(String schemaSearchPath) {
            this.schemaSearchPath = schemaSearchPath;
            return this;
        }

        @Override
        public SQLConnectionData withProperty(AbstractSQLConnection.CustomDatabaseProperty prop) {
            this.properties.removeIf(p -> p.name.equals(prop.name));
            this.properties.add(prop);
            return this;
        }

        @Override
        public SQLConnectionData withProperty(String name, String value) {
            AbstractSQLConnection.CustomDatabaseProperty prop = new AbstractSQLConnection.CustomDatabaseProperty();
            prop.name = name;
            prop.value = value;
            return this.withProperty(prop);
        }

        @Override
        public SQLConnectionData withHiddenProperty(String name, String value) {
            this.hiddenProperties.put(name, value);
            return this;
        }

        @Override
        public SQLConnectionData withPropertyIfNotBlank(AbstractSQLConnection.CustomDatabaseProperty prop) {
            if (prop != null && StringUtils.isNotBlank((String)prop.value)) {
                return this.withProperty(prop);
            }
            return this;
        }

        @Override
        public SQLConnectionData withPropertyIfNotBlank(String name, String value) {
            AbstractSQLConnection.CustomDatabaseProperty prop = new AbstractSQLConnection.CustomDatabaseProperty();
            prop.name = name;
            prop.value = value;
            return this.withPropertyIfNotBlank(prop);
        }

        @Nullable
        public ProxySettings getProxySettings() {
            return this.connection.getProxySettings();
        }

        protected void initPostConnectStatements(AuthCtx authCtx, String projectKey) {
            VariablesContext vc = ((VariablesService)SpringUtils.getBean(VariablesService.class)).getForConnectionAndProjectAndUser(this.getConnection(), authCtx, projectKey);
            this.postConnectStatements = this.getConnection().getParams().postConnectStatements;
            if (StringUtils.isNotBlank((String)this.postConnectStatements)) {
                this.postConnectStatements = vc.expand(this.postConnectStatements);
            }
            if (JobContext.getCurrentJobContext() != null) {
                this.jobOnlyPostConnectStatements = this.getConnection().getParams().jobOnlyPostConnectStatements;
                if (StringUtils.isNotBlank((String)this.jobOnlyPostConnectStatements)) {
                    this.jobOnlyPostConnectStatements = vc.expand(this.jobOnlyPostConnectStatements);
                }
            }
        }

        protected void runPostConnectStatements(SQLConnectionWrapper wrapper) throws SQLException {
            if (StringUtils.isNotBlank((String)this.postConnectStatements)) {
                this.runBasePostConnectStatements(wrapper);
            }
            if (StringUtils.isNotBlank((String)this.jobOnlyPostConnectStatements)) {
                this.runJobOnlyPostConnectStatements(wrapper);
            }
        }

        protected void runBasePostConnectStatements(SQLConnectionWrapper wrapper) throws SQLException {
            SQLUtils.safeSplitAndExec(this.getDialect(), wrapper, this.postConnectStatements, true);
        }

        protected void runJobOnlyPostConnectStatements(SQLConnectionWrapper wrapper) throws SQLException {
            SQLUtils.safeSplitAndExec(this.getDialect(), wrapper, this.jobOnlyPostConnectStatements, true);
        }
    }

    public static class SparkJDBCInfo {
        public String url;
        public String driver;
        public Properties properties;
    }

    public static class SimpleJdbcConnectionData
    implements JdbcConnectionData {
        private final String jdbcUrl;
        private final String displayableJdbcUrl;
        private final Properties properties;
        private final Properties displayableProperties;
        private final Map<String, String> hiddenProperties;

        SimpleJdbcConnectionData(String jdbcUrl, String displayableJdbcUrl, Properties properties, Properties displayableProperties, Map<String, String> hiddenProperties) {
            this.jdbcUrl = jdbcUrl;
            this.displayableJdbcUrl = displayableJdbcUrl;
            this.properties = properties;
            this.displayableProperties = displayableProperties;
            this.hiddenProperties = hiddenProperties;
        }

        @Override
        public void addDisplayableProperty(String key, String value) {
            this.properties.put(key, value);
            this.displayableProperties.put(key, value);
        }

        @Override
        public void addNonDisplayableProperty(String key, String value) {
            this.properties.put(key, value);
            this.displayableProperties.put(key, "***");
        }

        @Override
        public String getJdbcUrl() {
            return this.jdbcUrl;
        }

        @Override
        public String getDisplayableJdbcUrl() {
            return this.displayableJdbcUrl;
        }

        @Override
        public Properties getProperties() {
            return this.properties;
        }

        @Override
        public Map<String, String> getHiddenProperties() {
            return this.hiddenProperties;
        }

        @Override
        public Properties getDisplayableProperties() {
            return this.displayableProperties;
        }

        @Override
        public String getDisplayablePropertiesAsString() {
            return JSON.json((Object)this.displayableProperties);
        }

        @Override
        public JdbcConnectionData expandVariables(AuthCtx authCtx, AbstractSQLConnection connection, String projectKey) throws SQLException {
            VariablesContext vc = ((VariablesService)SpringUtils.getBean(VariablesService.class)).getForConnectionAndProjectAndUser(connection, authCtx, projectKey);
            Map map = vc.getAllVariables();
            StrSubstitutor subs = new StrSubstitutor(map, "%{", "}");
            String expandedJdbcUrl = vc.expand(this.jdbcUrl);
            expandedJdbcUrl = subs.replace(expandedJdbcUrl);
            Properties expandedProperties = new Properties();
            for (Object key : this.properties.keySet()) {
                Object value = this.properties.get(key);
                if (value instanceof String) {
                    value = vc.expand((String)value);
                    value = subs.replace((String)value);
                }
                expandedProperties.put(key, value);
            }
            HashMap expandedHiddenProperties = Maps.newHashMap();
            for (String key : this.hiddenProperties.keySet()) {
                String value = this.hiddenProperties.get(key);
                value = vc.expand(value);
                value = subs.replace(value);
                expandedHiddenProperties.put(key, value);
            }
            return new SimpleJdbcConnectionData(expandedJdbcUrl, this.displayableJdbcUrl, expandedProperties, this.displayableProperties, expandedHiddenProperties);
        }
    }

    public static interface JdbcConnectionData {
        public String getJdbcUrl();

        public String getDisplayableJdbcUrl();

        public Properties getProperties();

        public Properties getDisplayableProperties();

        public String getDisplayablePropertiesAsString();

        public Map<String, String> getHiddenProperties();

        public JdbcConnectionData expandVariables(AuthCtx var1, AbstractSQLConnection var2, String var3) throws SQLException;

        public void addDisplayableProperty(String var1, String var2);

        public void addNonDisplayableProperty(String var1, String var2);
    }

    public static interface ConnectionCloser {
        public void close() throws SQLException;

        public boolean isClosed() throws SQLException;
    }
}

