/*
 * Decompiled with CFR 0.152.
 */
package com.dataiku.dip.connections.bigquery.builtin;

import com.dataiku.dip.connections.bigquery.builtin.BigQueryJdbcConnection;
import com.dataiku.dip.connections.bigquery.builtin.QueryParameter;
import com.dataiku.dip.connections.bigquery.builtin.SqlLikePatternMatcher;
import com.dataiku.dip.sql.bigquery.QueryResult;
import com.dataiku.dip.utils.DKULogger;
import com.dataiku.dss.shadelib.com.google.common.collect.Lists;
import com.dataiku.dss.shadelibgcp.com.google.api.services.bigquery.model.ProjectList;
import com.dataiku.dss.shadelibgcp.com.google.cloud.bigquery.BigQueryException;
import com.dataiku.dss.shadelibgcp.com.google.cloud.bigquery.Dataset;
import com.dataiku.dss.shadelibgcp.com.google.cloud.bigquery.DatasetId;
import com.dataiku.dss.shadelibgcp.com.google.cloud.bigquery.DatasetInfo;
import com.dataiku.dss.shadelibgcp.com.google.cloud.bigquery.FieldValue;
import com.dataiku.dss.shadelibgcp.com.google.cloud.bigquery.FieldValueList;
import com.dataiku.dss.shadelibgcp.com.google.cloud.bigquery.StandardSQLTypeName;
import com.dataiku.dss.shadelibgcp.com.google.cloud.bigquery.TableId;
import com.google.common.util.concurrent.ThreadFactoryBuilder;
import java.sql.SQLException;
import java.util.ArrayList;
import java.util.Arrays;
import java.util.Collections;
import java.util.Comparator;
import java.util.List;
import java.util.concurrent.ExecutorService;
import java.util.concurrent.Executors;
import java.util.concurrent.TimeUnit;
import java.util.stream.Collectors;

public class BigQueryInformationSchema {
    private static final long METADATA_PAGE_SIZE = 10000L;
    private static final Comparator<String> STRING_COMPARATOR = Comparator.nullsFirst(String::compareTo);
    private static final Comparator<DatasetId> DATASET_COMPARATOR = (d1, d2) -> {
        int order = STRING_COMPARATOR.compare(d1.getProject(), d2.getProject());
        return order != 0 ? order : STRING_COMPARATOR.compare(d1.getDataset(), d2.getDataset());
    };
    private static final Comparator<TableInfo> TABLE_COMPARATOR = (t1, t2) -> {
        int order = STRING_COMPARATOR.compare(t1.tableId.getProject(), t2.tableId.getProject());
        if (order == 0 && (order = STRING_COMPARATOR.compare(t1.tableId.getDataset(), t2.tableId.getDataset())) == 0) {
            order = STRING_COMPARATOR.compare(t1.tableId.getTable(), t2.tableId.getTable());
        }
        return order;
    };
    private final BigQueryJdbcConnection connection;
    private static final DKULogger logger = DKULogger.getLogger((String)"dku.sql.bigquery.jdbc");

    public BigQueryInformationSchema(BigQueryJdbcConnection connection) {
        this.connection = connection;
    }

    public Iterable<ProjectList.Projects> listProjects() throws SQLException {
        try {
            return this.connection.getBigQueryClient().listProjects();
        }
        catch (BigQueryException e) {
            throw new SQLException("Unable to list BigQuery projects", e);
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public List<DatasetId> listDatasetsIds(String projectIdPattern, String datasetIdPattern) throws SQLException {
        List<String> projectIds;
        if (projectIdPattern != null && !projectIdPattern.contains("%")) {
            projectIds = Collections.singletonList(projectIdPattern);
        } else {
            logger.debug((Object)("Listing all BigQuery projects" + (String)(projectIdPattern == null ? "" : " matching " + projectIdPattern)));
            projectIds = Lists.newArrayList(this.listProjects()).stream().map(ProjectList.Projects::getId).filter(projectId -> projectIdPattern == null || SqlLikePatternMatcher.matches(projectId, projectIdPattern)).collect(Collectors.toList());
        }
        ArrayList<DatasetId> datasetsIds = new ArrayList<DatasetId>();
        if (projectIds.size() == 1) {
            datasetsIds.addAll(this.listDatasetsInProject(projectIds.get(0), datasetIdPattern));
        } else if (projectIds.size() > 1) {
            ExecutorService executorService = BigQueryInformationSchema.newExecutorService("BigQueryGetDatasets-%d");
            List threadSafeDatasetsIds = Collections.synchronizedList(new ArrayList());
            logger.debug((Object)("Listing all BigQuery projects" + (String)(projectIdPattern == null ? "" : " matching " + projectIdPattern)));
            for (String projectId2 : projectIds) {
                executorService.submit(() -> {
                    try {
                        threadSafeDatasetsIds.addAll(this.listDatasetsInProject(projectId2, datasetIdPattern));
                    }
                    catch (BigQueryException | SQLException e) {
                        logger.warn((Object)("Unable to list BigQuery datasets of project " + projectId2), e);
                    }
                });
            }
            BigQueryInformationSchema.shutdownExecutor(executorService);
            List list = threadSafeDatasetsIds;
            synchronized (list) {
                datasetsIds.addAll(threadSafeDatasetsIds);
            }
        }
        datasetsIds.sort(DATASET_COMPARATOR);
        return datasetsIds;
    }

    public List<TableInfo> listTablesInfo(String projectIdPattern, String datasetIdPattern, String tableNamePattern) throws SQLException {
        List<DatasetId> datasetsIds = this.listDatasetsIds(projectIdPattern, datasetIdPattern);
        ListTableInfoAggregator resultAggregator = new ListTableInfoAggregator();
        if (datasetsIds.size() == 1) {
            this.listTablesInfoFromDataset(datasetsIds.get(0), tableNamePattern, resultAggregator);
        } else if (datasetsIds.size() > 1) {
            ExecutorService executorService = BigQueryInformationSchema.newExecutorService("BigQueryGetTables-%d");
            for (DatasetId datasetId : datasetsIds) {
                executorService.submit(() -> this.listTablesInfoFromDataset(datasetId, tableNamePattern, resultAggregator));
            }
            BigQueryInformationSchema.shutdownExecutor(executorService);
        }
        return resultAggregator.compute();
    }

    private List<DatasetId> listDatasetsInProject(String projectId, String datasetIdPattern) throws SQLException {
        if (datasetIdPattern == null || datasetIdPattern.contains("%")) {
            logger.debug((Object)("Listing all BigQuery datasets in project " + projectId));
            return this.listDatasets(projectId).stream().map(DatasetInfo::getDatasetId).filter(datasetId -> datasetIdPattern == null || SqlLikePatternMatcher.matches(datasetId.getDataset(), datasetIdPattern)).collect(Collectors.toList());
        }
        logger.debug((Object)("Checking that BigQuery dataset " + datasetIdPattern + " exists in project " + projectId));
        DatasetId datasetId2 = DatasetId.of((String)projectId, (String)datasetIdPattern);
        return this.connection.getBigQueryClient().hasDataset(datasetId2) ? Collections.singletonList(datasetId2) : Collections.emptyList();
    }

    private void listTablesInfoFromDataset(DatasetId datasetId, String tableNamePattern, ListTableInfoAggregator resultAggregator) {
        try {
            resultAggregator.addResult(this.listTablesInfoFromDataset(datasetId, tableNamePattern));
        }
        catch (SQLException exception) {
            resultAggregator.addResult(exception);
        }
    }

    private List<TableInfo> listTablesInfoFromDataset(DatasetId datasetId, String tableNamePattern) throws SQLException {
        logger.debug((Object)("Listing all BigQuery tables in dataset " + BigQueryInformationSchema.toPrettyString(datasetId)));
        List<QueryParameter> parameters = null;
        Object query = "SELECT\n  tbl.TABLE_CATALOG AS CATALOG,\n  tbl.TABLE_SCHEMA AS SCHEMA,\n  tbl.TABLE_NAME AS NAME,\n  tbl.TABLE_TYPE AS TYPE,\n  opt.DESCRIPTION AS DESCRIPTION\nFROM\n  INFORMATION_SCHEMA.TABLES AS tbl\nLEFT JOIN (\n  SELECT\n    TABLE_CATALOG,\n    TABLE_SCHEMA,\n    TABLE_NAME,\n    OPTION_VALUE AS DESCRIPTION,\n  FROM\n    INFORMATION_SCHEMA.TABLE_OPTIONS\n  WHERE\n    OPTION_NAME='description') AS opt\nON\n  opt.TABLE_CATALOG=tbl.TABLE_CATALOG\n  AND opt.TABLE_SCHEMA=tbl.TABLE_SCHEMA\n  AND opt.TABLE_NAME=tbl.TABLE_NAME";
        if (tableNamePattern != null && !"%".equals(tableNamePattern)) {
            query = (String)query + " WHERE tbl.TABLE_NAME " + (tableNamePattern.contains("%") ? "LIKE" : "=") + " ?";
            parameters = Arrays.asList(new QueryParameter(tableNamePattern, StandardSQLTypeName.STRING));
        }
        try {
            QueryResult queryResult = this.connection.getBigQueryClient().executeQuery(datasetId, (String)query, parameters, false, 10000L);
            ArrayList<TableInfo> result = new ArrayList<TableInfo>();
            for (FieldValueList row : queryResult.tableResult.iterateAll()) {
                String catalog = BigQueryInformationSchema.getColumnValue(row, "CATALOG");
                String schema = BigQueryInformationSchema.getColumnValue(row, "SCHEMA");
                String tableName = BigQueryInformationSchema.getColumnValue(row, "NAME");
                String tableType = BigQueryInformationSchema.convertToTableType(BigQueryInformationSchema.getColumnValue(row, "TYPE"));
                String description = BigQueryInformationSchema.getColumnValue(row, "DESCRIPTION");
                if (tableName != null && description != null && description.startsWith("\"") && description.endsWith("\"")) {
                    description = description.substring(1, description.length() - 1).replace("\\\"", "\"").replace("\\\\", "\\");
                }
                if (catalog == null) {
                    logger.warnV("Missing catalog in returned response for row: datasetId=%s, tableName=%s, tableType=%s", new Object[]{schema, tableName, tableType});
                    continue;
                }
                result.add(new TableInfo(TableId.of((String)catalog, (String)schema, (String)tableName), tableType, description));
            }
            return result;
        }
        catch (BigQueryException e) {
            if (e.getCode() == 403) {
                logger.infoV("Missing permissions to list tables from dataset %s: %s", new Object[]{BigQueryInformationSchema.toPrettyString(datasetId), e.getMessage()});
                return Collections.emptyList();
            }
            throw new SQLException("Unable to list tables from dataset " + BigQueryInformationSchema.toPrettyString(datasetId), e);
        }
    }

    private List<Dataset> listDatasets(String projectId) throws SQLException {
        try {
            return this.connection.getBigQueryClient().listDatasets(projectId);
        }
        catch (BigQueryException e) {
            if (e.getCode() == 404) {
                return Collections.emptyList();
            }
            throw new SQLException("Unable to list BigQuery datasets of project " + projectId, e);
        }
    }

    static ExecutorService newExecutorService(String nameFormat) {
        return Executors.newFixedThreadPool(16, new ThreadFactoryBuilder().setNameFormat(nameFormat).build());
    }

    static void shutdownExecutor(ExecutorService executorService) throws SQLException {
        executorService.shutdown();
        try {
            if (!executorService.awaitTermination(60L, TimeUnit.MINUTES)) {
                executorService.shutdownNow();
                throw new SQLException("Timeout while listing BigQuery tables");
            }
        }
        catch (InterruptedException e) {
            Thread.currentThread().interrupt();
            executorService.shutdownNow();
            throw new SQLException("Interrupted while listing BigQuery objects", e);
        }
    }

    static String toPrettyString(DatasetId datasetId) {
        if (datasetId == null) {
            return "null";
        }
        return datasetId.getProject() + "." + datasetId.getDataset();
    }

    private static String convertToTableType(String type) {
        if ("BASE TABLE".equalsIgnoreCase(type)) {
            return "TABLE";
        }
        return type;
    }

    private static String getColumnValue(FieldValueList row, String columnName) {
        FieldValue fieldValue = row.get(columnName);
        return fieldValue.isNull() ? null : fieldValue.getStringValue();
    }

    private static class ListTableInfoAggregator {
        private SQLException exception;
        private boolean hasResult;
        private final List<TableInfo> tables = new ArrayList<TableInfo>();

        private ListTableInfoAggregator() {
        }

        public synchronized void addResult(List<TableInfo> result) {
            this.hasResult = true;
            this.tables.addAll(result);
        }

        public synchronized void addResult(SQLException exception) {
            this.exception = exception;
        }

        public synchronized List<TableInfo> compute() throws SQLException {
            if (!this.hasResult && this.exception != null) {
                throw this.exception;
            }
            this.tables.sort(TABLE_COMPARATOR);
            return this.tables;
        }
    }

    public static class TableInfo {
        public final TableId tableId;
        public final String tableType;
        public final String description;

        public TableInfo(TableId tableId, String tableType, String description) {
            this.tableId = tableId;
            this.tableType = tableType;
            this.description = description;
        }
    }
}

