/*
 * Decompiled with CFR 0.152.
 */
package com.dataiku.dip.containers.exec;

import com.dataiku.dip.DKUApp;
import com.dataiku.dip.containers.exec.ContainerExecUtils;
import com.dataiku.dip.server.SpringUtils;
import com.dataiku.dip.transactions.fs.RelFile;
import com.dataiku.dip.transactions.fs.utils.NativeCache;
import com.dataiku.dip.utils.DKULogger;
import com.dataiku.dip.utils.DKUtils;
import java.io.File;
import java.io.IOException;
import java.util.ArrayList;
import java.util.List;
import java.util.Objects;
import java.util.Set;
import java.util.UUID;
import java.util.stream.Collectors;
import org.quartz.DisallowConcurrentExecution;
import org.quartz.Job;
import org.quartz.JobExecutionContext;
import org.quartz.JobExecutionException;
import org.springframework.beans.factory.annotation.Autowired;
import org.springframework.stereotype.Service;

@Service
public class ContainerExecImagesDeleterService {
    private NativeCache.CachedReadWriteFS cache;
    private static final RelFile IMAGES_DELETE_PATH = new RelFile(RelFile.global((String)"run"), new String[]{"images-to-delete.json"});
    private static final DKULogger logger = DKULogger.getLogger((String)"dku.containers.imagedeleter");

    public ContainerExecImagesDeleterService() {
        try {
            this.cache = NativeCache.build((File)DKUApp.getBaseFolderF());
        }
        catch (IOException e) {
            logger.error((Object)"Fail to build a native cache", (Throwable)e);
        }
    }

    public void addImagesToDelete(Set<String> images, ContainerExecUtils.ContainerBuildConfig config) throws IOException {
        ImagesToDelete imagesToDelete = new ImagesToDelete();
        imagesToDelete.timestamp = System.currentTimeMillis();
        imagesToDelete.images = images;
        if (config != null && !ContainerExecUtils.ContainerBuildConfig.isImageBuiltLocally(config)) {
            imagesToDelete.dockerHost = config.dockerHost;
            imagesToDelete.dockerCertPath = config.dockerCertPath;
            imagesToDelete.dockerTLSVerify = config.dockerTLSVerify;
        }
        if (this.cache == null) {
            this.deleteImages(imagesToDelete);
        } else {
            this.save(imagesToDelete);
        }
    }

    private void deleteImages(ImagesToDelete toDelete) {
        for (String imageToDelete : toDelete.images) {
            try {
                logger.info((Object)("Trying to delete (old) image tag " + imageToDelete));
                ProcessBuilder pb = new ProcessBuilder("docker", "rmi", imageToDelete);
                ContainerExecUtils.enrichDockerEnv(toDelete.dockerHost, toDelete.dockerTLSVerify, toDelete.dockerCertPath, pb.environment());
                DKUtils.execAndLogThrows((ProcessBuilder)pb);
            }
            catch (Exception ex) {
                logger.error((Object)"Could not delete old Docker image", (Throwable)ex);
            }
        }
    }

    private synchronized void save(ImagesToDelete images) throws IOException {
        logger.info((Object)String.format("Saving %d old images to delete ", images.images.size()));
        AllImagesToDelete read = this.cache.exists(IMAGES_DELETE_PATH) ? (AllImagesToDelete)this.cache.readObject(IMAGES_DELETE_PATH, AllImagesToDelete.class) : new AllImagesToDelete();
        read.add(images);
        this.cache.writeObject(IMAGES_DELETE_PATH, (Object)read);
    }

    private synchronized void remove(List<ImagesToDelete> images) throws IOException {
        if (images.isEmpty()) {
            return;
        }
        AllImagesToDelete read = this.cache.exists(IMAGES_DELETE_PATH) ? (AllImagesToDelete)this.cache.readObject(IMAGES_DELETE_PATH, AllImagesToDelete.class) : new AllImagesToDelete();
        for (ImagesToDelete image : images) {
            read.images.remove(image);
        }
        this.cache.writeObject(IMAGES_DELETE_PATH, (Object)read);
    }

    private synchronized AllImagesToDelete read() throws IOException {
        return this.cache != null && this.cache.exists(IMAGES_DELETE_PATH) ? (AllImagesToDelete)this.cache.readObject(IMAGES_DELETE_PATH, AllImagesToDelete.class) : new AllImagesToDelete();
    }

    public static class ImagesToDelete {
        UUID uuid = UUID.randomUUID();
        long timestamp;
        Set<String> images;
        String dockerHost;
        boolean dockerTLSVerify;
        String dockerCertPath;

        boolean sameHost(ImagesToDelete imagestoDelete) {
            return Objects.equals(this.dockerHost, imagestoDelete.dockerHost) && Objects.equals(this.dockerTLSVerify, imagestoDelete.dockerTLSVerify) && Objects.equals(this.dockerCertPath, imagestoDelete.dockerCertPath);
        }

        public boolean equals(Object o) {
            if (this == o) {
                return true;
            }
            if (o == null || this.getClass() != o.getClass()) {
                return false;
            }
            ImagesToDelete that = (ImagesToDelete)o;
            return Objects.equals(this.uuid, that.uuid);
        }

        public int hashCode() {
            return Objects.hashCode(this.uuid);
        }
    }

    public static class AllImagesToDelete {
        List<ImagesToDelete> images = new ArrayList<ImagesToDelete>();

        void add(ImagesToDelete imagestoDelete) {
            for (ImagesToDelete image : this.images) {
                if (!image.sameHost(imagestoDelete)) continue;
                imagestoDelete.images.removeAll(image.images);
                if (!imagestoDelete.images.isEmpty()) continue;
                return;
            }
            this.images.add(imagestoDelete);
        }
    }

    @DisallowConcurrentExecution
    public static class ImagesDeleter
    implements Job {
        private static final int TTL = DKUApp.getProperty((String)"dku.containers.imagesDeleteTTL.ms", (int)21600000);
        @Autowired
        private ContainerExecImagesDeleterService imagesDeleteService;

        public ImagesDeleter() {
            SpringUtils.getInstance().autowire((Object)this);
        }

        public void execute(JobExecutionContext jec) throws JobExecutionException {
            try {
                long now = System.currentTimeMillis();
                AllImagesToDelete images = this.imagesDeleteService.read();
                logger.info((Object)"Checking old images to delete...");
                List<ImagesToDelete> toDelete = images.images.stream().filter(s -> now - s.timestamp > (long)TTL).collect(Collectors.toList());
                for (ImagesToDelete image : toDelete) {
                    this.imagesDeleteService.deleteImages(image);
                }
                this.imagesDeleteService.remove(toDelete);
                logger.info((Object)"Done old images deletion");
            }
            catch (IOException e) {
                logger.error((Object)"Fail checking for old images deletion", (Throwable)e);
            }
        }
    }
}

