/*
 * Decompiled with CFR 0.152.
 */
package com.dataiku.dip.datadirectories;

import com.dataiku.dip.datadirectories.DataDirectoriesFootprintModel;
import java.io.File;
import java.nio.file.Path;
import java.util.ArrayList;
import java.util.Arrays;
import java.util.List;
import java.util.regex.Matcher;
import java.util.regex.Pattern;
import org.apache.commons.lang.StringUtils;

public class DataDirectoriesBucketer {
    public static Pattern PROJECT_KEY_PATTERN = Pattern.compile("^[A-Za-z0-9_]+$");
    public static Pattern CODE_ENV_PATTERN = Pattern.compile("^[_A-Za-z0-9-]+$");

    public static Bucket transformRecursively(Bucket bucket, BucketVisitor visitor, NodeBucketSimplifier simplifier) {
        if (bucket instanceof NodeBucket) {
            NodeBucket nodeBucket = (NodeBucket)bucket;
            List<Bucket> transformed = nodeBucket.children.stream().map(b -> DataDirectoriesBucketer.transformRecursively(b, visitor, simplifier)).toList();
            return simplifier.simplify(nodeBucket, transformed);
        }
        if (bucket instanceof AggregatingBucket) {
            AggregatingBucket aggregatingBucket = (AggregatingBucket)bucket;
            return visitor.apply(aggregatingBucket);
        }
        throw new IllegalArgumentException("Bucket type " + String.valueOf(bucket.getClass()) + " is not supported");
    }

    public static abstract class NodeBucket
    implements Bucket {
        private final List<Bucket> children = new ArrayList<Bucket>();
        protected final BucketingContext context;
        private String previousNodeBucketPath;

        public NodeBucket(BucketingContext context) {
            this.context = context;
        }

        public NodeBucket then(Bucket child) {
            this.children.add(child);
            return this;
        }

        public List<Bucket> possibilities() {
            return this.children;
        }

        @Override
        public boolean recurse() {
            return true;
        }

        @Override
        public void onEnter(Path p) {
            this.previousNodeBucketPath = this.context.currentNodeBucketPath;
            this.context.currentNodeBucketPath = this.buildPathFromParent(StringUtils.defaultIfBlank((String)this.previousNodeBucketPath, (String)""), p);
        }

        @Override
        public void onExit(Path p) {
            this.context.currentNodeBucketPath = this.previousNodeBucketPath;
        }

        protected abstract String buildPathFromParent(String var1, Path var2);

        protected abstract NodeBucket copyWithoutChildren(BucketingContext var1, DataDirectoriesFootprintModel.ProjectFootprint var2);

        protected abstract NodeBucket copyWithoutChildren(BucketingContext var1);

        protected abstract NodeBucket copyWithoutChildren(BucketingContext var1, List<String> var2);
    }

    public static interface BucketVisitor {
        public Bucket apply(AggregatingBucket var1);
    }

    public static interface NodeBucketSimplifier {
        public Bucket simplify(NodeBucket var1, List<Bucket> var2);
    }

    public static interface Bucket {
        public boolean handles(Path var1, boolean var2);

        public void onEnter(Path var1);

        public void onExit(Path var1);

        public boolean recurse();
    }

    public static interface AggregatingBucket
    extends Bucket {
        public void handle(Path var1, long var2, boolean var4);
    }

    public static class UnknownAggregation
    implements AggregatingBucket {
        private final BucketingContext context;

        public UnknownAggregation(BucketingContext context) {
            this.context = context;
        }

        @Override
        public boolean handles(Path p, boolean isFile) {
            return true;
        }

        DataDirectoriesFootprintModel.UnknownData getOrStartUnknownData(Path p, boolean isFolder) {
            if (this.context.unknownBucket == null || this.context.unknownBucket != this || this.context.unknownData == null || !p.toString().startsWith(this.context.unknownData.path) || isFolder && !this.context.unknownData.folder && !p.toString().equals(this.context.unknownData.path)) {
                this.context.unknownBucket = this;
                String unknownDataPath = p.toString();
                DataDirectoriesFootprintModel.UnknownData unknownDataToUse = null;
                for (DataDirectoriesFootprintModel.UnknownData known : this.context.global.unknown.items) {
                    if (!known.path.equals(unknownDataPath)) continue;
                    unknownDataToUse = known;
                    break;
                }
                if (unknownDataToUse == null) {
                    unknownDataToUse = new DataDirectoriesFootprintModel.UnknownData();
                    unknownDataToUse.path = unknownDataPath;
                    this.context.global.unknown.items.add(unknownDataToUse);
                }
                this.context.unknownData = unknownDataToUse;
            }
            if (isFolder) {
                if (!this.context.unknownData.folder && this.context.unknownData.files != null) {
                    this.context.unknownData.add(this.context.unknownData.files);
                    this.context.unknownData.files = null;
                }
                this.context.unknownData.folder = true;
            }
            return this.context.unknownData;
        }

        @Override
        public void onEnter(Path p) {
            DataDirectoriesFootprintModel.UnknownData unknownData = this.getOrStartUnknownData(p, true);
            if (!p.toString().equals(unknownData.path)) {
                unknownData.add(0L, true, false);
            }
        }

        @Override
        public void onExit(Path p) {
            if (this.context.unknownData != null && p.toString().equals(this.context.unknownData.path)) {
                this.context.unknownData = null;
            }
        }

        @Override
        public void handle(Path p, long size, boolean hasError) {
            DataDirectoriesFootprintModel.Size aggregate;
            Path parent = p.getParent();
            if (parent == null) {
                parent = new File("").toPath();
            }
            DataDirectoriesFootprintModel.UnknownData unknownData = this.getOrStartUnknownData(parent, false);
            if (unknownData.folder) {
                aggregate = unknownData;
            } else if (parent.toString().equals(this.context.unknownData.path)) {
                if (this.context.unknownData.files == null) {
                    this.context.unknownData.files = new DataDirectoriesFootprintModel.UnknownFiles();
                }
                aggregate = this.context.unknownData.files;
            } else {
                aggregate = unknownData;
            }
            aggregate.add(size, false, hasError);
            if (aggregate instanceof DataDirectoriesFootprintModel.UnknownFiles && ((DataDirectoriesFootprintModel.UnknownFiles)aggregate).names.size() < 10) {
                ((DataDirectoriesFootprintModel.UnknownFiles)aggregate).names.add(p.getFileName().toString());
            }
        }

        @Override
        public boolean recurse() {
            return true;
        }
    }

    public static class PluginAggregation
    extends AggregatingBucketToSizeWithLocation {
        public PluginAggregation(BucketingContext context) {
            super(context);
        }

        @Override
        DataDirectoriesFootprintModel.Size getLeaf() {
            return this.context.plugin;
        }

        @Override
        public boolean handles(Path p, boolean isFile) {
            return true;
        }

        @Override
        public boolean recurse() {
            return true;
        }
    }

    public static class CodeEnvAggregation
    extends AggregatingBucketToSizeWithLocation {
        public CodeEnvAggregation(BucketingContext context) {
            super(context);
        }

        @Override
        DataDirectoriesFootprintModel.Size getLeaf() {
            return this.context.codeEnv;
        }

        @Override
        public boolean handles(Path p, boolean isFile) {
            return true;
        }

        @Override
        public boolean recurse() {
            return true;
        }
    }

    public static class ProjectAggregation
    extends AggregatingBucketToSizeWithLocation {
        private final SizeAccessor<DataDirectoriesFootprintModel.ProjectFootprint> sizeAccessor;

        public ProjectAggregation(BucketingContext context, SizeGetter<DataDirectoriesFootprintModel.ProjectFootprint> sizeGetter, SizeCreator<DataDirectoriesFootprintModel.ProjectFootprint> sizeCreator) {
            this(context, new ProjectSizeFieldAccessor(sizeGetter, sizeCreator));
        }

        public ProjectAggregation(BucketingContext context, SizeAccessor<DataDirectoriesFootprintModel.ProjectFootprint> sizeAccessor) {
            super(context);
            this.sizeAccessor = sizeAccessor;
        }

        @Override
        public boolean handles(Path p, boolean isFile) {
            return true;
        }

        @Override
        DataDirectoriesFootprintModel.Size getLeaf() {
            return this.sizeAccessor.getOrCreate(this.context.project);
        }

        @Override
        public boolean recurse() {
            return true;
        }
    }

    public static class SpecificFilesGlobalAggregation
    extends GlobalAggregation {
        private final Pattern accepts;

        public SpecificFilesGlobalAggregation(BucketingContext context, SizeGetter<DataDirectoriesFootprintModel.DatadirFootprint> sizeGetter, SizeCreator<DataDirectoriesFootprintModel.DatadirFootprint> sizeCreator, String accepts) {
            super(context, new GlobalSizeFieldAccessor(sizeGetter, sizeCreator));
            this.accepts = Pattern.compile(accepts);
        }

        @Override
        public boolean handles(Path p, boolean isFile) {
            return this.accepts.matcher(p.getFileName().toString()).matches();
        }

        @Override
        public boolean recurse() {
            return false;
        }

        @Override
        public void handle(Path p, long size, boolean hasError) {
            DataDirectoriesFootprintModel.Size leaf = this.getLeaf();
            leaf.add(size, false, hasError);
            if (leaf instanceof DataDirectoriesFootprintModel.SizeWithLocation) {
                ((DataDirectoriesFootprintModel.SizeWithLocation)leaf).addLocation(this.context.currentNodeBucketPath + "/" + p.getFileName().toString());
            }
        }
    }

    public static class GlobalAggregation
    extends AggregatingBucketToSizeWithLocation {
        protected final SizeAccessor<DataDirectoriesFootprintModel.DatadirFootprint> sizeAccessor;

        public GlobalAggregation(BucketingContext context, SizeGetter<DataDirectoriesFootprintModel.DatadirFootprint> sizeGetter, SizeCreator<DataDirectoriesFootprintModel.DatadirFootprint> sizeCreator) {
            this(context, new GlobalSizeFieldAccessor(sizeGetter, sizeCreator));
        }

        public GlobalAggregation(BucketingContext context, SizeAccessor<DataDirectoriesFootprintModel.DatadirFootprint> sizeAccessor) {
            super(context);
            this.sizeAccessor = sizeAccessor;
        }

        @Override
        public boolean handles(Path p, boolean isFile) {
            return true;
        }

        @Override
        DataDirectoriesFootprintModel.Size getLeaf() {
            return this.sizeAccessor.getOrCreate(this.context.global);
        }

        @Override
        public boolean recurse() {
            return true;
        }
    }

    public static class TechnicalFiles
    extends BaseAggregatingBucket {
        private final Pattern pattern = Pattern.compile("((\\.ts)|(\\.mainlock)|(\\.wlock))");

        @Override
        public boolean handles(Path p, boolean isFile) {
            return this.pattern.matcher(p.getFileName().toString()).matches();
        }

        @Override
        public void handle(Path p, long size, boolean hasError) {
        }

        @Override
        public boolean recurse() {
            return false;
        }
    }

    public static class SkipLike
    extends AbstractSkip {
        private final Bucket original;

        public SkipLike(Bucket original) {
            this.original = original;
        }

        @Override
        public boolean handles(Path p, boolean isFile) {
            return this.original.handles(p, isFile);
        }
    }

    public static class SkipAll
    extends AbstractSkip {
        @Override
        public boolean handles(Path p, boolean isFile) {
            return true;
        }
    }

    static abstract class AbstractSkip
    extends BaseAggregatingBucket {
        AbstractSkip() {
        }

        @Override
        public void handle(Path p, long size, boolean hasError) {
        }

        @Override
        public boolean recurse() {
            return false;
        }
    }

    public static class Blackhole
    extends BaseAggregatingBucket {
        @Override
        public boolean handles(Path p, boolean isFile) {
            return true;
        }

        @Override
        public void handle(Path p, long size, boolean hasError) {
        }

        @Override
        public boolean recurse() {
            return true;
        }
    }

    public static class PluginList
    extends NodeBucket {
        public PluginList(BucketingContext context) {
            super(context);
        }

        @Override
        public boolean handles(Path p, boolean isFile) {
            if (isFile) {
                return false;
            }
            String pluginName = p.getFileName().toString();
            DataDirectoriesFootprintModel.PluginFootprint plugin = null;
            if (this.context.global.plugins == null) {
                this.context.global.plugins = new DataDirectoriesFootprintModel.Sizes();
            }
            List plugins = this.context.global.plugins.items;
            for (DataDirectoriesFootprintModel.PluginFootprint footprint : plugins) {
                if (!pluginName.equals(footprint.name)) continue;
                plugin = footprint;
            }
            if (plugin == null) {
                plugin = new DataDirectoriesFootprintModel.PluginFootprint();
                plugin.name = pluginName;
                plugin.type = p.getParent().getFileName().toString();
                plugins.add(plugin);
            }
            this.context.plugin = plugin;
            return true;
        }

        @Override
        public void onExit(Path p) {
            super.onExit(p);
            this.context.plugin = null;
        }

        @Override
        protected String buildPathFromParent(String parentPath, Path p) {
            return parentPath + "/" + (this.context.plugin != null ? this.context.plugin.name : p.getFileName().toString());
        }

        @Override
        protected NodeBucket copyWithoutChildren(BucketingContext context, DataDirectoriesFootprintModel.ProjectFootprint project) {
            return new PluginList(context);
        }

        @Override
        protected NodeBucket copyWithoutChildren(BucketingContext context) {
            return new PluginList(context);
        }

        @Override
        protected NodeBucket copyWithoutChildren(BucketingContext context, List<String> projectKeys) {
            return new PluginList(context);
        }
    }

    public static class CodeEnvList
    extends NodeBucket {
        public CodeEnvList(BucketingContext context) {
            super(context);
        }

        @Override
        public boolean handles(Path p, boolean isFile) {
            if (isFile) {
                return false;
            }
            String codeEnvName = p.getFileName().toString();
            if (!CODE_ENV_PATTERN.matcher(codeEnvName).matches()) {
                return false;
            }
            DataDirectoriesFootprintModel.CodeEnvFootprint codeEnv = null;
            if (this.context.global.codeEnvs == null) {
                this.context.global.codeEnvs = new DataDirectoriesFootprintModel.Sizes();
            }
            List codeEnvs = this.context.global.codeEnvs.items;
            for (DataDirectoriesFootprintModel.CodeEnvFootprint footprint : codeEnvs) {
                if (!codeEnvName.equals(footprint.name)) continue;
                codeEnv = footprint;
            }
            if (codeEnv == null) {
                codeEnv = new DataDirectoriesFootprintModel.CodeEnvFootprint();
                codeEnv.name = codeEnvName;
                codeEnv.language = p.getParent().getFileName().toString();
                codeEnvs.add(codeEnv);
            }
            this.context.codeEnv = codeEnv;
            return true;
        }

        @Override
        public void onExit(Path p) {
            super.onExit(p);
            this.context.codeEnv = null;
        }

        @Override
        protected String buildPathFromParent(String parentPath, Path p) {
            return parentPath + "/" + (this.context.codeEnv != null ? this.context.codeEnv.name : p.getFileName().toString());
        }

        @Override
        protected NodeBucket copyWithoutChildren(BucketingContext context, DataDirectoriesFootprintModel.ProjectFootprint project) {
            return new CodeEnvList(context);
        }

        @Override
        protected NodeBucket copyWithoutChildren(BucketingContext context) {
            return new CodeEnvList(context);
        }

        @Override
        protected NodeBucket copyWithoutChildren(BucketingContext context, List<String> projectKeys) {
            return new CodeEnvList(context);
        }
    }

    public static class SingleProjectUnderscoreStuff
    extends AbstractSingleProjectByPrefix {
        public SingleProjectUnderscoreStuff(BucketingContext context, DataDirectoriesFootprintModel.ProjectFootprint project) {
            super(context, project);
        }

        @Override
        String makeExpectedPrefix() {
            return this.project.projectKey + "_";
        }

        @Override
        protected String buildPathFromParent(String parentPath, Path p) {
            return parentPath + "/" + (this.context.project != null ? this.context.project.projectKey : p.getFileName().toString()) + "_*";
        }

        @Override
        protected NodeBucket copyWithoutChildren(BucketingContext context, DataDirectoriesFootprintModel.ProjectFootprint project) {
            return new SingleProjectUnderscoreStuff(context, project);
        }

        @Override
        protected NodeBucket copyWithoutChildren(BucketingContext context) {
            return new SingleProjectUnderscoreStuff(context, this.project);
        }
    }

    public static class SingleProjectDotStuff
    extends AbstractSingleProjectByPrefix {
        public SingleProjectDotStuff(BucketingContext context, DataDirectoriesFootprintModel.ProjectFootprint project) {
            super(context, project);
        }

        @Override
        String makeExpectedPrefix() {
            return this.project.projectKey + ".";
        }

        @Override
        protected String buildPathFromParent(String parentPath, Path p) {
            return parentPath + "/" + (this.context.project != null ? this.context.project.projectKey : p.getFileName().toString()) + ".*";
        }

        @Override
        protected NodeBucket copyWithoutChildren(BucketingContext context, DataDirectoriesFootprintModel.ProjectFootprint project) {
            return new SingleProjectDotStuff(context, project);
        }

        @Override
        protected NodeBucket copyWithoutChildren(BucketingContext context) {
            return new SingleProjectDotStuff(context, this.project);
        }
    }

    public static class SingleProject
    extends AbstractSingleProject {
        public SingleProject(BucketingContext context, DataDirectoriesFootprintModel.ProjectFootprint project) {
            super(context, project);
        }

        @Override
        public boolean handlesFolderName(String name) {
            return this.project.projectKey.equals(name);
        }

        @Override
        protected String buildPathFromParent(String parentPath, Path p) {
            return parentPath + "/" + (this.context.project != null ? this.context.project.projectKey : p.getFileName().toString());
        }

        @Override
        protected NodeBucket copyWithoutChildren(BucketingContext context, DataDirectoriesFootprintModel.ProjectFootprint project) {
            return new SingleProject(context, project);
        }

        @Override
        protected NodeBucket copyWithoutChildren(BucketingContext context) {
            return new SingleProject(context, this.project);
        }
    }

    static abstract class AbstractSingleProjectByPrefix
    extends AbstractSingleProject {
        protected final String expectedPrefix = this.makeExpectedPrefix();

        public AbstractSingleProjectByPrefix(BucketingContext context, DataDirectoriesFootprintModel.ProjectFootprint project) {
            super(context, project);
        }

        abstract String makeExpectedPrefix();

        @Override
        public boolean handlesFolderName(String name) {
            return name.startsWith(this.expectedPrefix);
        }
    }

    public static abstract class AbstractSingleProject
    extends NodeBucket {
        final DataDirectoriesFootprintModel.ProjectFootprint project;

        public AbstractSingleProject(BucketingContext context, DataDirectoriesFootprintModel.ProjectFootprint project) {
            super(context);
            this.project = project;
        }

        abstract boolean handlesFolderName(String var1);

        @Override
        public boolean handles(Path p, boolean isFile) {
            if (isFile) {
                return false;
            }
            if (this.handlesFolderName(p.getFileName().toString())) {
                this.context.project = this.project;
                return true;
            }
            return false;
        }

        @Override
        public void onExit(Path p) {
            super.onExit(p);
            this.context.project = null;
        }

        @Override
        protected NodeBucket copyWithoutChildren(BucketingContext context, List<String> projectKeys) {
            throw new UnsupportedOperationException("Cannot filter by project then projects");
        }
    }

    public static class ProjectUnderscoreStuffList
    extends AbstractProjectList {
        public ProjectUnderscoreStuffList(BucketingContext context, List<String> projectKeys) {
            super(context, projectKeys);
        }

        @Override
        public boolean handles(Path p, boolean isFile) {
            boolean known;
            if (isFile) {
                return false;
            }
            String projectKeyStuffName = p.getFileName().toString();
            String projectKey = null;
            for (String test : this.projectKeys) {
                if (!projectKeyStuffName.startsWith(test + "_")) continue;
                projectKey = test;
                break;
            }
            if (projectKey == null) {
                known = false;
                if (this.context.unknownProjects == null) {
                    return false;
                }
                String[] parts = projectKeyStuffName.split("_");
                for (int l = 1; l < parts.length; ++l) {
                    String test = String.join((CharSequence)"_", Arrays.copyOf(parts, l));
                    if (!this.projectKeys.stream().noneMatch(test::startsWith)) continue;
                    projectKey = test;
                    break;
                }
                if (projectKey == null) {
                    return false;
                }
            } else {
                known = true;
            }
            if (!PROJECT_KEY_PATTERN.matcher(projectKey).matches()) {
                return false;
            }
            this.handlesInternal(projectKey, known);
            return true;
        }

        @Override
        protected String buildPathFromParent(String parentPath, Path p) {
            return parentPath + "/" + (this.context.project != null ? this.context.project.projectKey : p.getFileName().toString()) + "_*";
        }

        @Override
        protected NodeBucket copyWithoutChildren(BucketingContext context, DataDirectoriesFootprintModel.ProjectFootprint project) {
            return new SingleProjectUnderscoreStuff(context, project);
        }

        @Override
        protected NodeBucket copyWithoutChildren(BucketingContext context) {
            return new ProjectUnderscoreStuffList(context, this.projectKeys);
        }

        @Override
        protected NodeBucket copyWithoutChildren(BucketingContext context, List<String> projectKeys) {
            return new ProjectUnderscoreStuffList(context, projectKeys);
        }
    }

    public static class ProjectDotStuffList
    extends AbstractProjectList {
        private final Pattern namePattern = Pattern.compile("([^.]+)\\.(.*)");

        public ProjectDotStuffList(BucketingContext context, List<String> projectKeys) {
            super(context, projectKeys);
        }

        @Override
        public boolean handles(Path p, boolean isFile) {
            if (isFile) {
                return false;
            }
            String projectKeyStuffName = p.getFileName().toString();
            Matcher matcher = this.namePattern.matcher(projectKeyStuffName);
            if (!matcher.matches()) {
                return false;
            }
            String projectKey = matcher.group(1);
            if (!PROJECT_KEY_PATTERN.matcher(projectKey).matches()) {
                return false;
            }
            boolean known = this.projectKeys.contains(projectKey);
            this.handlesInternal(projectKey, known);
            return true;
        }

        @Override
        protected String buildPathFromParent(String parentPath, Path p) {
            return parentPath + "/" + (this.context.project != null ? this.context.project.projectKey : p.getFileName().toString()) + ".*";
        }

        @Override
        protected NodeBucket copyWithoutChildren(BucketingContext context, DataDirectoriesFootprintModel.ProjectFootprint project) {
            return new SingleProjectDotStuff(context, project);
        }

        @Override
        protected NodeBucket copyWithoutChildren(BucketingContext context) {
            return new ProjectDotStuffList(context, this.projectKeys);
        }

        @Override
        protected NodeBucket copyWithoutChildren(BucketingContext context, List<String> projectKeys) {
            return new ProjectDotStuffList(context, projectKeys);
        }
    }

    public static class ProjectList
    extends AbstractProjectList {
        public ProjectList(BucketingContext context, List<String> projectKeys) {
            super(context, projectKeys);
        }

        @Override
        public boolean handles(Path p, boolean isFile) {
            if (isFile) {
                return false;
            }
            String projectKey = p.getFileName().toString();
            if (!PROJECT_KEY_PATTERN.matcher(projectKey).matches()) {
                return false;
            }
            boolean known = this.projectKeys.contains(projectKey);
            this.handlesInternal(projectKey, known);
            return true;
        }

        @Override
        protected String buildPathFromParent(String parentPath, Path p) {
            return parentPath + "/" + (this.context.project != null ? this.context.project.projectKey : p.getFileName().toString());
        }

        @Override
        protected NodeBucket copyWithoutChildren(BucketingContext context, DataDirectoriesFootprintModel.ProjectFootprint project) {
            return new SingleProject(context, project);
        }

        @Override
        protected NodeBucket copyWithoutChildren(BucketingContext context) {
            return new ProjectList(context, this.projectKeys);
        }

        @Override
        protected NodeBucket copyWithoutChildren(BucketingContext context, List<String> projectKeys) {
            return new ProjectList(context, projectKeys);
        }
    }

    static abstract class AbstractProjectList
    extends NodeBucket {
        final List<String> projectKeys;

        public AbstractProjectList(BucketingContext context, List<String> projectKeys) {
            super(context);
            this.projectKeys = projectKeys;
        }

        void handlesInternal(String projectKey, boolean known) {
            if (known && this.context.knownProjects == null || !known && this.context.unknownProjects == null) {
                this.context.project = new DataDirectoriesFootprintModel.ProjectFootprint();
                this.context.project.projectKey = projectKey;
                return;
            }
            DataDirectoriesFootprintModel.Sizes<DataDirectoriesFootprintModel.ProjectFootprint> projectsHolder = known ? this.context.knownProjects : this.context.unknownProjects;
            DataDirectoriesFootprintModel.ProjectFootprint project = null;
            for (DataDirectoriesFootprintModel.ProjectFootprint footprint : projectsHolder.items) {
                if (!projectKey.equals(footprint.projectKey)) continue;
                project = footprint;
            }
            if (project == null) {
                project = new DataDirectoriesFootprintModel.ProjectFootprint();
                project.projectKey = projectKey;
                projectsHolder.items.add(project);
            }
            this.context.project = project;
        }

        @Override
        public void onExit(Path p) {
            super.onExit(p);
            this.context.project = null;
        }

        @Override
        public boolean recurse() {
            return this.context.project == null || this.context.project.projectKey == null || this.context.knownProjects != null && this.projectKeys.contains(this.context.project.projectKey) || this.context.unknownProjects != null && !this.projectKeys.contains(this.context.project.projectKey);
        }
    }

    public static class SomeFolderByPattern
    extends NodeBucket {
        private final String patternStr;
        private final boolean keepPattern;
        private final Pattern pattern;

        public SomeFolderByPattern(BucketingContext context, String pattern, boolean keepPattern) {
            super(context);
            this.patternStr = pattern;
            this.keepPattern = keepPattern;
            this.pattern = Pattern.compile(pattern);
        }

        public SomeFolderByPattern(BucketingContext context, Pattern pattern, String patternStr, boolean keepPattern) {
            super(context);
            this.patternStr = patternStr;
            this.keepPattern = keepPattern;
            this.pattern = pattern;
        }

        @Override
        public boolean handles(Path p, boolean isFile) {
            return !isFile && this.pattern.matcher(p.getFileName().toString()).matches();
        }

        @Override
        protected String buildPathFromParent(String parentPath, Path p) {
            if (this.keepPattern) {
                return parentPath + "/" + this.patternStr.replace(".*", "*");
            }
            return parentPath + "/" + p.getFileName().toString();
        }

        @Override
        protected NodeBucket copyWithoutChildren(BucketingContext context, DataDirectoriesFootprintModel.ProjectFootprint project) {
            return new SomeFolderByPattern(context, this.pattern, this.patternStr, this.keepPattern);
        }

        @Override
        protected NodeBucket copyWithoutChildren(BucketingContext context) {
            return new SomeFolderByPattern(context, this.pattern, this.patternStr, this.keepPattern);
        }

        @Override
        protected NodeBucket copyWithoutChildren(BucketingContext context, List<String> projectKeys) {
            return new SomeFolderByPattern(context, this.pattern, this.patternStr, this.keepPattern);
        }
    }

    public static class SomeFolder
    extends NodeBucket {
        private final String name;

        public SomeFolder(BucketingContext context, String name) {
            super(context);
            this.name = name;
        }

        @Override
        public boolean handles(Path p, boolean isFile) {
            return !isFile && this.name.equals(p.getFileName().toString());
        }

        @Override
        protected String buildPathFromParent(String parentPath, Path p) {
            return parentPath + "/" + this.name;
        }

        @Override
        protected NodeBucket copyWithoutChildren(BucketingContext context, DataDirectoriesFootprintModel.ProjectFootprint project) {
            return new SomeFolder(context, this.name);
        }

        @Override
        protected NodeBucket copyWithoutChildren(BucketingContext context) {
            return new SomeFolder(context, this.name);
        }

        @Override
        protected NodeBucket copyWithoutChildren(BucketingContext context, List<String> projectKeys) {
            return new SomeFolder(context, this.name);
        }
    }

    public static class DatadirRoot
    extends NodeBucket {
        public DatadirRoot(BucketingContext context) {
            super(context);
        }

        @Override
        public boolean handles(Path p, boolean isFile) {
            return p.getNameCount() == 0 || p.getNameCount() == 1 && (p.getFileName() == null || p.getFileName().toString().isEmpty());
        }

        @Override
        protected String buildPathFromParent(String parentPath, Path p) {
            return "";
        }

        @Override
        protected NodeBucket copyWithoutChildren(BucketingContext context, DataDirectoriesFootprintModel.ProjectFootprint project) {
            return new DatadirRoot(context);
        }

        @Override
        protected NodeBucket copyWithoutChildren(BucketingContext context) {
            return new DatadirRoot(context);
        }

        @Override
        protected NodeBucket copyWithoutChildren(BucketingContext context, List<String> projectKeys) {
            return new DatadirRoot(context);
        }
    }

    public static class ProjectSizeFieldAccessor
    implements SizeAccessor<DataDirectoriesFootprintModel.ProjectFootprint> {
        private final SizeGetter<DataDirectoriesFootprintModel.ProjectFootprint> getter;
        private final SizeCreator<DataDirectoriesFootprintModel.ProjectFootprint> creator;

        public ProjectSizeFieldAccessor(SizeGetter<DataDirectoriesFootprintModel.ProjectFootprint> getter, SizeCreator<DataDirectoriesFootprintModel.ProjectFootprint> creator) {
            this.getter = getter;
            this.creator = creator;
        }

        @Override
        public DataDirectoriesFootprintModel.Size getOrCreate(DataDirectoriesFootprintModel.ProjectFootprint project) {
            DataDirectoriesFootprintModel.Size size = this.getter.get(project);
            if (size == null) {
                this.creator.create(project);
            }
            return this.getter.get(project);
        }
    }

    public static class GlobalSizeFieldAccessor
    implements SizeAccessor<DataDirectoriesFootprintModel.DatadirFootprint> {
        private final SizeGetter<DataDirectoriesFootprintModel.DatadirFootprint> getter;
        private final SizeCreator<DataDirectoriesFootprintModel.DatadirFootprint> creator;

        public GlobalSizeFieldAccessor(SizeGetter<DataDirectoriesFootprintModel.DatadirFootprint> getter, SizeCreator<DataDirectoriesFootprintModel.DatadirFootprint> creator) {
            this.getter = getter;
            this.creator = creator;
        }

        @Override
        public DataDirectoriesFootprintModel.Size getOrCreate(DataDirectoriesFootprintModel.DatadirFootprint global) {
            DataDirectoriesFootprintModel.Size size = this.getter.get(global);
            if (size == null) {
                this.creator.create(global);
            }
            return this.getter.get(global);
        }
    }

    public static interface SizeCreator<T extends DataDirectoriesFootprintModel.GenericFootprint> {
        public void create(T var1);
    }

    public static interface SizeGetter<T extends DataDirectoriesFootprintModel.GenericFootprint> {
        public DataDirectoriesFootprintModel.Size get(T var1);
    }

    public static interface SizeAccessor<T extends DataDirectoriesFootprintModel.GenericFootprint> {
        public DataDirectoriesFootprintModel.Size getOrCreate(T var1);
    }

    public static abstract class AggregatingBucketToSizeWithLocation
    extends BaseAggregatingBucket {
        protected final BucketingContext context;

        AggregatingBucketToSizeWithLocation(BucketingContext context) {
            this.context = context;
        }

        abstract DataDirectoriesFootprintModel.Size getLeaf();

        @Override
        public void handle(Path p, long size, boolean hasError) {
            DataDirectoriesFootprintModel.Size leaf = this.getLeaf();
            leaf.add(size, false, hasError);
            if (leaf instanceof DataDirectoriesFootprintModel.SizeWithLocation) {
                ((DataDirectoriesFootprintModel.SizeWithLocation)leaf).addLocation(this.context.currentNodeBucketPath);
            }
        }

        @Override
        public void onEnter(Path p) {
            DataDirectoriesFootprintModel.Size leaf = this.getLeaf();
            if (leaf != null) {
                leaf.add(0L, true, false);
                if (leaf instanceof DataDirectoriesFootprintModel.SizeWithLocation) {
                    ((DataDirectoriesFootprintModel.SizeWithLocation)leaf).addLocation(this.context.currentNodeBucketPath);
                }
            }
        }
    }

    public static abstract class BaseAggregatingBucket
    implements AggregatingBucket {
        @Override
        public void onEnter(Path p) {
        }

        @Override
        public void onExit(Path p) {
        }
    }

    public static class KnownDataSkipper
    implements NodeBucketSimplifier {
        private final BucketingContext context;

        public KnownDataSkipper(BucketingContext context) {
            this.context = context;
        }

        @Override
        public Bucket simplify(NodeBucket nodeBucket, List<Bucket> transformed) {
            if (transformed.stream().noneMatch(b -> b instanceof UnknownAggregation)) {
                return new SkipLike(nodeBucket);
            }
            NodeBucket ret = nodeBucket.copyWithoutChildren(this.context);
            for (Bucket b2 : transformed) {
                ret = ret.then(b2);
            }
            return ret;
        }
    }

    public static class OrphanProjectsSimplifier
    extends NodeBucketSkipReducer {
        private final BucketingContext context;
        private final List<String> projectKeys;

        public OrphanProjectsSimplifier(BucketingContext context, List<String> projectKeys) {
            this.context = context;
            this.projectKeys = projectKeys;
        }

        @Override
        NodeBucket copy(NodeBucket bucket) {
            return bucket.copyWithoutChildren(this.context, this.projectKeys);
        }
    }

    public static class SingleProjectSimplifier
    extends NodeBucketSkipReducer {
        private final BucketingContext context;
        private final DataDirectoriesFootprintModel.ProjectFootprint project;

        public SingleProjectSimplifier(BucketingContext context, DataDirectoriesFootprintModel.ProjectFootprint project) {
            this.context = context;
            this.project = project;
        }

        @Override
        NodeBucket copy(NodeBucket bucket) {
            return bucket.copyWithoutChildren(this.context, this.project);
        }

        @Override
        public Bucket simplify(NodeBucket nodeBucket, List<Bucket> transformed) {
            if (nodeBucket instanceof AbstractSingleProject) {
                AbstractSingleProject singleProject = (AbstractSingleProject)nodeBucket;
                if (singleProject.project != this.project) {
                    return new SkipAll();
                }
            }
            return super.simplify(nodeBucket, transformed);
        }
    }

    public static class BasicSimplifier
    extends NodeBucketSkipReducer {
        private final BucketingContext context;

        public BasicSimplifier(BucketingContext context) {
            this.context = context;
        }

        @Override
        NodeBucket copy(NodeBucket bucket) {
            return bucket.copyWithoutChildren(this.context);
        }
    }

    static abstract class NodeBucketSkipReducer
    implements NodeBucketSimplifier {
        NodeBucketSkipReducer() {
        }

        abstract NodeBucket copy(NodeBucket var1);

        @Override
        public Bucket simplify(NodeBucket nodeBucket, List<Bucket> transformed) {
            List<Bucket> nonSkipped = transformed.stream().filter(b -> !(b instanceof AbstractSkip)).toList();
            if (!nonSkipped.isEmpty()) {
                Bucket lastNonSkipped = nonSkipped.get(nonSkipped.size() - 1);
                int lastNonSkippedIdx = transformed.indexOf(lastNonSkipped);
                List<Bucket> filtered = transformed.subList(0, lastNonSkippedIdx + 1).stream().filter(b -> !(b instanceof SkipAll)).toList();
                NodeBucket ret = this.copy(nodeBucket);
                for (Bucket b2 : filtered) {
                    ret = ret.then(b2);
                }
                return ret.then(new SkipAll());
            }
            return new SkipLike(nodeBucket);
        }
    }

    public static class KeepUnknownDataVisitor
    implements BucketVisitor {
        private final BucketingContext context;

        public KeepUnknownDataVisitor(BucketingContext context) {
            this.context = context;
        }

        @Override
        public Bucket apply(AggregatingBucket bucket) {
            if (bucket instanceof Blackhole) {
                return new UnknownAggregation(this.context);
            }
            if (bucket instanceof AbstractSkip) {
                return bucket;
            }
            if (bucket instanceof TechnicalFiles) {
                return new SkipLike(bucket);
            }
            if (bucket instanceof SpecificFilesGlobalAggregation) {
                return new SkipLike(bucket);
            }
            if (bucket instanceof UnknownAggregation) {
                return bucket;
            }
            return new SkipAll();
        }
    }

    public static class KeepGlobalDataVisitor
    implements BucketVisitor {
        @Override
        public Bucket apply(AggregatingBucket bucket) {
            if (bucket instanceof GlobalAggregation) {
                return bucket;
            }
            if (bucket instanceof PluginAggregation) {
                return bucket;
            }
            if (bucket instanceof CodeEnvAggregation) {
                return bucket;
            }
            if (bucket instanceof AbstractSkip) {
                return bucket;
            }
            return new SkipAll();
        }
    }

    public static class KeepProjectDataVisitor
    implements BucketVisitor {
        @Override
        public Bucket apply(AggregatingBucket bucket) {
            if (bucket instanceof ProjectAggregation) {
                return bucket;
            }
            if (bucket instanceof AbstractSkip) {
                return bucket;
            }
            return new SkipAll();
        }
    }

    public static class BucketingContext {
        public final DataDirectoriesFootprintModel.DatadirFootprint global;
        public DataDirectoriesFootprintModel.ProjectFootprint project;
        public DataDirectoriesFootprintModel.CodeEnvFootprint codeEnv;
        public DataDirectoriesFootprintModel.PluginFootprint plugin;
        public DataDirectoriesFootprintModel.UnknownData unknownData;
        public Bucket unknownBucket;
        public String currentNodeBucketPath;
        public DataDirectoriesFootprintModel.Sizes<DataDirectoriesFootprintModel.ProjectFootprint> knownProjects;
        public DataDirectoriesFootprintModel.Sizes<DataDirectoriesFootprintModel.ProjectFootprint> unknownProjects;

        public BucketingContext(DataDirectoriesFootprintModel.DatadirFootprint global) {
            this.global = global;
        }
    }
}

