/*
 * Decompiled with CFR 0.152.
 */
package com.dataiku.dip.dataflow.exec;

import com.dataiku.dip.code.CodeEnvModel;
import com.dataiku.dip.code.CodeEnvResolutionService;
import com.dataiku.dip.coremodel.SimpleKeyValue;
import com.dataiku.dip.dataflow.JobAuthCtxService;
import com.dataiku.dip.dataflow.exec.EnvironmentStash;
import com.dataiku.dip.server.SpringUtils;
import com.dataiku.dip.spark.SparkJobBuilder;
import com.dataiku.dip.spark.SparkJobHelper;
import com.dataiku.dip.spark.SparkOverrideConfig;
import com.dataiku.dip.spark.submit.SparkSubmitJob;
import com.google.common.collect.Lists;
import java.io.IOException;
import java.util.List;
import java.util.Map;
import org.springframework.beans.factory.annotation.Autowired;

public class SparkExecutionEnginesHelper {
    private final String projectKey;
    @Autowired
    protected JobAuthCtxService authCtxService;
    @Autowired
    private CodeEnvResolutionService codeEnvResolutionService;

    public SparkExecutionEnginesHelper(String projectKey) {
        SpringUtils.getInstance().autowire((Object)this);
        this.projectKey = projectKey;
    }

    public void enrichSparkSubmitCommandForCodeEnv(SparkJobHelper.RunMode runMode, String envName, List<String> cmd) throws IOException {
        switch (runMode) {
            case SPARK: {
                break;
            }
            case PYSPARK: {
                CodeEnvResolutionService.ExecutionEnv executionEnv = new CodeEnvResolutionService.ExecutionEnv();
                executionEnv.cmd = cmd;
                this.codeEnvResolutionService.setupPySparkCmd(envName, this.projectKey, executionEnv);
                break;
            }
            case SPARKR: {
                CodeEnvResolutionService.ExecutionEnv executionEnv = new CodeEnvResolutionService.ExecutionEnv();
                executionEnv.cmd = cmd;
                this.codeEnvResolutionService.setupSparkRCmd(envName, this.projectKey, executionEnv);
                break;
            }
            default: {
                throw new Error("unreachable");
            }
        }
    }

    public CodeEnvModel.UsedCodeEnvRef buildUsedCodeEnvRefForSparkSubmitJob(SparkJobHelper.RunMode runMode, String envName, EnvironmentStash stash, SparkSubmitJob job) throws IOException {
        return switch (runMode) {
            case SparkJobHelper.RunMode.SPARK -> null;
            case SparkJobHelper.RunMode.PYSPARK -> {
                CodeEnvResolutionService.ExecutionEnv executionEnv = new CodeEnvResolutionService.ExecutionEnv();
                executionEnv.cmd = Lists.newArrayList((Object[])new String[]{"python"});
                this.codeEnvResolutionService.setupPySparkCmd(envName, this.projectKey, executionEnv);
                stash.env.putAll(executionEnv.env);
                stash.env.putAll(this.codeEnvResolutionService.getEnvironmentVariablesForPythonCmd(envName, this.projectKey));
                for (Map.Entry<String, String> kv : executionEnv.sparkConf.entrySet()) {
                    job.conf.add(new SimpleKeyValue(kv.getKey(), kv.getValue()));
                }
                yield new CodeEnvModel.UsedCodeEnvRef(CodeEnvModel.EnvLang.PYTHON, envName);
            }
            case SparkJobHelper.RunMode.SPARKR -> {
                CodeEnvResolutionService.ExecutionEnv executionEnv = new CodeEnvResolutionService.ExecutionEnv();
                executionEnv.cmd = Lists.newArrayList((Object[])new String[]{"R"});
                this.codeEnvResolutionService.setupSparkRCmd(envName, this.projectKey, executionEnv);
                stash.env.putAll(executionEnv.env);
                for (Map.Entry<String, String> kv : executionEnv.sparkConf.entrySet()) {
                    job.conf.add(new SimpleKeyValue(kv.getKey(), kv.getValue()));
                }
                yield new CodeEnvModel.UsedCodeEnvRef(CodeEnvModel.EnvLang.R, envName);
            }
            default -> throw new Error("unreachable");
        };
    }

    public static abstract class SparkRecipeJobBuilder
    extends SparkJobBuilder {
        public abstract SparkOverrideConfig getRecipeOverrideConf();
    }
}

