/*
 * Decompiled with CFR 0.152.
 */
package com.dataiku.dip.dataflow.exec.dataquality;

import com.dataiku.dip.coremodel.Dataset;
import com.dataiku.dip.coremodel.Schema;
import com.dataiku.dip.coremodel.SchemaColumn;
import com.dataiku.dip.coremodel.SerializedDataset;
import com.dataiku.dip.dataflow.JobActivity;
import com.dataiku.dip.dataflow.exec.AbstractInitializedRunner;
import com.dataiku.dip.dataflow.exec.AbstractStagedThreadedBuiltinRunner;
import com.dataiku.dip.dataflow.exec.dataquality.ExtractFailedRowsRecipePayloadParams;
import com.dataiku.dip.dataflow.exec.window.WindowRecipePayloadParams;
import com.dataiku.dip.datalayer.ColumnFactory;
import com.dataiku.dip.datalayer.ProcessorOutput;
import com.dataiku.dip.datalayer.Row;
import com.dataiku.dip.datalayer.RowFactory;
import com.dataiku.dip.datalayer.RowInputStream;
import com.dataiku.dip.datalayer.window.Windower;
import com.dataiku.dip.dataquality.DataQualityRule;
import com.dataiku.dip.dataquality.FailedRowsExtractRuleVisitor;
import com.dataiku.dip.dataquality.rules.AbstractMultiColumnRule;
import com.dataiku.dip.dataquality.rules.ColumnEmptyRule;
import com.dataiku.dip.dataquality.rules.ColumnMeaningValidityRule;
import com.dataiku.dip.dataquality.rules.ColumnNotEmptyRule;
import com.dataiku.dip.dataquality.rules.ColumnUniqueValuesRule;
import com.dataiku.dip.dataquality.rules.ValuesInRangeRule;
import com.dataiku.dip.dataquality.rules.ValuesInSetRule;
import com.dataiku.dip.datasets.sql.BuiltinSQLDatasets;
import com.dataiku.dip.meanings.SharedBasicMeaningsService;
import com.dataiku.dip.metrics.checks.AbstractCheckContext;
import com.dataiku.dip.server.recipes.ExtractFailedRowsSchemaGenerator;
import com.dataiku.dip.shaker.processors.transform.ColumnRenamer;
import com.dataiku.dip.shaker.processors.transform.FindReplace;
import com.dataiku.dip.shaker.types.MeaningDetector;
import com.dataiku.dip.sql.OracleSQLDialect;
import com.dataiku.dip.util.DatasetLocUtils;
import com.dataiku.dip.utils.DKULogger;
import com.google.common.collect.Lists;
import java.io.File;
import java.io.IOException;
import java.util.ArrayList;
import java.util.HashMap;
import java.util.List;
import java.util.Map;
import java.util.Objects;
import org.apache.commons.lang3.StringUtils;
import org.springframework.beans.factory.annotation.Autowired;

public class ExtractFailedRowsRecipeBuiltinRunner
extends AbstractStagedThreadedBuiltinRunner {
    @Autowired
    SharedBasicMeaningsService meaningsService;
    private ExtractFailedRowsRecipePayloadParams params;
    private static DKULogger logger = DKULogger.getLogger((String)"dku.recipes.dataquality");

    public ExtractFailedRowsRecipeBuiltinRunner(JobActivity activity, ExtractFailedRowsRecipePayloadParams params) {
        super(activity);
        this.params = params;
    }

    @Override
    public List<AbstractInitializedRunner.Output> prepareStages(File tempDirectory) throws Exception {
        assert (this.inputs.containsKey("main"));
        assert (!((List)this.inputs.get("main")).isEmpty());
        assert (this.outputs.containsKey("main"));
        assert (!((List)this.outputs.get("main")).isEmpty());
        AbstractInitializedRunner.Input input = (AbstractInitializedRunner.Input)((List)this.inputs.get("main")).get(0);
        AbstractInitializedRunner.Output output = (AbstractInitializedRunner.Output)((List)this.outputs.get("main")).get(0);
        SerializedDataset sd = (SerializedDataset)this.datasetsDAO.getMandatory(DatasetLocUtils.resolveFull(input.fullId));
        Dataset inputDS = Dataset.fromSerialized(sd);
        OracleSQLDialect dialect = inputDS.getType().equals(BuiltinSQLDatasets.ORACLE_META.getType()) ? new OracleSQLDialect(this.authCtxService.getAuthCtx(), inputDS) : null;
        ExtractFailedRowsSchemaGenerator schemaGenerator = new ExtractFailedRowsSchemaGenerator(inputDS);
        schemaGenerator.checkRuleSelectionValidity(this.params, false);
        ExtractFailedRowsSchemaGenerator.FailedRowsSchemaDetails schemaDetails = schemaGenerator.generate(this.params, dialect == null ? null : Integer.valueOf(dialect.getIdentifiersMaxLength()));
        List<DataQualityRule> rules = schemaDetails.rules;
        EnrichedOutcomeColumnDetails outcomeColumnDetails = new EnrichedOutcomeColumnDetails(schemaDetails.outcomeColumnsDetails);
        PreprocessingStagesBuilder preprocessingStagesBuilder = new PreprocessingStagesBuilder(tempDirectory, inputDS.getSchema(), outcomeColumnDetails);
        preprocessingStagesBuilder.build(rules);
        this.stages.addAll(preprocessingStagesBuilder.computationStages);
        this.stages.add(new ExtractFailedRowsThread(inputDS.getSchema(), rules, outcomeColumnDetails));
        if (!this.params.outputColumnNameOverrides.isEmpty()) {
            ColumnRenamer.Parameter rp = new ColumnRenamer.Parameter();
            for (String from : this.params.outputColumnNameOverrides.keySet()) {
                String to = this.params.outputColumnNameOverrides.get(from);
                if (!StringUtils.isNotBlank((CharSequence)from) || !StringUtils.isNotBlank((CharSequence)to)) continue;
                rp.renamings.add(new FindReplace.Substitution(from, to));
            }
            ColumnRenamer columnRenamer = new ColumnRenamer(rp);
            columnRenamer.setColumnFactory((ColumnFactory)output.cf);
            columnRenamer.init();
            this.stages.add(new AbstractStagedThreadedBuiltinRunner.RenamingThread(columnRenamer, schemaDetails.outputSchema));
        }
        return Lists.newArrayList((Object[])new AbstractInitializedRunner.Output[]{output});
    }

    private static class EnrichedOutcomeColumnDetails
    extends ExtractFailedRowsSchemaGenerator.OutcomeColumnsDetails {
        final Map<ExtractFailedRowsSchemaGenerator.OutcomeColumnKey, String> valuesCountColumns = new HashMap<ExtractFailedRowsSchemaGenerator.OutcomeColumnKey, String>();

        EnrichedOutcomeColumnDetails(ExtractFailedRowsSchemaGenerator.OutcomeColumnsDetails outcomeColumnsDetails) {
            super(outcomeColumnsDetails);
        }

        void addValuesCountColumn(String ruleId, String ruleColumn, String valuesCountColumn) {
            this.valuesCountColumns.put(new ExtractFailedRowsSchemaGenerator.OutcomeColumnKey(ruleId, ruleColumn), valuesCountColumn);
        }

        String getValuesCountColumn(String ruleId, String ruleColumn) {
            return this.valuesCountColumns.get(new ExtractFailedRowsSchemaGenerator.OutcomeColumnKey(ruleId, ruleColumn));
        }
    }

    private class PreprocessingStagesBuilder
    implements FailedRowsExtractRuleVisitor {
        final File tempDirectory;
        final Schema inputSchema;
        final EnrichedOutcomeColumnDetails outcomeColumnDetails;
        final List<AbstractStagedThreadedBuiltinRunner.ComputationStage> computationStages = new ArrayList<AbstractStagedThreadedBuiltinRunner.ComputationStage>();
        Schema currentStageSchema;

        PreprocessingStagesBuilder(File tempDirectory, Schema inputSchema, EnrichedOutcomeColumnDetails outcomeColumnDetails) {
            this.tempDirectory = tempDirectory;
            this.inputSchema = inputSchema;
            this.outcomeColumnDetails = outcomeColumnDetails;
        }

        void build(List<DataQualityRule> rules) {
            this.currentStageSchema = this.inputSchema;
            for (DataQualityRule rule : rules) {
                rule.accept(this);
            }
        }

        @Override
        public void visit(ValuesInSetRule rule) {
        }

        @Override
        public void visit(ValuesInRangeRule rule) {
        }

        @Override
        public void visit(ColumnNotEmptyRule rule) {
        }

        @Override
        public void visit(ColumnEmptyRule rule) {
        }

        @Override
        public void visit(ColumnUniqueValuesRule rule) {
            if (!rule.enabled) {
                return;
            }
            for (String column : rule.columns) {
                WindowRecipePayloadParams.WindowDesc windowDesc = new WindowRecipePayloadParams.WindowDesc();
                windowDesc.enablePartitioning = true;
                windowDesc.partitioningColumns = new ArrayList<String>(List.of(column));
                windowDesc.enableLimits = true;
                windowDesc.windowLimitMode = WindowRecipePayloadParams.WindowLimitMode.ROWS;
                List<WindowRecipePayloadParams.WindowValue> valuesDesc = this.currentStageSchema.columns.stream().map(schemaColumn -> {
                    WindowRecipePayloadParams.WindowValue windowValue = new WindowRecipePayloadParams.WindowValue();
                    windowValue.column = schemaColumn.getName();
                    windowValue.count = Objects.equals(column, schemaColumn.getName());
                    windowValue.value = true;
                    return windowValue;
                }).toList();
                Windower windower = new Windower(windowDesc, valuesDesc, false, false, false, false, null, new File(this.tempDirectory, "count_over_partition_by_" + column), ExtractFailedRowsRecipeBuiltinRunner.this.mergeSortParams, null, false);
                this.computationStages.add(new AbstractStagedThreadedBuiltinRunner.WindowerThread(windower, this.currentStageSchema));
                this.currentStageSchema = windower.getOutputSchema(this.currentStageSchema);
                this.outcomeColumnDetails.addValuesCountColumn(rule.getId(), column, ((SchemaColumn)this.currentStageSchema.columns.get(this.currentStageSchema.columns.size() - 1)).getName());
            }
        }

        @Override
        public void visit(ColumnMeaningValidityRule rule) {
        }
    }

    private class ExtractFailedRowsThread
    extends AbstractStagedThreadedBuiltinRunner.ComputationStage {
        final Schema inputSchema;
        final List<DataQualityRule> rules;
        final EnrichedOutcomeColumnDetails outcomeColumnDetails;
        ProcessorOutput output;
        RowInputStream input;
        ColumnFactory outputCf;
        ColumnFactory inputCf;
        RowFactory outputRf;
        Throwable exception;

        ExtractFailedRowsThread(Schema inputSchema, List<DataQualityRule> rules, EnrichedOutcomeColumnDetails outcomeColumnDetails) {
            this.inputSchema = inputSchema;
            this.rules = rules;
            this.outcomeColumnDetails = outcomeColumnDetails;
        }

        @Override
        public void setInputFactories(ColumnFactory cf, RowFactory rf, RowInputStream input) {
            this.inputCf = cf;
            this.input = input;
        }

        @Override
        public void setOutputFactories(ColumnFactory cf, RowFactory rf, ProcessorOutput output) {
            this.outputCf = cf;
            this.outputRf = rf;
            this.output = output;
        }

        @Override
        public void run() {
            try {
                RowProcessor rowProcessor = new RowProcessor(this.inputSchema, this.inputCf, this.outcomeColumnDetails);
                Row row = this.input.next();
                while (row != null) {
                    rowProcessor.reset(row);
                    for (DataQualityRule rule : this.rules) {
                        rule.accept(rowProcessor);
                    }
                    if (rowProcessor.emit) {
                        Row outputRow = this.outputRf.row();
                        for (SchemaColumn schemaColumn : this.inputSchema.getColumns()) {
                            String column = schemaColumn.getName();
                            outputRow = outputRow.with(this.outputCf, column, row.get(this.inputCf.column(column)));
                        }
                        for (Map.Entry entry : rowProcessor.outcomesByColumn.entrySet()) {
                            outputRow = outputRow.with(this.outputCf, (String)entry.getKey(), ((AbstractCheckContext.CheckOutcome)((Object)entry.getValue())).name());
                        }
                        this.output.emitRow(outputRow);
                    }
                    row = this.input.next();
                }
                this.output.lastRowEmitted();
            }
            catch (InterruptedException e) {
                logger.info((Object)"Interrupted failed rows export");
                try {
                    this.output.cancel();
                }
                catch (Exception e1) {
                    this.exception = e1;
                }
                Thread.currentThread().interrupt();
            }
            catch (Exception e) {
                logger.error((Object)"Failed rows extract failed", (Throwable)e);
                ExtractFailedRowsRecipeBuiltinRunner.this.interruptStages();
                try {
                    this.output.cancel();
                }
                catch (Exception e1) {
                    logger.error((Object)"Failed to cleanup resources", (Throwable)e1);
                }
                this.exception = e;
            }
        }

        @Override
        public Throwable getException() {
            return this.exception;
        }
    }

    private class RowProcessor
    implements FailedRowsExtractRuleVisitor {
        final Schema inputSchema;
        final ColumnFactory inputCf;
        final EnrichedOutcomeColumnDetails outcomeColumnDetails;
        final Map<String, MeaningDetector> cachedMeaningsDetectors = new HashMap<String, MeaningDetector>();
        final Map<String, AbstractCheckContext.CheckOutcome> outcomesByColumn = new HashMap<String, AbstractCheckContext.CheckOutcome>();
        Row row;
        boolean emit;

        RowProcessor(Schema inputSchema, ColumnFactory inputCf, EnrichedOutcomeColumnDetails outcomeColumnDetails) {
            this.inputSchema = inputSchema;
            this.inputCf = inputCf;
            this.outcomeColumnDetails = outcomeColumnDetails;
        }

        void reset(Row row) {
            this.row = row;
            this.outcomesByColumn.clear();
            this.emit = false;
        }

        @Override
        public void visit(ValuesInSetRule rule) {
            for (String column : rule.getColumns()) {
                String outcomeColumn = this.outcomeColumnDetails.getOutcomeColumn(rule.getId(), column);
                if (!rule.enabled) {
                    this.outcomesByColumn.put(outcomeColumn, AbstractCheckContext.CheckOutcome.EMPTY);
                    continue;
                }
                String value = this.row.get(this.inputCf.column(column));
                if (StringUtils.isNotBlank((CharSequence)value) && !rule.getWhitelistedValues().contains(value)) {
                    this.outcomesByColumn.put(outcomeColumn, AbstractCheckContext.CheckOutcome.ERROR);
                    this.emit = true;
                    continue;
                }
                this.outcomesByColumn.put(outcomeColumn, AbstractCheckContext.CheckOutcome.OK);
            }
        }

        @Override
        public void visit(ValuesInRangeRule rule) {
            for (String column : rule.getColumns()) {
                String outcomeColumn = this.outcomeColumnDetails.getOutcomeColumn(rule.getId(), column);
                if (!rule.enabled) {
                    this.outcomesByColumn.put(outcomeColumn, AbstractCheckContext.CheckOutcome.EMPTY);
                    continue;
                }
                AbstractCheckContext.CheckOutcome outcome = this.evaluateColumnValue(column, rule);
                this.outcomesByColumn.put(outcomeColumn, outcome);
                if (outcome != AbstractCheckContext.CheckOutcome.ERROR && outcome != AbstractCheckContext.CheckOutcome.WARNING) continue;
                this.emit = true;
            }
        }

        private AbstractCheckContext.CheckOutcome evaluateColumnValue(String column, ValuesInRangeRule rule) {
            boolean isNumericColumn;
            SchemaColumn schemaColumn = this.inputSchema.getColumn(column);
            boolean bl = isNumericColumn = schemaColumn != null && schemaColumn.getType().isNumeric();
            if (!isNumericColumn) {
                return AbstractCheckContext.CheckOutcome.WARNING;
            }
            String valueStr = this.row.get(this.inputCf.column(column));
            if (StringUtils.isBlank((CharSequence)valueStr)) {
                return AbstractCheckContext.CheckOutcome.OK;
            }
            try {
                double value = Double.parseDouble(valueStr);
                return this.determineRangeViolation(value, rule);
            }
            catch (NumberFormatException e) {
                return this.nonNumericValueOutcome(rule);
            }
        }

        private AbstractCheckContext.CheckOutcome nonNumericValueOutcome(ValuesInRangeRule rule) {
            if (rule.maximumEnabled || rule.minimumEnabled) {
                return AbstractCheckContext.CheckOutcome.ERROR;
            }
            if (rule.softMaximumEnabled || rule.softMinimumEnabled) {
                return AbstractCheckContext.CheckOutcome.WARNING;
            }
            return AbstractCheckContext.CheckOutcome.OK;
        }

        private AbstractCheckContext.CheckOutcome determineRangeViolation(double value, ValuesInRangeRule rule) {
            if (rule.isHardRangeViolation(value)) {
                return AbstractCheckContext.CheckOutcome.ERROR;
            }
            if (rule.isSoftRangeViolation(value)) {
                return AbstractCheckContext.CheckOutcome.WARNING;
            }
            return AbstractCheckContext.CheckOutcome.OK;
        }

        @Override
        public void visit(ColumnNotEmptyRule rule) {
            this.visitEmptyOrNotEmptyRule(rule, false);
        }

        @Override
        public void visit(ColumnEmptyRule rule) {
            this.visitEmptyOrNotEmptyRule(rule, true);
        }

        private void visitEmptyOrNotEmptyRule(AbstractMultiColumnRule rule, boolean emptyRule) {
            for (String column : rule.getColumns()) {
                String outcomeColumn = this.outcomeColumnDetails.getOutcomeColumn(rule.getId(), column);
                if (!rule.enabled) {
                    this.outcomesByColumn.put(outcomeColumn, AbstractCheckContext.CheckOutcome.EMPTY);
                    continue;
                }
                String value = this.row.get(this.inputCf.column(column));
                if (emptyRule ? StringUtils.isNotBlank((CharSequence)value) : StringUtils.isBlank((CharSequence)value)) {
                    this.outcomesByColumn.put(outcomeColumn, AbstractCheckContext.CheckOutcome.ERROR);
                    this.emit = true;
                    continue;
                }
                this.outcomesByColumn.put(outcomeColumn, AbstractCheckContext.CheckOutcome.OK);
            }
        }

        @Override
        public void visit(ColumnUniqueValuesRule rule) {
            for (String column : rule.getColumns()) {
                String outcomeColumn = this.outcomeColumnDetails.getOutcomeColumn(rule.getId(), column);
                if (!rule.enabled) {
                    this.outcomesByColumn.put(outcomeColumn, AbstractCheckContext.CheckOutcome.EMPTY);
                    continue;
                }
                String value = this.row.get(this.inputCf.column(column));
                long count = Long.parseLong(this.row.get(this.inputCf.column(this.outcomeColumnDetails.getValuesCountColumn(rule.getId(), column))));
                if (StringUtils.isNotBlank((CharSequence)value) && count > 1L) {
                    this.outcomesByColumn.put(outcomeColumn, AbstractCheckContext.CheckOutcome.ERROR);
                    this.emit = true;
                    continue;
                }
                this.outcomesByColumn.put(outcomeColumn, AbstractCheckContext.CheckOutcome.OK);
            }
        }

        @Override
        public void visit(ColumnMeaningValidityRule rule) {
            for (String column : rule.getColumns()) {
                String value;
                MeaningDetector meaningDetector;
                SchemaColumn schemaColumn;
                String outcomeColumn = this.outcomeColumnDetails.getOutcomeColumn(rule.getId(), column);
                if (!rule.enabled) {
                    this.outcomesByColumn.put(outcomeColumn, AbstractCheckContext.CheckOutcome.EMPTY);
                    continue;
                }
                String meaning = rule.getMeaningFor(column);
                if (meaning == null && (schemaColumn = this.inputSchema.getColumn(column)) != null) {
                    meaning = schemaColumn.getMeaning();
                }
                if ((meaningDetector = this.cachedMeaningsDetectors.get(meaning)) == null) {
                    try {
                        meaningDetector = ExtractFailedRowsRecipeBuiltinRunner.this.meaningsService.buildSingleDetector(meaning);
                        this.cachedMeaningsDetectors.put(meaning, meaningDetector);
                    }
                    catch (IOException e) {
                        throw new IllegalStateException(e);
                    }
                }
                if (StringUtils.isBlank((CharSequence)(value = this.row.get(this.inputCf.column(column)))) && !rule.considerEmptyAsValid || !meaningDetector.validates(value)) {
                    this.outcomesByColumn.put(outcomeColumn, AbstractCheckContext.CheckOutcome.ERROR);
                    this.emit = true;
                    continue;
                }
                this.outcomesByColumn.put(outcomeColumn, AbstractCheckContext.CheckOutcome.OK);
            }
        }
    }
}

