/*
 * Decompiled with CFR 0.152.
 */
package com.dataiku.dip.dataflow.exec.geojoin;

import com.dataiku.dip.coremodel.SchemaColumn;
import com.dataiku.dip.datalayer.ColumnFactory;
import com.dataiku.dip.datalayer.FilteringProcessorOutput;
import com.dataiku.dip.datalayer.ProcessorOutput;
import com.dataiku.dip.datalayer.Row;
import com.dataiku.dip.datalayer.streamimpl.StreamRowFactory;
import java.util.List;

public class GeoJoinProcessor
extends FilteringProcessorOutput {
    private final List<SchemaColumn> outputColumns;
    private final List<Integer> outputColumnsIndexes;
    private final List<SchemaColumn> inputColumns;
    private final int inputSize;
    private final int outputSize;
    private final ColumnFactory cf;
    private final StreamRowFactory rf;

    public GeoJoinProcessor(ProcessorOutput downstream, List<SchemaColumn> inputColumns, ColumnFactory cf, List<SchemaColumn> outputColumns, List<Integer> outputColumnsIndexes, StreamRowFactory rf) {
        super(downstream);
        this.cf = cf;
        this.outputColumns = outputColumns;
        this.outputColumnsIndexes = outputColumnsIndexes;
        this.inputColumns = inputColumns;
        this.inputSize = inputColumns.size();
        this.outputSize = outputColumns.size();
        this.rf = rf;
    }

    public void emitRow(Row row) throws Exception {
        int index = 0;
        Row newRow = this.rf.row();
        for (SchemaColumn column : this.outputColumns) {
            String columnName = column.getName();
            String value = null;
            if (index < this.outputSize) {
                if (index < this.outputColumnsIndexes.size()) {
                    int targetIndex = this.outputColumnsIndexes.get(index);
                    if (targetIndex < this.inputSize) {
                        value = row.get(this.cf.column(this.inputColumns.get(targetIndex).getName()));
                    }
                } else {
                    value = row.get(this.cf.column(columnName));
                }
                newRow.put(this.cf.column(columnName), value);
            }
            ++index;
        }
        this.downstream.emitRow(newRow);
    }
}

