/*
 * Decompiled with CFR 0.152.
 */
package com.dataiku.dip.dataflow.exec.geojoin;

import com.dataiku.dip.containers.exec.ContainerExecSelection;
import com.dataiku.dip.dataflow.exec.WithPostFilter;
import com.dataiku.dip.dataflow.exec.filter.FilterDesc;
import com.dataiku.dip.dataflow.exec.joinlike.ConditionsMode;
import com.dataiku.dip.dataflow.exec.joinlike.JoinDescBase;
import com.dataiku.dip.dataflow.exec.joinlike.JoinInputDescBase;
import com.dataiku.dip.dataflow.exec.joinlike.JoinLikeRecipePayloadParams;
import com.dataiku.dip.dataflow.exec.joinlike.JoinType;
import com.dataiku.dip.dataflow.exec.joinlike.MatchingConditionBase;
import com.dataiku.dip.recipes.ParamsWithContainerizable;
import com.dataiku.dip.utils.ErrorContext;
import com.dataiku.j2ts.annotations.UIModel;
import java.util.ArrayList;
import java.util.List;

@UIModel
public class GeoJoinRecipePayloadParams
extends JoinLikeRecipePayloadParams<JoinInputDescBase, MatchingCondition, JoinDesc>
implements WithPostFilter,
ParamsWithContainerizable {
    public FilterDesc postFilter;

    @Override
    public void validateJoinCondition(MatchingCondition cond) {
        if (cond.type == null) {
            throw ErrorContext.iae((String)"Invalid matching condition.");
        }
        if (!this.isValidColumnDesc(cond.column1) || !this.isValidColumnDesc(cond.column2)) {
            throw ErrorContext.iae((String)"Invalid column in matching conditions.");
        }
        if ((cond.type == MatchingType.DWITHIN || cond.type == MatchingType.BEYOND) && cond.threshold <= 0.0) {
            throw ErrorContext.iae((String)"Distance parameter cannot be <= 0.");
        }
    }

    @Override
    protected JoinDesc newJoinDesc() {
        return new JoinDesc();
    }

    @Override
    public JoinInputDescBase newInputDesc() {
        return new JoinInputDescBase();
    }

    @Override
    public FilterDesc getPostFilter() {
        return this.postFilter;
    }

    @Override
    public ContainerExecSelection getContainerSelection() {
        return this.engineParams.containerSelection;
    }

    @Override
    public void setContainerSelection(ContainerExecSelection selection) {
        this.engineParams.containerSelection = selection;
    }

    public static class MatchingCondition
    extends MatchingConditionBase {
        public MatchingType type;
        public double threshold;
        public DistanceUnit unit = DistanceUnit.METER;

        public MatchingCondition(MatchingType type, double threshold) {
            this.type = type;
            this.threshold = threshold;
        }

        @Override
        public boolean isEqualityCondition() {
            return false;
        }
    }

    public static enum MatchingType {
        EQ("Is strictly equal to"),
        DWITHIN("Is within %.0f %s of"),
        WITHIN("Is contained within"),
        BEYOND("Is beyond %.0f %s of"),
        TOUCHES("Touches"),
        CONTAINS("Contains"),
        DISJOINT("Is disjoint to"),
        INTERSECTS("Intersects");

        private final String displayWithDistanceFormat;

        private MatchingType(String displayWithDistanceFormat) {
            this.displayWithDistanceFormat = displayWithDistanceFormat;
        }

        public String getDisplayWithDistanceFormat() {
            return this.displayWithDistanceFormat;
        }
    }

    public static class JoinDesc
    extends JoinDescBase<MatchingCondition> {
        @Override
        public boolean requiresJoinConditions() {
            return this.type != JoinType.CROSS && (this.conditionsMode == ConditionsMode.AND || this.conditionsMode == ConditionsMode.OR);
        }

        @Override
        public List<MatchingCondition> getJoinConditions() {
            if (!this.requiresJoinConditions()) {
                return new ArrayList<MatchingCondition>();
            }
            return this.on;
        }

        public String toString() {
            return this.table1 + " <- " + this.table2;
        }
    }

    public static enum DistanceUnit {
        METER("m"),
        KILOMETER("km"),
        MILE("mi"),
        YARD("yds"),
        FOOT("ft"),
        NAUTICAL_MILE("nmi");

        private final String displayName;

        private DistanceUnit(String displayName) {
            this.displayName = displayName;
        }

        public String getDisplayName() {
            return this.displayName;
        }
    }

    public static enum SelectionType {
        KEEP_ALL,
        KEEP_LARGEST,
        KEEP_SMALLEST;

    }
}

