/*
 * Decompiled with CFR 0.152.
 */
package com.dataiku.dip.dataflow.exec.geojoin;

import com.dataiku.dip.containers.exec.ContainerExecRuntimeConfig;
import com.dataiku.dip.dataflow.JobActivity;
import com.dataiku.dip.dataflow.cde.ContainerizedDSSEngineAble;
import com.dataiku.dip.dataflow.cde.ContainerizedStreamEngineExecutor;
import com.dataiku.dip.dataflow.exec.MultiEngineRecipeRunner;
import com.dataiku.dip.dataflow.exec.VisualSQLRecipePayloadParams;
import com.dataiku.dip.dataflow.exec.geojoin.GeoJoinRecipeBuiltinRunner;
import com.dataiku.dip.dataflow.exec.geojoin.GeoJoinRecipeHelper;
import com.dataiku.dip.dataflow.exec.geojoin.GeoJoinRecipePayloadParams;
import com.dataiku.dip.dataflow.exec.geojoin.GeoJoinRecipeService;
import com.dataiku.dip.dataflow.exec.geojoin.GeoJoinRecipeStatusComputer;
import com.dataiku.dip.output.Output;
import com.dataiku.dip.recipes.consistency.CDECompatibilityCheckerService;
import com.dataiku.dip.recipes.visualsql.VisualSQLRecipesBaseService;
import com.dataiku.dip.server.SpringUtils;
import com.dataiku.dip.sql.SQLDialect;
import com.dataiku.dip.utils.DKULogger;
import org.springframework.beans.factory.annotation.Autowired;

public class GeoJoinRecipeRunner
extends MultiEngineRecipeRunner
implements ContainerizedDSSEngineAble {
    @Autowired
    private GeoJoinRecipeService service;
    @Autowired
    private CDECompatibilityCheckerService cdeCompatibilityCheckerService;
    private final GeoJoinRecipeHelper helper = new GeoJoinRecipeHelper();
    protected GeoJoinRecipePayloadParams params;
    private boolean isRunningInContainer = false;
    private static final DKULogger logger = DKULogger.getLogger((String)"dku.recipes.geojoin");

    public GeoJoinRecipeRunner(JobActivity activity) {
        super(activity);
    }

    @Override
    public void setPayload(String payload) {
        logger.info((Object)("SET PAYLOAD: " + payload));
        this.payload = payload;
        this.params = this.service.loadParams(payload, this.recipe.getModel());
    }

    @Override
    public void setIsRunningInContainer() {
        this.isRunningInContainer = true;
    }

    @Override
    protected String generateSQL(SQLDialect dialect) throws Exception {
        VisualSQLRecipesBaseService.SQLBasedEngineStatus selectedEngine = new GeoJoinRecipeStatusComputer(this.recipe.getModel(), this.payload).fastStatusIgnorePartitions(this.authCtxService.getAuthCtx()).getSelectedSQLBasedEngine();
        boolean mustLowerCaseColumnsNames = this.visualRecipesBaseService.mustLowerCaseColumnsNames((VisualSQLRecipePayloadParams)this.params, selectedEngine);
        boolean caseInsensitive = mustLowerCaseColumnsNames || dialect != null && dialect.hasCaseInsensitiveColumns();
        this.helper.initInputDatasets(this.activity, this.params, dialect, caseInsensitive);
        return this.helper.generateSQL(this.authCtxService.getAuthCtx(), this.activity, dialect, this.params, mustLowerCaseColumnsNames);
    }

    @Override
    protected void initBuiltinExecutor(VisualSQLRecipesBaseService.SQLBasedEngineStatus engine) throws Exception {
        ContainerExecRuntimeConfig containerConfig = this.cdeCompatibilityCheckerService.getContainerConfig(this.isRunningInContainer, this.authCtxService.getAuthCtx(), this.activity.warnContext, this.params.engineParams.containerSelection, this.recipe.getModel(), this.payload);
        if (containerConfig != null) {
            logger.info((Object)"Run in container");
            ContainerizedStreamEngineExecutor containerizedRunner = new ContainerizedStreamEngineExecutor(this.recipe, this.activity, containerConfig);
            containerizedRunner.init(this.activity, Output.WriteMode.APPEND);
            this.executor = containerizedRunner;
        } else {
            GeoJoinRecipeBuiltinRunner dssRunner = new GeoJoinRecipeBuiltinRunner(this.activity);
            dssRunner.params = this.params;
            SpringUtils.getInstance().autowire((Object)dssRunner);
            this.helper.initInputDatasets(this.activity, this.params, null, false);
            this.helper.initAliases(dssRunner.params, false);
            this.executor = dssRunner;
        }
    }
}

