/*
 * Decompiled with CFR 0.152.
 */
package com.dataiku.dip.dataflow.exec.split;

import com.dataiku.dip.coremodel.Dataset;
import com.dataiku.dip.coremodel.InfoMessage;
import com.dataiku.dip.coremodel.RecipeEnginesPreferenceConfig;
import com.dataiku.dip.coremodel.Schema;
import com.dataiku.dip.coremodel.SerializedRecipe;
import com.dataiku.dip.dataflow.JobActivity;
import com.dataiku.dip.dataflow.exec.QueryGenerationUtils;
import com.dataiku.dip.dataflow.exec.VisualSQLRecipePayloadParams;
import com.dataiku.dip.dataflow.exec.computedcolumn.ComputedColumn;
import com.dataiku.dip.dataflow.exec.filter.FilterDesc;
import com.dataiku.dip.dataflow.exec.filter.FilterDescUtils;
import com.dataiku.dip.dataflow.exec.split.SplitRecipeHelper;
import com.dataiku.dip.dataflow.exec.split.SplitRecipePayloadParams;
import com.dataiku.dip.datasets.DatasetUtils;
import com.dataiku.dip.queries.ExecutionPlanService;
import com.dataiku.dip.recipes.FakeJobActivityFromRecipeBuilder;
import com.dataiku.dip.recipes.common.RecipeConfigUtils;
import com.dataiku.dip.recipes.common.RecipeEngineStatus;
import com.dataiku.dip.recipes.common.RecipeStatus;
import com.dataiku.dip.recipes.common.VisualSQLRecipeStatusComputer;
import com.dataiku.dip.recipes.consistency.RecipeCodes;
import com.dataiku.dip.recipes.visualsql.VisualSQLRecipeStatus;
import com.dataiku.dip.recipes.visualsql.VisualSQLRecipesBaseService;
import com.dataiku.dip.security.AuthCtx;
import com.dataiku.dip.server.SpringUtils;
import com.dataiku.dip.server.recipes.SplitRecipeService;
import com.dataiku.dip.sql.DummySQLDialect;
import com.dataiku.dip.sql.MySQLDialect;
import com.dataiku.dip.sql.SQLDialect;
import com.dataiku.dip.sql.SQLUtils;
import com.dataiku.dip.sql.queries.ExpressionBuilder;
import com.dataiku.dip.sql.queries.SelectQueryBuilder;
import com.dataiku.dip.transactions.ifaces.Transaction;
import com.dataiku.dip.util.DatasetLocUtils;
import com.dataiku.dip.utils.ExceptionUtils;
import com.dataiku.dip.utils.JSON;
import java.util.ArrayList;
import java.util.List;
import org.apache.commons.lang.StringUtils;
import org.apache.log4j.Logger;
import org.springframework.beans.factory.annotation.Autowired;

public class SplitRecipeStatusComputer
extends VisualSQLRecipeStatusComputer {
    @Autowired
    private SplitRecipeService splitService;
    private static final Logger logger = Logger.getLogger((String)"dip.split.status.computer");

    public SplitRecipeStatusComputer(SerializedRecipe recipe, String payload) {
        super(recipe, payload);
        SpringUtils.getInstance().autowire((Object)this);
    }

    @Override
    public VisualSQLRecipeStatus getStatusForConversion_NT(AuthCtx authCtx) throws Exception {
        SplitRecipeStatus status;
        StatusInitializer init = new StatusInitializer();
        try (Transaction t = this.transactionService.beginRead();){
            String sql;
            status = this.fastStatusIgnorePartitions(init, authCtx);
            if (status.isInvalid()) {
                logger.warn((Object)"Recipe status is invalid. Try to generate query anyway:");
            }
            this.generateSqlQueries(status, init, true);
            status.sql = sql = status.sqlWithExecutionPlanList.get((int)0).sql;
        }
        return status;
    }

    @Override
    public RecipeStatus getFullStatus_NT(AuthCtx authCtx, String requestData) throws Exception {
        SplitRecipeStatus status;
        StatusInitializer init = new StatusInitializer();
        try (Transaction t = this.transactionService.beginRead();){
            status = this.fastStatusIgnorePartitions(init, authCtx);
            if (status.isInvalid()) {
                this.fixupStatusOutputInvalid(status);
                SplitRecipeStatus splitRecipeStatus = status;
                return splitRecipeStatus;
            }
        }
        SplitRecipePayloadParams params = init.params;
        RecipeEngineStatus engine = status.selectedEngine;
        ArrayList<String> splitFilterSQLExpressions = null;
        String prefilterSQLExpression = null;
        VisualSQLRecipeStatus.VisualSQLRecipeStatusRequest request = (VisualSQLRecipeStatus.VisualSQLRecipeStatusRequest)JSON.parse((String)requestData, VisualSQLRecipeStatus.VisualSQLRecipeStatusRequest.class);
        if (init.dialect != null && params.hasPrefilter()) {
            status.preFilter = new RecipeStatus.StepStatus();
            boolean translateFully = !engine.type.equals("DSS");
            prefilterSQLExpression = this.visualRecipesService.checkFilter(params.preFilter, init.inputDS, init.dialect, status.preFilter, translateFully);
        }
        if (params.hasComputedColumns()) {
            status.computedColumns = new RecipeStatus.StepStatus();
            this.visualRecipesService.checkComputedColumns(params.computedColumns, init.inputDS.getSchema(), status.getSelectedSQLBasedEngine(), init.dialect, init.lowerCaseColumnsNames, status.computedColumns);
        }
        if (params.mode != null) {
            status.splitting = new RecipeStatus.StepStatus();
            if (params.mode == SplitRecipePayloadParams.Mode.VALUES) {
                if (params.valueSplits == null || params.valueSplits.isEmpty()) {
                    status.splitting.withFatal(RecipeCodes.ERR_RECIPE_SPLIT_INVALID_SPLIT, "No split defined");
                }
                if (StringUtils.isBlank((String)params.column) || !this.splitService.isColumnInSchemaOrComputedColumns(params.column, params, init.inputDS)) {
                    status.splitting.withFatal(RecipeCodes.ERR_RECIPE_SPLIT_INVALID_SPLIT, "Column for splitting not selected");
                }
            } else if (params.mode == SplitRecipePayloadParams.Mode.FILTERS) {
                splitFilterSQLExpressions = new ArrayList<String>();
                if (params.filterSplits == null || params.filterSplits.isEmpty()) {
                    status.splitting.withFatal(RecipeCodes.ERR_RECIPE_SPLIT_INVALID_SPLIT, "No split defined");
                }
                boolean translateFully = !engine.type.equals("DSS");
                for (SplitRecipePayloadParams.FilterSplitDesc split : params.filterSplits) {
                    split.filter.enabled = true;
                    String sqlExpression = this.visualRecipesService.checkFilter(split.filter, init.helper.getInputDSWithComputedColumnsSchema(init.dialect), init.dialect, status.splitting, translateFully);
                    splitFilterSQLExpressions.add(sqlExpression);
                }
            } else if (params.mode == SplitRecipePayloadParams.Mode.RANDOM) {
                this.checkShareSplit(params.randomSplits, status.splitting);
                if (params.seed == null) {
                    status.splitting.withFatal(RecipeCodes.ERR_RECIPE_SPLIT_INVALID_SPLIT, "Value of seed is not defined.");
                }
            } else if (params.mode == SplitRecipePayloadParams.Mode.RANDOM_COLUMNS) {
                this.checkShareSplit(params.randomColumnsSplits, status.splitting);
                if (params.randomColumns == null || params.randomColumns.size() == 0) {
                    status.splitting.withFatal(RecipeCodes.ERR_RECIPE_SPLIT_INVALID_SPLIT, "No column selected.");
                } else {
                    for (String col : params.randomColumns) {
                        this.checkColumnInSchemaOrComputedColumns(col, params, status.splitting, init.inputDS);
                    }
                }
            } else if (params.mode == SplitRecipePayloadParams.Mode.CENTILE) {
                this.checkShareSplit(params.centileSplits, status.splitting);
                if (params.centileOrders == null || params.centileOrders.size() == 0) {
                    status.splitting.withFatal(RecipeCodes.ERR_RECIPE_SPLIT_INVALID_SPLIT, "No column selected for building order.");
                } else {
                    for (SplitRecipePayloadParams.Order order : params.centileOrders) {
                        String column = order.column;
                        this.checkColumnInSchemaOrComputedColumns(column, params, status.splitting, init.inputDS);
                    }
                }
            } else if (params.mode == SplitRecipePayloadParams.Mode.RANGE) {
                if (StringUtils.isBlank((String)params.column) || !this.splitService.isColumnInSchemaOrComputedColumns(params.column, params, init.inputDS)) {
                    status.splitting.withFatal(RecipeCodes.ERR_RECIPE_SPLIT_INVALID_SPLIT, "Column for sorting not selected");
                }
                this.checkRangeSplits(params.rangeSplits, status.splitting);
            } else {
                status.splitting.withFatal(RecipeCodes.ERR_RECIPE_SPLIT_INVALID_SPLIT, "No splitting defined.");
            }
        }
        this.checkOutputSchema(status);
        if (!status.isInvalid() && this.isRecipeQueryBased(params.mode, engine)) {
            this.generateExecutionPlans(status, init, authCtx, request);
            if (!status.executionPlanErrMsgs.isEmpty()) {
                this.investigateExecutionPlanFailure(status, init, authCtx, prefilterSQLExpression, splitFilterSQLExpressions);
            }
        }
        if (init.error != null && !status.isInvalid()) {
            status.output.withFatalV(RecipeCodes.ERR_RECIPE_VALIDATION_FAILED, "Unknown error: %s", new Object[]{init.error});
        }
        this.fixupStatusOutputInvalid(status);
        if (!status.isInvalid() && params.mode == null) {
            status.output = null;
        }
        return status;
    }

    private void generateExecutionPlans(SplitRecipeStatus status, StatusInitializer init, AuthCtx authCtx, VisualSQLRecipeStatus.VisualSQLRecipeStatusRequest request) throws Exception {
        if (status.selectedEngine.type.equals("HIVE")) {
            String mainQuerySql = init.helper.generateMainQueryForHive(init.dialect, false);
            status.sqlWithExecutionPlanList.get((int)0).executionPlan = this.getExecutionPlan(authCtx, status, init, mainQuerySql, request);
        } else {
            for (SqlWithExecutionPlan sqlWithExecutionPlan : status.sqlWithExecutionPlanList) {
                sqlWithExecutionPlan.executionPlan = this.getExecutionPlan(authCtx, status, init, sqlWithExecutionPlan.sql, request);
            }
        }
    }

    private ExecutionPlanService.ExecutionPlan getExecutionPlan(AuthCtx authCtx, SplitRecipeStatus status, StatusInitializer init, String sql, VisualSQLRecipeStatus.VisualSQLRecipeStatusRequest request) {
        ExecutionPlanService.ExecutionPlan executionPlan = null;
        if (this.needToComputeExecutionPlan((VisualSQLRecipesBaseService.SQLBasedEngineStatus)status.selectedEngine, request)) {
            try {
                executionPlan = this.getExecutionPlan(authCtx, init.inputDS, (VisualSQLRecipesBaseService.SQLBasedEngineStatus)status.selectedEngine, sql, init.params.engineParams);
            }
            catch (ExecutionPlanService.HiveTableNotFound e) {
                logger.error((Object)"Failed to compute execution plan", (Throwable)e);
                status.executionPlanErrMsgs.add(ExceptionUtils.getMessageWithCauses((Throwable)e));
            }
            catch (Exception e) {
                logger.error((Object)"Failed to compute execution plan", (Throwable)e);
                logger.info((Object)("Query:\n" + sql));
                status.executionPlanErrMsgs.add(ExceptionUtils.getMessageWithCauses((Throwable)e));
            }
        }
        return executionPlan;
    }

    private void investigateExecutionPlanFailure(SplitRecipeStatus status, StatusInitializer init, AuthCtx authCtx, String preFilterSQLExpression, List<String> splitFilterSQLExpressions) throws Exception {
        if (status.getSelectedSQLBasedEngine().type.equals("HIVE")) {
            for (String executionPlanErrMsg : status.executionPlanErrMsgs) {
                status.output.withFatal(RecipeCodes.ERR_RECIPE_EXECUTION_PLAN_COMPUTATION_FAILED, executionPlanErrMsg);
            }
            return;
        }
        boolean errorOriginFound = false;
        ExpressionBuilder.ExpressionBuilderFactory ef = new ExpressionBuilder.ExpressionBuilderFactory();
        SQLUtils.SQLTable table = DatasetUtils.getResolvedTableWithSparkSQLFallback(init.inputDS, init.dialect, init.params.engineParams);
        SelectQueryBuilder qb = new SelectQueryBuilder();
        qb.from(table, null);
        qb.where(ef.expr(preFilterSQLExpression));
        String sql = qb.toSQL(init.dialect);
        try {
            this.getExecutionPlan(authCtx, init.inputDS, status.getSelectedSQLBasedEngine(), sql, init.params.engineParams);
        }
        catch (Exception e) {
            logger.error((Object)"Prefilter execution failed", (Throwable)e);
            logger.error((Object)sql);
            if (status.preFilter != null) {
                status.preFilter.withFatal(RecipeCodes.ERR_RECIPE_EXECUTION_PLAN_COMPUTATION_FAILED, this.formatDatabaseErrorMsg(e.getMessage(), init.dialect));
            }
            errorOriginFound = true;
        }
        if (splitFilterSQLExpressions != null && !splitFilterSQLExpressions.isEmpty()) {
            int index = 0;
            for (String filterSQLExpression : splitFilterSQLExpressions) {
                qb = new SelectQueryBuilder();
                qb.from(table, null);
                qb.where(ef.expr(filterSQLExpression));
                sql = qb.toSQL(init.dialect);
                try {
                    this.getExecutionPlan(authCtx, init.inputDS, status.getSelectedSQLBasedEngine(), sql, init.params.engineParams);
                }
                catch (Exception e) {
                    logger.error((Object)"Prefilter execution failed", (Throwable)e);
                    logger.error((Object)sql);
                    status.splitting.withFatal(RecipeCodes.ERR_RECIPE_EXECUTION_PLAN_COMPUTATION_FAILED, "Split #" + index + " :" + this.formatDatabaseErrorMsg(e.getMessage(), init.dialect));
                    errorOriginFound = true;
                }
                ++index;
            }
        }
        if (!errorOriginFound) {
            for (String executionPlanErrMsg : status.executionPlanErrMsgs) {
                status.output.withFatal(RecipeCodes.ERR_RECIPE_VALIDATION_FAILED, executionPlanErrMsg);
            }
        }
    }

    private void checkRangeSplits(List<SplitRecipePayloadParams.FilterSplitDesc> rangeSplits, RecipeStatus.StepStatus stepStatus) {
        if (rangeSplits == null || rangeSplits.isEmpty()) {
            stepStatus.withFatal(RecipeCodes.ERR_RECIPE_SPLIT_INVALID_SPLIT, "No split defined");
            return;
        }
        int p = 0;
        for (SplitRecipePayloadParams.FilterSplitDesc split : rangeSplits) {
            List conditions;
            List list = conditions = split.filter.uiData != null ? split.filter.uiData.conditions : null;
            if (conditions == null || conditions.isEmpty()) {
                stepStatus.withFatal(RecipeCodes.ERR_RECIPE_SPLIT_INVALID_SPLIT, "Range for split #" + p + " not set.");
            } else {
                Double minValue = null;
                Double maxValue = null;
                for (FilterDesc.FilterUiCondition condition : conditions) {
                    if (">  [number]".equals(condition.operator) || ">= [number]".equals(condition.operator)) {
                        minValue = condition.num;
                    }
                    if (!"<  [number]".equals(condition.operator) && !"<= [number]".equals(condition.operator)) continue;
                    maxValue = condition.num;
                }
                if (minValue != null && maxValue != null && maxValue < minValue) {
                    stepStatus.withFatal(RecipeCodes.ERR_RECIPE_SPLIT_INVALID_SPLIT, "Range for split #" + p + " is invalid. Max value must be superior to min value.");
                }
            }
            ++p;
        }
    }

    private void checkShareSplit(List<SplitRecipePayloadParams.ShareSplitDesc> splits, RecipeStatus.StepStatus stepStatus) {
        if (splits == null || splits.isEmpty()) {
            stepStatus.withFatal(RecipeCodes.ERR_RECIPE_SPLIT_INVALID_SPLIT, "No split defined");
            return;
        }
        int p = 0;
        float totalShare = 0.0f;
        for (SplitRecipePayloadParams.ShareSplitDesc split : splits) {
            if (split.share == null) {
                stepStatus.withFatal(RecipeCodes.ERR_RECIPE_SPLIT_INVALID_SPLIT, "Share for split #" + p + " not set.");
            } else {
                if (split.share.floatValue() < 0.0f) {
                    stepStatus.withFatal(RecipeCodes.ERR_RECIPE_SPLIT_INVALID_SPLIT, "Share for split #" + p + " is negative. All shares must be positive.");
                }
                totalShare += split.share.floatValue();
            }
            ++p;
        }
        if (totalShare > 100.0f) {
            stepStatus.withFatal(RecipeCodes.ERR_RECIPE_SPLIT_INVALID_SPLIT, "Sum of shares is " + totalShare + " %. It must be inferior to 100%.");
        }
    }

    private void checkColumnInSchemaOrComputedColumns(String column, SplitRecipePayloadParams params, RecipeStatus.StepStatus stepStatus, Dataset inputDataset) {
        if (!this.splitService.isColumnInSchemaOrComputedColumns(column, params, inputDataset)) {
            stepStatus.withFatal(RecipeCodes.ERR_RECIPE_SPLIT_INVALID_SPLIT, "Column \"" + column + "\" is not in input dataset schema.");
        }
    }

    private void fixupStatusOutputInvalid(SplitRecipeStatus status) {
        if (status.isInvalid() && !status.output.anyFatal()) {
            status.output.withFatal(RecipeCodes.ERR_RECIPE_GENERIC_ERROR, "Failed to validate all recipe steps");
        }
    }

    private void checkOutputSchema(SplitRecipeStatus status) {
        if (status.outputSchema != null && status.outputSchema.columns.isEmpty()) {
            status.output.withFatal(RecipeCodes.ERR_RECIPE_EMPTY_OUTPUT_SCHEMA, "Empty output schema");
        }
    }

    @Override
    public SplitRecipeStatus fastStatusIgnorePartitions(AuthCtx authCtx) throws Exception {
        return this.fastStatusIgnorePartitions(new StatusInitializer(), authCtx);
    }

    private SplitRecipeStatus fastStatusIgnorePartitions(StatusInitializer init, AuthCtx authCtx) {
        SplitRecipeStatus status = new SplitRecipeStatus();
        try {
            this.fillStatusInitializer(init);
            SplitRecipePayloadParams params = init.params;
            status.engineParams = params.engineParams;
            this.performBasicStructureChecks(status, authCtx);
            if (params.preFilter != null && (params.preFilter.enabled || params.preFilter.distinct)) {
                status.preFilter = new RecipeStatus.StepStatus();
                this.visualRecipesService.checkFilter(params.preFilter, init.inputDS, new DummySQLDialect(), status.preFilter, false);
            }
            RecipeEnginesPreferenceConfig repc = new RecipeConfigUtils().getResolvedPreferenceConfig(this.recipe.projectKey, this.recipe.type, params.enginesPreferences);
            try {
                this.visualRecipesService.initEngines(authCtx, init.activity, status, this.recipe.projectKey);
                this.performBasicCDEChecks(status, authCtx);
                this.visualRecipesService.selectEngine(authCtx, init.activity, params.engineType, status, this.recipe.type, repc);
                this.visualRecipesService.adjustEngineStatus(authCtx, init.activity, status, "Filter each split in-database, then streaming of rows");
                this.makeRecipeSpecificEnginesStatus(authCtx, init, status, params);
                this.visualRecipesService.selectEngine(authCtx, init.activity, params.engineType, status, this.recipe.type, repc);
                this.visualRecipesService.adjustEngineStatus(authCtx, init.activity, status, "Filter each split in-database, then streaming of rows");
                if (status.selectedEngine == null && !status.isInvalid()) {
                    status.output.withFatalV(RecipeCodes.ERR_RECIPE_VALIDATION_FAILED, "No engine selected", new Object[0]);
                    return status;
                }
            }
            catch (Exception e) {
                logger.error((Object)"Failed to init engine", (Throwable)e);
                status.output.withFatalV(RecipeCodes.ERR_RECIPE_VALIDATION_FAILED, "Failed to init engine: %s", new Object[]{ExceptionUtils.getMessageWithCauses((Throwable)e)});
                return status;
            }
            init.dialect = this.visualRecipesService.getDialect(authCtx, init.activity, status.selectedEngine);
            try {
                init.lowerCaseColumnsNames = this.visualRecipesService.mustLowerCaseColumnsNames((VisualSQLRecipePayloadParams)params, status.selectedEngine);
                status.outputSchema = this.splitService.getOutputSchema(init.inputDS, params, init.lowerCaseColumnsNames);
            }
            catch (Exception e) {
                logger.error((Object)"Failed to compute output schema", (Throwable)e);
                status.output.withFatalV(RecipeCodes.ERR_RECIPE_VALIDATION_FAILED, "Failed to compute output schema: %s", new Object[]{ExceptionUtils.getMessageWithCauses((Throwable)e)});
                return status;
            }
            if (!status.isInvalid() && this.isRecipeQueryBased(params.mode, status.selectedEngine)) {
                init.helper.setBaseOutputSchema(init.baseOutputSchema);
                init.helper.setLowerCaseColumns(init.lowerCaseColumnsNames);
                try {
                    init.helper.computeEffectiveConditions(init.dialect);
                    this.generateSqlQueries(status, init, false);
                }
                catch (Exception e) {
                    logger.error((Object)"Failed to generate SQL query", (Throwable)e);
                    init.error = e.getMessage();
                }
            }
            this.recipesValidationService.checkComplianceWithRecipeDesc(authCtx, this.recipe);
            this.recipesValidationService.checkTargetsAreWritable(init.activity);
        }
        catch (Throwable e) {
            status.output.withFatal(RecipeCodes.ERR_RECIPE_VALIDATION_FAILED, ExceptionUtils.getMessageWithCauses((Throwable)e));
        }
        return status;
    }

    private void generateSqlQueries(SplitRecipeStatus status, StatusInitializer init, boolean withPartitioning) throws Exception {
        status.sqlWithExecutionPlanList = new ArrayList<SqlWithExecutionPlan>();
        if (status.selectedEngine.type.equals("HIVE")) {
            String sql = init.helper.generateSqlForHive(init.dialect, withPartitioning);
            status.sqlWithExecutionPlanList.add(new SqlWithExecutionPlan(null, sql));
        } else {
            for (String outputDatasetFullId : init.helper.effectiveConditions.keySet()) {
                String outputName = DatasetLocUtils.DatasetLoc.resolveFull(outputDatasetFullId).getId();
                String sql = init.params.mode == SplitRecipePayloadParams.Mode.CENTILE && init.dialect instanceof MySQLDialect ? init.helper.generateSqlForCentileForMysql(init.dialect, outputDatasetFullId, withPartitioning) : init.helper.generateSql(init.dialect, outputDatasetFullId, withPartitioning);
                status.sqlWithExecutionPlanList.add(new SqlWithExecutionPlan(outputName, sql));
            }
        }
    }

    private void makeRecipeSpecificEnginesStatus(AuthCtx authCtx, StatusInitializer init, SplitRecipeStatus status, SplitRecipePayloadParams params) throws Exception {
        logger.info((Object)"Computing engine status for split recipe");
        for (RecipeEngineStatus engine : status.engines) {
            if (!engine.isSelectable) continue;
            SQLDialect dialect = this.visualRecipesService.getDialect(authCtx, init.activity, engine);
            this.makeEngineStatusRandomMode(params, engine);
            this.makeEngineStatusRandomColumnsMode(params, engine);
            this.makeEngineStatusCentileMode(params, dialect, engine);
            if (!(engine instanceof VisualSQLRecipesBaseService.SQLBasedEngineStatus) || !((VisualSQLRecipesBaseService.SQLBasedEngineStatus)engine).queryBased) continue;
            try {
                this.makeEngineStatusFiltersMode(init, params, dialect);
                this.makeEngineStatusPrefilters(init, params, dialect, engine);
                this.makeEngineStatusComputedColumns(init, params, dialect);
            }
            catch (Exception e) {
                if (engine.type.equals("DSS")) {
                    RecipeEngineStatus.setErrorStatus("Recipe configuration is not supported: " + ExceptionUtils.getMessageWithCauses((Throwable)e), engine);
                    continue;
                }
                RecipeEngineStatus.setErrorStatus("Recipe cannot be translated to SQL: " + ExceptionUtils.getMessageWithCauses((Throwable)e), engine);
            }
        }
    }

    private void makeEngineStatusFiltersMode(StatusInitializer init, SplitRecipePayloadParams params, SQLDialect dialect) throws Exception {
        if (params.mode == SplitRecipePayloadParams.Mode.FILTERS) {
            for (SplitRecipePayloadParams.FilterSplitDesc split : params.filterSplits) {
                FilterDescUtils.getSQLExpression(split.filter, dialect, init.helper.getInputDSWithComputedColumnsSchema(dialect), true);
            }
        }
    }

    private void makeEngineStatusRandomMode(SplitRecipePayloadParams params, RecipeEngineStatus engine) {
        if (!(params.mode != SplitRecipePayloadParams.Mode.RANDOM || engine.type.equals("DSS") || engine.type.equals("SPARK") || engine.type.equals("HIVE"))) {
            RecipeEngineStatus.setErrorStatus("Random split is not supported by this engine", engine);
        }
    }

    private void makeEngineStatusRandomColumnsMode(SplitRecipePayloadParams params, RecipeEngineStatus engine) {
        if (params.mode == SplitRecipePayloadParams.Mode.RANDOM_COLUMNS && engine.type.equals("IMPALA")) {
            RecipeEngineStatus.setErrorStatus("Random columns split is not supported by this engine", engine);
        }
    }

    private void makeEngineStatusCentileMode(SplitRecipePayloadParams params, SQLDialect dialect, RecipeEngineStatus engine) {
        if (dialect == null) {
            return;
        }
        boolean notSQL99ButSupportCentile = dialect instanceof MySQLDialect;
        if (params.mode == SplitRecipePayloadParams.Mode.CENTILE && !dialect.canSQL99() && !notSQL99ButSupportCentile) {
            RecipeEngineStatus.setErrorStatus("Centile split recipe has not been implemented yet for this engine", engine);
        }
    }

    private void makeEngineStatusPrefilters(StatusInitializer init, SplitRecipePayloadParams params, SQLDialect dialect, RecipeEngineStatus engine) throws Exception {
        boolean translateFully = !engine.type.equals("DSS");
        FilterDescUtils.getSQLExpression(params.preFilter, dialect, init.inputDS, translateFully);
    }

    private void makeEngineStatusComputedColumns(StatusInitializer init, SplitRecipePayloadParams params, SQLDialect dialect) {
        if (params.hasComputedColumns()) {
            for (ComputedColumn cc : params.computedColumns) {
                ExpressionBuilder expr = QueryGenerationUtils.getComputedColumnExpr(cc, dialect, init.inputDS.getSchema());
                expr.toSQL(dialect);
            }
        }
    }

    private boolean isRecipeQueryBased(SplitRecipePayloadParams.Mode mode, RecipeEngineStatus engine) {
        boolean isDSS = engine.type.equals("DSS");
        boolean isSparkAndRandom = engine.type.equals("SPARK") && mode.equals((Object)SplitRecipePayloadParams.Mode.RANDOM);
        boolean isImpalaAndRandomColumns = engine.type.equals("IMPALA") && mode.equals((Object)SplitRecipePayloadParams.Mode.RANDOM_COLUMNS);
        return mode != null && !isDSS && !isSparkAndRandom && !isImpalaAndRandomColumns;
    }

    private void fillStatusInitializer(StatusInitializer init) throws Exception {
        init.activity = new FakeJobActivityFromRecipeBuilder().buildFakeJobActivity(this.recipe);
        init.params = this.splitService.loadParams(this.payload, init.activity, this.recipe.getProjectKey());
        init.inputDS = init.activity.getSubgraph().getSourceDatasets().get(0).getMandatory(this.datasetsDAO);
        init.baseOutputSchema = this.splitService.getBaseOutputSchema(init.inputDS, init.params);
        init.helper = new SplitRecipeHelper(init.activity, init.inputDS, init.params, this.recipe.getProjectKey());
    }

    private static class StatusInitializer {
        public SplitRecipePayloadParams params;
        public Dataset inputDS;
        public Schema baseOutputSchema;
        public SQLDialect dialect;
        public JobActivity activity;
        public SplitRecipeHelper helper;
        public boolean lowerCaseColumnsNames = false;
        public String error;

        private StatusInitializer() {
        }
    }

    public static class SplitRecipeStatus
    extends VisualSQLRecipeStatus {
        RecipeStatus.StepStatus preFilter;
        RecipeStatus.StepStatus computedColumns;
        RecipeStatus.StepStatus splitting;
        List<SqlWithExecutionPlan> sqlWithExecutionPlanList;
        List<String> executionPlanErrMsgs = new ArrayList<String>();

        @Override
        public InfoMessage.InfoMessages gatherAllMessages() {
            InfoMessage.InfoMessages ret = new InfoMessage.InfoMessages();
            ret.mergeFrom(this.topLevelMessages);
            if (this.preFilter != null) {
                ret.mergeFrom((InfoMessage.InfoMessages)this.preFilter);
            }
            if (this.computedColumns != null) {
                ret.mergeFrom((InfoMessage.InfoMessages)this.computedColumns);
            }
            if (this.splitting != null) {
                ret.mergeFrom((InfoMessage.InfoMessages)this.splitting);
            }
            if (this.output != null) {
                ret.mergeFrom((InfoMessage.InfoMessages)this.output);
            }
            return ret;
        }

        @Override
        public boolean isInvalid() {
            return this.gatherAllMessages().anyFatal();
        }
    }

    public static class SqlWithExecutionPlan {
        public String outputName;
        public String sql;
        public ExecutionPlanService.ExecutionPlan executionPlan;

        public SqlWithExecutionPlan(String outputName, String sql) {
            this.outputName = outputName;
            this.sql = sql;
            this.executionPlan = null;
        }
    }
}

