/*
 * Decompiled with CFR 0.152.
 */
package com.dataiku.dip.dataflow.exec.sync;

import com.dataiku.dip.connections.SQLConnectionProvider;
import com.dataiku.dip.coremodel.InfoMessage;
import com.dataiku.dip.coremodel.Schema;
import com.dataiku.dip.dataflow.exec.FSSubgraphHelper;
import com.dataiku.dip.dataflow.exec.PeriodicObserver;
import com.dataiku.dip.dataflow.exec.sync.AbtractToVerticaExecutor;
import com.dataiku.dip.dataflow.exec.sync.SyncRecipeParams;
import com.dataiku.dip.dataflow.exec.sync.VerticaPartitionConfig;
import com.dataiku.dip.datalayer.utils.StreamsInputSplitToOutputStreamRunnable;
import com.dataiku.dip.datasets.DatasetHandler;
import com.dataiku.dip.datasets.fs.AbstractFSDatasetHandler;
import com.dataiku.dip.datasets.sql.AbstractSQLTableDatasetHandler;
import com.dataiku.dip.exceptions.CodedException;
import com.dataiku.dip.formats.FormatFactory;
import com.dataiku.dip.input.DatasetHandlerFactory;
import com.dataiku.dip.input.formats.FormatExtractor;
import com.dataiku.dip.input.stream.ParallelStreamer;
import com.dataiku.dip.output.OutputFormatter;
import com.dataiku.dip.partitioning.FilePartitioner;
import com.dataiku.dip.sql.SQLUtils;
import com.dataiku.dip.sql.VerticaCopyCSVFormatter;
import com.dataiku.dip.sql.VerticaCopyHelper;
import com.dataiku.dip.utils.DKULogger;
import com.dataiku.dip.warnings.WarningsContext;
import java.io.IOException;
import java.io.OutputStream;
import java.io.PipedInputStream;
import java.io.PipedOutputStream;
import java.util.ArrayList;

public class FSToVertica
extends AbtractToVerticaExecutor
implements PeriodicObserver {
    private DatasetHandler datasetHandler;
    private static final DKULogger logger = DKULogger.getLogger((String)"dku.flow.vertica");

    public FSToVertica(SyncRecipeParams params) {
        super(params);
    }

    @Override
    public void run() throws Exception {
        this.datasetHandler = DatasetHandlerFactory.build(this.authCtx, this.inputDS);
        AbstractFSDatasetHandler fsdh = (AbstractFSDatasetHandler)this.datasetHandler;
        FilePartitioner.ResolvedFilesFilterResult inputFiles = FSSubgraphHelper.getInputFiles(this.authCtx, this.inputPartitions, this.inputDS);
        AbstractSQLTableDatasetHandler baseHandler = (AbstractSQLTableDatasetHandler)DatasetHandlerFactory.build(this.authCtx, this.outputDS);
        this.connData = baseHandler.getConnectionData();
        VerticaPartitionConfig partitionConfig = new VerticaPartitionConfig(this.outputDS, this.outputPartition);
        try (SQLConnectionProvider.SQLConnectionWrapper conn = baseHandler.newConnection();){
            try {
                InfoMessage.InfoMessages messages = new InfoMessage.InfoMessages();
                this.connData.getDialect().dropIfNeededAndCreateTableOrPartition(this.authCtx, this.connData, conn, this.outputDS, partitionConfig.outKey, this.writeMode, messages);
                if (!messages.isEmpty()) {
                    this.warnContext.addWarning(WarningsContext.WarningType.SQL_CREATE_QUERY_WARNING, messages.report("\n"), logger);
                }
                SQLUtils.executePreWriteStatements(baseHandler.getConnectionData(), conn, this.outputDS);
                logger.info((Object)"Starting parallel streamer");
                ParallelStreamer ps2 = new ParallelStreamer(fsdh, inputFiles.matchingFilePartitions, this.params.engineParams.maxThreads);
                logger.info((Object)"Starting Vertica load threads");
                ArrayList<LoadSplitToVerticaThread> threads = new ArrayList<LoadSplitToVerticaThread>();
                for (int i = 0; i < this.params.engineParams.maxThreads; ++i) {
                    LoadSplitToVerticaThread loadThread = new LoadSplitToVerticaThread(ps2.getRunner(i), baseHandler, partitionConfig);
                    loadThread.start();
                    threads.add(loadThread);
                }
                logger.info((Object)"Starting to offer files");
                ps2.run();
                logger.info((Object)"Parallel streamer done, waiting for processing threads");
                Exception loadFailed = null;
                for (LoadSplitToVerticaThread t : threads) {
                    t.join();
                    if (loadFailed != null || t.loadFailure == null) continue;
                    loadFailed = t.loadFailure;
                }
                if (loadFailed != null) {
                    throw loadFailed;
                }
                logger.info((Object)"Processing threads joined, committing");
                SQLUtils.executePostWriteStatements(baseHandler.getConnectionData(), conn, this.outputDS);
                conn.commit();
                logger.info((Object)"Vertica connection committed");
            }
            catch (Exception e) {
                conn.rollback();
                throw e;
            }
        }
    }

    @Override
    public void onInterval() throws IOException {
    }

    @Override
    public void onEnd(boolean isSuccess) throws IOException {
        if (this.datasetHandler != null) {
            try {
                this.datasetHandler.close();
            }
            finally {
                this.datasetHandler = null;
            }
        }
    }

    private class LoadSplitToVerticaThread
    extends Thread {
        private VerticaPartitionConfig partitionConfig;
        private FormatExtractor extractor;
        private Schema outSchema;
        private ParallelStreamer.SplitRunner split;
        private AbstractSQLTableDatasetHandler baseHandler;
        private Exception loadFailure = null;

        public LoadSplitToVerticaThread(ParallelStreamer.SplitRunner split, AbstractSQLTableDatasetHandler baseHandler, VerticaPartitionConfig partitionConfig) throws CodedException {
            this.split = split;
            this.baseHandler = baseHandler;
            this.extractor = FormatFactory.buildExtractor(FSToVertica.this.inputDS.getFormatType(), FSToVertica.this.inputDS.getFormatParams(), FSToVertica.this.authCtx, FSToVertica.this.inputDS.getProjectKey());
            this.extractor.setSchema(FSToVertica.this.inputDS.getSchema(), false);
            this.extractor.setWarningsContext(FSToVertica.this.warnContext);
            this.outSchema = FSToVertica.this.outputDS.getSchema();
            this.partitionConfig = partitionConfig;
        }

        @Override
        public void run() {
            SQLConnectionProvider.SQLConnectionWrapper conn = null;
            try (PipedInputStream pis = new PipedInputStream();
                 PipedOutputStream pos = new PipedOutputStream(pis);){
                conn = this.baseHandler.newConnection();
                logger.info((Object)"Starting one copy thread to Vertica");
                VerticaCopyHelper helper = new VerticaCopyHelper();
                String copyStatement = FSToVertica.this.createCopyStatement(this.baseHandler);
                logger.info((Object)("Using copy statement " + copyStatement));
                helper.createCopyStream(conn, copyStatement);
                logger.info((Object)"Starting input dataset read thread");
                ReadThread readThread = new ReadThread(pos);
                readThread.start();
                logger.info((Object)"Starting to send to Vertica ...");
                helper.addStream(pis);
                helper.execute();
                logger.info((Object)"Vertica streaming is done, waiting for read thread");
                readThread.join();
                this.split.cancel();
                if (readThread.readFailure != null) {
                    throw new Exception("Executor read failure", readThread.readFailure);
                }
                logger.info((Object)("Terminating Vertica connection, loaded: " + helper.getRowCount()));
                helper.finish();
                FSToVertica.this.warnRejects();
                conn.commit();
                conn.close();
            }
            catch (Exception e) {
                this.split.cancel();
                logger.error((Object)"Copy to vertica failed", (Throwable)e);
                this.loadFailure = e;
                SQLUtils.unsafeRollbackAndClose(conn);
            }
        }

        private class ReadThread
        extends Thread {
            private Exception readFailure = null;
            private final OutputStream os;

            public ReadThread(OutputStream os) {
                this.os = os;
            }

            @Override
            public void run() {
                try {
                    new StreamsInputSplitToOutputStreamRunnable(LoadSplitToVerticaThread.this.split, this.os, (OutputFormatter)new VerticaCopyCSVFormatter(LoadSplitToVerticaThread.this.outSchema, LoadSplitToVerticaThread.this.partitionConfig.keyColumn, LoadSplitToVerticaThread.this.partitionConfig.partitionValue), LoadSplitToVerticaThread.this.extractor).run();
                }
                catch (Exception e) {
                    logger.error((Object)"Input dataset read thread failed,", (Throwable)e);
                    this.readFailure = e;
                }
            }
        }
    }
}

