/*
 * Decompiled with CFR 0.152.
 */
package com.dataiku.dip.dataflow.graph;

import com.dataiku.dip.coremodel.Dataset;
import com.dataiku.dip.coremodel.Partitionable;
import com.dataiku.dip.coremodel.SerializedDataset;
import com.dataiku.dip.dao.DatasetsDAO;
import com.dataiku.dip.dataflow.graph.FlowComputable;
import com.dataiku.dip.dataflow.graph.FlowPartitionable;
import com.dataiku.dip.server.SpringUtils;
import com.dataiku.dip.util.AnyLoc;
import com.dataiku.dip.util.DatasetLocUtils;
import java.io.IOException;

public class FlowDataset
extends FlowComputable
implements FlowPartitionable {
    private String datasetFullName;
    private Dataset forcedDataset;

    public Dataset getOrNull(DatasetsDAO dao) throws IOException {
        if (this.forcedDataset != null) {
            return this.forcedDataset;
        }
        SerializedDataset sd = (SerializedDataset)dao.getOrNull(DatasetLocUtils.resolveFull(this.datasetFullName));
        if (sd == null) {
            return null;
        }
        return Dataset.fromSerialized(sd);
    }

    public Dataset getMandatory(DatasetsDAO dao) throws IOException {
        if (this.forcedDataset != null) {
            return this.forcedDataset;
        }
        SerializedDataset sd = (SerializedDataset)dao.getMandatory(DatasetLocUtils.resolveFull(this.datasetFullName));
        return Dataset.fromSerialized(sd);
    }

    public Dataset getMandatoryUnsafe(DatasetsDAO dao) throws IOException {
        if (this.forcedDataset != null) {
            return this.forcedDataset;
        }
        DatasetLocUtils.DatasetLoc loc = DatasetLocUtils.resolveFull(this.datasetFullName);
        SerializedDataset sds = (SerializedDataset)dao.getMandatoryUnsafe(loc);
        return Dataset.fromSerializedUnsafe(sds);
    }

    public SerializedDataset getSerializedMandatoryUnsafe(DatasetsDAO dao) throws IOException {
        if (this.forcedDataset != null) {
            return this.forcedDataset.getModel();
        }
        return (SerializedDataset)dao.getMandatoryUnsafe(DatasetLocUtils.resolveFull(this.datasetFullName));
    }

    public String toString() {
        return "<FD:" + this.datasetFullName + "/>";
    }

    @Override
    public String getFullName() {
        if (this.forcedDataset != null) {
            return this.forcedDataset.getFullName();
        }
        assert (this.datasetFullName != null);
        return this.datasetFullName;
    }

    public FlowDataset(String datasetFullName) {
        super(FlowComputable.FCType.DATASET);
        this.datasetFullName = datasetFullName;
    }

    public FlowDataset(Dataset forcedDataset) {
        super(FlowComputable.FCType.DATASET);
        this.forcedDataset = forcedDataset;
        this.datasetFullName = forcedDataset.getFullName();
    }

    @Override
    public String getFullId() {
        return this.getFullName();
    }

    @Override
    public SerializedDataset.RebuildBehavior getRebuildBehavior() throws IOException {
        DatasetsDAO dao = (DatasetsDAO)SpringUtils.getBean(DatasetsDAO.class);
        return this.getMandatory((DatasetsDAO)dao).getFlowOptions().rebuildBehavior;
    }

    @Override
    public SerializedDataset.CrossProjectBuildBehaviour getCrossProjectBehavior() throws IOException {
        DatasetsDAO dao = (DatasetsDAO)SpringUtils.getBean(DatasetsDAO.class);
        return this.getMandatory((DatasetsDAO)dao).getFlowOptions().crossProjectBuildBehavior;
    }

    public boolean isVirtualizable() throws IOException {
        if (this.forcedDataset != null) {
            return this.forcedDataset.getFlowOptions().virtualizable;
        }
        return ((SerializedDataset)((DatasetsDAO)SpringUtils.getBean(DatasetsDAO.class)).getMandatoryUnsafe((AnyLoc)DatasetLocUtils.resolveFull((String)this.datasetFullName))).flowOptions.virtualizable;
    }

    @Override
    public Partitionable getPartitioned(DatasetsDAO datasetsDAO) throws IOException {
        return this.getMandatoryUnsafe(datasetsDAO);
    }

    @Override
    public boolean isPartitionable() {
        return true;
    }
}

