/*
 * Decompiled with CFR 0.152.
 */
package com.dataiku.dip.dataflow.kernel.master.locking;

import com.dataiku.dip.dataflow.kernel.master.locking.AcquirabilityTestResult;
import com.dataiku.dip.dataflow.kernel.master.locking.FCFSPrioritizationStrategy;
import com.dataiku.dip.dataflow.kernel.master.locking.Permit;
import com.dataiku.dip.dataflow.kernel.master.locking.PermitStatus;
import com.dataiku.dip.dataflow.kernel.master.locking.PrioritizationStrategy;
import com.dataiku.dip.dataflow.kernel.master.locking.SchedulingConstraintPolicy;
import com.dataiku.dip.dataflow.kernel.master.locking.UnconstrainedSchedulingConstraintPolicy;
import com.dataiku.dip.utils.DKULogger;
import com.google.common.base.Function;
import com.google.common.base.Preconditions;
import com.google.common.collect.FluentIterable;
import com.google.common.collect.ImmutableList;
import java.util.ArrayList;
import java.util.Collections;
import java.util.LinkedHashMap;
import java.util.List;
import java.util.concurrent.TimeUnit;
import java.util.concurrent.locks.Condition;
import java.util.concurrent.locks.Lock;
import java.util.concurrent.locks.ReentrantLock;

public class ConstrainedLock<PermitRequest> {
    private static DKULogger logger = DKULogger.getLogger(ConstrainedLock.class);
    private ReentrantLock lock = new ReentrantLock(true);
    private Condition atLeastOneStableState = this.lock.newCondition();
    private PrioritizationStrategy<PermitRequest> prioritizationStrategy = new FCFSPrioritizationStrategy();
    private SchedulingConstraintPolicy<PermitRequest> constraintPolicy = new UnconstrainedSchedulingConstraintPolicy();
    private LinkedHashMap<String, PermitImpl> activePermits = new LinkedHashMap();
    private long nextPermitId = 0L;

    public Permit<PermitRequest> newPermit(PermitRequest permitRequest) {
        try (LockHolder holder = LockHolder.lock(this.lock);){
            PermitImpl permitImpl = new PermitImpl(permitRequest);
            return permitImpl;
        }
    }

    public void setPrioritizationStrategy(PrioritizationStrategy<PermitRequest> prioritizationStrategy) {
        try (LockHolder holder = LockHolder.lock(this.lock);){
            this.prioritizationStrategy = (PrioritizationStrategy)Preconditions.checkNotNull(prioritizationStrategy);
        }
    }

    public void setSchedulingConstraintPolicy(SchedulingConstraintPolicy<PermitRequest> constraintPolicy) {
        try (LockHolder holder = LockHolder.lock(this.lock);){
            this.constraintPolicy = (SchedulingConstraintPolicy)Preconditions.checkNotNull(constraintPolicy);
            this.update();
        }
    }

    private void update() {
        boolean acquiredNewPermit;
        assert (this.lock.isLocked());
        do {
            acquiredNewPermit = false;
            boolean hasWaitingPermit = false;
            for (PermitImpl permit : this.activePermits.values()) {
                if (permit.state != PermitStatus.PermitState.WAITING) continue;
                hasWaitingPermit = true;
                break;
            }
            if (!hasWaitingPermit) continue;
            ArrayList<PermitImpl> waitList = new ArrayList<PermitImpl>();
            ArrayList<PermitImpl> acquiredList = new ArrayList<PermitImpl>();
            block6: for (PermitImpl permit : this.activePermits.values()) {
                switch (permit.state) {
                    case WAITING: {
                        waitList.add(permit);
                        continue block6;
                    }
                    case ACQUIRED: {
                        acquiredList.add(permit);
                        continue block6;
                    }
                }
                throw new RuntimeException("Unreachable");
            }
            List<PermitRequest> unwrappedAcquiredList = ConstrainedLock.unwrapPermitList(acquiredList);
            SchedulingConstraintPolicy.ConstraintChecker checker = this.constraintPolicy.newConstraintChecker(unwrappedAcquiredList);
            ArrayList<PermitImpl> filteredWaitList = new ArrayList<PermitImpl>();
            for (PermitImpl permit : waitList) {
                AcquirabilityTestResult res = checker.canBeAcquired(permit.getRequest());
                if (res.isAcquirable()) {
                    filteredWaitList.add(permit);
                    continue;
                }
                permit.waitReason = res.getReason();
            }
            if (filteredWaitList.size() <= 0) continue;
            List<PermitRequest> unwrappedFilteredWaitList = ConstrainedLock.unwrapPermitList(filteredWaitList);
            int nextCandidateIdx = this.prioritizationStrategy.selectHighestPriorityPermit(unwrappedAcquiredList, unwrappedFilteredWaitList);
            PermitImpl nextCandidate = (PermitImpl)filteredWaitList.get(nextCandidateIdx);
            nextCandidate.waitReason = null;
            nextCandidate.state = PermitStatus.PermitState.ACQUIRED;
            this.logWithCounters("Permit " + nextCandidate.id + ": WAITING->ACQUIRED");
            this.activePermits.remove(nextCandidate.id);
            this.activePermits.put(nextCandidate.id, nextCandidate);
            acquiredNewPermit = true;
            nextCandidate.stableState.signalAll();
            this.atLeastOneStableState.signalAll();
        } while (acquiredNewPermit);
    }

    private static <PermitRequest> List<PermitRequest> unwrapPermitList(List<? extends Permit<PermitRequest>> lst) {
        return Collections.unmodifiableList(FluentIterable.from(lst).transform(new Function<Permit<PermitRequest>, PermitRequest>(){

            public PermitRequest apply(Permit<PermitRequest> permitRequestPermit) {
                return permitRequestPermit.getRequest();
            }
        }).toList());
    }

    private void logWithCounters(String msg) {
        assert (this.lock.isLocked());
        int acquired = 0;
        int waiting = 0;
        for (PermitImpl permit : this.activePermits.values()) {
            if (permit.state == PermitStatus.PermitState.ACQUIRED) {
                ++acquired;
            }
            if (permit.state != PermitStatus.PermitState.WAITING) continue;
            ++waiting;
        }
        logger.debug((Object)(msg + " [" + acquired + " acquired, " + waiting + " waiting]"));
    }

    public List<PermitStatus> awaitOn(List<Permit<PermitRequest>> permits, long timeoutMs) throws InterruptedException {
        long startAt = System.currentTimeMillis();
        try (LockHolder holder = LockHolder.lock(this.lock);){
            ImmutableList immutableList;
            block5: while (true) {
                immutableList = permits.iterator();
                while (true) {
                    long spent;
                    if (!immutableList.hasNext()) continue block5;
                    Permit<PermitRequest> permit = immutableList.next();
                    PermitImpl permitImpl = (PermitImpl)permit;
                    if (permitImpl.state == PermitStatus.PermitState.ACQUIRED || permitImpl.state == PermitStatus.PermitState.RELEASED || (spent = System.currentTimeMillis() - startAt) >= timeoutMs) break block5;
                    long remaining = timeoutMs - spent;
                    this.atLeastOneStableState.await(remaining, TimeUnit.MILLISECONDS);
                }
                break;
            }
            immutableList = FluentIterable.from(permits).transform(new Function<Permit<PermitRequest>, PermitStatus>(){

                public PermitStatus apply(Permit<PermitRequest> permit) {
                    return permit.getStatus();
                }
            }).toList();
            return immutableList;
        }
    }

    private static class LockHolder
    implements AutoCloseable {
        private final Lock lock;

        public static LockHolder lock(Lock aLock) {
            return new LockHolder(aLock);
        }

        @Override
        public void close() {
            this.lock.unlock();
        }

        private LockHolder(Lock aLock) {
            this.lock = (Lock)Preconditions.checkNotNull((Object)aLock);
            this.lock.lock();
        }
    }

    public class PermitImpl
    implements Permit<PermitRequest> {
        private final String id;
        private final PermitRequest permitRequest;
        private final Condition stableState;
        private String waitReason;
        private PermitStatus.PermitState state = PermitStatus.PermitState.RELEASED;

        public PermitImpl(PermitRequest permitRequest) {
            this.permitRequest = Preconditions.checkNotNull(permitRequest);
            this.id = "P" + ConstrainedLock.this.nextPermitId++;
            this.stableState = ConstrainedLock.this.lock.newCondition();
        }

        @Override
        public void acquire() {
            try (LockHolder holder = LockHolder.lock(ConstrainedLock.this.lock);){
                if (this.state == PermitStatus.PermitState.RELEASED) {
                    ConstrainedLock.this.activePermits.put(this.id, this);
                    this.state = PermitStatus.PermitState.WAITING;
                    ConstrainedLock.this.logWithCounters("Permit " + this.id + ": RELEASED->WAITING");
                    ConstrainedLock.this.update();
                }
            }
        }

        @Override
        public void release() {
            try (LockHolder holder = LockHolder.lock(ConstrainedLock.this.lock);){
                if (this.state == PermitStatus.PermitState.WAITING || this.state == PermitStatus.PermitState.ACQUIRED) {
                    PermitStatus.PermitState previousState = this.state;
                    this.state = PermitStatus.PermitState.RELEASED;
                    this.waitReason = null;
                    ConstrainedLock.this.logWithCounters("Permit " + this.id + ": " + String.valueOf((Object)previousState) + "->RELEASED");
                    ConstrainedLock.this.activePermits.remove(this.id);
                    this.stableState.signalAll();
                    ConstrainedLock.this.atLeastOneStableState.signalAll();
                    ConstrainedLock.this.update();
                }
            }
        }

        @Override
        public PermitStatus await(long timeoutMs) throws InterruptedException {
            long startAt = System.currentTimeMillis();
            try (LockHolder holder = LockHolder.lock(ConstrainedLock.this.lock);){
                while (true) {
                    if (this.state == PermitStatus.PermitState.ACQUIRED || this.state == PermitStatus.PermitState.RELEASED) {
                        PermitStatus permitStatus = this.getStatus();
                        return permitStatus;
                    }
                    long spent = System.currentTimeMillis() - startAt;
                    if (spent >= timeoutMs) {
                        PermitStatus permitStatus = this.getStatus();
                        return permitStatus;
                    }
                    long remaining = timeoutMs - spent;
                    this.stableState.await(remaining, TimeUnit.MILLISECONDS);
                }
            }
        }

        @Override
        public PermitStatus getStatus() {
            try (LockHolder holder = LockHolder.lock(ConstrainedLock.this.lock);){
                PermitStatus permitStatus = new PermitStatus(this.id, this.state, this.waitReason);
                return permitStatus;
            }
        }

        @Override
        public PermitRequest getRequest() {
            return this.permitRequest;
        }

        @Override
        public String getPermitId() {
            return this.id;
        }

        @Override
        public String getWaitReason() {
            try (LockHolder holder = LockHolder.lock(ConstrainedLock.this.lock);){
                if (this.state == PermitStatus.PermitState.WAITING) {
                    String string = this.waitReason;
                    return string;
                }
                String string = null;
                return string;
            }
        }
    }
}

