/*
 * Decompiled with CFR 0.152.
 */
package com.dataiku.dip.dataflow.pdep;

import com.dataiku.dip.dataflow.pdep.DimensionDependencyEvaluator;
import com.dataiku.dip.partitioning.Dimension;
import com.dataiku.dip.partitioning.DimensionValue;
import com.dataiku.dip.util.PythonInterpreterFactory;
import com.dataiku.dip.variables.VariablesContext;
import com.google.common.base.Preconditions;
import java.util.ArrayList;
import java.util.List;
import java.util.Map;
import org.apache.log4j.Logger;
import org.python.core.PyDictionary;
import org.python.core.PyException;
import org.python.core.PyFunction;
import org.python.core.PyList;
import org.python.core.PyObject;
import org.python.core.PySequenceList;
import org.python.core.PyString;
import org.python.util.PythonInterpreter;

public class CustomPythonDependencyEvaluator
extends DimensionDependencyEvaluator {
    public static final String PYTHON_FUNCTION_NAME = "get_dependencies";
    private final String pythonCode;
    private PythonInterpreter interpreter;
    private PyObject entryPoint;
    private VariablesContext variablesContext;

    public CustomPythonDependencyEvaluator(String pythonCode, VariablesContext variablesContext) {
        this.pythonCode = (String)Preconditions.checkNotNull((Object)pythonCode);
        this.variablesContext = variablesContext;
    }

    private synchronized void init() {
        if (this.entryPoint == null) {
            try {
                Logger.getLogger((String)"dku").info((Object)"Create Python interpreter for pdep");
                this.interpreter = PythonInterpreterFactory.newInstance(true);
                this.interpreter.exec(this.pythonCode);
                this.entryPoint = this.interpreter.get(PYTHON_FUNCTION_NAME);
                if (!(this.entryPoint instanceof PyFunction)) {
                    throw new IllegalArgumentException("Python source code should contain a process function named get_dependencies().");
                }
            }
            catch (PyException e) {
                throw new IllegalArgumentException("Python error : " + String.valueOf(e.type) + " : " + String.valueOf(e.value), e);
            }
        }
    }

    @Override
    public List<DimensionValue> getDependent(DimensionValue target, Dimension srcDim) throws Exception {
        this.init();
        try {
            ArrayList<DimensionValue> requiredPartitionIDs = new ArrayList<DimensionValue>();
            String targetId = target.id();
            Map customVariables = this.variablesContext.getAllVariables();
            PyDictionary varsDict = new PyDictionary();
            for (Map.Entry v : customVariables.entrySet()) {
                varsDict.put(v.getKey(), v.getValue());
            }
            this.interpreter.set("dku_custom_variables", (PyObject)varsDict);
            PyObject pyRequiredPartitionIDs = this.entryPoint.__call__((PyObject)new PyString(targetId));
            if (!(pyRequiredPartitionIDs instanceof PyList)) {
                throw new IllegalArgumentException("The function get_dependencies must return a list of partition identifiers. (target identifier is \"" + targetId + "\")");
            }
            for (PyObject pyDepId : ((PySequenceList)pyRequiredPartitionIDs).getArray()) {
                if (!(pyDepId instanceof PyString)) {
                    throw new IllegalArgumentException("A partition identifier must be a string");
                }
                String depId = pyDepId.asString();
                requiredPartitionIDs.add(srcDim.getValueFromId(depId));
            }
            return requiredPartitionIDs;
        }
        catch (PyException e) {
            throw new IllegalArgumentException("Python error : " + String.valueOf(e.type) + " : " + String.valueOf(e.value), e);
        }
    }
}

